# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"

module Google
  module Iam
    ##
    # @example Loading just the REST part of this package, including all its services, and instantiating a REST client
    #
    #     require "google/iam/v1/rest"
    #     client = ::Google::Iam::V1::IAMPolicy::Rest::Client.new
    #
    module V1
      ##
      # @private
      # Initialize the mixin bindings configuration
      #
      def self.configure
        @configure ||= begin
          namespace = ["Google", "Iam"]
          parent_config = while namespace.any?
                            parent_name = namespace.join "::"
                            parent_const = const_get parent_name
                            break parent_const.configure if parent_const.respond_to? :configure
                            namespace.pop
                          end

          default_config = ::Gapic::Rest::HttpBindingOverrideConfiguration.new parent_config
          default_config.bindings_override["google.cloud.location.Locations.GetLocation"] = [
            Gapic::Rest::GrpcTranscoder::HttpBinding.create_with_validation(
              uri_method: :get,
              uri_template: "/v1/{name}",
              matches: [
                ["name", %r{^projects/[^/]+/locations/[^/]+/?$}, false]
              ],
              body: nil
            )
          ]
          default_config.bindings_override["google.cloud.location.Locations.ListLocations"] = [

            Gapic::Rest::GrpcTranscoder::HttpBinding.create_with_validation(
              uri_method: :get,
              uri_template: "/v1/{name}/locations",
              matches: [
                ["name", %r{^projects/[^/]+/?$}, false]
              ],
              body: nil
            )
          ]
          default_config
        end
        yield @configure if block_given?
        @configure
      end
    end
  end
end
