# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/vmmigration/v1/vmmigration_pb"
require "google/cloud/vm_migration/v1/vm_migration/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module VMMigration
      module V1
        module VMMigration
          module Rest
            ##
            # REST client for the VmMigration service.
            #
            # VM Migration Service
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "vmmigration.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :vm_migration_stub

              ##
              # Configure the VmMigration Client class.
              #
              # See {::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all VmMigration clients
              #   ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "VMMigration", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config.rpcs.create_source.timeout = 900.0

                  default_config.rpcs.fetch_inventory.timeout = 300.0

                  default_config.rpcs.create_utilization_report.timeout = 300.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the VmMigration Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @vm_migration_stub.universe_domain
              end

              ##
              # Create a new VmMigration REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the VmMigration client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @vm_migration_stub = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @vm_migration_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @vm_migration_stub.endpoint
                  config.universe_domain = @vm_migration_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @vm_migration_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::VMMigration::V1::VMMigration::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @vm_migration_stub.logger
              end

              # Service calls

              ##
              # Lists Sources in a given project and location.
              #
              # @overload list_sources(request, options = nil)
              #   Pass arguments to `list_sources` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListSourcesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListSourcesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sources(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_sources` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of sources.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of sources to return. The service may return
              #     fewer than this value. If unspecified, at most 500 sources will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListSources` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListSources` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::Source>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::Source>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListSourcesRequest.new
              #
              #   # Call the list_sources method.
              #   result = client.list_sources request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::Source.
              #     p item
              #   end
              #
              def list_sources request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListSourcesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sources.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sources.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sources.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_sources request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_sources, "sources", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Source.
              #
              # @overload get_source(request, options = nil)
              #   Pass arguments to `get_source` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_source(name: nil)
              #   Pass arguments to `get_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Source name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::Source]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::Source]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetSourceRequest.new
              #
              #   # Call the get_source method.
              #   result = client.get_source request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::Source.
              #   p result
              #
              def get_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_source request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Source in a given project and location.
              #
              # @overload create_source(request, options = nil)
              #   Pass arguments to `create_source` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_source(parent: nil, source_id: nil, source: nil, request_id: nil)
              #   Pass arguments to `create_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Source's parent.
              #   @param source_id [::String]
              #     Required. The source identifier.
              #   @param source [::Google::Cloud::VMMigration::V1::Source, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateSourceRequest.new
              #
              #   # Call the create_source method.
              #   result = client.create_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Source.
              #
              # @overload update_source(request, options = nil)
              #   Pass arguments to `update_source` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpdateSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpdateSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_source(update_mask: nil, source: nil, request_id: nil)
              #   Pass arguments to `update_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the
              #     Source resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param source [::Google::Cloud::VMMigration::V1::Source, ::Hash]
              #     Required. The update request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpdateSourceRequest.new
              #
              #   # Call the update_source method.
              #   result = client.update_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpdateSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.update_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Source.
              #
              # @overload delete_source(request, options = nil)
              #   Pass arguments to `delete_source` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteSourceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteSourceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_source(name: nil, request_id: nil)
              #   Pass arguments to `delete_source` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Source name.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteSourceRequest.new
              #
              #   # Call the delete_source method.
              #   result = client.delete_source request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_source request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteSourceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_source.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_source.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_source.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_source request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List remote source's inventory of VMs.
              # The remote source is the onprem vCenter (remote in the sense it's not in
              # Compute Engine). The inventory describes the list of existing VMs in that
              # source. Note that this operation lists the VMs on the remote source, as
              # opposed to listing the MigratingVms resources in the vmmigration service.
              #
              # @overload fetch_inventory(request, options = nil)
              #   Pass arguments to `fetch_inventory` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::FetchInventoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::FetchInventoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_inventory(source: nil, force_refresh: nil)
              #   Pass arguments to `fetch_inventory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param source [::String]
              #     Required. The name of the Source.
              #   @param force_refresh [::Boolean]
              #     If this flag is set to true, the source will be queried instead of using
              #     cached results. Using this flag will make the call slower.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::FetchInventoryResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::FetchInventoryResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::FetchInventoryRequest.new
              #
              #   # Call the fetch_inventory method.
              #   result = client.fetch_inventory request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::FetchInventoryResponse.
              #   p result
              #
              def fetch_inventory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::FetchInventoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_inventory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_inventory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_inventory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.fetch_inventory request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List remote source's inventory of storage resources.
              # The remote source is another cloud vendor (e.g. AWS, Azure).
              # The inventory describes the list of existing storage resources in that
              # source. Note that this operation lists the resources on the remote source,
              # as opposed to listing the MigratingVms resources in the vmmigration
              # service.
              #
              # @overload fetch_storage_inventory(request, options = nil)
              #   Pass arguments to `fetch_storage_inventory` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_storage_inventory(source: nil, type: nil, force_refresh: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_storage_inventory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param source [::String]
              #     Required. The name of the Source.
              #   @param type [::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest::StorageType]
              #     Required. The type of the storage inventory to fetch.
              #   @param force_refresh [::Boolean]
              #     Optional. If this flag is set to true, the source will be queried instead
              #     of using cached results. Using this flag will make the call slower.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of VMs to return. The service may return
              #     fewer than this value.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `FetchStorageInventory`
              #     call. Provide this to retrieve the subsequent page. When paginating, all
              #     other parameters provided to `FetchStorageInventory` must match the call
              #     that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::SourceStorageResource>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::SourceStorageResource>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest.new
              #
              #   # Call the fetch_storage_inventory method.
              #   result = client.fetch_storage_inventory request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::SourceStorageResource.
              #     p item
              #   end
              #
              def fetch_storage_inventory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_storage_inventory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_storage_inventory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_storage_inventory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.fetch_storage_inventory request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :fetch_storage_inventory, "resources", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Utilization Reports of the given Source.
              #
              # @overload list_utilization_reports(request, options = nil)
              #   Pass arguments to `list_utilization_reports` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_utilization_reports(parent: nil, view: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_utilization_reports` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Utilization Reports parent.
              #   @param view [::Google::Cloud::VMMigration::V1::UtilizationReportView]
              #     Optional. The level of details of each report.
              #     Defaults to BASIC.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of reports to return. The service may return
              #     fewer than this value. If unspecified, at most 500 reports will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListUtilizationReports`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListUtilizationReports`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::UtilizationReport>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::UtilizationReport>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest.new
              #
              #   # Call the list_utilization_reports method.
              #   result = client.list_utilization_reports request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::UtilizationReport.
              #     p item
              #   end
              #
              def list_utilization_reports request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_utilization_reports.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_utilization_reports.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_utilization_reports.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_utilization_reports request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_utilization_reports, "utilization_reports", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a single Utilization Report.
              #
              # @overload get_utilization_report(request, options = nil)
              #   Pass arguments to `get_utilization_report` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetUtilizationReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetUtilizationReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_utilization_report(name: nil, view: nil)
              #   Pass arguments to `get_utilization_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Utilization Report name.
              #   @param view [::Google::Cloud::VMMigration::V1::UtilizationReportView]
              #     Optional. The level of details of the report.
              #     Defaults to FULL
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::UtilizationReport]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::UtilizationReport]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetUtilizationReportRequest.new
              #
              #   # Call the get_utilization_report method.
              #   result = client.get_utilization_report request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::UtilizationReport.
              #   p result
              #
              def get_utilization_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetUtilizationReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_utilization_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_utilization_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_utilization_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_utilization_report request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new UtilizationReport.
              #
              # @overload create_utilization_report(request, options = nil)
              #   Pass arguments to `create_utilization_report` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_utilization_report(parent: nil, utilization_report: nil, utilization_report_id: nil, request_id: nil)
              #   Pass arguments to `create_utilization_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Utilization Report's parent.
              #   @param utilization_report [::Google::Cloud::VMMigration::V1::UtilizationReport, ::Hash]
              #     Required. The report to create.
              #   @param utilization_report_id [::String]
              #     Required. The ID to use for the report, which will become the final
              #     component of the reports's resource name.
              #
              #     This value maximum length is 63 characters, and valid characters
              #     are /[a-z][0-9]-/. It must start with an english letter and must not
              #     end with a hyphen.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest.new
              #
              #   # Call the create_utilization_report method.
              #   result = client.create_utilization_report request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_utilization_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_utilization_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_utilization_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_utilization_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_utilization_report request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Utilization Report.
              #
              # @overload delete_utilization_report(request, options = nil)
              #   Pass arguments to `delete_utilization_report` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_utilization_report(name: nil, request_id: nil)
              #   Pass arguments to `delete_utilization_report` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Utilization Report name.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest.new
              #
              #   # Call the delete_utilization_report method.
              #   result = client.delete_utilization_report request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_utilization_report request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_utilization_report.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_utilization_report.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_utilization_report.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_utilization_report request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DatacenterConnectors in a given Source.
              #
              # @overload list_datacenter_connectors(request, options = nil)
              #   Pass arguments to `list_datacenter_connectors` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_datacenter_connectors(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_datacenter_connectors` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of connectors.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of connectors to return. The service may
              #     return fewer than this value. If unspecified, at most 500 sources will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListDatacenterConnectors`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListDatacenterConnectors` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::DatacenterConnector>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::DatacenterConnector>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest.new
              #
              #   # Call the list_datacenter_connectors method.
              #   result = client.list_datacenter_connectors request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::DatacenterConnector.
              #     p item
              #   end
              #
              def list_datacenter_connectors request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_datacenter_connectors.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_datacenter_connectors.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_datacenter_connectors.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_datacenter_connectors request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_datacenter_connectors, "datacenter_connectors", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DatacenterConnector.
              #
              # @overload get_datacenter_connector(request, options = nil)
              #   Pass arguments to `get_datacenter_connector` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_datacenter_connector(name: nil)
              #   Pass arguments to `get_datacenter_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DatacenterConnector.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::DatacenterConnector]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::DatacenterConnector]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest.new
              #
              #   # Call the get_datacenter_connector method.
              #   result = client.get_datacenter_connector request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::DatacenterConnector.
              #   p result
              #
              def get_datacenter_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_datacenter_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_datacenter_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_datacenter_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_datacenter_connector request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DatacenterConnector in a given Source.
              #
              # @overload create_datacenter_connector(request, options = nil)
              #   Pass arguments to `create_datacenter_connector` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_datacenter_connector(parent: nil, datacenter_connector_id: nil, datacenter_connector: nil, request_id: nil)
              #   Pass arguments to `create_datacenter_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The DatacenterConnector's parent.
              #     Required. The Source in where the new DatacenterConnector will be created.
              #     For example:
              #     `projects/my-project/locations/us-central1/sources/my-source`
              #   @param datacenter_connector_id [::String]
              #     Required. The datacenterConnector identifier.
              #   @param datacenter_connector [::Google::Cloud::VMMigration::V1::DatacenterConnector, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest.new
              #
              #   # Call the create_datacenter_connector method.
              #   result = client.create_datacenter_connector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_datacenter_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_datacenter_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_datacenter_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_datacenter_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_datacenter_connector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DatacenterConnector.
              #
              # @overload delete_datacenter_connector(request, options = nil)
              #   Pass arguments to `delete_datacenter_connector` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_datacenter_connector(name: nil, request_id: nil)
              #   Pass arguments to `delete_datacenter_connector` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The DatacenterConnector name.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest.new
              #
              #   # Call the delete_datacenter_connector method.
              #   result = client.delete_datacenter_connector request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_datacenter_connector request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_datacenter_connector.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_datacenter_connector.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_datacenter_connector.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_datacenter_connector request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Upgrades the appliance relate to this DatacenterConnector to the in-place
              # updateable version.
              #
              # @overload upgrade_appliance(request, options = nil)
              #   Pass arguments to `upgrade_appliance` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpgradeApplianceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpgradeApplianceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload upgrade_appliance(datacenter_connector: nil, request_id: nil)
              #   Pass arguments to `upgrade_appliance` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param datacenter_connector [::String]
              #     Required. The DatacenterConnector name.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpgradeApplianceRequest.new
              #
              #   # Call the upgrade_appliance method.
              #   result = client.upgrade_appliance request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def upgrade_appliance request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpgradeApplianceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.upgrade_appliance.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.upgrade_appliance.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.upgrade_appliance.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.upgrade_appliance request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new MigratingVm in a given Source.
              #
              # @overload create_migrating_vm(request, options = nil)
              #   Pass arguments to `create_migrating_vm` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateMigratingVmRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateMigratingVmRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_migrating_vm(parent: nil, migrating_vm_id: nil, migrating_vm: nil, request_id: nil)
              #   Pass arguments to `create_migrating_vm` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The MigratingVm's parent.
              #   @param migrating_vm_id [::String]
              #     Required. The migratingVm identifier.
              #   @param migrating_vm [::Google::Cloud::VMMigration::V1::MigratingVm, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateMigratingVmRequest.new
              #
              #   # Call the create_migrating_vm method.
              #   result = client.create_migrating_vm request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_migrating_vm request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateMigratingVmRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_migrating_vm.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_migrating_vm.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_migrating_vm.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_migrating_vm request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists MigratingVms in a given Source.
              #
              # @overload list_migrating_vms(request, options = nil)
              #   Pass arguments to `list_migrating_vms` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListMigratingVmsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListMigratingVmsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_migrating_vms(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, view: nil)
              #   Pass arguments to `list_migrating_vms` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of MigratingVms.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of migrating VMs to return. The service may
              #     return fewer than this value. If unspecified, at most 500 migrating VMs
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListMigratingVms` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListMigratingVms`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              #   @param view [::Google::Cloud::VMMigration::V1::MigratingVmView]
              #     Optional. The level of details of each migrating VM.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::MigratingVm>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::MigratingVm>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListMigratingVmsRequest.new
              #
              #   # Call the list_migrating_vms method.
              #   result = client.list_migrating_vms request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::MigratingVm.
              #     p item
              #   end
              #
              def list_migrating_vms request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListMigratingVmsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_migrating_vms.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_migrating_vms.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_migrating_vms.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_migrating_vms request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_migrating_vms, "migrating_vms", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single MigratingVm.
              #
              # @overload get_migrating_vm(request, options = nil)
              #   Pass arguments to `get_migrating_vm` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetMigratingVmRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetMigratingVmRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_migrating_vm(name: nil, view: nil)
              #   Pass arguments to `get_migrating_vm` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the MigratingVm.
              #   @param view [::Google::Cloud::VMMigration::V1::MigratingVmView]
              #     Optional. The level of details of the migrating VM.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::MigratingVm]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::MigratingVm]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetMigratingVmRequest.new
              #
              #   # Call the get_migrating_vm method.
              #   result = client.get_migrating_vm request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::MigratingVm.
              #   p result
              #
              def get_migrating_vm request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetMigratingVmRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_migrating_vm.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_migrating_vm.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_migrating_vm.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_migrating_vm request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single MigratingVm.
              #
              # @overload update_migrating_vm(request, options = nil)
              #   Pass arguments to `update_migrating_vm` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_migrating_vm(update_mask: nil, migrating_vm: nil, request_id: nil)
              #   Pass arguments to `update_migrating_vm` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the
              #     MigratingVm resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param migrating_vm [::Google::Cloud::VMMigration::V1::MigratingVm, ::Hash]
              #     Required. The update request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest.new
              #
              #   # Call the update_migrating_vm method.
              #   result = client.update_migrating_vm request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_migrating_vm request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_migrating_vm.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_migrating_vm.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_migrating_vm.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.update_migrating_vm request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single MigratingVm.
              #
              # @overload delete_migrating_vm(request, options = nil)
              #   Pass arguments to `delete_migrating_vm` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_migrating_vm(name: nil)
              #   Pass arguments to `delete_migrating_vm` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest.new
              #
              #   # Call the delete_migrating_vm method.
              #   result = client.delete_migrating_vm request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_migrating_vm request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_migrating_vm.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_migrating_vm.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_migrating_vm.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_migrating_vm request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts migration for a VM. Starts the process of uploading
              # data and creating snapshots, in replication cycles scheduled by the policy.
              #
              # @overload start_migration(request, options = nil)
              #   Pass arguments to `start_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::StartMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::StartMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_migration(migrating_vm: nil)
              #   Pass arguments to `start_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param migrating_vm [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::StartMigrationRequest.new
              #
              #   # Call the start_migration method.
              #   result = client.start_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::StartMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.start_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resumes a migration for a VM. When called on a paused migration, will start
              # the process of uploading data and creating snapshots; when called on a
              # completed cut-over migration, will update the migration to active state and
              # start the process of uploading data and creating snapshots.
              #
              # @overload resume_migration(request, options = nil)
              #   Pass arguments to `resume_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ResumeMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ResumeMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_migration(migrating_vm: nil)
              #   Pass arguments to `resume_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param migrating_vm [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ResumeMigrationRequest.new
              #
              #   # Call the resume_migration method.
              #   result = client.resume_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def resume_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ResumeMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.resume_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Pauses a migration for a VM. If cycle tasks are running they will be
              # cancelled, preserving source task data. Further replication cycles will not
              # be triggered while the VM is paused.
              #
              # @overload pause_migration(request, options = nil)
              #   Pass arguments to `pause_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::PauseMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::PauseMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload pause_migration(migrating_vm: nil)
              #   Pass arguments to `pause_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param migrating_vm [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::PauseMigrationRequest.new
              #
              #   # Call the pause_migration method.
              #   result = client.pause_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def pause_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::PauseMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.pause_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.pause_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.pause_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.pause_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Marks a migration as completed, deleting migration resources that are no
              # longer being used. Only applicable after cutover is done.
              #
              # @overload finalize_migration(request, options = nil)
              #   Pass arguments to `finalize_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::FinalizeMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::FinalizeMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload finalize_migration(migrating_vm: nil)
              #   Pass arguments to `finalize_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param migrating_vm [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::FinalizeMigrationRequest.new
              #
              #   # Call the finalize_migration method.
              #   result = client.finalize_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def finalize_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::FinalizeMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.finalize_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.finalize_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.finalize_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.finalize_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Extend the migrating VM time to live.
              #
              # @overload extend_migration(request, options = nil)
              #   Pass arguments to `extend_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ExtendMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ExtendMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload extend_migration(migrating_vm: nil)
              #   Pass arguments to `extend_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param migrating_vm [::String]
              #     Required. The name of the MigratingVm.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ExtendMigrationRequest.new
              #
              #   # Call the extend_migration method.
              #   result = client.extend_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def extend_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ExtendMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.extend_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.extend_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.extend_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.extend_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates a Clone of a specific migrating VM.
              #
              # @overload create_clone_job(request, options = nil)
              #   Pass arguments to `create_clone_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateCloneJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateCloneJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_clone_job(parent: nil, clone_job_id: nil, clone_job: nil, request_id: nil)
              #   Pass arguments to `create_clone_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Clone's parent.
              #   @param clone_job_id [::String]
              #     Required. The clone job identifier.
              #   @param clone_job [::Google::Cloud::VMMigration::V1::CloneJob, ::Hash]
              #     Required. The clone request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateCloneJobRequest.new
              #
              #   # Call the create_clone_job method.
              #   result = client.create_clone_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_clone_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateCloneJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_clone_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_clone_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_clone_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_clone_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates the cancellation of a running clone job.
              #
              # @overload cancel_clone_job(request, options = nil)
              #   Pass arguments to `cancel_clone_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CancelCloneJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CancelCloneJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_clone_job(name: nil)
              #   Pass arguments to `cancel_clone_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The clone job id
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CancelCloneJobRequest.new
              #
              #   # Call the cancel_clone_job method.
              #   result = client.cancel_clone_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def cancel_clone_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CancelCloneJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_clone_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_clone_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_clone_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.cancel_clone_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the CloneJobs of a migrating VM. Only 25 most recent CloneJobs are
              # listed.
              #
              # @overload list_clone_jobs(request, options = nil)
              #   Pass arguments to `list_clone_jobs` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListCloneJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListCloneJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_clone_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_clone_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of source VMs.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of clone jobs to return. The service may
              #     return fewer than this value. If unspecified, at most 500 clone jobs will
              #     be returned. The maximum value is 1000; values above 1000 will be coerced
              #     to 1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListCloneJobs` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCloneJobs` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::CloneJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::CloneJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListCloneJobsRequest.new
              #
              #   # Call the list_clone_jobs method.
              #   result = client.list_clone_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::CloneJob.
              #     p item
              #   end
              #
              def list_clone_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListCloneJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_clone_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_clone_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_clone_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_clone_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_clone_jobs, "clone_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single CloneJob.
              #
              # @overload get_clone_job(request, options = nil)
              #   Pass arguments to `get_clone_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetCloneJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetCloneJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_clone_job(name: nil)
              #   Pass arguments to `get_clone_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CloneJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::CloneJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::CloneJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetCloneJobRequest.new
              #
              #   # Call the get_clone_job method.
              #   result = client.get_clone_job request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::CloneJob.
              #   p result
              #
              def get_clone_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetCloneJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_clone_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_clone_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_clone_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_clone_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates a Cutover of a specific migrating VM.
              # The returned LRO is completed when the cutover job resource is created
              # and the job is initiated.
              #
              # @overload create_cutover_job(request, options = nil)
              #   Pass arguments to `create_cutover_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateCutoverJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateCutoverJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cutover_job(parent: nil, cutover_job_id: nil, cutover_job: nil, request_id: nil)
              #   Pass arguments to `create_cutover_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Cutover's parent.
              #   @param cutover_job_id [::String]
              #     Required. The cutover job identifier.
              #   @param cutover_job [::Google::Cloud::VMMigration::V1::CutoverJob, ::Hash]
              #     Required. The cutover request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateCutoverJobRequest.new
              #
              #   # Call the create_cutover_job method.
              #   result = client.create_cutover_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cutover_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateCutoverJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cutover_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cutover_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cutover_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_cutover_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates the cancellation of a running cutover job.
              #
              # @overload cancel_cutover_job(request, options = nil)
              #   Pass arguments to `cancel_cutover_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CancelCutoverJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CancelCutoverJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_cutover_job(name: nil)
              #   Pass arguments to `cancel_cutover_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The cutover job id
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CancelCutoverJobRequest.new
              #
              #   # Call the cancel_cutover_job method.
              #   result = client.cancel_cutover_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def cancel_cutover_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CancelCutoverJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_cutover_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_cutover_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_cutover_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.cancel_cutover_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the CutoverJobs of a migrating VM. Only 25 most recent CutoverJobs
              # are listed.
              #
              # @overload list_cutover_jobs(request, options = nil)
              #   Pass arguments to `list_cutover_jobs` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListCutoverJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListCutoverJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_cutover_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_cutover_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of migrating VMs.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of cutover jobs to return. The service may
              #     return fewer than this value. If unspecified, at most 500 cutover jobs will
              #     be returned. The maximum value is 1000; values above 1000 will be coerced
              #     to 1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListCutoverJobs` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListCutoverJobs` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::CutoverJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::CutoverJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListCutoverJobsRequest.new
              #
              #   # Call the list_cutover_jobs method.
              #   result = client.list_cutover_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::CutoverJob.
              #     p item
              #   end
              #
              def list_cutover_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListCutoverJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_cutover_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_cutover_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_cutover_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_cutover_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_cutover_jobs, "cutover_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single CutoverJob.
              #
              # @overload get_cutover_job(request, options = nil)
              #   Pass arguments to `get_cutover_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetCutoverJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetCutoverJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cutover_job(name: nil)
              #   Pass arguments to `get_cutover_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CutoverJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::CutoverJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::CutoverJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetCutoverJobRequest.new
              #
              #   # Call the get_cutover_job method.
              #   result = client.get_cutover_job request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::CutoverJob.
              #   p result
              #
              def get_cutover_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetCutoverJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cutover_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cutover_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cutover_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_cutover_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Groups in a given project and location.
              #
              # @overload list_groups(request, options = nil)
              #   Pass arguments to `list_groups` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_groups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of groups.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of groups to return. The service may return
              #     fewer than this value. If unspecified, at most 500 groups will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListGroups` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListGroups` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::Group>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::Group>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListGroupsRequest.new
              #
              #   # Call the list_groups method.
              #   result = client.list_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::Group.
              #     p item
              #   end
              #
              def list_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_groups, "groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Group.
              #
              # @overload get_group(request, options = nil)
              #   Pass arguments to `get_group` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_group(name: nil)
              #   Pass arguments to `get_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The group name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::Group]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::Group]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetGroupRequest.new
              #
              #   # Call the get_group method.
              #   result = client.get_group request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::Group.
              #   p result
              #
              def get_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_group request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Group in a given project and location.
              #
              # @overload create_group(request, options = nil)
              #   Pass arguments to `create_group` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_group(parent: nil, group_id: nil, group: nil, request_id: nil)
              #   Pass arguments to `create_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The Group's parent.
              #   @param group_id [::String]
              #     Required. The group identifier.
              #   @param group [::Google::Cloud::VMMigration::V1::Group, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateGroupRequest.new
              #
              #   # Call the create_group method.
              #   result = client.create_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Group.
              #
              # @overload update_group(request, options = nil)
              #   Pass arguments to `update_group` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpdateGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpdateGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_group(update_mask: nil, group: nil, request_id: nil)
              #   Pass arguments to `update_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the
              #     Group resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param group [::Google::Cloud::VMMigration::V1::Group, ::Hash]
              #     Required. The update request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpdateGroupRequest.new
              #
              #   # Call the update_group method.
              #   result = client.update_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpdateGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.update_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Group.
              #
              # @overload delete_group(request, options = nil)
              #   Pass arguments to `delete_group` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteGroupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteGroupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_group(name: nil, request_id: nil)
              #   Pass arguments to `delete_group` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The Group name.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteGroupRequest.new
              #
              #   # Call the delete_group method.
              #   result = client.delete_group request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_group request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteGroupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_group.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_group.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_group.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_group request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a MigratingVm to a Group.
              #
              # @overload add_group_migration(request, options = nil)
              #   Pass arguments to `add_group_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::AddGroupMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::AddGroupMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_group_migration(group: nil, migrating_vm: nil)
              #   Pass arguments to `add_group_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param group [::String]
              #     Required. The full path name of the Group to add to.
              #   @param migrating_vm [::String]
              #     The full path name of the MigratingVm to add.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::AddGroupMigrationRequest.new
              #
              #   # Call the add_group_migration method.
              #   result = client.add_group_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def add_group_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::AddGroupMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_group_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_group_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_group_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.add_group_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a MigratingVm from a Group.
              #
              # @overload remove_group_migration(request, options = nil)
              #   Pass arguments to `remove_group_migration` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_group_migration(group: nil, migrating_vm: nil)
              #   Pass arguments to `remove_group_migration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param group [::String]
              #     Required. The name of the Group.
              #   @param migrating_vm [::String]
              #     The MigratingVm to remove.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest.new
              #
              #   # Call the remove_group_migration method.
              #   result = client.remove_group_migration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def remove_group_migration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_group_migration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_group_migration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_group_migration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.remove_group_migration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists TargetProjects in a given project.
              #
              # NOTE: TargetProject is a global resource; hence the only supported value
              # for location is `global`.
              #
              # @overload list_target_projects(request, options = nil)
              #   Pass arguments to `list_target_projects` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListTargetProjectsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListTargetProjectsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_target_projects(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_target_projects` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of targets.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of targets to return. The service may return
              #     fewer than this value. If unspecified, at most 500 targets will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListTargets` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListTargets` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::TargetProject>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::TargetProject>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListTargetProjectsRequest.new
              #
              #   # Call the list_target_projects method.
              #   result = client.list_target_projects request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::TargetProject.
              #     p item
              #   end
              #
              def list_target_projects request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListTargetProjectsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_target_projects.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_target_projects.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_target_projects.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_target_projects request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_target_projects, "target_projects", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single TargetProject.
              #
              # NOTE: TargetProject is a global resource; hence the only supported value
              # for location is `global`.
              #
              # @overload get_target_project(request, options = nil)
              #   Pass arguments to `get_target_project` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetTargetProjectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetTargetProjectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_target_project(name: nil)
              #   Pass arguments to `get_target_project` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The TargetProject name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::TargetProject]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::TargetProject]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetTargetProjectRequest.new
              #
              #   # Call the get_target_project method.
              #   result = client.get_target_project request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::TargetProject.
              #   p result
              #
              def get_target_project request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetTargetProjectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_target_project.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_target_project.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_target_project.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_target_project request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new TargetProject in a given project.
              #
              # NOTE: TargetProject is a global resource; hence the only supported value
              # for location is `global`.
              #
              # @overload create_target_project(request, options = nil)
              #   Pass arguments to `create_target_project` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateTargetProjectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateTargetProjectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_target_project(parent: nil, target_project_id: nil, target_project: nil, request_id: nil)
              #   Pass arguments to `create_target_project` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The TargetProject's parent.
              #   @param target_project_id [::String]
              #     Required. The target_project identifier.
              #   @param target_project [::Google::Cloud::VMMigration::V1::TargetProject, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateTargetProjectRequest.new
              #
              #   # Call the create_target_project method.
              #   result = client.create_target_project request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_target_project request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateTargetProjectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_target_project.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_target_project.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_target_project.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_target_project request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single TargetProject.
              #
              # NOTE: TargetProject is a global resource; hence the only supported value
              # for location is `global`.
              #
              # @overload update_target_project(request, options = nil)
              #   Pass arguments to `update_target_project` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_target_project(update_mask: nil, target_project: nil, request_id: nil)
              #   Pass arguments to `update_target_project` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the
              #     TargetProject resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param target_project [::Google::Cloud::VMMigration::V1::TargetProject, ::Hash]
              #     Required. The update request body.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest.new
              #
              #   # Call the update_target_project method.
              #   result = client.update_target_project request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_target_project request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_target_project.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_target_project.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_target_project.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.update_target_project request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single TargetProject.
              #
              # NOTE: TargetProject is a global resource; hence the only supported value
              # for location is `global`.
              #
              # @overload delete_target_project(request, options = nil)
              #   Pass arguments to `delete_target_project` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_target_project(name: nil, request_id: nil)
              #   Pass arguments to `delete_target_project` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The TargetProject name.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest.new
              #
              #   # Call the delete_target_project method.
              #   result = client.delete_target_project request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_target_project request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_target_project.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_target_project.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_target_project.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_target_project request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ReplicationCycles in a given MigratingVM.
              #
              # @overload list_replication_cycles(request, options = nil)
              #   Pass arguments to `list_replication_cycles` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_replication_cycles(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_replication_cycles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of ReplicationCycles.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of replication cycles to return. The service
              #     may return fewer than this value. If unspecified, at most 100 migrating VMs
              #     will be returned. The maximum value is 100; values above 100 will be
              #     coerced to 100.
              #   @param page_token [::String]
              #     Required. A page token, received from a previous `ListReplicationCycles`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListReplicationCycles`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request.
              #   @param order_by [::String]
              #     Optional. the order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ReplicationCycle>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ReplicationCycle>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest.new
              #
              #   # Call the list_replication_cycles method.
              #   result = client.list_replication_cycles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::ReplicationCycle.
              #     p item
              #   end
              #
              def list_replication_cycles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_replication_cycles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_replication_cycles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_replication_cycles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_replication_cycles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_replication_cycles, "replication_cycles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ReplicationCycle.
              #
              # @overload get_replication_cycle(request, options = nil)
              #   Pass arguments to `get_replication_cycle` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetReplicationCycleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetReplicationCycleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_replication_cycle(name: nil)
              #   Pass arguments to `get_replication_cycle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ReplicationCycle.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::ReplicationCycle]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::ReplicationCycle]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetReplicationCycleRequest.new
              #
              #   # Call the get_replication_cycle method.
              #   result = client.get_replication_cycle request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::ReplicationCycle.
              #   p result
              #
              def get_replication_cycle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetReplicationCycleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_replication_cycle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_replication_cycle.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_replication_cycle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_replication_cycle request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ImageImports in a given project.
              #
              # @overload list_image_imports(request, options = nil)
              #   Pass arguments to `list_image_imports` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListImageImportsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListImageImportsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_image_imports(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_image_imports` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of targets.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of targets to return. The service may return
              #     fewer than this value. If unspecified, at most 500 targets will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListImageImports` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListImageImports` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request (according to <a
              #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
              #   @param order_by [::String]
              #     Optional. The order by fields for the result (according to <a
              #     href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
              #     Currently ordering is only possible by "name" field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ImageImport>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ImageImport>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListImageImportsRequest.new
              #
              #   # Call the list_image_imports method.
              #   result = client.list_image_imports request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::ImageImport.
              #     p item
              #   end
              #
              def list_image_imports request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListImageImportsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_image_imports.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_image_imports.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_image_imports.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_image_imports request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_image_imports, "image_imports", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ImageImport.
              #
              # @overload get_image_import(request, options = nil)
              #   Pass arguments to `get_image_import` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetImageImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetImageImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_image_import(name: nil)
              #   Pass arguments to `get_image_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ImageImport name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::ImageImport]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::ImageImport]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetImageImportRequest.new
              #
              #   # Call the get_image_import method.
              #   result = client.get_image_import request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::ImageImport.
              #   p result
              #
              def get_image_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetImageImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_image_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_image_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_image_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_image_import request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new ImageImport in a given project.
              #
              # @overload create_image_import(request, options = nil)
              #   Pass arguments to `create_image_import` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateImageImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateImageImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_image_import(parent: nil, image_import_id: nil, image_import: nil, request_id: nil)
              #   Pass arguments to `create_image_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The ImageImport's parent.
              #   @param image_import_id [::String]
              #     Required. The image import identifier.
              #     This value maximum length is 63 characters, and valid characters are
              #     /[a-z][0-9]-/. It must start with an english letter and must not end with a
              #     hyphen.
              #   @param image_import [::Google::Cloud::VMMigration::V1::ImageImport, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateImageImportRequest.new
              #
              #   # Call the create_image_import method.
              #   result = client.create_image_import request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_image_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateImageImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_image_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_image_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_image_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_image_import request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single ImageImport.
              #
              # @overload delete_image_import(request, options = nil)
              #   Pass arguments to `delete_image_import` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteImageImportRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteImageImportRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_image_import(name: nil, request_id: nil)
              #   Pass arguments to `delete_image_import` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ImageImport name.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and t
              #     he request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteImageImportRequest.new
              #
              #   # Call the delete_image_import method.
              #   result = client.delete_image_import request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_image_import request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteImageImportRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_image_import.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_image_import.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_image_import.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_image_import request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ImageImportJobs in a given project.
              #
              # @overload list_image_import_jobs(request, options = nil)
              #   Pass arguments to `list_image_import_jobs` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListImageImportJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListImageImportJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_image_import_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_image_import_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of targets.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of targets to return. The service may return
              #     fewer than this value. If unspecified, at most 500 targets will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListImageImportJobs`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListImageImportJobs`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request (according to <a
              #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
              #   @param order_by [::String]
              #     Optional. The order by fields for the result (according to <a
              #     href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
              #     Currently ordering is only possible by "name" field.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ImageImportJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::ImageImportJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListImageImportJobsRequest.new
              #
              #   # Call the list_image_import_jobs method.
              #   result = client.list_image_import_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::ImageImportJob.
              #     p item
              #   end
              #
              def list_image_import_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListImageImportJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_image_import_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_image_import_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_image_import_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_image_import_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_image_import_jobs, "image_import_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single ImageImportJob.
              #
              # @overload get_image_import_job(request, options = nil)
              #   Pass arguments to `get_image_import_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetImageImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetImageImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_image_import_job(name: nil)
              #   Pass arguments to `get_image_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ImageImportJob name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::ImageImportJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::ImageImportJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetImageImportJobRequest.new
              #
              #   # Call the get_image_import_job method.
              #   result = client.get_image_import_job request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::ImageImportJob.
              #   p result
              #
              def get_image_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetImageImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_image_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_image_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_image_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_image_import_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates the cancellation of a running ImageImportJob.
              #
              # @overload cancel_image_import_job(request, options = nil)
              #   Pass arguments to `cancel_image_import_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CancelImageImportJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CancelImageImportJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_image_import_job(name: nil)
              #   Pass arguments to `cancel_image_import_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The image import job id.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CancelImageImportJobRequest.new
              #
              #   # Call the cancel_image_import_job method.
              #   result = client.cancel_image_import_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def cancel_image_import_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CancelImageImportJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_image_import_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_image_import_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_image_import_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.cancel_image_import_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new disk migration job in a given Source.
              #
              # @overload create_disk_migration_job(request, options = nil)
              #   Pass arguments to `create_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_disk_migration_job(parent: nil, disk_migration_job_id: nil, disk_migration_job: nil, request_id: nil)
              #   Pass arguments to `create_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The DiskMigrationJob's parent.
              #   @param disk_migration_job_id [::String]
              #     Required. The DiskMigrationJob identifier.
              #     The maximum length of this value is 63 characters.
              #     Valid characters are lower case Latin letters, digits and hyphen.
              #     It must start with a Latin letter and must not end with a hyphen.
              #   @param disk_migration_job [::Google::Cloud::VMMigration::V1::DiskMigrationJob, ::Hash]
              #     Required. The create request body.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request timed out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest.new
              #
              #   # Call the create_disk_migration_job method.
              #   result = client.create_disk_migration_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.create_disk_migration_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DiskMigrationJobs in a given Source.
              #
              # @overload list_disk_migration_jobs(request, options = nil)
              #   Pass arguments to `list_disk_migration_jobs` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_disk_migration_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_disk_migration_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of DiskMigrationJobs.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of disk migration jobs to return. The service
              #     may return fewer than this value. If unspecified, at most 500
              #     disk migration jobs will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListDiskMigrationJobs`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all parameters provided to `ListDiskMigrationJobs`
              #     except `page_size` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. The filter request (according to <a
              #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
              #   @param order_by [::String]
              #     Optional. Ordering of the result list.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::DiskMigrationJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VMMigration::V1::DiskMigrationJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest.new
              #
              #   # Call the list_disk_migration_jobs method.
              #   result = client.list_disk_migration_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VMMigration::V1::DiskMigrationJob.
              #     p item
              #   end
              #
              def list_disk_migration_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_disk_migration_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_disk_migration_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_disk_migration_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.list_disk_migration_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vm_migration_stub, :list_disk_migration_jobs, "disk_migration_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DiskMigrationJob.
              #
              # @overload get_disk_migration_job(request, options = nil)
              #   Pass arguments to `get_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_disk_migration_job(name: nil)
              #   Pass arguments to `get_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DiskMigrationJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VMMigration::V1::DiskMigrationJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VMMigration::V1::DiskMigrationJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest.new
              #
              #   # Call the get_disk_migration_job method.
              #   result = client.get_disk_migration_job request
              #
              #   # The returned object is of type Google::Cloud::VMMigration::V1::DiskMigrationJob.
              #   p result
              #
              def get_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.get_disk_migration_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single DiskMigrationJob.
              #
              # @overload update_disk_migration_job(request, options = nil)
              #   Pass arguments to `update_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_disk_migration_job(update_mask: nil, disk_migration_job: nil, request_id: nil)
              #   Pass arguments to `update_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     DiskMigrationJob resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask, then a mask equivalent to all fields that are
              #     populated (have a non-empty value), will be implied.
              #   @param disk_migration_job [::Google::Cloud::VMMigration::V1::DiskMigrationJob, ::Hash]
              #     Required. The update request body.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request timed out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest.new
              #
              #   # Call the update_disk_migration_job method.
              #   result = client.update_disk_migration_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.update_disk_migration_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DiskMigrationJob.
              #
              # @overload delete_disk_migration_job(request, options = nil)
              #   Pass arguments to `delete_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_disk_migration_job(name: nil)
              #   Pass arguments to `delete_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DiskMigrationJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest.new
              #
              #   # Call the delete_disk_migration_job method.
              #   result = client.delete_disk_migration_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.delete_disk_migration_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Runs the disk migration job.
              #
              # @overload run_disk_migration_job(request, options = nil)
              #   Pass arguments to `run_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_disk_migration_job(name: nil)
              #   Pass arguments to `run_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DiskMigrationJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest.new
              #
              #   # Call the run_disk_migration_job method.
              #   result = client.run_disk_migration_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def run_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.run_disk_migration_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels the disk migration job.
              #
              # @overload cancel_disk_migration_job(request, options = nil)
              #   Pass arguments to `cancel_disk_migration_job` via a request object, either of type
              #   {::Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_disk_migration_job(name: nil)
              #   Pass arguments to `cancel_disk_migration_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DiskMigrationJob.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vm_migration/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest.new
              #
              #   # Call the cancel_disk_migration_job method.
              #   result = client.cancel_disk_migration_job request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def cancel_disk_migration_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_disk_migration_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VMMigration::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_disk_migration_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_disk_migration_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vm_migration_stub.cancel_disk_migration_job request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the VmMigration REST API.
              #
              # This class represents the configuration for VmMigration REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_sources to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_sources.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_sources.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "vmmigration.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the VmMigration API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_sources`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sources
                  ##
                  # RPC-specific configuration for `get_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_source
                  ##
                  # RPC-specific configuration for `create_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_source
                  ##
                  # RPC-specific configuration for `update_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_source
                  ##
                  # RPC-specific configuration for `delete_source`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_source
                  ##
                  # RPC-specific configuration for `fetch_inventory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_inventory
                  ##
                  # RPC-specific configuration for `fetch_storage_inventory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_storage_inventory
                  ##
                  # RPC-specific configuration for `list_utilization_reports`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_utilization_reports
                  ##
                  # RPC-specific configuration for `get_utilization_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_utilization_report
                  ##
                  # RPC-specific configuration for `create_utilization_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_utilization_report
                  ##
                  # RPC-specific configuration for `delete_utilization_report`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_utilization_report
                  ##
                  # RPC-specific configuration for `list_datacenter_connectors`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_datacenter_connectors
                  ##
                  # RPC-specific configuration for `get_datacenter_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_datacenter_connector
                  ##
                  # RPC-specific configuration for `create_datacenter_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_datacenter_connector
                  ##
                  # RPC-specific configuration for `delete_datacenter_connector`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_datacenter_connector
                  ##
                  # RPC-specific configuration for `upgrade_appliance`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :upgrade_appliance
                  ##
                  # RPC-specific configuration for `create_migrating_vm`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_migrating_vm
                  ##
                  # RPC-specific configuration for `list_migrating_vms`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_migrating_vms
                  ##
                  # RPC-specific configuration for `get_migrating_vm`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_migrating_vm
                  ##
                  # RPC-specific configuration for `update_migrating_vm`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_migrating_vm
                  ##
                  # RPC-specific configuration for `delete_migrating_vm`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_migrating_vm
                  ##
                  # RPC-specific configuration for `start_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_migration
                  ##
                  # RPC-specific configuration for `resume_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_migration
                  ##
                  # RPC-specific configuration for `pause_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :pause_migration
                  ##
                  # RPC-specific configuration for `finalize_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :finalize_migration
                  ##
                  # RPC-specific configuration for `extend_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :extend_migration
                  ##
                  # RPC-specific configuration for `create_clone_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_clone_job
                  ##
                  # RPC-specific configuration for `cancel_clone_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_clone_job
                  ##
                  # RPC-specific configuration for `list_clone_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clone_jobs
                  ##
                  # RPC-specific configuration for `get_clone_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_clone_job
                  ##
                  # RPC-specific configuration for `create_cutover_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cutover_job
                  ##
                  # RPC-specific configuration for `cancel_cutover_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_cutover_job
                  ##
                  # RPC-specific configuration for `list_cutover_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cutover_jobs
                  ##
                  # RPC-specific configuration for `get_cutover_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cutover_job
                  ##
                  # RPC-specific configuration for `list_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_groups
                  ##
                  # RPC-specific configuration for `get_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_group
                  ##
                  # RPC-specific configuration for `create_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_group
                  ##
                  # RPC-specific configuration for `update_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_group
                  ##
                  # RPC-specific configuration for `delete_group`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_group
                  ##
                  # RPC-specific configuration for `add_group_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_group_migration
                  ##
                  # RPC-specific configuration for `remove_group_migration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_group_migration
                  ##
                  # RPC-specific configuration for `list_target_projects`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_target_projects
                  ##
                  # RPC-specific configuration for `get_target_project`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_target_project
                  ##
                  # RPC-specific configuration for `create_target_project`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_target_project
                  ##
                  # RPC-specific configuration for `update_target_project`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_target_project
                  ##
                  # RPC-specific configuration for `delete_target_project`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_target_project
                  ##
                  # RPC-specific configuration for `list_replication_cycles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_replication_cycles
                  ##
                  # RPC-specific configuration for `get_replication_cycle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_replication_cycle
                  ##
                  # RPC-specific configuration for `list_image_imports`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_image_imports
                  ##
                  # RPC-specific configuration for `get_image_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_image_import
                  ##
                  # RPC-specific configuration for `create_image_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_image_import
                  ##
                  # RPC-specific configuration for `delete_image_import`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_image_import
                  ##
                  # RPC-specific configuration for `list_image_import_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_image_import_jobs
                  ##
                  # RPC-specific configuration for `get_image_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_image_import_job
                  ##
                  # RPC-specific configuration for `cancel_image_import_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_image_import_job
                  ##
                  # RPC-specific configuration for `create_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_disk_migration_job
                  ##
                  # RPC-specific configuration for `list_disk_migration_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_disk_migration_jobs
                  ##
                  # RPC-specific configuration for `get_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_disk_migration_job
                  ##
                  # RPC-specific configuration for `update_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_disk_migration_job
                  ##
                  # RPC-specific configuration for `delete_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_disk_migration_job
                  ##
                  # RPC-specific configuration for `run_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_disk_migration_job
                  ##
                  # RPC-specific configuration for `cancel_disk_migration_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_disk_migration_job

                  # @private
                  def initialize parent_rpcs = nil
                    list_sources_config = parent_rpcs.list_sources if parent_rpcs.respond_to? :list_sources
                    @list_sources = ::Gapic::Config::Method.new list_sources_config
                    get_source_config = parent_rpcs.get_source if parent_rpcs.respond_to? :get_source
                    @get_source = ::Gapic::Config::Method.new get_source_config
                    create_source_config = parent_rpcs.create_source if parent_rpcs.respond_to? :create_source
                    @create_source = ::Gapic::Config::Method.new create_source_config
                    update_source_config = parent_rpcs.update_source if parent_rpcs.respond_to? :update_source
                    @update_source = ::Gapic::Config::Method.new update_source_config
                    delete_source_config = parent_rpcs.delete_source if parent_rpcs.respond_to? :delete_source
                    @delete_source = ::Gapic::Config::Method.new delete_source_config
                    fetch_inventory_config = parent_rpcs.fetch_inventory if parent_rpcs.respond_to? :fetch_inventory
                    @fetch_inventory = ::Gapic::Config::Method.new fetch_inventory_config
                    fetch_storage_inventory_config = parent_rpcs.fetch_storage_inventory if parent_rpcs.respond_to? :fetch_storage_inventory
                    @fetch_storage_inventory = ::Gapic::Config::Method.new fetch_storage_inventory_config
                    list_utilization_reports_config = parent_rpcs.list_utilization_reports if parent_rpcs.respond_to? :list_utilization_reports
                    @list_utilization_reports = ::Gapic::Config::Method.new list_utilization_reports_config
                    get_utilization_report_config = parent_rpcs.get_utilization_report if parent_rpcs.respond_to? :get_utilization_report
                    @get_utilization_report = ::Gapic::Config::Method.new get_utilization_report_config
                    create_utilization_report_config = parent_rpcs.create_utilization_report if parent_rpcs.respond_to? :create_utilization_report
                    @create_utilization_report = ::Gapic::Config::Method.new create_utilization_report_config
                    delete_utilization_report_config = parent_rpcs.delete_utilization_report if parent_rpcs.respond_to? :delete_utilization_report
                    @delete_utilization_report = ::Gapic::Config::Method.new delete_utilization_report_config
                    list_datacenter_connectors_config = parent_rpcs.list_datacenter_connectors if parent_rpcs.respond_to? :list_datacenter_connectors
                    @list_datacenter_connectors = ::Gapic::Config::Method.new list_datacenter_connectors_config
                    get_datacenter_connector_config = parent_rpcs.get_datacenter_connector if parent_rpcs.respond_to? :get_datacenter_connector
                    @get_datacenter_connector = ::Gapic::Config::Method.new get_datacenter_connector_config
                    create_datacenter_connector_config = parent_rpcs.create_datacenter_connector if parent_rpcs.respond_to? :create_datacenter_connector
                    @create_datacenter_connector = ::Gapic::Config::Method.new create_datacenter_connector_config
                    delete_datacenter_connector_config = parent_rpcs.delete_datacenter_connector if parent_rpcs.respond_to? :delete_datacenter_connector
                    @delete_datacenter_connector = ::Gapic::Config::Method.new delete_datacenter_connector_config
                    upgrade_appliance_config = parent_rpcs.upgrade_appliance if parent_rpcs.respond_to? :upgrade_appliance
                    @upgrade_appliance = ::Gapic::Config::Method.new upgrade_appliance_config
                    create_migrating_vm_config = parent_rpcs.create_migrating_vm if parent_rpcs.respond_to? :create_migrating_vm
                    @create_migrating_vm = ::Gapic::Config::Method.new create_migrating_vm_config
                    list_migrating_vms_config = parent_rpcs.list_migrating_vms if parent_rpcs.respond_to? :list_migrating_vms
                    @list_migrating_vms = ::Gapic::Config::Method.new list_migrating_vms_config
                    get_migrating_vm_config = parent_rpcs.get_migrating_vm if parent_rpcs.respond_to? :get_migrating_vm
                    @get_migrating_vm = ::Gapic::Config::Method.new get_migrating_vm_config
                    update_migrating_vm_config = parent_rpcs.update_migrating_vm if parent_rpcs.respond_to? :update_migrating_vm
                    @update_migrating_vm = ::Gapic::Config::Method.new update_migrating_vm_config
                    delete_migrating_vm_config = parent_rpcs.delete_migrating_vm if parent_rpcs.respond_to? :delete_migrating_vm
                    @delete_migrating_vm = ::Gapic::Config::Method.new delete_migrating_vm_config
                    start_migration_config = parent_rpcs.start_migration if parent_rpcs.respond_to? :start_migration
                    @start_migration = ::Gapic::Config::Method.new start_migration_config
                    resume_migration_config = parent_rpcs.resume_migration if parent_rpcs.respond_to? :resume_migration
                    @resume_migration = ::Gapic::Config::Method.new resume_migration_config
                    pause_migration_config = parent_rpcs.pause_migration if parent_rpcs.respond_to? :pause_migration
                    @pause_migration = ::Gapic::Config::Method.new pause_migration_config
                    finalize_migration_config = parent_rpcs.finalize_migration if parent_rpcs.respond_to? :finalize_migration
                    @finalize_migration = ::Gapic::Config::Method.new finalize_migration_config
                    extend_migration_config = parent_rpcs.extend_migration if parent_rpcs.respond_to? :extend_migration
                    @extend_migration = ::Gapic::Config::Method.new extend_migration_config
                    create_clone_job_config = parent_rpcs.create_clone_job if parent_rpcs.respond_to? :create_clone_job
                    @create_clone_job = ::Gapic::Config::Method.new create_clone_job_config
                    cancel_clone_job_config = parent_rpcs.cancel_clone_job if parent_rpcs.respond_to? :cancel_clone_job
                    @cancel_clone_job = ::Gapic::Config::Method.new cancel_clone_job_config
                    list_clone_jobs_config = parent_rpcs.list_clone_jobs if parent_rpcs.respond_to? :list_clone_jobs
                    @list_clone_jobs = ::Gapic::Config::Method.new list_clone_jobs_config
                    get_clone_job_config = parent_rpcs.get_clone_job if parent_rpcs.respond_to? :get_clone_job
                    @get_clone_job = ::Gapic::Config::Method.new get_clone_job_config
                    create_cutover_job_config = parent_rpcs.create_cutover_job if parent_rpcs.respond_to? :create_cutover_job
                    @create_cutover_job = ::Gapic::Config::Method.new create_cutover_job_config
                    cancel_cutover_job_config = parent_rpcs.cancel_cutover_job if parent_rpcs.respond_to? :cancel_cutover_job
                    @cancel_cutover_job = ::Gapic::Config::Method.new cancel_cutover_job_config
                    list_cutover_jobs_config = parent_rpcs.list_cutover_jobs if parent_rpcs.respond_to? :list_cutover_jobs
                    @list_cutover_jobs = ::Gapic::Config::Method.new list_cutover_jobs_config
                    get_cutover_job_config = parent_rpcs.get_cutover_job if parent_rpcs.respond_to? :get_cutover_job
                    @get_cutover_job = ::Gapic::Config::Method.new get_cutover_job_config
                    list_groups_config = parent_rpcs.list_groups if parent_rpcs.respond_to? :list_groups
                    @list_groups = ::Gapic::Config::Method.new list_groups_config
                    get_group_config = parent_rpcs.get_group if parent_rpcs.respond_to? :get_group
                    @get_group = ::Gapic::Config::Method.new get_group_config
                    create_group_config = parent_rpcs.create_group if parent_rpcs.respond_to? :create_group
                    @create_group = ::Gapic::Config::Method.new create_group_config
                    update_group_config = parent_rpcs.update_group if parent_rpcs.respond_to? :update_group
                    @update_group = ::Gapic::Config::Method.new update_group_config
                    delete_group_config = parent_rpcs.delete_group if parent_rpcs.respond_to? :delete_group
                    @delete_group = ::Gapic::Config::Method.new delete_group_config
                    add_group_migration_config = parent_rpcs.add_group_migration if parent_rpcs.respond_to? :add_group_migration
                    @add_group_migration = ::Gapic::Config::Method.new add_group_migration_config
                    remove_group_migration_config = parent_rpcs.remove_group_migration if parent_rpcs.respond_to? :remove_group_migration
                    @remove_group_migration = ::Gapic::Config::Method.new remove_group_migration_config
                    list_target_projects_config = parent_rpcs.list_target_projects if parent_rpcs.respond_to? :list_target_projects
                    @list_target_projects = ::Gapic::Config::Method.new list_target_projects_config
                    get_target_project_config = parent_rpcs.get_target_project if parent_rpcs.respond_to? :get_target_project
                    @get_target_project = ::Gapic::Config::Method.new get_target_project_config
                    create_target_project_config = parent_rpcs.create_target_project if parent_rpcs.respond_to? :create_target_project
                    @create_target_project = ::Gapic::Config::Method.new create_target_project_config
                    update_target_project_config = parent_rpcs.update_target_project if parent_rpcs.respond_to? :update_target_project
                    @update_target_project = ::Gapic::Config::Method.new update_target_project_config
                    delete_target_project_config = parent_rpcs.delete_target_project if parent_rpcs.respond_to? :delete_target_project
                    @delete_target_project = ::Gapic::Config::Method.new delete_target_project_config
                    list_replication_cycles_config = parent_rpcs.list_replication_cycles if parent_rpcs.respond_to? :list_replication_cycles
                    @list_replication_cycles = ::Gapic::Config::Method.new list_replication_cycles_config
                    get_replication_cycle_config = parent_rpcs.get_replication_cycle if parent_rpcs.respond_to? :get_replication_cycle
                    @get_replication_cycle = ::Gapic::Config::Method.new get_replication_cycle_config
                    list_image_imports_config = parent_rpcs.list_image_imports if parent_rpcs.respond_to? :list_image_imports
                    @list_image_imports = ::Gapic::Config::Method.new list_image_imports_config
                    get_image_import_config = parent_rpcs.get_image_import if parent_rpcs.respond_to? :get_image_import
                    @get_image_import = ::Gapic::Config::Method.new get_image_import_config
                    create_image_import_config = parent_rpcs.create_image_import if parent_rpcs.respond_to? :create_image_import
                    @create_image_import = ::Gapic::Config::Method.new create_image_import_config
                    delete_image_import_config = parent_rpcs.delete_image_import if parent_rpcs.respond_to? :delete_image_import
                    @delete_image_import = ::Gapic::Config::Method.new delete_image_import_config
                    list_image_import_jobs_config = parent_rpcs.list_image_import_jobs if parent_rpcs.respond_to? :list_image_import_jobs
                    @list_image_import_jobs = ::Gapic::Config::Method.new list_image_import_jobs_config
                    get_image_import_job_config = parent_rpcs.get_image_import_job if parent_rpcs.respond_to? :get_image_import_job
                    @get_image_import_job = ::Gapic::Config::Method.new get_image_import_job_config
                    cancel_image_import_job_config = parent_rpcs.cancel_image_import_job if parent_rpcs.respond_to? :cancel_image_import_job
                    @cancel_image_import_job = ::Gapic::Config::Method.new cancel_image_import_job_config
                    create_disk_migration_job_config = parent_rpcs.create_disk_migration_job if parent_rpcs.respond_to? :create_disk_migration_job
                    @create_disk_migration_job = ::Gapic::Config::Method.new create_disk_migration_job_config
                    list_disk_migration_jobs_config = parent_rpcs.list_disk_migration_jobs if parent_rpcs.respond_to? :list_disk_migration_jobs
                    @list_disk_migration_jobs = ::Gapic::Config::Method.new list_disk_migration_jobs_config
                    get_disk_migration_job_config = parent_rpcs.get_disk_migration_job if parent_rpcs.respond_to? :get_disk_migration_job
                    @get_disk_migration_job = ::Gapic::Config::Method.new get_disk_migration_job_config
                    update_disk_migration_job_config = parent_rpcs.update_disk_migration_job if parent_rpcs.respond_to? :update_disk_migration_job
                    @update_disk_migration_job = ::Gapic::Config::Method.new update_disk_migration_job_config
                    delete_disk_migration_job_config = parent_rpcs.delete_disk_migration_job if parent_rpcs.respond_to? :delete_disk_migration_job
                    @delete_disk_migration_job = ::Gapic::Config::Method.new delete_disk_migration_job_config
                    run_disk_migration_job_config = parent_rpcs.run_disk_migration_job if parent_rpcs.respond_to? :run_disk_migration_job
                    @run_disk_migration_job = ::Gapic::Config::Method.new run_disk_migration_job_config
                    cancel_disk_migration_job_config = parent_rpcs.cancel_disk_migration_job if parent_rpcs.respond_to? :cancel_disk_migration_job
                    @cancel_disk_migration_job = ::Gapic::Config::Method.new cancel_disk_migration_job_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
