# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/visionai/v1/warehouse_pb"
require "google/cloud/vision_ai/v1/warehouse"

class ::Google::Cloud::VisionAI::V1::Warehouse::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    asset = {}
    asset_id = "hello world"

    create_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateAssetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Asset), request["asset"]
      assert_equal "hello world", request["asset_id"]
      assert request.has_asset_id?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_asset({ parent: parent, asset: asset, asset_id: asset_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_asset parent: parent, asset: asset, asset_id: asset_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_asset ::Google::Cloud::VisionAI::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_asset({ parent: parent, asset: asset, asset_id: asset_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_asset(::Google::Cloud::VisionAI::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_asset_client_stub.call_rpc_count
    end
  end

  def test_update_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    asset = {}
    update_mask = {}

    update_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateAssetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Asset), request["asset"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_asset({ asset: asset, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_asset asset: asset, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_asset ::Google::Cloud::VisionAI::V1::UpdateAssetRequest.new(asset: asset, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_asset({ asset: asset, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_asset(::Google::Cloud::VisionAI::V1::UpdateAssetRequest.new(asset: asset, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_asset_client_stub.call_rpc_count
    end
  end

  def test_get_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetAssetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_asset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_asset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_asset ::Google::Cloud::VisionAI::V1::GetAssetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_asset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_asset(::Google::Cloud::VisionAI::V1::GetAssetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_asset_client_stub.call_rpc_count
    end
  end

  def test_list_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_assets, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_assets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_assets ::Google::Cloud::VisionAI::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_assets(::Google::Cloud::VisionAI::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_assets_client_stub.call_rpc_count
    end
  end

  def test_delete_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteAssetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_asset({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_asset name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_asset ::Google::Cloud::VisionAI::V1::DeleteAssetRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_asset({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_asset(::Google::Cloud::VisionAI::V1::DeleteAssetRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_asset_client_stub.call_rpc_count
    end
  end

  def test_upload_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    asset_source = {}

    upload_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upload_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UploadAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::AssetSource), request["asset_source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upload_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upload_asset({ name: name, asset_source: asset_source }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upload_asset name: name, asset_source: asset_source do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upload_asset ::Google::Cloud::VisionAI::V1::UploadAssetRequest.new(name: name, asset_source: asset_source) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upload_asset({ name: name, asset_source: asset_source }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upload_asset(::Google::Cloud::VisionAI::V1::UploadAssetRequest.new(name: name, asset_source: asset_source), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upload_asset_client_stub.call_rpc_count
    end
  end

  def test_generate_retrieval_url
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    generate_retrieval_url_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_retrieval_url, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_retrieval_url_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_retrieval_url({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_retrieval_url name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_retrieval_url ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_retrieval_url({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_retrieval_url(::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_retrieval_url_client_stub.call_rpc_count
    end
  end

  def test_analyze_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    analyze_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :analyze_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, analyze_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.analyze_asset({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.analyze_asset name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.analyze_asset ::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.analyze_asset({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.analyze_asset(::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, analyze_asset_client_stub.call_rpc_count
    end
  end

  def test_index_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    index = "hello world"

    index_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :index_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::IndexAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, index_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.index_asset({ name: name, index: index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.index_asset name: name, index: index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.index_asset ::Google::Cloud::VisionAI::V1::IndexAssetRequest.new(name: name, index: index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.index_asset({ name: name, index: index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.index_asset(::Google::Cloud::VisionAI::V1::IndexAssetRequest.new(name: name, index: index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, index_asset_client_stub.call_rpc_count
    end
  end

  def test_remove_index_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    index = "hello world"

    remove_index_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_index_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_index_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_index_asset({ name: name, index: index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_index_asset name: name, index: index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_index_asset ::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest.new(name: name, index: index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_index_asset({ name: name, index: index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_index_asset(::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest.new(name: name, index: index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_index_asset_client_stub.call_rpc_count
    end
  end

  def test_view_indexed_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    view_indexed_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :view_indexed_assets, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest, request
      assert_equal "hello world", request["index"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, view_indexed_assets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.view_indexed_assets({ index: index, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.view_indexed_assets index: index, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.view_indexed_assets ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest.new(index: index, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.view_indexed_assets({ index: index, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.view_indexed_assets(::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest.new(index: index, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, view_indexed_assets_client_stub.call_rpc_count
    end
  end

  def test_create_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index_id = "hello world"
    index = {}

    create_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateIndexRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["index_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Index), request["index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_index({ parent: parent, index_id: index_id, index: index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_index parent: parent, index_id: index_id, index: index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_index ::Google::Cloud::VisionAI::V1::CreateIndexRequest.new(parent: parent, index_id: index_id, index: index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_index({ parent: parent, index_id: index_id, index: index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_index(::Google::Cloud::VisionAI::V1::CreateIndexRequest.new(parent: parent, index_id: index_id, index: index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_index_client_stub.call_rpc_count
    end
  end

  def test_update_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index = {}
    update_mask = {}

    update_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateIndexRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Index), request["index"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_index({ index: index, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_index index: index, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_index ::Google::Cloud::VisionAI::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_index({ index: index, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_index(::Google::Cloud::VisionAI::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_index_client_stub.call_rpc_count
    end
  end

  def test_get_index
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Index.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetIndexRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_index({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_index name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_index ::Google::Cloud::VisionAI::V1::GetIndexRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_index({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_index(::Google::Cloud::VisionAI::V1::GetIndexRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_index_client_stub.call_rpc_count
    end
  end

  def test_list_indexes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListIndexesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_indexes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_indexes, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListIndexesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_indexes_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_indexes({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_indexes parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_indexes ::Google::Cloud::VisionAI::V1::ListIndexesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_indexes({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_indexes(::Google::Cloud::VisionAI::V1::ListIndexesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_indexes_client_stub.call_rpc_count
    end
  end

  def test_delete_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteIndexRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_index({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_index name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_index ::Google::Cloud::VisionAI::V1::DeleteIndexRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_index({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_index(::Google::Cloud::VisionAI::V1::DeleteIndexRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_index_client_stub.call_rpc_count
    end
  end

  def test_create_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    corpus = {}

    create_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_corpus, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateCorpusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Corpus), request["corpus"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_corpus({ parent: parent, corpus: corpus }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_corpus parent: parent, corpus: corpus do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_corpus ::Google::Cloud::VisionAI::V1::CreateCorpusRequest.new(parent: parent, corpus: corpus) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_corpus({ parent: parent, corpus: corpus }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_corpus(::Google::Cloud::VisionAI::V1::CreateCorpusRequest.new(parent: parent, corpus: corpus), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_corpus_client_stub.call_rpc_count
    end
  end

  def test_get_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Corpus.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_corpus, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetCorpusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_corpus({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_corpus name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_corpus ::Google::Cloud::VisionAI::V1::GetCorpusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_corpus({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_corpus(::Google::Cloud::VisionAI::V1::GetCorpusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_corpus_client_stub.call_rpc_count
    end
  end

  def test_update_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Corpus.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    corpus = {}
    update_mask = {}

    update_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_corpus, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateCorpusRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Corpus), request["corpus"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_corpus({ corpus: corpus, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_corpus corpus: corpus, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_corpus ::Google::Cloud::VisionAI::V1::UpdateCorpusRequest.new(corpus: corpus, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_corpus({ corpus: corpus, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_corpus(::Google::Cloud::VisionAI::V1::UpdateCorpusRequest.new(corpus: corpus, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_corpus_client_stub.call_rpc_count
    end
  end

  def test_list_corpora
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListCorporaResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_corpora_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_corpora, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListCorporaRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_corpora_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_corpora({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_corpora parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_corpora ::Google::Cloud::VisionAI::V1::ListCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_corpora({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_corpora(::Google::Cloud::VisionAI::V1::ListCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_corpora_client_stub.call_rpc_count
    end
  end

  def test_delete_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_corpus, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteCorpusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_corpus({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_corpus name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_corpus ::Google::Cloud::VisionAI::V1::DeleteCorpusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_corpus({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_corpus(::Google::Cloud::VisionAI::V1::DeleteCorpusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_corpus_client_stub.call_rpc_count
    end
  end

  def test_analyze_corpus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    analyze_corpus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :analyze_corpus, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, analyze_corpus_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.analyze_corpus({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.analyze_corpus name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.analyze_corpus ::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.analyze_corpus({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.analyze_corpus(::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, analyze_corpus_client_stub.call_rpc_count
    end
  end

  def test_create_data_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::DataSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_schema = {}

    create_data_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_schema, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::DataSchema), request["data_schema"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_schema_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_schema({ parent: parent, data_schema: data_schema }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_schema parent: parent, data_schema: data_schema do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_schema ::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest.new(parent: parent, data_schema: data_schema) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_schema({ parent: parent, data_schema: data_schema }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_schema(::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest.new(parent: parent, data_schema: data_schema), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_schema_client_stub.call_rpc_count
    end
  end

  def test_update_data_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::DataSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_schema = {}
    update_mask = {}

    update_data_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_schema, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::DataSchema), request["data_schema"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_schema_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_schema({ data_schema: data_schema, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_schema data_schema: data_schema, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_schema ::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest.new(data_schema: data_schema, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_schema({ data_schema: data_schema, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_schema(::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest.new(data_schema: data_schema, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_schema_client_stub.call_rpc_count
    end
  end

  def test_get_data_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::DataSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_schema, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetDataSchemaRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_schema_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_schema({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_schema name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_schema ::Google::Cloud::VisionAI::V1::GetDataSchemaRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_schema({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_schema(::Google::Cloud::VisionAI::V1::GetDataSchemaRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_schema_client_stub.call_rpc_count
    end
  end

  def test_delete_data_schema
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_schema, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_schema_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_schema({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_schema name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_schema ::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_schema({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_schema(::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_schema_client_stub.call_rpc_count
    end
  end

  def test_list_data_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListDataSchemasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_schemas, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListDataSchemasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_schemas_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_schemas({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_schemas parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_schemas ::Google::Cloud::VisionAI::V1::ListDataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_schemas({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_schemas(::Google::Cloud::VisionAI::V1::ListDataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_schemas_client_stub.call_rpc_count
    end
  end

  def test_create_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Annotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    annotation = {}
    annotation_id = "hello world"

    create_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_annotation, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateAnnotationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Annotation), request["annotation"]
      assert_equal "hello world", request["annotation_id"]
      assert request.has_annotation_id?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_annotation_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_annotation({ parent: parent, annotation: annotation, annotation_id: annotation_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_annotation parent: parent, annotation: annotation, annotation_id: annotation_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_annotation ::Google::Cloud::VisionAI::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, annotation_id: annotation_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_annotation({ parent: parent, annotation: annotation, annotation_id: annotation_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_annotation(::Google::Cloud::VisionAI::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, annotation_id: annotation_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_annotation_client_stub.call_rpc_count
    end
  end

  def test_get_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Annotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_annotation, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetAnnotationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_annotation_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_annotation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_annotation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_annotation ::Google::Cloud::VisionAI::V1::GetAnnotationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_annotation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_annotation(::Google::Cloud::VisionAI::V1::GetAnnotationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_annotation_client_stub.call_rpc_count
    end
  end

  def test_list_annotations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListAnnotationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_annotations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_annotations, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListAnnotationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_annotations_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_annotations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_annotations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_annotations ::Google::Cloud::VisionAI::V1::ListAnnotationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_annotations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_annotations(::Google::Cloud::VisionAI::V1::ListAnnotationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_annotations_client_stub.call_rpc_count
    end
  end

  def test_update_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Annotation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    annotation = {}
    update_mask = {}

    update_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_annotation, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Annotation), request["annotation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_annotation_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_annotation({ annotation: annotation, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_annotation annotation: annotation, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_annotation ::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest.new(annotation: annotation, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_annotation({ annotation: annotation, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_annotation(::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest.new(annotation: annotation, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_annotation_client_stub.call_rpc_count
    end
  end

  def test_delete_annotation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_annotation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_annotation, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_annotation_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_annotation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_annotation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_annotation ::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_annotation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_annotation(::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_annotation_client_stub.call_rpc_count
    end
  end

  def test_ingest_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::IngestAssetResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    config = {}

    ingest_asset_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :ingest_asset, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, ingest_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::VisionAI::V1::IngestAssetRequest.new config: config
      enum_input = [request_hash, request_proto].to_enum
      client.ingest_asset enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::IngestAssetResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { config: config }
      request_proto = ::Google::Cloud::VisionAI::V1::IngestAssetRequest.new config: config
      stream_input = Gapic::StreamInput.new
      client.ingest_asset stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::IngestAssetResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::VisionAI::V1::IngestAssetRequest.new config: config
      enum_input = [request_hash, request_proto].to_enum
      client.ingest_asset enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::IngestAssetResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { config: config }
      request_proto = ::Google::Cloud::VisionAI::V1::IngestAssetRequest.new config: config
      stream_input = Gapic::StreamInput.new
      client.ingest_asset stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::IngestAssetResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, ingest_asset_client_stub.call_rpc_count
      ingest_asset_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::IngestAssetRequest, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::IngestAssetRequest::Config), r["config"]
          assert_equal :config, r.streaming_request
        end
      end
    end
  end

  def test_clip_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ClipAssetResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    temporal_partition = {}

    clip_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :clip_asset, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ClipAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Partition::TemporalPartition), request["temporal_partition"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, clip_asset_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.clip_asset({ name: name, temporal_partition: temporal_partition }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.clip_asset name: name, temporal_partition: temporal_partition do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.clip_asset ::Google::Cloud::VisionAI::V1::ClipAssetRequest.new(name: name, temporal_partition: temporal_partition) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.clip_asset({ name: name, temporal_partition: temporal_partition }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.clip_asset(::Google::Cloud::VisionAI::V1::ClipAssetRequest.new(name: name, temporal_partition: temporal_partition), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, clip_asset_client_stub.call_rpc_count
    end
  end

  def test_generate_hls_uri
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::GenerateHlsUriResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    temporal_partitions = [{}]
    live_view_enabled = true

    generate_hls_uri_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_hls_uri, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::Partition::TemporalPartition, request["temporal_partitions"].first
      assert_equal true, request["live_view_enabled"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_hls_uri_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_hls_uri({ name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_hls_uri name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_hls_uri ::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest.new(name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_hls_uri({ name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_hls_uri(::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest.new(name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_hls_uri_client_stub.call_rpc_count
    end
  end

  def test_import_assets
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    assets_gcs_uri = "hello world"
    parent = "hello world"

    import_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_assets, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ImportAssetsRequest, request
      assert_equal "hello world", request["assets_gcs_uri"]
      assert_equal :assets_gcs_uri, request.source
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_assets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_assets({ assets_gcs_uri: assets_gcs_uri, parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_assets assets_gcs_uri: assets_gcs_uri, parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_assets ::Google::Cloud::VisionAI::V1::ImportAssetsRequest.new(assets_gcs_uri: assets_gcs_uri, parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_assets({ assets_gcs_uri: assets_gcs_uri, parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_assets(::Google::Cloud::VisionAI::V1::ImportAssetsRequest.new(assets_gcs_uri: assets_gcs_uri, parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_assets_client_stub.call_rpc_count
    end
  end

  def test_create_search_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_config = {}
    search_config_id = "hello world"

    create_search_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_search_config, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::SearchConfig), request["search_config"]
      assert_equal "hello world", request["search_config_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_search_config_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_search_config({ parent: parent, search_config: search_config, search_config_id: search_config_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_search_config parent: parent, search_config: search_config, search_config_id: search_config_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_search_config ::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest.new(parent: parent, search_config: search_config, search_config_id: search_config_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_search_config({ parent: parent, search_config: search_config, search_config_id: search_config_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_search_config(::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest.new(parent: parent, search_config: search_config, search_config_id: search_config_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_search_config_client_stub.call_rpc_count
    end
  end

  def test_update_search_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    search_config = {}
    update_mask = {}

    update_search_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_search_config, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::SearchConfig), request["search_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_search_config_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_search_config({ search_config: search_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_search_config search_config: search_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_search_config ::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest.new(search_config: search_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_search_config({ search_config: search_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_search_config(::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest.new(search_config: search_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_search_config_client_stub.call_rpc_count
    end
  end

  def test_get_search_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_search_config, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetSearchConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_search_config_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_search_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_search_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_search_config ::Google::Cloud::VisionAI::V1::GetSearchConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_search_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_search_config(::Google::Cloud::VisionAI::V1::GetSearchConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_search_config_client_stub.call_rpc_count
    end
  end

  def test_delete_search_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_search_config, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_search_config_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_search_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_search_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_search_config ::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_search_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_search_config(::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_search_config_client_stub.call_rpc_count
    end
  end

  def test_list_search_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListSearchConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_search_configs, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_search_configs_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_search_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_search_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_search_configs ::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_search_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_search_configs(::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_search_configs_client_stub.call_rpc_count
    end
  end

  def test_create_search_hypernym
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_hypernym = {}
    search_hypernym_id = "hello world"

    create_search_hypernym_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_search_hypernym, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::SearchHypernym), request["search_hypernym"]
      assert_equal "hello world", request["search_hypernym_id"]
      assert request.has_search_hypernym_id?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_search_hypernym_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_search_hypernym({ parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_search_hypernym parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_search_hypernym ::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest.new(parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_search_hypernym({ parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_search_hypernym(::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest.new(parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_search_hypernym_client_stub.call_rpc_count
    end
  end

  def test_update_search_hypernym
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    search_hypernym = {}
    update_mask = {}

    update_search_hypernym_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_search_hypernym, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::SearchHypernym), request["search_hypernym"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_search_hypernym_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_search_hypernym({ search_hypernym: search_hypernym, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_search_hypernym search_hypernym: search_hypernym, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_search_hypernym ::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest.new(search_hypernym: search_hypernym, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_search_hypernym({ search_hypernym: search_hypernym, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_search_hypernym(::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest.new(search_hypernym: search_hypernym, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_search_hypernym_client_stub.call_rpc_count
    end
  end

  def test_get_search_hypernym
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_hypernym_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_search_hypernym, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_search_hypernym_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_search_hypernym({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_search_hypernym name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_search_hypernym ::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_search_hypernym({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_search_hypernym(::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_search_hypernym_client_stub.call_rpc_count
    end
  end

  def test_delete_search_hypernym
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_hypernym_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_search_hypernym, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_search_hypernym_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_search_hypernym({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_search_hypernym name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_search_hypernym ::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_search_hypernym({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_search_hypernym(::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_search_hypernym_client_stub.call_rpc_count
    end
  end

  def test_list_search_hypernyms
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListSearchHypernymsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_hypernyms_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_search_hypernyms, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_search_hypernyms_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_search_hypernyms({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_search_hypernyms parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_search_hypernyms ::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_search_hypernyms({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_search_hypernyms(::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_search_hypernyms_client_stub.call_rpc_count
    end
  end

  def test_search_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    schema_key_sorting_strategy = {}
    corpus = "hello world"
    page_size = 42
    page_token = "hello world"
    content_time_ranges = {}
    criteria = [{}]
    facet_selections = [{}]
    result_annotation_keys = ["hello world"]
    search_query = "hello world"

    search_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_assets, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::SearchAssetsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::SchemaKeySortingStrategy), request["schema_key_sorting_strategy"]
      assert_equal :schema_key_sorting_strategy, request.sort_spec
      assert_equal "hello world", request["corpus"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::DateTimeRangeArray), request["content_time_ranges"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::Criteria, request["criteria"].first
      assert_kind_of ::Google::Cloud::VisionAI::V1::FacetGroup, request["facet_selections"].first
      assert_equal ["hello world"], request["result_annotation_keys"]
      assert_equal "hello world", request["search_query"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_assets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_assets({ schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_assets schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_assets ::Google::Cloud::VisionAI::V1::SearchAssetsRequest.new(schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_assets({ schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_assets(::Google::Cloud::VisionAI::V1::SearchAssetsRequest.new(schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_assets_client_stub.call_rpc_count
    end
  end

  def test_search_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SearchIndexEndpointResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    image_query = {}
    index_endpoint = "hello world"
    criteria = [{}]
    exclusion_criteria = [{}]
    page_size = 42
    page_token = "hello world"

    search_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_index_endpoint, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::ImageQuery), request["image_query"]
      assert_equal :image_query, request.query
      assert_equal "hello world", request["index_endpoint"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::Criteria, request["criteria"].first
      assert_kind_of ::Google::Cloud::VisionAI::V1::Criteria, request["exclusion_criteria"].first
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_index_endpoint({ image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_index_endpoint image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_index_endpoint ::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest.new(image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_index_endpoint({ image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_index_endpoint(::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest.new(image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_create_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index_endpoint_id = "hello world"
    index_endpoint = {}

    create_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_index_endpoint, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["index_endpoint_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::IndexEndpoint), request["index_endpoint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_index_endpoint({ parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_index_endpoint parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_index_endpoint ::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_index_endpoint({ parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_index_endpoint(::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_get_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::IndexEndpoint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_index_endpoint, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_index_endpoint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_index_endpoint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_index_endpoint ::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_index_endpoint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_index_endpoint(::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_list_index_endpoints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListIndexEndpointsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_index_endpoints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_index_endpoints, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_index_endpoints_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_index_endpoints({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_index_endpoints parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_index_endpoints ::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_index_endpoints({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_index_endpoints(::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_index_endpoints_client_stub.call_rpc_count
    end
  end

  def test_update_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = {}
    update_mask = {}

    update_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_index_endpoint, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::IndexEndpoint), request["index_endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_index_endpoint index_endpoint: index_endpoint, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_index_endpoint ::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_index_endpoint(::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_delete_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_index_endpoint, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_index_endpoint({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_index_endpoint name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_index_endpoint ::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_index_endpoint({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_index_endpoint(::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_deploy_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index = {}

    deploy_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeployIndexRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::DeployedIndex), request["deployed_index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_index index_endpoint: index_endpoint, deployed_index: deployed_index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_index ::Google::Cloud::VisionAI::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_index(::Google::Cloud::VisionAI::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_index_client_stub.call_rpc_count
    end
  end

  def test_undeploy_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"

    undeploy_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_index, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UndeployIndexRequest, request
      assert_equal "hello world", request["index_endpoint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_index_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_index({ index_endpoint: index_endpoint }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_index index_endpoint: index_endpoint do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_index ::Google::Cloud::VisionAI::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_index({ index_endpoint: index_endpoint }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_index(::Google::Cloud::VisionAI::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_index_client_stub.call_rpc_count
    end
  end

  def test_create_collection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    collection = {}
    collection_id = "hello world"

    create_collection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_collection, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateCollectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Collection), request["collection"]
      assert_equal "hello world", request["collection_id"]
      assert request.has_collection_id?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_collection_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_collection({ parent: parent, collection: collection, collection_id: collection_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_collection parent: parent, collection: collection, collection_id: collection_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_collection ::Google::Cloud::VisionAI::V1::CreateCollectionRequest.new(parent: parent, collection: collection, collection_id: collection_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_collection({ parent: parent, collection: collection, collection_id: collection_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_collection(::Google::Cloud::VisionAI::V1::CreateCollectionRequest.new(parent: parent, collection: collection, collection_id: collection_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_collection_client_stub.call_rpc_count
    end
  end

  def test_delete_collection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_collection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_collection, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteCollectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_collection_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_collection({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_collection name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_collection ::Google::Cloud::VisionAI::V1::DeleteCollectionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_collection({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_collection(::Google::Cloud::VisionAI::V1::DeleteCollectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_collection_client_stub.call_rpc_count
    end
  end

  def test_get_collection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Collection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_collection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_collection, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetCollectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_collection_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_collection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_collection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_collection ::Google::Cloud::VisionAI::V1::GetCollectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_collection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_collection(::Google::Cloud::VisionAI::V1::GetCollectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_collection_client_stub.call_rpc_count
    end
  end

  def test_update_collection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Collection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    collection = {}
    update_mask = {}

    update_collection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_collection, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateCollectionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Collection), request["collection"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_collection_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_collection({ collection: collection, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_collection collection: collection, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_collection ::Google::Cloud::VisionAI::V1::UpdateCollectionRequest.new(collection: collection, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_collection({ collection: collection, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_collection(::Google::Cloud::VisionAI::V1::UpdateCollectionRequest.new(collection: collection, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_collection_client_stub.call_rpc_count
    end
  end

  def test_list_collections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListCollectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_collections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_collections, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListCollectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_collections_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_collections({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_collections parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_collections ::Google::Cloud::VisionAI::V1::ListCollectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_collections({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_collections(::Google::Cloud::VisionAI::V1::ListCollectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_collections_client_stub.call_rpc_count
    end
  end

  def test_add_collection_item
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::AddCollectionItemResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    item = {}

    add_collection_item_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_collection_item, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::AddCollectionItemRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::CollectionItem), request["item"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_collection_item_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_collection_item({ item: item }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_collection_item item: item do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_collection_item ::Google::Cloud::VisionAI::V1::AddCollectionItemRequest.new(item: item) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_collection_item({ item: item }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_collection_item(::Google::Cloud::VisionAI::V1::AddCollectionItemRequest.new(item: item), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_collection_item_client_stub.call_rpc_count
    end
  end

  def test_remove_collection_item
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    item = {}

    remove_collection_item_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_collection_item, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::CollectionItem), request["item"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_collection_item_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_collection_item({ item: item }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_collection_item item: item do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_collection_item ::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest.new(item: item) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_collection_item({ item: item }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_collection_item(::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest.new(item: item), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_collection_item_client_stub.call_rpc_count
    end
  end

  def test_view_collection_items
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ViewCollectionItemsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    collection = "hello world"
    page_size = 42
    page_token = "hello world"

    view_collection_items_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :view_collection_items, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest, request
      assert_equal "hello world", request["collection"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, view_collection_items_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.view_collection_items({ collection: collection, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.view_collection_items collection: collection, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.view_collection_items ::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest.new(collection: collection, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.view_collection_items({ collection: collection, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.view_collection_items(::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest.new(collection: collection, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, view_collection_items_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::Warehouse::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::VisionAI::V1::Warehouse::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::VisionAI::V1::Warehouse::Operations, client.operations_client
  end
end
