# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/visionai/v1/warehouse_pb"
require "google/cloud/vision_ai/v1/warehouse/rest"


class ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_asset
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    asset = {}
    asset_id = "hello world"

    create_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_asset({ parent: parent, asset: asset, asset_id: asset_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_asset parent: parent, asset: asset, asset_id: asset_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_asset ::Google::Cloud::VisionAI::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_asset({ parent: parent, asset: asset, asset_id: asset_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_asset(::Google::Cloud::VisionAI::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_asset_client_stub.call_count
      end
    end
  end

  def test_update_asset
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    asset = {}
    update_mask = {}

    update_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_asset({ asset: asset, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_asset asset: asset, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_asset ::Google::Cloud::VisionAI::V1::UpdateAssetRequest.new(asset: asset, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_asset({ asset: asset, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_asset(::Google::Cloud::VisionAI::V1::UpdateAssetRequest.new(asset: asset, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_asset_client_stub.call_count
      end
    end
  end

  def test_get_asset
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_asset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_asset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_asset ::Google::Cloud::VisionAI::V1::GetAssetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_asset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_asset(::Google::Cloud::VisionAI::V1::GetAssetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_asset_client_stub.call_count
      end
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::VisionAI::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::VisionAI::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_delete_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_asset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_asset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_asset ::Google::Cloud::VisionAI::V1::DeleteAssetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_asset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_asset(::Google::Cloud::VisionAI::V1::DeleteAssetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_asset_client_stub.call_count
      end
    end
  end

  def test_upload_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    asset_source = {}

    upload_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_upload_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upload_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upload_asset({ name: name, asset_source: asset_source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upload_asset name: name, asset_source: asset_source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upload_asset ::Google::Cloud::VisionAI::V1::UploadAssetRequest.new(name: name, asset_source: asset_source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upload_asset({ name: name, asset_source: asset_source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upload_asset(::Google::Cloud::VisionAI::V1::UploadAssetRequest.new(name: name, asset_source: asset_source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upload_asset_client_stub.call_count
      end
    end
  end

  def test_generate_retrieval_url
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    generate_retrieval_url_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_generate_retrieval_url_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_retrieval_url_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_retrieval_url({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_retrieval_url name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_retrieval_url ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_retrieval_url({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_retrieval_url(::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_retrieval_url_client_stub.call_count
      end
    end
  end

  def test_analyze_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    analyze_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_analyze_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_asset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_asset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_asset ::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_asset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_asset(::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_asset_client_stub.call_count
      end
    end
  end

  def test_index_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    index = "hello world"

    index_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_index_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, index_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.index_asset({ name: name, index: index }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.index_asset name: name, index: index do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.index_asset ::Google::Cloud::VisionAI::V1::IndexAssetRequest.new(name: name, index: index) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.index_asset({ name: name, index: index }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.index_asset(::Google::Cloud::VisionAI::V1::IndexAssetRequest.new(name: name, index: index), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, index_asset_client_stub.call_count
      end
    end
  end

  def test_remove_index_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    index = "hello world"

    remove_index_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_remove_index_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_index_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_index_asset({ name: name, index: index }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_index_asset name: name, index: index do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_index_asset ::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest.new(name: name, index: index) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_index_asset({ name: name, index: index }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_index_asset(::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest.new(name: name, index: index), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_index_asset_client_stub.call_count
      end
    end
  end

  def test_view_indexed_assets
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    view_indexed_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_view_indexed_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, view_indexed_assets_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.view_indexed_assets({ index: index, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.view_indexed_assets index: index, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.view_indexed_assets ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest.new(index: index, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.view_indexed_assets({ index: index, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.view_indexed_assets(::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest.new(index: index, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, view_indexed_assets_client_stub.call_count
      end
    end
  end

  def test_create_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index_id = "hello world"
    index = {}

    create_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_index({ parent: parent, index_id: index_id, index: index }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_index parent: parent, index_id: index_id, index: index do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_index ::Google::Cloud::VisionAI::V1::CreateIndexRequest.new(parent: parent, index_id: index_id, index: index) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_index({ parent: parent, index_id: index_id, index: index }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_index(::Google::Cloud::VisionAI::V1::CreateIndexRequest.new(parent: parent, index_id: index_id, index: index), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_index_client_stub.call_count
      end
    end
  end

  def test_update_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index = {}
    update_mask = {}

    update_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_index({ index: index, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_index index: index, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_index ::Google::Cloud::VisionAI::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_index({ index: index, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_index(::Google::Cloud::VisionAI::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_index_client_stub.call_count
      end
    end
  end

  def test_get_index
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Index.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_index({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_index name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_index ::Google::Cloud::VisionAI::V1::GetIndexRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_index({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_index(::Google::Cloud::VisionAI::V1::GetIndexRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_index_client_stub.call_count
      end
    end
  end

  def test_list_indexes
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListIndexesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_indexes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_indexes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_indexes_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_indexes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_indexes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_indexes ::Google::Cloud::VisionAI::V1::ListIndexesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_indexes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_indexes(::Google::Cloud::VisionAI::V1::ListIndexesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_indexes_client_stub.call_count
      end
    end
  end

  def test_delete_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_index({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_index name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_index ::Google::Cloud::VisionAI::V1::DeleteIndexRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_index({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_index(::Google::Cloud::VisionAI::V1::DeleteIndexRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_index_client_stub.call_count
      end
    end
  end

  def test_create_corpus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    corpus = {}

    create_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_corpus({ parent: parent, corpus: corpus }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_corpus parent: parent, corpus: corpus do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_corpus ::Google::Cloud::VisionAI::V1::CreateCorpusRequest.new(parent: parent, corpus: corpus) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_corpus({ parent: parent, corpus: corpus }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_corpus(::Google::Cloud::VisionAI::V1::CreateCorpusRequest.new(parent: parent, corpus: corpus), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_corpus_client_stub.call_count
      end
    end
  end

  def test_get_corpus
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Corpus.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_corpus({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_corpus name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_corpus ::Google::Cloud::VisionAI::V1::GetCorpusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_corpus({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_corpus(::Google::Cloud::VisionAI::V1::GetCorpusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_corpus_client_stub.call_count
      end
    end
  end

  def test_update_corpus
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Corpus.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    corpus = {}
    update_mask = {}

    update_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_corpus({ corpus: corpus, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_corpus corpus: corpus, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_corpus ::Google::Cloud::VisionAI::V1::UpdateCorpusRequest.new(corpus: corpus, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_corpus({ corpus: corpus, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_corpus(::Google::Cloud::VisionAI::V1::UpdateCorpusRequest.new(corpus: corpus, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_corpus_client_stub.call_count
      end
    end
  end

  def test_list_corpora
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListCorporaResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_corpora_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_corpora_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_corpora_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_corpora({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_corpora parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_corpora ::Google::Cloud::VisionAI::V1::ListCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_corpora({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_corpora(::Google::Cloud::VisionAI::V1::ListCorporaRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_corpora_client_stub.call_count
      end
    end
  end

  def test_delete_corpus
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_corpus({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_corpus name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_corpus ::Google::Cloud::VisionAI::V1::DeleteCorpusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_corpus({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_corpus(::Google::Cloud::VisionAI::V1::DeleteCorpusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_corpus_client_stub.call_count
      end
    end
  end

  def test_analyze_corpus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    analyze_corpus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_analyze_corpus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, analyze_corpus_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.analyze_corpus({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.analyze_corpus name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.analyze_corpus ::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.analyze_corpus({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.analyze_corpus(::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, analyze_corpus_client_stub.call_count
      end
    end
  end

  def test_create_data_schema
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::DataSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_schema = {}

    create_data_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_data_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_schema_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_schema({ parent: parent, data_schema: data_schema }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_schema parent: parent, data_schema: data_schema do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_schema ::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest.new(parent: parent, data_schema: data_schema) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_schema({ parent: parent, data_schema: data_schema }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_schema(::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest.new(parent: parent, data_schema: data_schema), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_schema_client_stub.call_count
      end
    end
  end

  def test_update_data_schema
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::DataSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    data_schema = {}
    update_mask = {}

    update_data_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_data_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_schema_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_schema({ data_schema: data_schema, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_schema data_schema: data_schema, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_schema ::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest.new(data_schema: data_schema, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_schema({ data_schema: data_schema, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_schema(::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest.new(data_schema: data_schema, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_schema_client_stub.call_count
      end
    end
  end

  def test_get_data_schema
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::DataSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_data_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_schema_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_schema({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_schema name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_schema ::Google::Cloud::VisionAI::V1::GetDataSchemaRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_schema({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_schema(::Google::Cloud::VisionAI::V1::GetDataSchemaRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_schema_client_stub.call_count
      end
    end
  end

  def test_delete_data_schema
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_data_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_schema_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_schema({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_schema name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_schema ::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_schema({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_schema(::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_schema_client_stub.call_count
      end
    end
  end

  def test_list_data_schemas
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListDataSchemasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_data_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_schemas_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_schemas({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_schemas parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_schemas ::Google::Cloud::VisionAI::V1::ListDataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_schemas({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_schemas(::Google::Cloud::VisionAI::V1::ListDataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_schemas_client_stub.call_count
      end
    end
  end

  def test_create_annotation
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Annotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    annotation = {}
    annotation_id = "hello world"

    create_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_annotation({ parent: parent, annotation: annotation, annotation_id: annotation_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_annotation parent: parent, annotation: annotation, annotation_id: annotation_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_annotation ::Google::Cloud::VisionAI::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, annotation_id: annotation_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_annotation({ parent: parent, annotation: annotation, annotation_id: annotation_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_annotation(::Google::Cloud::VisionAI::V1::CreateAnnotationRequest.new(parent: parent, annotation: annotation, annotation_id: annotation_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_annotation_client_stub.call_count
      end
    end
  end

  def test_get_annotation
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Annotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_annotation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_annotation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_annotation ::Google::Cloud::VisionAI::V1::GetAnnotationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_annotation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_annotation(::Google::Cloud::VisionAI::V1::GetAnnotationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_annotation_client_stub.call_count
      end
    end
  end

  def test_list_annotations
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListAnnotationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_annotations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_annotations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_annotations_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_annotations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_annotations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_annotations ::Google::Cloud::VisionAI::V1::ListAnnotationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_annotations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_annotations(::Google::Cloud::VisionAI::V1::ListAnnotationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_annotations_client_stub.call_count
      end
    end
  end

  def test_update_annotation
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Annotation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    annotation = {}
    update_mask = {}

    update_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_annotation({ annotation: annotation, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_annotation annotation: annotation, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_annotation ::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest.new(annotation: annotation, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_annotation({ annotation: annotation, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_annotation(::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest.new(annotation: annotation, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_annotation_client_stub.call_count
      end
    end
  end

  def test_delete_annotation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_annotation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_annotation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_annotation_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_annotation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_annotation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_annotation ::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_annotation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_annotation(::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_annotation_client_stub.call_count
      end
    end
  end

  def test_clip_asset
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ClipAssetResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    temporal_partition = {}

    clip_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_clip_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, clip_asset_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.clip_asset({ name: name, temporal_partition: temporal_partition }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.clip_asset name: name, temporal_partition: temporal_partition do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.clip_asset ::Google::Cloud::VisionAI::V1::ClipAssetRequest.new(name: name, temporal_partition: temporal_partition) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.clip_asset({ name: name, temporal_partition: temporal_partition }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.clip_asset(::Google::Cloud::VisionAI::V1::ClipAssetRequest.new(name: name, temporal_partition: temporal_partition), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, clip_asset_client_stub.call_count
      end
    end
  end

  def test_generate_hls_uri
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::GenerateHlsUriResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    temporal_partitions = [{}]
    live_view_enabled = true

    generate_hls_uri_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_generate_hls_uri_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_hls_uri_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_hls_uri({ name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_hls_uri name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_hls_uri ::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest.new(name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_hls_uri({ name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_hls_uri(::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest.new(name: name, temporal_partitions: temporal_partitions, live_view_enabled: live_view_enabled), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_hls_uri_client_stub.call_count
      end
    end
  end

  def test_import_assets
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    assets_gcs_uri = "hello world"
    parent = "hello world"

    import_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_import_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_assets_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_assets({ assets_gcs_uri: assets_gcs_uri, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_assets assets_gcs_uri: assets_gcs_uri, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_assets ::Google::Cloud::VisionAI::V1::ImportAssetsRequest.new(assets_gcs_uri: assets_gcs_uri, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_assets({ assets_gcs_uri: assets_gcs_uri, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_assets(::Google::Cloud::VisionAI::V1::ImportAssetsRequest.new(assets_gcs_uri: assets_gcs_uri, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_assets_client_stub.call_count
      end
    end
  end

  def test_create_search_config
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_config = {}
    search_config_id = "hello world"

    create_search_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_search_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_search_config_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_search_config({ parent: parent, search_config: search_config, search_config_id: search_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_search_config parent: parent, search_config: search_config, search_config_id: search_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_search_config ::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest.new(parent: parent, search_config: search_config, search_config_id: search_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_search_config({ parent: parent, search_config: search_config, search_config_id: search_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_search_config(::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest.new(parent: parent, search_config: search_config, search_config_id: search_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_search_config_client_stub.call_count
      end
    end
  end

  def test_update_search_config
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    search_config = {}
    update_mask = {}

    update_search_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_search_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_search_config_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_search_config({ search_config: search_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_search_config search_config: search_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_search_config ::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest.new(search_config: search_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_search_config({ search_config: search_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_search_config(::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest.new(search_config: search_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_search_config_client_stub.call_count
      end
    end
  end

  def test_get_search_config
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_search_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_search_config_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_search_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_search_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_search_config ::Google::Cloud::VisionAI::V1::GetSearchConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_search_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_search_config(::Google::Cloud::VisionAI::V1::GetSearchConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_search_config_client_stub.call_count
      end
    end
  end

  def test_delete_search_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_search_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_search_config_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_search_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_search_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_search_config ::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_search_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_search_config(::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_search_config_client_stub.call_count
      end
    end
  end

  def test_list_search_configs
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListSearchConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_search_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_search_configs_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_search_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_search_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_search_configs ::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_search_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_search_configs(::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_search_configs_client_stub.call_count
      end
    end
  end

  def test_create_search_hypernym
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    search_hypernym = {}
    search_hypernym_id = "hello world"

    create_search_hypernym_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_search_hypernym_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_search_hypernym_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_search_hypernym({ parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_search_hypernym parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_search_hypernym ::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest.new(parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_search_hypernym({ parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_search_hypernym(::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest.new(parent: parent, search_hypernym: search_hypernym, search_hypernym_id: search_hypernym_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_search_hypernym_client_stub.call_count
      end
    end
  end

  def test_update_search_hypernym
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    search_hypernym = {}
    update_mask = {}

    update_search_hypernym_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_search_hypernym_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_search_hypernym_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_search_hypernym({ search_hypernym: search_hypernym, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_search_hypernym search_hypernym: search_hypernym, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_search_hypernym ::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest.new(search_hypernym: search_hypernym, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_search_hypernym({ search_hypernym: search_hypernym, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_search_hypernym(::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest.new(search_hypernym: search_hypernym, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_search_hypernym_client_stub.call_count
      end
    end
  end

  def test_get_search_hypernym
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchHypernym.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_search_hypernym_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_search_hypernym_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_search_hypernym_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_search_hypernym({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_search_hypernym name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_search_hypernym ::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_search_hypernym({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_search_hypernym(::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_search_hypernym_client_stub.call_count
      end
    end
  end

  def test_delete_search_hypernym
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_search_hypernym_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_search_hypernym_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_search_hypernym_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_search_hypernym({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_search_hypernym name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_search_hypernym ::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_search_hypernym({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_search_hypernym(::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_search_hypernym_client_stub.call_count
      end
    end
  end

  def test_list_search_hypernyms
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListSearchHypernymsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_search_hypernyms_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_search_hypernyms_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_search_hypernyms_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_search_hypernyms({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_search_hypernyms parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_search_hypernyms ::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_search_hypernyms({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_search_hypernyms(::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_search_hypernyms_client_stub.call_count
      end
    end
  end

  def test_search_assets
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    schema_key_sorting_strategy = {}
    corpus = "hello world"
    page_size = 42
    page_token = "hello world"
    content_time_ranges = {}
    criteria = [{}]
    facet_selections = [{}]
    result_annotation_keys = ["hello world"]
    search_query = "hello world"

    search_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_search_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_assets_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_assets({ schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_assets schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_assets ::Google::Cloud::VisionAI::V1::SearchAssetsRequest.new(schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_assets({ schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_assets(::Google::Cloud::VisionAI::V1::SearchAssetsRequest.new(schema_key_sorting_strategy: schema_key_sorting_strategy, corpus: corpus, page_size: page_size, page_token: page_token, content_time_ranges: content_time_ranges, criteria: criteria, facet_selections: facet_selections, result_annotation_keys: result_annotation_keys, search_query: search_query), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_assets_client_stub.call_count
      end
    end
  end

  def test_search_index_endpoint
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::SearchIndexEndpointResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    image_query = {}
    index_endpoint = "hello world"
    criteria = [{}]
    exclusion_criteria = [{}]
    page_size = 42
    page_token = "hello world"

    search_index_endpoint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_search_index_endpoint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_index_endpoint_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_index_endpoint({ image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_index_endpoint image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_index_endpoint ::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest.new(image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_index_endpoint({ image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_index_endpoint(::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest.new(image_query: image_query, index_endpoint: index_endpoint, criteria: criteria, exclusion_criteria: exclusion_criteria, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_index_endpoint_client_stub.call_count
      end
    end
  end

  def test_create_index_endpoint
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index_endpoint_id = "hello world"
    index_endpoint = {}

    create_index_endpoint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_index_endpoint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_index_endpoint_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_index_endpoint({ parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_index_endpoint parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_index_endpoint ::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_index_endpoint({ parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_index_endpoint(::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint_id: index_endpoint_id, index_endpoint: index_endpoint), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_index_endpoint_client_stub.call_count
      end
    end
  end

  def test_get_index_endpoint
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::IndexEndpoint.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_endpoint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_index_endpoint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_index_endpoint_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_index_endpoint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_index_endpoint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_index_endpoint ::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_index_endpoint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_index_endpoint(::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_index_endpoint_client_stub.call_count
      end
    end
  end

  def test_list_index_endpoints
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListIndexEndpointsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_index_endpoints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_index_endpoints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_index_endpoints_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_index_endpoints({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_index_endpoints parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_index_endpoints ::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_index_endpoints({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_index_endpoints(::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_index_endpoints_client_stub.call_count
      end
    end
  end

  def test_update_index_endpoint
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index_endpoint = {}
    update_mask = {}

    update_index_endpoint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_index_endpoint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_index_endpoint_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_index_endpoint index_endpoint: index_endpoint, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_index_endpoint ::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_index_endpoint(::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_index_endpoint_client_stub.call_count
      end
    end
  end

  def test_delete_index_endpoint
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_endpoint_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_index_endpoint_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_index_endpoint_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_index_endpoint({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_index_endpoint name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_index_endpoint ::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_index_endpoint({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_index_endpoint(::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_index_endpoint_client_stub.call_count
      end
    end
  end

  def test_deploy_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index = {}

    deploy_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_deploy_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_index index_endpoint: index_endpoint, deployed_index: deployed_index do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_index ::Google::Cloud::VisionAI::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_index(::Google::Cloud::VisionAI::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_index_client_stub.call_count
      end
    end
  end

  def test_undeploy_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"

    undeploy_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_undeploy_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_index_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_index({ index_endpoint: index_endpoint }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_index index_endpoint: index_endpoint do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_index ::Google::Cloud::VisionAI::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_index({ index_endpoint: index_endpoint }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_index(::Google::Cloud::VisionAI::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_index_client_stub.call_count
      end
    end
  end

  def test_create_collection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    collection = {}
    collection_id = "hello world"

    create_collection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_create_collection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_collection_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_collection({ parent: parent, collection: collection, collection_id: collection_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_collection parent: parent, collection: collection, collection_id: collection_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_collection ::Google::Cloud::VisionAI::V1::CreateCollectionRequest.new(parent: parent, collection: collection, collection_id: collection_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_collection({ parent: parent, collection: collection, collection_id: collection_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_collection(::Google::Cloud::VisionAI::V1::CreateCollectionRequest.new(parent: parent, collection: collection, collection_id: collection_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_collection_client_stub.call_count
      end
    end
  end

  def test_delete_collection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_collection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_delete_collection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_collection_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_collection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_collection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_collection ::Google::Cloud::VisionAI::V1::DeleteCollectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_collection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_collection(::Google::Cloud::VisionAI::V1::DeleteCollectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_collection_client_stub.call_count
      end
    end
  end

  def test_get_collection
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Collection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_collection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_get_collection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_collection_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_collection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_collection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_collection ::Google::Cloud::VisionAI::V1::GetCollectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_collection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_collection(::Google::Cloud::VisionAI::V1::GetCollectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_collection_client_stub.call_count
      end
    end
  end

  def test_update_collection
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Collection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    collection = {}
    update_mask = {}

    update_collection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_update_collection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_collection_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_collection({ collection: collection, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_collection collection: collection, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_collection ::Google::Cloud::VisionAI::V1::UpdateCollectionRequest.new(collection: collection, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_collection({ collection: collection, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_collection(::Google::Cloud::VisionAI::V1::UpdateCollectionRequest.new(collection: collection, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_collection_client_stub.call_count
      end
    end
  end

  def test_list_collections
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListCollectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_collections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_list_collections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_collections_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_collections({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_collections parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_collections ::Google::Cloud::VisionAI::V1::ListCollectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_collections({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_collections(::Google::Cloud::VisionAI::V1::ListCollectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_collections_client_stub.call_count
      end
    end
  end

  def test_add_collection_item
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::AddCollectionItemResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    item = {}

    add_collection_item_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_add_collection_item_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_collection_item_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_collection_item({ item: item }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_collection_item item: item do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_collection_item ::Google::Cloud::VisionAI::V1::AddCollectionItemRequest.new(item: item) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_collection_item({ item: item }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_collection_item(::Google::Cloud::VisionAI::V1::AddCollectionItemRequest.new(item: item), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_collection_item_client_stub.call_count
      end
    end
  end

  def test_remove_collection_item
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    item = {}

    remove_collection_item_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_remove_collection_item_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_collection_item_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_collection_item({ item: item }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_collection_item item: item do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_collection_item ::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest.new(item: item) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_collection_item({ item: item }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_collection_item(::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest.new(item: item), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_collection_item_client_stub.call_count
      end
    end
  end

  def test_view_collection_items
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ViewCollectionItemsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    collection = "hello world"
    page_size = 42
    page_token = "hello world"

    view_collection_items_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::Warehouse::Rest::ServiceStub.stub :transcode_view_collection_items_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, view_collection_items_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.view_collection_items({ collection: collection, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.view_collection_items collection: collection, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.view_collection_items ::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest.new(collection: collection, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.view_collection_items({ collection: collection, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.view_collection_items(::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest.new(collection: collection, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, view_collection_items_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::Warehouse::Rest::Client::Configuration, config
  end
end
