# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/visionai/v1/streaming_service_pb"
require "google/cloud/vision_ai/v1/streaming_service"

class ::Google::Cloud::VisionAI::V1::StreamingService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_send_packets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::SendPacketsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    packet = {}

    send_packets_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :send_packets, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, send_packets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { packet: packet }
      request_proto = ::Google::Cloud::VisionAI::V1::SendPacketsRequest.new packet: packet
      enum_input = [request_hash, request_proto].to_enum
      client.send_packets enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::SendPacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { packet: packet }
      request_proto = ::Google::Cloud::VisionAI::V1::SendPacketsRequest.new packet: packet
      stream_input = Gapic::StreamInput.new
      client.send_packets stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::SendPacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { packet: packet }
      request_proto = ::Google::Cloud::VisionAI::V1::SendPacketsRequest.new packet: packet
      enum_input = [request_hash, request_proto].to_enum
      client.send_packets enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::SendPacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { packet: packet }
      request_proto = ::Google::Cloud::VisionAI::V1::SendPacketsRequest.new packet: packet
      stream_input = Gapic::StreamInput.new
      client.send_packets stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::SendPacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, send_packets_client_stub.call_rpc_count
      send_packets_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::SendPacketsRequest, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Packet), r["packet"]
          assert_equal :packet, r.request
        end
      end
    end
  end

  def test_receive_packets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    setup_request = {}

    receive_packets_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :receive_packets, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, receive_packets_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new setup_request: setup_request
      enum_input = [request_hash, request_proto].to_enum
      client.receive_packets enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new setup_request: setup_request
      stream_input = Gapic::StreamInput.new
      client.receive_packets stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new setup_request: setup_request
      enum_input = [request_hash, request_proto].to_enum
      client.receive_packets enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new setup_request: setup_request
      stream_input = Gapic::StreamInput.new
      client.receive_packets stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, receive_packets_client_stub.call_rpc_count
      receive_packets_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest::SetupRequest), r["setup_request"]
          assert_equal :setup_request, r.request
        end
      end
    end
  end

  def test_receive_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    setup_request = {}

    receive_events_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :receive_events, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, receive_events_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new setup_request: setup_request
      enum_input = [request_hash, request_proto].to_enum
      client.receive_events enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new setup_request: setup_request
      stream_input = Gapic::StreamInput.new
      client.receive_events stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new setup_request: setup_request
      enum_input = [request_hash, request_proto].to_enum
      client.receive_events enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { setup_request: setup_request }
      request_proto = ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new setup_request: setup_request
      stream_input = Gapic::StreamInput.new
      client.receive_events stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, receive_events_client_stub.call_rpc_count
      receive_events_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest, r
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest::SetupRequest), r["setup_request"]
          assert_equal :setup_request, r.request
        end
      end
    end
  end

  def test_acquire_lease
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Lease.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    series = "hello world"
    owner = "hello world"
    term = {}
    lease_type = :LEASE_TYPE_UNSPECIFIED

    acquire_lease_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :acquire_lease, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::AcquireLeaseRequest, request
      assert_equal "hello world", request["series"]
      assert_equal "hello world", request["owner"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["term"]
      assert_equal :LEASE_TYPE_UNSPECIFIED, request["lease_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, acquire_lease_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.acquire_lease({ series: series, owner: owner, term: term, lease_type: lease_type }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.acquire_lease series: series, owner: owner, term: term, lease_type: lease_type do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.acquire_lease ::Google::Cloud::VisionAI::V1::AcquireLeaseRequest.new(series: series, owner: owner, term: term, lease_type: lease_type) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.acquire_lease({ series: series, owner: owner, term: term, lease_type: lease_type }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.acquire_lease(::Google::Cloud::VisionAI::V1::AcquireLeaseRequest.new(series: series, owner: owner, term: term, lease_type: lease_type), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, acquire_lease_client_stub.call_rpc_count
    end
  end

  def test_renew_lease
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Lease.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    id = "hello world"
    series = "hello world"
    owner = "hello world"
    term = {}

    renew_lease_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :renew_lease, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::RenewLeaseRequest, request
      assert_equal "hello world", request["id"]
      assert_equal "hello world", request["series"]
      assert_equal "hello world", request["owner"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["term"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, renew_lease_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.renew_lease({ id: id, series: series, owner: owner, term: term }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.renew_lease id: id, series: series, owner: owner, term: term do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.renew_lease ::Google::Cloud::VisionAI::V1::RenewLeaseRequest.new(id: id, series: series, owner: owner, term: term) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.renew_lease({ id: id, series: series, owner: owner, term: term }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.renew_lease(::Google::Cloud::VisionAI::V1::RenewLeaseRequest.new(id: id, series: series, owner: owner, term: term), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, renew_lease_client_stub.call_rpc_count
    end
  end

  def test_release_lease
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ReleaseLeaseResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    id = "hello world"
    series = "hello world"
    owner = "hello world"

    release_lease_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :release_lease, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest, request
      assert_equal "hello world", request["id"]
      assert_equal "hello world", request["series"]
      assert_equal "hello world", request["owner"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, release_lease_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.release_lease({ id: id, series: series, owner: owner }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.release_lease id: id, series: series, owner: owner do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.release_lease ::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest.new(id: id, series: series, owner: owner) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.release_lease({ id: id, series: series, owner: owner }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.release_lease(::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest.new(id: id, series: series, owner: owner), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, release_lease_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::StreamingService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::VisionAI::V1::StreamingService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
