# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/visionai/v1/lva_service_pb"
require "google/cloud/vision_ai/v1/live_video_analytics"

class ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_public_operators
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListPublicOperatorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_public_operators_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_public_operators, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListPublicOperatorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_public_operators_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_public_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_public_operators parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_public_operators ::Google::Cloud::VisionAI::V1::ListPublicOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_public_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_public_operators(::Google::Cloud::VisionAI::V1::ListPublicOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_public_operators_client_stub.call_rpc_count
    end
  end

  def test_resolve_operator_info
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ResolveOperatorInfoResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    queries = [{}]

    resolve_operator_info_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resolve_operator_info, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ResolveOperatorInfoRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::OperatorQuery, request["queries"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resolve_operator_info_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resolve_operator_info({ parent: parent, queries: queries }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resolve_operator_info parent: parent, queries: queries do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resolve_operator_info ::Google::Cloud::VisionAI::V1::ResolveOperatorInfoRequest.new(parent: parent, queries: queries) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resolve_operator_info({ parent: parent, queries: queries }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resolve_operator_info(::Google::Cloud::VisionAI::V1::ResolveOperatorInfoRequest.new(parent: parent, queries: queries), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resolve_operator_info_client_stub.call_rpc_count
    end
  end

  def test_list_operators
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListOperatorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_operators_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_operators, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListOperatorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_operators_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_operators parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_operators ::Google::Cloud::VisionAI::V1::ListOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_operators(::Google::Cloud::VisionAI::V1::ListOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_operators_client_stub.call_rpc_count
    end
  end

  def test_get_operator
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Operator.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_operator_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_operator, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetOperatorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_operator_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_operator({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_operator name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_operator ::Google::Cloud::VisionAI::V1::GetOperatorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_operator({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_operator(::Google::Cloud::VisionAI::V1::GetOperatorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_operator_client_stub.call_rpc_count
    end
  end

  def test_create_operator
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    operator_id = "hello world"
    operator = {}
    request_id = "hello world"

    create_operator_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_operator, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateOperatorRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["operator_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Operator), request["operator"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_operator_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_operator({ parent: parent, operator_id: operator_id, operator: operator, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_operator parent: parent, operator_id: operator_id, operator: operator, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_operator ::Google::Cloud::VisionAI::V1::CreateOperatorRequest.new(parent: parent, operator_id: operator_id, operator: operator, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_operator({ parent: parent, operator_id: operator_id, operator: operator, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_operator(::Google::Cloud::VisionAI::V1::CreateOperatorRequest.new(parent: parent, operator_id: operator_id, operator: operator, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_operator_client_stub.call_rpc_count
    end
  end

  def test_update_operator
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    operator = {}
    request_id = "hello world"

    update_operator_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_operator, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateOperatorRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Operator), request["operator"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_operator_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_operator({ update_mask: update_mask, operator: operator, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_operator update_mask: update_mask, operator: operator, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_operator ::Google::Cloud::VisionAI::V1::UpdateOperatorRequest.new(update_mask: update_mask, operator: operator, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_operator({ update_mask: update_mask, operator: operator, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_operator(::Google::Cloud::VisionAI::V1::UpdateOperatorRequest.new(update_mask: update_mask, operator: operator, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_operator_client_stub.call_rpc_count
    end
  end

  def test_delete_operator
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_operator_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_operator, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteOperatorRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_operator_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_operator({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_operator name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_operator ::Google::Cloud::VisionAI::V1::DeleteOperatorRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_operator({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_operator(::Google::Cloud::VisionAI::V1::DeleteOperatorRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_operator_client_stub.call_rpc_count
    end
  end

  def test_list_analyses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListAnalysesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_analyses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_analyses, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListAnalysesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_analyses_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_analyses parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_analyses ::Google::Cloud::VisionAI::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_analyses(::Google::Cloud::VisionAI::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_analyses_client_stub.call_rpc_count
    end
  end

  def test_get_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Analysis.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_analysis, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetAnalysisRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_analysis({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_analysis name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_analysis ::Google::Cloud::VisionAI::V1::GetAnalysisRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_analysis({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_analysis(::Google::Cloud::VisionAI::V1::GetAnalysisRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_analysis_client_stub.call_rpc_count
    end
  end

  def test_create_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis_id = "hello world"
    analysis = {}
    request_id = "hello world"

    create_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_analysis, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateAnalysisRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["analysis_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Analysis), request["analysis"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_analysis({ parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_analysis parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_analysis ::Google::Cloud::VisionAI::V1::CreateAnalysisRequest.new(parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_analysis({ parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_analysis(::Google::Cloud::VisionAI::V1::CreateAnalysisRequest.new(parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_analysis_client_stub.call_rpc_count
    end
  end

  def test_update_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    analysis = {}
    request_id = "hello world"

    update_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_analysis, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateAnalysisRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Analysis), request["analysis"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_analysis({ update_mask: update_mask, analysis: analysis, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_analysis update_mask: update_mask, analysis: analysis, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_analysis ::Google::Cloud::VisionAI::V1::UpdateAnalysisRequest.new(update_mask: update_mask, analysis: analysis, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_analysis({ update_mask: update_mask, analysis: analysis, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_analysis(::Google::Cloud::VisionAI::V1::UpdateAnalysisRequest.new(update_mask: update_mask, analysis: analysis, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_analysis_client_stub.call_rpc_count
    end
  end

  def test_delete_analysis
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_analysis_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_analysis, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteAnalysisRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_analysis_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_analysis({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_analysis name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_analysis ::Google::Cloud::VisionAI::V1::DeleteAnalysisRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_analysis({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_analysis(::Google::Cloud::VisionAI::V1::DeleteAnalysisRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_analysis_client_stub.call_rpc_count
    end
  end

  def test_list_processes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListProcessesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_processes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_processes, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListProcessesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_processes_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_processes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_processes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_processes ::Google::Cloud::VisionAI::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_processes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_processes(::Google::Cloud::VisionAI::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_processes_client_stub.call_rpc_count
    end
  end

  def test_get_process
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Process.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_process, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetProcessRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_process_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_process({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_process name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_process ::Google::Cloud::VisionAI::V1::GetProcessRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_process({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_process(::Google::Cloud::VisionAI::V1::GetProcessRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_process_client_stub.call_rpc_count
    end
  end

  def test_create_process
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    process_id = "hello world"
    process = {}
    request_id = "hello world"

    create_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_process, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateProcessRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["process_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Process), request["process"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_process_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_process({ parent: parent, process_id: process_id, process: process, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_process parent: parent, process_id: process_id, process: process, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_process ::Google::Cloud::VisionAI::V1::CreateProcessRequest.new(parent: parent, process_id: process_id, process: process, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_process({ parent: parent, process_id: process_id, process: process, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_process(::Google::Cloud::VisionAI::V1::CreateProcessRequest.new(parent: parent, process_id: process_id, process: process, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_process_client_stub.call_rpc_count
    end
  end

  def test_update_process
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    process = {}
    request_id = "hello world"

    update_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_process, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateProcessRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Process), request["process"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_process_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_process({ update_mask: update_mask, process: process, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_process update_mask: update_mask, process: process, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_process ::Google::Cloud::VisionAI::V1::UpdateProcessRequest.new(update_mask: update_mask, process: process, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_process({ update_mask: update_mask, process: process, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_process(::Google::Cloud::VisionAI::V1::UpdateProcessRequest.new(update_mask: update_mask, process: process, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_process_client_stub.call_rpc_count
    end
  end

  def test_delete_process
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_process, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteProcessRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_process_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_process({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_process name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_process ::Google::Cloud::VisionAI::V1::DeleteProcessRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_process({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_process(::Google::Cloud::VisionAI::V1::DeleteProcessRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_process_client_stub.call_rpc_count
    end
  end

  def test_batch_run_process
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]
    options = {}
    batch_id = "hello world"

    batch_run_process_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_run_process, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::BatchRunProcessRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateProcessRequest, request["requests"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::BatchRunProcessRequest::BatchRunProcessOptions), request["options"]
      assert_equal "hello world", request["batch_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_run_process_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_run_process({ parent: parent, requests: requests, options: options, batch_id: batch_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_run_process parent: parent, requests: requests, options: options, batch_id: batch_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_run_process ::Google::Cloud::VisionAI::V1::BatchRunProcessRequest.new(parent: parent, requests: requests, options: options, batch_id: batch_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_run_process({ parent: parent, requests: requests, options: options, batch_id: batch_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_run_process(::Google::Cloud::VisionAI::V1::BatchRunProcessRequest.new(parent: parent, requests: requests, options: options, batch_id: batch_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_run_process_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Operations, client.operations_client
  end
end
