# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/visionai/v1/lva_service_pb"
require "google/cloud/vision_ai/v1/live_video_analytics/rest"


class ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_public_operators
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListPublicOperatorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_public_operators_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_list_public_operators_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_public_operators_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_public_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_public_operators parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_public_operators ::Google::Cloud::VisionAI::V1::ListPublicOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_public_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_public_operators(::Google::Cloud::VisionAI::V1::ListPublicOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_public_operators_client_stub.call_count
      end
    end
  end

  def test_resolve_operator_info
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ResolveOperatorInfoResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    queries = [{}]

    resolve_operator_info_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_resolve_operator_info_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resolve_operator_info_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resolve_operator_info({ parent: parent, queries: queries }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resolve_operator_info parent: parent, queries: queries do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resolve_operator_info ::Google::Cloud::VisionAI::V1::ResolveOperatorInfoRequest.new(parent: parent, queries: queries) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resolve_operator_info({ parent: parent, queries: queries }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resolve_operator_info(::Google::Cloud::VisionAI::V1::ResolveOperatorInfoRequest.new(parent: parent, queries: queries), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resolve_operator_info_client_stub.call_count
      end
    end
  end

  def test_list_operators
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListOperatorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_operators_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_list_operators_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_operators_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_operators parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_operators ::Google::Cloud::VisionAI::V1::ListOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_operators({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_operators(::Google::Cloud::VisionAI::V1::ListOperatorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_operators_client_stub.call_count
      end
    end
  end

  def test_get_operator
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Operator.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_operator_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_get_operator_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_operator_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_operator({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_operator name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_operator ::Google::Cloud::VisionAI::V1::GetOperatorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_operator({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_operator(::Google::Cloud::VisionAI::V1::GetOperatorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_operator_client_stub.call_count
      end
    end
  end

  def test_create_operator
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    operator_id = "hello world"
    operator = {}
    request_id = "hello world"

    create_operator_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_create_operator_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_operator_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_operator({ parent: parent, operator_id: operator_id, operator: operator, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_operator parent: parent, operator_id: operator_id, operator: operator, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_operator ::Google::Cloud::VisionAI::V1::CreateOperatorRequest.new(parent: parent, operator_id: operator_id, operator: operator, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_operator({ parent: parent, operator_id: operator_id, operator: operator, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_operator(::Google::Cloud::VisionAI::V1::CreateOperatorRequest.new(parent: parent, operator_id: operator_id, operator: operator, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_operator_client_stub.call_count
      end
    end
  end

  def test_update_operator
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    operator = {}
    request_id = "hello world"

    update_operator_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_update_operator_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_operator_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_operator({ update_mask: update_mask, operator: operator, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_operator update_mask: update_mask, operator: operator, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_operator ::Google::Cloud::VisionAI::V1::UpdateOperatorRequest.new(update_mask: update_mask, operator: operator, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_operator({ update_mask: update_mask, operator: operator, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_operator(::Google::Cloud::VisionAI::V1::UpdateOperatorRequest.new(update_mask: update_mask, operator: operator, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_operator_client_stub.call_count
      end
    end
  end

  def test_delete_operator
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_operator_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_delete_operator_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_operator_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_operator({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_operator name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_operator ::Google::Cloud::VisionAI::V1::DeleteOperatorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_operator({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_operator(::Google::Cloud::VisionAI::V1::DeleteOperatorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_operator_client_stub.call_count
      end
    end
  end

  def test_list_analyses
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListAnalysesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_analyses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_list_analyses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_analyses_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_analyses parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_analyses ::Google::Cloud::VisionAI::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_analyses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_analyses(::Google::Cloud::VisionAI::V1::ListAnalysesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_analyses_client_stub.call_count
      end
    end
  end

  def test_get_analysis
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Analysis.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_get_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_analysis({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_analysis name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_analysis ::Google::Cloud::VisionAI::V1::GetAnalysisRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_analysis({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_analysis(::Google::Cloud::VisionAI::V1::GetAnalysisRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_analysis_client_stub.call_count
      end
    end
  end

  def test_create_analysis
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    analysis_id = "hello world"
    analysis = {}
    request_id = "hello world"

    create_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_create_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_analysis({ parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_analysis parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_analysis ::Google::Cloud::VisionAI::V1::CreateAnalysisRequest.new(parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_analysis({ parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_analysis(::Google::Cloud::VisionAI::V1::CreateAnalysisRequest.new(parent: parent, analysis_id: analysis_id, analysis: analysis, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_analysis_client_stub.call_count
      end
    end
  end

  def test_update_analysis
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    analysis = {}
    request_id = "hello world"

    update_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_update_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_analysis({ update_mask: update_mask, analysis: analysis, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_analysis update_mask: update_mask, analysis: analysis, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_analysis ::Google::Cloud::VisionAI::V1::UpdateAnalysisRequest.new(update_mask: update_mask, analysis: analysis, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_analysis({ update_mask: update_mask, analysis: analysis, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_analysis(::Google::Cloud::VisionAI::V1::UpdateAnalysisRequest.new(update_mask: update_mask, analysis: analysis, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_analysis_client_stub.call_count
      end
    end
  end

  def test_delete_analysis
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_analysis_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_delete_analysis_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_analysis_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_analysis({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_analysis name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_analysis ::Google::Cloud::VisionAI::V1::DeleteAnalysisRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_analysis({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_analysis(::Google::Cloud::VisionAI::V1::DeleteAnalysisRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_analysis_client_stub.call_count
      end
    end
  end

  def test_list_processes
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListProcessesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_processes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_list_processes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processes_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processes ::Google::Cloud::VisionAI::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processes(::Google::Cloud::VisionAI::V1::ListProcessesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processes_client_stub.call_count
      end
    end
  end

  def test_get_process
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Process.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_get_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_process_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_process({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_process name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_process ::Google::Cloud::VisionAI::V1::GetProcessRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_process({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_process(::Google::Cloud::VisionAI::V1::GetProcessRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_process_client_stub.call_count
      end
    end
  end

  def test_create_process
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    process_id = "hello world"
    process = {}
    request_id = "hello world"

    create_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_create_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_process_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_process({ parent: parent, process_id: process_id, process: process, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_process parent: parent, process_id: process_id, process: process, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_process ::Google::Cloud::VisionAI::V1::CreateProcessRequest.new(parent: parent, process_id: process_id, process: process, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_process({ parent: parent, process_id: process_id, process: process, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_process(::Google::Cloud::VisionAI::V1::CreateProcessRequest.new(parent: parent, process_id: process_id, process: process, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_process_client_stub.call_count
      end
    end
  end

  def test_update_process
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    process = {}
    request_id = "hello world"

    update_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_update_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_process_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_process({ update_mask: update_mask, process: process, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_process update_mask: update_mask, process: process, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_process ::Google::Cloud::VisionAI::V1::UpdateProcessRequest.new(update_mask: update_mask, process: process, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_process({ update_mask: update_mask, process: process, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_process(::Google::Cloud::VisionAI::V1::UpdateProcessRequest.new(update_mask: update_mask, process: process, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_process_client_stub.call_count
      end
    end
  end

  def test_delete_process
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_delete_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_process_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_process({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_process name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_process ::Google::Cloud::VisionAI::V1::DeleteProcessRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_process({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_process(::Google::Cloud::VisionAI::V1::DeleteProcessRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_process_client_stub.call_count
      end
    end
  end

  def test_batch_run_process
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]
    options = {}
    batch_id = "hello world"

    batch_run_process_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::ServiceStub.stub :transcode_batch_run_process_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_run_process_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_run_process({ parent: parent, requests: requests, options: options, batch_id: batch_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_run_process parent: parent, requests: requests, options: options, batch_id: batch_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_run_process ::Google::Cloud::VisionAI::V1::BatchRunProcessRequest.new(parent: parent, requests: requests, options: options, batch_id: batch_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_run_process({ parent: parent, requests: requests, options: options, batch_id: batch_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_run_process(::Google::Cloud::VisionAI::V1::BatchRunProcessRequest.new(parent: parent, requests: requests, options: options, batch_id: batch_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_run_process_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::LiveVideoAnalytics::Rest::Client::Configuration, config
  end
end
