# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/visionai/v1/platform_pb"
require "google/cloud/vision_ai/v1/app_platform"

class ::Google::Cloud::VisionAI::V1::AppPlatform::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_applications
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListApplicationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_applications_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_applications, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListApplicationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_applications_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_applications parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_applications ::Google::Cloud::VisionAI::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_applications(::Google::Cloud::VisionAI::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_applications_client_stub.call_rpc_count
    end
  end

  def test_get_application
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Application.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetApplicationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_application({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_application name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_application ::Google::Cloud::VisionAI::V1::GetApplicationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_application({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_application(::Google::Cloud::VisionAI::V1::GetApplicationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_application_client_stub.call_rpc_count
    end
  end

  def test_create_application
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    application_id = "hello world"
    application = {}
    request_id = "hello world"

    create_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateApplicationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["application_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Application), request["application"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_application parent: parent, application_id: application_id, application: application, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_application ::Google::Cloud::VisionAI::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_application(::Google::Cloud::VisionAI::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_application_client_stub.call_rpc_count
    end
  end

  def test_update_application
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    application = {}
    request_id = "hello world"

    update_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateApplicationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Application), request["application"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_application({ update_mask: update_mask, application: application, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_application update_mask: update_mask, application: application, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_application ::Google::Cloud::VisionAI::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_application({ update_mask: update_mask, application: application, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_application(::Google::Cloud::VisionAI::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_application_client_stub.call_rpc_count
    end
  end

  def test_delete_application
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteApplicationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_application({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_application name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_application ::Google::Cloud::VisionAI::V1::DeleteApplicationRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_application({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_application(::Google::Cloud::VisionAI::V1::DeleteApplicationRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_application_client_stub.call_rpc_count
    end
  end

  def test_deploy_application
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    request_id = "hello world"
    enable_monitoring = true

    deploy_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeployApplicationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["enable_monitoring"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_application({ name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_application name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_application ::Google::Cloud::VisionAI::V1::DeployApplicationRequest.new(name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_application({ name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_application(::Google::Cloud::VisionAI::V1::DeployApplicationRequest.new(name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_application_client_stub.call_rpc_count
    end
  end

  def test_undeploy_application
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undeploy_application_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_application, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UndeployApplicationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_application_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_application({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_application name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_application ::Google::Cloud::VisionAI::V1::UndeployApplicationRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_application({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_application(::Google::Cloud::VisionAI::V1::UndeployApplicationRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_application_client_stub.call_rpc_count
    end
  end

  def test_add_application_stream_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_stream_inputs = [{}]
    request_id = "hello world"

    add_application_stream_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_application_stream_input, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::AddApplicationStreamInputRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::ApplicationStreamInput, request["application_stream_inputs"].first
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_application_stream_input_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_application_stream_input name: name, application_stream_inputs: application_stream_inputs, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_application_stream_input ::Google::Cloud::VisionAI::V1::AddApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_application_stream_input(::Google::Cloud::VisionAI::V1::AddApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_application_stream_input_client_stub.call_rpc_count
    end
  end

  def test_remove_application_stream_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_stream_inputs = [{}]
    request_id = "hello world"

    remove_application_stream_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_application_stream_input, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest::TargetStreamInput, request["target_stream_inputs"].first
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_application_stream_input_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_application_stream_input({ name: name, target_stream_inputs: target_stream_inputs, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_application_stream_input name: name, target_stream_inputs: target_stream_inputs, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_application_stream_input ::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest.new(name: name, target_stream_inputs: target_stream_inputs, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_application_stream_input({ name: name, target_stream_inputs: target_stream_inputs, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_application_stream_input(::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest.new(name: name, target_stream_inputs: target_stream_inputs, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_application_stream_input_client_stub.call_rpc_count
    end
  end

  def test_update_application_stream_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_stream_inputs = [{}]
    request_id = "hello world"
    allow_missing = true

    update_application_stream_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_application_stream_input, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateApplicationStreamInputRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::ApplicationStreamInput, request["application_stream_inputs"].first
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_application_stream_input_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_application_stream_input name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_application_stream_input ::Google::Cloud::VisionAI::V1::UpdateApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_application_stream_input(::Google::Cloud::VisionAI::V1::UpdateApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_application_stream_input_client_stub.call_rpc_count
    end
  end

  def test_list_instances
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListInstancesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instances, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListInstancesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instances_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instances ::Google::Cloud::VisionAI::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instances(::Google::Cloud::VisionAI::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instances_client_stub.call_rpc_count
    end
  end

  def test_get_instance
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Instance.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instance, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetInstanceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instance_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instance({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instance name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instance ::Google::Cloud::VisionAI::V1::GetInstanceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instance({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instance(::Google::Cloud::VisionAI::V1::GetInstanceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instance_client_stub.call_rpc_count
    end
  end

  def test_create_application_instances
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_instances = [{}]
    request_id = "hello world"

    create_application_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_application_instances, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateApplicationInstancesRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::ApplicationInstance, request["application_instances"].first
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_application_instances_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_application_instances({ name: name, application_instances: application_instances, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_application_instances name: name, application_instances: application_instances, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_application_instances ::Google::Cloud::VisionAI::V1::CreateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_application_instances({ name: name, application_instances: application_instances, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_application_instances(::Google::Cloud::VisionAI::V1::CreateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_application_instances_client_stub.call_rpc_count
    end
  end

  def test_delete_application_instances
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    instance_ids = ["hello world"]
    request_id = "hello world"

    delete_application_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_application_instances, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteApplicationInstancesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["instance_ids"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_application_instances_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_application_instances({ name: name, instance_ids: instance_ids, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_application_instances name: name, instance_ids: instance_ids, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_application_instances ::Google::Cloud::VisionAI::V1::DeleteApplicationInstancesRequest.new(name: name, instance_ids: instance_ids, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_application_instances({ name: name, instance_ids: instance_ids, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_application_instances(::Google::Cloud::VisionAI::V1::DeleteApplicationInstancesRequest.new(name: name, instance_ids: instance_ids, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_application_instances_client_stub.call_rpc_count
    end
  end

  def test_update_application_instances
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_instances = [{}]
    request_id = "hello world"
    allow_missing = true

    update_application_instances_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_application_instances, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest::UpdateApplicationInstance, request["application_instances"].first
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_application_instances_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_application_instances({ name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_application_instances name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_application_instances ::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_application_instances({ name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_application_instances(::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_application_instances_client_stub.call_rpc_count
    end
  end

  def test_list_drafts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListDraftsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_drafts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_drafts, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListDraftsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_drafts_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_drafts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_drafts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_drafts ::Google::Cloud::VisionAI::V1::ListDraftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_drafts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_drafts(::Google::Cloud::VisionAI::V1::ListDraftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_drafts_client_stub.call_rpc_count
    end
  end

  def test_get_draft
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Draft.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_draft_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_draft, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetDraftRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_draft_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_draft({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_draft name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_draft ::Google::Cloud::VisionAI::V1::GetDraftRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_draft({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_draft(::Google::Cloud::VisionAI::V1::GetDraftRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_draft_client_stub.call_rpc_count
    end
  end

  def test_create_draft
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    draft_id = "hello world"
    draft = {}
    request_id = "hello world"

    create_draft_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_draft, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateDraftRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["draft_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Draft), request["draft"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_draft_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_draft({ parent: parent, draft_id: draft_id, draft: draft, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_draft parent: parent, draft_id: draft_id, draft: draft, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_draft ::Google::Cloud::VisionAI::V1::CreateDraftRequest.new(parent: parent, draft_id: draft_id, draft: draft, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_draft({ parent: parent, draft_id: draft_id, draft: draft, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_draft(::Google::Cloud::VisionAI::V1::CreateDraftRequest.new(parent: parent, draft_id: draft_id, draft: draft, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_draft_client_stub.call_rpc_count
    end
  end

  def test_update_draft
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    draft = {}
    request_id = "hello world"
    allow_missing = true

    update_draft_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_draft, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateDraftRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Draft), request["draft"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_draft_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_draft({ update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_draft update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_draft ::Google::Cloud::VisionAI::V1::UpdateDraftRequest.new(update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_draft({ update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_draft(::Google::Cloud::VisionAI::V1::UpdateDraftRequest.new(update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_draft_client_stub.call_rpc_count
    end
  end

  def test_delete_draft
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_draft_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_draft, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteDraftRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_draft_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_draft({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_draft name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_draft ::Google::Cloud::VisionAI::V1::DeleteDraftRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_draft({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_draft(::Google::Cloud::VisionAI::V1::DeleteDraftRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_draft_client_stub.call_rpc_count
    end
  end

  def test_list_processors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListProcessorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_processors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_processors, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListProcessorsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_processors_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_processors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_processors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_processors ::Google::Cloud::VisionAI::V1::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_processors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_processors(::Google::Cloud::VisionAI::V1::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_processors_client_stub.call_rpc_count
    end
  end

  def test_list_prebuilt_processors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_prebuilt_processors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_prebuilt_processors, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_prebuilt_processors_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_prebuilt_processors({ parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_prebuilt_processors parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_prebuilt_processors ::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsRequest.new(parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_prebuilt_processors({ parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_prebuilt_processors(::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_prebuilt_processors_client_stub.call_rpc_count
    end
  end

  def test_get_processor
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VisionAI::V1::Processor.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_processor_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_processor, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::GetProcessorRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_processor_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_processor({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_processor name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_processor ::Google::Cloud::VisionAI::V1::GetProcessorRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_processor({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_processor(::Google::Cloud::VisionAI::V1::GetProcessorRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_processor_client_stub.call_rpc_count
    end
  end

  def test_create_processor
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    processor_id = "hello world"
    processor = {}
    request_id = "hello world"

    create_processor_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_processor, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::CreateProcessorRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["processor_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Processor), request["processor"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_processor_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_processor({ parent: parent, processor_id: processor_id, processor: processor, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_processor parent: parent, processor_id: processor_id, processor: processor, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_processor ::Google::Cloud::VisionAI::V1::CreateProcessorRequest.new(parent: parent, processor_id: processor_id, processor: processor, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_processor({ parent: parent, processor_id: processor_id, processor: processor, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_processor(::Google::Cloud::VisionAI::V1::CreateProcessorRequest.new(parent: parent, processor_id: processor_id, processor: processor, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_processor_client_stub.call_rpc_count
    end
  end

  def test_update_processor
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    processor = {}
    request_id = "hello world"

    update_processor_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_processor, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::UpdateProcessorRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VisionAI::V1::Processor), request["processor"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_processor_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_processor({ update_mask: update_mask, processor: processor, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_processor update_mask: update_mask, processor: processor, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_processor ::Google::Cloud::VisionAI::V1::UpdateProcessorRequest.new(update_mask: update_mask, processor: processor, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_processor({ update_mask: update_mask, processor: processor, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_processor(::Google::Cloud::VisionAI::V1::UpdateProcessorRequest.new(update_mask: update_mask, processor: processor, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_processor_client_stub.call_rpc_count
    end
  end

  def test_delete_processor
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_processor_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_processor, name
      assert_kind_of ::Google::Cloud::VisionAI::V1::DeleteProcessorRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_processor_client_stub do
      # Create client
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_processor({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_processor name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_processor ::Google::Cloud::VisionAI::V1::DeleteProcessorRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_processor({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_processor(::Google::Cloud::VisionAI::V1::DeleteProcessorRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_processor_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::AppPlatform::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::VisionAI::V1::AppPlatform::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::VisionAI::V1::AppPlatform::Operations, client.operations_client
  end
end
