# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/visionai/v1/platform_pb"
require "google/cloud/vision_ai/v1/app_platform/rest"


class ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_applications
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListApplicationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_applications_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_list_applications_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_applications_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_applications parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_applications ::Google::Cloud::VisionAI::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_applications({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_applications(::Google::Cloud::VisionAI::V1::ListApplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_applications_client_stub.call_count
      end
    end
  end

  def test_get_application
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Application.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_get_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_application({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_application name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_application ::Google::Cloud::VisionAI::V1::GetApplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_application({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_application(::Google::Cloud::VisionAI::V1::GetApplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_application_client_stub.call_count
      end
    end
  end

  def test_create_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    application_id = "hello world"
    application = {}
    request_id = "hello world"

    create_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_create_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_application parent: parent, application_id: application_id, application: application, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_application ::Google::Cloud::VisionAI::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_application({ parent: parent, application_id: application_id, application: application, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_application(::Google::Cloud::VisionAI::V1::CreateApplicationRequest.new(parent: parent, application_id: application_id, application: application, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_application_client_stub.call_count
      end
    end
  end

  def test_update_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    application = {}
    request_id = "hello world"

    update_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_update_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_application({ update_mask: update_mask, application: application, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_application update_mask: update_mask, application: application, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_application ::Google::Cloud::VisionAI::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_application({ update_mask: update_mask, application: application, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_application(::Google::Cloud::VisionAI::V1::UpdateApplicationRequest.new(update_mask: update_mask, application: application, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_application_client_stub.call_count
      end
    end
  end

  def test_delete_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_delete_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_application({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_application name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_application ::Google::Cloud::VisionAI::V1::DeleteApplicationRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_application({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_application(::Google::Cloud::VisionAI::V1::DeleteApplicationRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_application_client_stub.call_count
      end
    end
  end

  def test_deploy_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    request_id = "hello world"
    enable_monitoring = true

    deploy_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_deploy_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_application({ name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_application name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_application ::Google::Cloud::VisionAI::V1::DeployApplicationRequest.new(name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_application({ name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_application(::Google::Cloud::VisionAI::V1::DeployApplicationRequest.new(name: name, validate_only: validate_only, request_id: request_id, enable_monitoring: enable_monitoring), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_application_client_stub.call_count
      end
    end
  end

  def test_undeploy_application
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undeploy_application_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_undeploy_application_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_application_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_application({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_application name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_application ::Google::Cloud::VisionAI::V1::UndeployApplicationRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_application({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_application(::Google::Cloud::VisionAI::V1::UndeployApplicationRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_application_client_stub.call_count
      end
    end
  end

  def test_add_application_stream_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_stream_inputs = [{}]
    request_id = "hello world"

    add_application_stream_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_add_application_stream_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_application_stream_input_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_application_stream_input name: name, application_stream_inputs: application_stream_inputs, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_application_stream_input ::Google::Cloud::VisionAI::V1::AddApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_application_stream_input(::Google::Cloud::VisionAI::V1::AddApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_application_stream_input_client_stub.call_count
      end
    end
  end

  def test_remove_application_stream_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_stream_inputs = [{}]
    request_id = "hello world"

    remove_application_stream_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_remove_application_stream_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_application_stream_input_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_application_stream_input({ name: name, target_stream_inputs: target_stream_inputs, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_application_stream_input name: name, target_stream_inputs: target_stream_inputs, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_application_stream_input ::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest.new(name: name, target_stream_inputs: target_stream_inputs, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_application_stream_input({ name: name, target_stream_inputs: target_stream_inputs, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_application_stream_input(::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest.new(name: name, target_stream_inputs: target_stream_inputs, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_application_stream_input_client_stub.call_count
      end
    end
  end

  def test_update_application_stream_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_stream_inputs = [{}]
    request_id = "hello world"
    allow_missing = true

    update_application_stream_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_update_application_stream_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_application_stream_input_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_application_stream_input name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_application_stream_input ::Google::Cloud::VisionAI::V1::UpdateApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_application_stream_input({ name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_application_stream_input(::Google::Cloud::VisionAI::V1::UpdateApplicationStreamInputRequest.new(name: name, application_stream_inputs: application_stream_inputs, request_id: request_id, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_application_stream_input_client_stub.call_count
      end
    end
  end

  def test_list_instances
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListInstancesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_list_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_instances_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_instances parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_instances ::Google::Cloud::VisionAI::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_instances({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_instances(::Google::Cloud::VisionAI::V1::ListInstancesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_instances_client_stub.call_count
      end
    end
  end

  def test_get_instance
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Instance.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_get_instance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_instance_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_instance({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_instance name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_instance ::Google::Cloud::VisionAI::V1::GetInstanceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_instance({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_instance(::Google::Cloud::VisionAI::V1::GetInstanceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_instance_client_stub.call_count
      end
    end
  end

  def test_create_application_instances
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_instances = [{}]
    request_id = "hello world"

    create_application_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_create_application_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_application_instances_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_application_instances({ name: name, application_instances: application_instances, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_application_instances name: name, application_instances: application_instances, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_application_instances ::Google::Cloud::VisionAI::V1::CreateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_application_instances({ name: name, application_instances: application_instances, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_application_instances(::Google::Cloud::VisionAI::V1::CreateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_application_instances_client_stub.call_count
      end
    end
  end

  def test_delete_application_instances
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    instance_ids = ["hello world"]
    request_id = "hello world"

    delete_application_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_delete_application_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_application_instances_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_application_instances({ name: name, instance_ids: instance_ids, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_application_instances name: name, instance_ids: instance_ids, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_application_instances ::Google::Cloud::VisionAI::V1::DeleteApplicationInstancesRequest.new(name: name, instance_ids: instance_ids, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_application_instances({ name: name, instance_ids: instance_ids, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_application_instances(::Google::Cloud::VisionAI::V1::DeleteApplicationInstancesRequest.new(name: name, instance_ids: instance_ids, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_application_instances_client_stub.call_count
      end
    end
  end

  def test_update_application_instances
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    application_instances = [{}]
    request_id = "hello world"
    allow_missing = true

    update_application_instances_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_update_application_instances_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_application_instances_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_application_instances({ name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_application_instances name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_application_instances ::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_application_instances({ name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_application_instances(::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest.new(name: name, application_instances: application_instances, request_id: request_id, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_application_instances_client_stub.call_count
      end
    end
  end

  def test_list_drafts
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListDraftsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_drafts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_list_drafts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_drafts_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_drafts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_drafts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_drafts ::Google::Cloud::VisionAI::V1::ListDraftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_drafts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_drafts(::Google::Cloud::VisionAI::V1::ListDraftsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_drafts_client_stub.call_count
      end
    end
  end

  def test_get_draft
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Draft.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_draft_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_get_draft_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_draft_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_draft({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_draft name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_draft ::Google::Cloud::VisionAI::V1::GetDraftRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_draft({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_draft(::Google::Cloud::VisionAI::V1::GetDraftRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_draft_client_stub.call_count
      end
    end
  end

  def test_create_draft
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    draft_id = "hello world"
    draft = {}
    request_id = "hello world"

    create_draft_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_create_draft_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_draft_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_draft({ parent: parent, draft_id: draft_id, draft: draft, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_draft parent: parent, draft_id: draft_id, draft: draft, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_draft ::Google::Cloud::VisionAI::V1::CreateDraftRequest.new(parent: parent, draft_id: draft_id, draft: draft, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_draft({ parent: parent, draft_id: draft_id, draft: draft, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_draft(::Google::Cloud::VisionAI::V1::CreateDraftRequest.new(parent: parent, draft_id: draft_id, draft: draft, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_draft_client_stub.call_count
      end
    end
  end

  def test_update_draft
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    draft = {}
    request_id = "hello world"
    allow_missing = true

    update_draft_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_update_draft_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_draft_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_draft({ update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_draft update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_draft ::Google::Cloud::VisionAI::V1::UpdateDraftRequest.new(update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_draft({ update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_draft(::Google::Cloud::VisionAI::V1::UpdateDraftRequest.new(update_mask: update_mask, draft: draft, request_id: request_id, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_draft_client_stub.call_count
      end
    end
  end

  def test_delete_draft
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_draft_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_delete_draft_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_draft_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_draft({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_draft name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_draft ::Google::Cloud::VisionAI::V1::DeleteDraftRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_draft({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_draft(::Google::Cloud::VisionAI::V1::DeleteDraftRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_draft_client_stub.call_count
      end
    end
  end

  def test_list_processors
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListProcessorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_processors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_list_processors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processors_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processors ::Google::Cloud::VisionAI::V1::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processors(::Google::Cloud::VisionAI::V1::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processors_client_stub.call_count
      end
    end
  end

  def test_list_prebuilt_processors
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    list_prebuilt_processors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_list_prebuilt_processors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_prebuilt_processors_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_prebuilt_processors({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_prebuilt_processors parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_prebuilt_processors ::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_prebuilt_processors({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_prebuilt_processors(::Google::Cloud::VisionAI::V1::ListPrebuiltProcessorsRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_prebuilt_processors_client_stub.call_count
      end
    end
  end

  def test_get_processor
    # Create test objects.
    client_result = ::Google::Cloud::VisionAI::V1::Processor.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_get_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_processor_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_processor({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_processor name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_processor ::Google::Cloud::VisionAI::V1::GetProcessorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_processor({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_processor(::Google::Cloud::VisionAI::V1::GetProcessorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_processor_client_stub.call_count
      end
    end
  end

  def test_create_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    processor_id = "hello world"
    processor = {}
    request_id = "hello world"

    create_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_create_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_processor_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_processor({ parent: parent, processor_id: processor_id, processor: processor, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_processor parent: parent, processor_id: processor_id, processor: processor, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_processor ::Google::Cloud::VisionAI::V1::CreateProcessorRequest.new(parent: parent, processor_id: processor_id, processor: processor, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_processor({ parent: parent, processor_id: processor_id, processor: processor, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_processor(::Google::Cloud::VisionAI::V1::CreateProcessorRequest.new(parent: parent, processor_id: processor_id, processor: processor, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_processor_client_stub.call_count
      end
    end
  end

  def test_update_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    processor = {}
    request_id = "hello world"

    update_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_update_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_processor_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_processor({ update_mask: update_mask, processor: processor, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_processor update_mask: update_mask, processor: processor, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_processor ::Google::Cloud::VisionAI::V1::UpdateProcessorRequest.new(update_mask: update_mask, processor: processor, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_processor({ update_mask: update_mask, processor: processor, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_processor(::Google::Cloud::VisionAI::V1::UpdateProcessorRequest.new(update_mask: update_mask, processor: processor, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_processor_client_stub.call_count
      end
    end
  end

  def test_delete_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::ServiceStub.stub :transcode_delete_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_processor_client_stub do
        # Create client
        client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_processor({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_processor name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_processor ::Google::Cloud::VisionAI::V1::DeleteProcessorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_processor({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_processor(::Google::Cloud::VisionAI::V1::DeleteProcessorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_processor_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VisionAI::V1::AppPlatform::Rest::Client::Configuration, config
  end
end
