# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Request message for CreateAssetRequest.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this asset will be created.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::VisionAI::V1::Asset]
        #     Required. The asset to create.
        # @!attribute [rw] asset_id
        #   @return [::String]
        #     Optional. The ID to use for the asset, which will become the final
        #     component of the asset's resource name if user choose to specify.
        #     Otherwise, asset id will be generated by system.
        #
        #     This value should be up to 63 characters, and valid characters
        #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
        #     a letter or a number.
        class CreateAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the asset to retrieve.
        #     Format:
        #     projects/\\{project_number}/locations/\\{location}/corpora/\\{corpus}/assets/\\{asset}
        class GetAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAssets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of assets.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of assets to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 50 assets will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAssets` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAssets` must match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter applied to the returned list.
        #     Only the following filterings are supported:
        #     "assets_with_contents = true", which returns assets with contents uploaded;
        #     "assets_with_contents = false", which returns assets without contents.
        class ListAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListAssets.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Asset>]
        #     The assets from the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAsset.
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::VisionAI::V1::Asset]
        #     Required. The asset to update.
        #
        #     The asset's `name` field is used to identify the asset to be updated.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the asset to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
        class DeleteAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The source of the asset.
        # @!attribute [rw] asset_gcs_source
        #   @return [::Google::Cloud::VisionAI::V1::AssetSource::AssetGcsSource]
        #     The source of the asset is from Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `asset_gcs_source`, `asset_content_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] asset_content_data
        #   @return [::Google::Cloud::VisionAI::V1::AssetSource::AssetContentData]
        #     The source of the asset is from content bytes.
        #
        #     Note: The following fields are mutually exclusive: `asset_content_data`, `asset_gcs_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AssetSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The asset source is from Cloud Storage.
          # @!attribute [rw] gcs_uri
          #   @return [::String]
          #     Cloud storage uri.
          class AssetGcsSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The content of the asset.
          # @!attribute [rw] asset_content_data
          #   @return [::String]
          class AssetContentData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for UploadAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to upload.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] asset_source
        #   @return [::Google::Cloud::VisionAI::V1::AssetSource]
        #     The source of the asset.
        class UploadAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for UploadAsset.
        class UploadAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for UploadAsset.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the operation.
        class UploadAssetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GenerateRetrievalUrl API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to request signed url for.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        class GenerateRetrievalUrlRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for GenerateRetrievalUrl API.
        # @!attribute [rw] signed_uri
        #   @return [::String]
        #     A signed url to download the content of the asset.
        class GenerateRetrievalUrlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An asset is a resource in corpus. It represents a media object inside corpus,
        # contains metadata and another resource annotation. Different feature could be
        # applied to the asset to generate annotations. User could specified annotation
        # related to the target asset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the asset.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     The duration for which all media assets, associated metadata, and search
        #     documents can exist. If not set, then it will using the default ttl in the
        #     parent corpus resource.
        # @!attribute [r] asset_gcs_source
        #   @return [::Google::Cloud::VisionAI::V1::AssetSource::AssetGcsSource]
        #     Output only. The original cloud storage source uri that is associated with
        #     this asset.
        class Asset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for AnalyzeAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to analyze.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        class AnalyzeAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for AnalyzeAsset.
        # @!attribute [rw] analysis_status
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AnalyzeAssetMetadata::AnalysisStatus>]
        #     The status of analysis on all search capabilities.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the operation.
        class AnalyzeAssetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of analysis on each search capability.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::VisionAI::V1::AnalyzeAssetMetadata::AnalysisStatus::State]
          # @!attribute [rw] status_message
          #   @return [::String]
          # @!attribute [rw] search_capability
          #   @return [::Google::Cloud::VisionAI::V1::SearchCapability]
          #     The search capability requested.
          class AnalysisStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the search capability.
            module State
              # The default process state should never happen.
              STATE_UNSPECIFIED = 0

              # The ml model analysis is in progress.
              IN_PROGRESS = 1

              # The ml model analysis is successfully done.
              SUCCEEDED = 2

              # The ml model analysis failed.
              FAILED = 3
            end
          end
        end

        # Response message for AnalyzeAsset.
        class AnalyzeAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The status of indexing for the asset.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VisionAI::V1::IndexingStatus::State]
        #     Output only. State of this asset's indexing.
        # @!attribute [rw] status_message
        #   @return [::String]
        #     Detailed message describing the state.
        class IndexingStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State enum for this asset's indexing.
          module State
            # The default process state should never happen.
            STATE_UNSPECIFIED = 0

            # The indexing is in progress.
            IN_PROGRESS = 1

            # The process is successfully done.
            SUCCEEDED = 2

            # The process failed.
            FAILED = 3
          end
        end

        # Request message for IndexAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to index.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] index
        #   @return [::String]
        #     Optional. The name of the index.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        class IndexAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for IndexAsset.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::VisionAI::V1::IndexingStatus]
        #     The status of indexing this asset.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the operation.
        class IndexAssetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for IndexAsset.
        class IndexAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for RemoveIndexAsset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to index.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] index
        #   @return [::String]
        #     Optional. The name of the index.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        class RemoveIndexAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for RemoveIndexAsset.
        # @!attribute [rw] indexing_status
        #   @return [::Google::Cloud::VisionAI::V1::IndexingStatus]
        #     The status of indexing this asset.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The start time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the operation.
        class RemoveIndexAssetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for RemoveIndexAsset.
        class RemoveIndexAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An IndexedAsset is an asset that the index is built upon.
        # @!attribute [rw] index
        #   @return [::String]
        #     Required. The index that this indexed asset belongs to.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        # @!attribute [rw] asset
        #   @return [::String]
        #     Required. The resource name of the asset.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        class IndexedAsset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ViewIndexedAssets.
        # @!attribute [rw] index
        #   @return [::String]
        #     Required. The index that owns this collection of assets.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of assets to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 50 assets will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ViewIndexedAssets` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ViewIndexedAssets` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter applied to the returned list.
        #     Only the following filterings are supported:
        #     "asset_id = xxxx", which returns asset with specified id.
        #     "asset_id = xxxx, yyyy, zzzz", which returns assets with specified ids.
        class ViewIndexedAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ViewIndexedAssets.
        # @!attribute [rw] indexed_assets
        #   @return [::Array<::Google::Cloud::VisionAI::V1::IndexedAsset>]
        #     The assets from the specified index.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ViewIndexedAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of CreateCorpus API.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Form: `projects/{project_number}/locations/{location_id}`
        # @!attribute [rw] corpus
        #   @return [::Google::Cloud::VisionAI::V1::Corpus]
        #     Required. The corpus to be created.
        class CreateCorpusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for CreateCorpus API.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The create time of the create corpus operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The update time of the create corpus operation.
        class CreateCorpusMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The capability and metadata of search capability.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::SearchCapability::Type]
        #     The search capability to enable.
        class SearchCapability
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Capability to perform different search on assets.
          module Type
            # Unspecified search capability, should never be used.
            TYPE_UNSPECIFIED = 0

            # Embedding search.
            EMBEDDING_SEARCH = 1
          end
        end

        # Setting for search capability to enable.
        # @!attribute [rw] search_capabilities
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SearchCapability>]
        #     The metadata of search capability to enable.
        class SearchCapabilitySetting
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for CreateCollectionRequest
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class CreateCollectionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateCollection.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this collection will be created.
        #     Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::VisionAI::V1::Collection]
        #     Required. The collection resource to be created.
        # @!attribute [rw] collection_id
        #   @return [::String]
        #     Optional. The ID to use for the collection, which will become the final
        #     component of the resource name if user choose to specify. Otherwise,
        #     collection id will be generated by system.
        #
        #     This value should be up to 55 characters, and valid characters
        #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
        #     a letter or a number.
        class CreateCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for DeleteCollectionRequest
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class DeleteCollectionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteCollectionRequest.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the collection to delete. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        class DeleteCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetCollectionRequest.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the collection to retrieve. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        class GetCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCollectionRequest.
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::VisionAI::V1::Collection]
        #     Required. The collection to update.
        #
        #     The collection's `name` field is used to identify the collection to be
        #     updated. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        #     - Unset `update_mask` or set `update_mask` to be a single "*" only will
        #       update all updatable fields with the value provided in `collection`.
        #     - To update `display_name` value to empty string, set it in the
        #     `collection`
        #       to empty string, and set `update_mask` with "display_name". Same applies
        #       to other updatable string fields in the `collection`.
        class UpdateCollectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCollections.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent corpus. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of collections to return. The service may return fewer
        #     than this value. If unspecified, at most 50 collections will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListCollectionsRequest` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCollectionsRequest`
        #     must match the call that provided the page token.
        class ListCollectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCollections.
        # @!attribute [rw] collections
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Collection>]
        #     The collections from the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCollectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for AddCollectionItem.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::VisionAI::V1::CollectionItem]
        #     Required. The item to be added.
        class AddCollectionItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for AddCollectionItem.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::VisionAI::V1::CollectionItem]
        #     The item that has already been added.
        class AddCollectionItemResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for RemoveCollectionItem.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::VisionAI::V1::CollectionItem]
        #     Required. The item to be removed.
        class RemoveCollectionItemRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for RemoveCollectionItem.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::VisionAI::V1::CollectionItem]
        #     The item that has already been removed.
        class RemoveCollectionItemResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ViewCollectionItems.
        # @!attribute [rw] collection
        #   @return [::String]
        #     Required. The collection to view. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of collections to return. The service may return fewer
        #     than this value. If unspecified, at most 50 collections will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ViewCollectionItemsRequest` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ViewCollectionItemsRequest` must match the call that provided the page
        #     token.
        class ViewCollectionItemsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ViewCollectionItems.
        # @!attribute [rw] items
        #   @return [::Array<::Google::Cloud::VisionAI::V1::CollectionItem>]
        #     The items from the specified collection.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ViewCollectionItemsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection is a resource in a corpus. It serves as a container of
        # references to original resources.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the collection. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The collection name for displaying.
        #     The name can be up to 256 characters long.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the collection. Can be up to 25000 characters
        #     long.
        class Collection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A CollectionItem is an item in a collection.
        # Each item is a reference to the original resource in a collection.
        # @!attribute [rw] collection
        #   @return [::String]
        #     Required. The collection name that this item belongs to. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::CollectionItem::Type]
        #     Required. The type of item.
        # @!attribute [rw] item_resource
        #   @return [::String]
        #     Required. The name of the CollectionItem. Its format depends on the `type`
        #     above. For ASSET:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
        class CollectionItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # CollectionItem types.
          module Type
            # The default type of item should never happen.
            TYPE_UNSPECIFIED = 0

            # Asset type item.
            ASSET = 1
          end
        end

        # Message for creating an Index.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for the parent. The resource name of the Corpus under which
        #     this index is created. Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] index_id
        #   @return [::String]
        #     Optional. The ID for the index. This will become the final resource name
        #     for the index. If the user does not specify this value, it will be
        #     generated by system.
        #
        #     This value should be up to 63 characters, and valid characters
        #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
        #     a letter or a number.
        # @!attribute [rw] index
        #   @return [::Google::Cloud::VisionAI::V1::Index]
        #     Required. The index being created.
        class CreateIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for CreateIndexRequest
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class CreateIndexMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateIndex.
        # @!attribute [rw] index
        #   @return [::Google::Cloud::VisionAI::V1::Index]
        #     Required. The resource being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Index resource by the update. The fields specified in the update_mask are
        #     relative to the resource, not the full request. A field of the resource
        #     will be overwritten if it is in the mask. Empty field mask is not allowed.
        #     If the mask is "*", it triggers a full update of the index, and also a
        #     whole rebuild of index data.
        class UpdateIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for UpdateIndexRequest
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class UpdateIndexMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting an Index.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Index resource.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        class GetIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing Indexes.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent corpus that owns this collection of indexes.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of indexes to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 50 indexes will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListIndexes` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListIndexes` must match
        #     the call that provided the page token.
        class ListIndexesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListIndexes.
        # @!attribute [rw] indexes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Index>]
        #     The indexes under the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListIndexesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteIndex.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the index to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
        class DeleteIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for DeleteIndexRequest
        class DeleteIndexMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An Index is a resource in Corpus. It contains an indexed version of the
        # assets and annotations. When deployed to an endpoint, it will allow users to
        # search the Index.
        # @!attribute [rw] entire_corpus
        #   @return [::Boolean]
        #     Include all assets under the corpus.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the Index resource.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Optional user-specified display name of the index.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Optional description of the index.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VisionAI::V1::Index::State]
        #     Output only. State of the index.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [r] deployed_indexes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::DeployedIndexReference>]
        #     Output only. References to the deployed index instance.
        #     Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
        #     Index of IMAGE corpus can have multiple deployed indexes.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Separation enabled via an Org Policy constraint. It is set to true
        #     when the index is a valid zone separated index and false if it isn't.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Isolation enabled via an Org Policy constraint. It is set to true when
        #     the index is a valid zone isolated index and false if it isn't.
        class Index
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum representing the different states through which an Index might cycle
          # during its lifetime.
          module State
            # The default value. Should not be used.
            STATE_UNSPECIFIED = 0

            # State CREATING.
            CREATING = 1

            # State CREATED.
            CREATED = 2

            # State UPDATING.
            UPDATING = 3
          end
        end

        # Points to a DeployedIndex.
        # @!attribute [rw] index_endpoint
        #   @return [::String]
        #     Immutable. A resource name of the IndexEndpoint.
        class DeployedIndexReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Corpus is a set of media contents for management.
        # Within a corpus, media shares the same data schema. Search is also restricted
        # within a single corpus.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the corpus.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The corpus name to shown in the UI. The name can be up to 32
        #     characters long.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the corpus. Can be up to 25000 characters long.
        # @!attribute [rw] default_ttl
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The default TTL value for all assets under the corpus without a
        #     asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
        #     required and the maximum allowed
        #       default_ttl is 10 years.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::Corpus::Type]
        #     Optional. Type of the asset inside corpus.
        # @!attribute [rw] search_capability_setting
        #   @return [::Google::Cloud::VisionAI::V1::SearchCapabilitySetting]
        #     Default search capability setting on corpus level.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Separation enabled via an Org Policy constraint. It is set to true
        #     when the corpus is a valid zone separated corpus and false if it isn't.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Isolation enabled via an Org Policy constraint. It is set to true when
        #     the corpus is a valid zone isolated corpus and false if it isn't.
        class Corpus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of the asset inside the corpus.
          module Type
            # The default type, not supposed to be used. If this default type is used,
            # the corpus will be created as STREAM_VIDEO corpus.
            TYPE_UNSPECIFIED = 0

            # Asset is a live streaming video.
            STREAM_VIDEO = 1

            # Asset is an image.
            IMAGE = 2

            # Asset is a batch video.
            VIDEO_ON_DEMAND = 3
          end
        end

        # Request message for GetCorpus.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the corpus to retrieve.
        class GetCorpusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateCorpus.
        # @!attribute [rw] corpus
        #   @return [::Google::Cloud::VisionAI::V1::Corpus]
        #     Required. The corpus which replaces the resource on the server.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateCorpusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListCorpora.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the project from which to list corpora.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. API may return fewer results than requested.
        #     If negative, INVALID_ARGUMENT error will be returned.
        #     If unspecified or 0, API will pick a default size, which is 10.
        #     If the requested page size is larger than the maximum size, API will pick
        #     use the maximum size, which is 20.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results for the server to return.
        #     Typically obtained via
        #     {::Google::Cloud::VisionAI::V1::ListCorporaResponse#next_page_token ListCorporaResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::VisionAI::V1::Warehouse::Client#list_corpora Warehouse.ListCorpora}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter applied to the returned corpora list.
        #     Only the following restrictions are supported:
        #     `type=<Corpus.Type>`,
        #     `type!=<Corpus.Type>`.
        class ListCorporaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListCorpora.
        # @!attribute [rw] corpora
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Corpus>]
        #     The corpora in the project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass to
        #     {::Google::Cloud::VisionAI::V1::ListCorporaRequest#page_token ListCorporaRequest.page_token}
        #     to obtain that page.
        class ListCorporaResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteCorpus.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the corpus to delete.
        class DeleteCorpusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for AnalyzeCorpus.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The parent corpus resource where the assets will be analyzed.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        class AnalyzeCorpusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata message for AnalyzeCorpus LRO.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     The metadata of the operation.
        class AnalyzeCorpusMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for AnalyzeCorpus LRO.
        class AnalyzeCorpusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDataSchema.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this data schema will be created.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] data_schema
        #   @return [::Google::Cloud::VisionAI::V1::DataSchema]
        #     Required. The data schema to create.
        class CreateDataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data schema indicates how the user specified annotation is interpreted in the
        # system.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the data schema in the form of:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
        #     where \\{data_schema} part should be the same as the `key` field below.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. The key of this data schema. This key should be matching the key
        #     of user specified annotation and unique inside corpus. This value can be up
        #     to 63 characters, and valid characters are /[a-z][0-9]-/. The first
        #     character must be a letter, the last could be a letter or a number.
        # @!attribute [rw] schema_details
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails]
        #     The schema details mapping to the key.
        class DataSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Data schema details indicates the data type and the data struct corresponding
        # to the key of user specified annotation.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::DataType]
        #     Type of the annotation.
        # @!attribute [rw] proto_any_config
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::ProtoAnyConfig]
        #     Config for protobuf any type.
        # @!attribute [rw] list_config
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::ListConfig]
        #     Config for List data type.
        # @!attribute [rw] customized_struct_config
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::CustomizedStructConfig]
        #     Config for CustomizedStruct data type.
        # @!attribute [rw] granularity
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::Granularity]
        #     The granularity associated with this DataSchema.
        # @!attribute [rw] search_strategy
        #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::SearchStrategy]
        #     The search strategy to be applied on the `key` above.
        class DataSchemaDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The configuration for `PROTO_ANY` data type.
          # @!attribute [rw] type_uri
          #   @return [::String]
          #     The type URI of the proto message.
          class ProtoAnyConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The configuration for `LIST` data type.
          # @!attribute [rw] value_schema
          #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails]
          #     The value's data schema in the list.
          class ListConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The configuration for `CUSTOMIZED_STRUCT` data type.
          # @!attribute [rw] field_schemas
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::VisionAI::V1::DataSchemaDetails}]
          #     Direct child elements data schemas.
          class CustomizedStructConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails]
            class FieldSchemasEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The search strategy for annotations value of the `key`.
          # @!attribute [rw] search_strategy_type
          #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::SearchStrategy::SearchStrategyType]
          #     The type of search strategy to be applied on the `key` above.
          #     The allowed `search_strategy_type` is different for different data types,
          #     which is documented in the DataSchemaDetails.DataType. Specifying
          #     unsupported `search_strategy_type` for data types will result in
          #     INVALID_ARGUMENT error.
          # @!attribute [rw] confidence_score_index_config
          #   @return [::Google::Cloud::VisionAI::V1::DataSchemaDetails::SearchStrategy::ConfidenceScoreIndexConfig]
          #     Optional. Configs the path to the confidence score, and the threshold.
          #     Only if the score is greater than the threshold, current field will be
          #     built into the index. Only applies to leaf nodes using EXACT_SEARCH or
          #     SMART_SEARCH.
          class SearchStrategy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Filter on the confidence score. Only adds to index if the confidence
            # score is higher than the threshold.
            # Example data schema:
            # key: "name-confidence-pair"
            # type: CUSTOMIZED_STRUCT
            # granularity: GRANULARITY_PARTITION_LEVEL
            # customized_struct_config {
            #   field_schemas {
            #     key: "name"
            #     type: STRING
            #     granularity: GRANULARITY_PARTITION_LEVEL
            #     search_strategy {
            #       search_strategy_type: SMART_SEARCH
            #       confidence_score_index_config {
            #         field_path: "name-confidence-pair.score"
            #         threshold: 0.6
            #       }
            #     }
            #   }
            #   field_schemas {
            #     key: "score"
            #     type: FLOAT
            #     granularity: GRANULARITY_PARTITION_LEVEL
            #   }
            # }
            # This means only "name" with score > 0.6 will be indexed.
            # @!attribute [rw] field_path
            #   @return [::String]
            #     Required. The path to the confidence score field. It is a string that
            #     concatenates all the data schema keys along the path. See the example
            #     above. If the data schema contains LIST, use '_ENTRIES' to concatenate.
            #     Example data schema contains a list:
            #     "key": "list-name-score",
            #     "schemaDetails": {
            #       "type": "LIST",
            #       "granularity": "GRANULARITY_PARTITION_LEVEL",
            #       "listConfig": {
            #         "valueSchema": {
            #           "type": "CUSTOMIZED_STRUCT",
            #           "granularity": "GRANULARITY_PARTITION_LEVEL",
            #           "customizedStructConfig": {
            #             "fieldSchemas": {
            #               "name": {
            #                 "type": "STRING",
            #                 "granularity": "GRANULARITY_PARTITION_LEVEL",
            #                 "searchStrategy": {
            #                   "searchStrategyType": "SMART_SEARCH"
            #                   "confidence_score_index_config": {
            #                     "field_path": "list-name-score._ENTRIES.score",
            #                     "threshold": "0.9",
            #                   }
            #                 }
            #               },
            #               "score": {
            #                 "type": "FLOAT",
            #                 "granularity": "GRANULARITY_PARTITION_LEVEL",
            #               }
            #             }
            #           }
            #         }
            #       }
            #     }
            # @!attribute [rw] threshold
            #   @return [::Float]
            #     Required. The threshold.
            class ConfidenceScoreIndexConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The types of search strategies to be applied on the annotation key.
            module SearchStrategyType
              # Annotatation values of the `key` above will not be searchable.
              NO_SEARCH = 0

              # When searching with `key`, the value must be exactly as the annotation
              # value that has been ingested.
              EXACT_SEARCH = 1

              # When searching with `key`, Warehouse will perform broad search based on
              # semantic of the annotation value.
              SMART_SEARCH = 2
            end
          end

          # Data type of the annotation.
          module DataType
            # Unspecified type.
            DATA_TYPE_UNSPECIFIED = 0

            # Integer type.
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH.
            #   Supports query by IntRangeArray.
            INTEGER = 1

            # Float type.
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH.
            #   Supports query by FloatRangeArray.
            FLOAT = 2

            # String type.
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH,
            # - DataSchema.SearchStrategy.SMART_SEARCH.
            STRING = 3

            # Supported formats:
            # %Y-%m-%dT%H:%M:%E*S%E*z (absl::RFC3339_full)
            # %Y-%m-%dT%H:%M:%E*S
            # %Y-%m-%dT%H:%M%E*z
            # %Y-%m-%dT%H:%M
            # %Y-%m-%dT%H%E*z
            # %Y-%m-%dT%H
            # %Y-%m-%d%E*z
            # %Y-%m-%d
            # %Y-%m
            # %Y
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH.
            #   Supports query by DateTimeRangeArray.
            DATETIME = 5

            # Geo coordinate type.
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH.
            #   Supports query by GeoLocationArray.
            GEO_COORDINATE = 7

            # Type to pass any proto as available in annotations.proto. Only use
            # internally.
            # Available proto types and its corresponding search behavior:
            # - ImageObjectDetectionPredictionResult, allows SMART_SEARCH on
            #   display_names and NO_SEARCH.
            # - ClassificationPredictionResult, allows SMART_SEARCH on display_names
            #   and NO_SEARCH.
            # - ImageSegmentationPredictionResult, allows NO_SEARCH.
            # - VideoActionRecognitionPredictionResult, allows SMART_SEARCH on
            #   display_name and NO_SEARCH.
            # - VideoObjectTrackingPredictionResult, allows SMART_SEARCH on
            #   display_name and NO_SEARCH.
            # - VideoClassificationPredictionResult, allows SMART_SEARCH on
            #   display_name and NO_SEARCH.
            # - OccupancyCountingPredictionResult, allows EXACT_SEARCH on
            #   stats.full_frame_count.count and NO_SEARCH.
            # - ObjectDetectionPredictionResult, allows SMART_SEARCH on
            #   identified_boxes.entity.label_string and NO_SEARCH.
            PROTO_ANY = 8

            # Boolean type.
            # Allowed search strategies:
            # - DataSchema.SearchStrategy.NO_SEARCH,
            # - DataSchema.SearchStrategy.EXACT_SEARCH.
            BOOLEAN = 9

            # List type.
            #  - Each element in the list must be of the exact same data schema;
            #    otherwise, they are invalid arguments.
            #  - List level cannot set search strategy. Leaf node level can do.
            #  - Elements cannot be another list (no list of list).
            #  - Elements can be CUSTOMIZED_STRUCT, and max number of layers is 10.
            LIST = 10

            # Struct type.
            # - SearchStrategy:
            #   * Data Schema that's CUSTOMIZED_STRUCT cannot set search strategy.
            #   * Leaf-node elements allow setting search strategy based on element's
            #     SearchStrategy restriction.
            # - Nested layer restrictions:
            #   * Data Schema that's CUSTOMIZED_STRUCT allows its fields to be of
            #     CUSTOMIZED_STRUCT as well, but the overall layers restriction is 10.
            CUSTOMIZED_STRUCT = 6
          end

          # The granularity of annotations under this DataSchema.
          module Granularity
            # Unspecified granularity.
            GRANULARITY_UNSPECIFIED = 0

            # Asset-level granularity (annotations must not contain partition info).
            GRANULARITY_ASSET_LEVEL = 1

            # Partition-level granularity (annotations must contain partition info).
            GRANULARITY_PARTITION_LEVEL = 2
          end
        end

        # Request message for UpdateDataSchema.
        # @!attribute [rw] data_schema
        #   @return [::Google::Cloud::VisionAI::V1::DataSchema]
        #     Required. The data schema's `name` field is used to identify the data
        #     schema to be updated. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateDataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataSchema.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the data schema to retrieve.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
        class GetDataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDataSchema.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the data schema to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
        class DeleteDataSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDataSchemas.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of data schemas.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of data schemas to return. The service may return fewer
        #     than this value. If unspecified, at most 50 data schemas will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDataSchemas` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDataSchemas` must
        #     match the call that provided the page token.
        class ListDataSchemasRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDataSchemas.
        # @!attribute [rw] data_schemas
        #   @return [::Array<::Google::Cloud::VisionAI::V1::DataSchema>]
        #     The data schemas from the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDataSchemasResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateAnnotation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this annotation will be created.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] annotation
        #   @return [::Google::Cloud::VisionAI::V1::Annotation]
        #     Required. The annotation to create.
        # @!attribute [rw] annotation_id
        #   @return [::String]
        #     Optional. The ID to use for the annotation, which will become the final
        #     component of the annotation's resource name if user choose to specify.
        #     Otherwise, annotation id will be generated by system.
        #
        #     This value should be up to 63 characters, and valid characters
        #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
        #     a letter or a number.
        class CreateAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An annotation is a resource in asset. It represents a key-value mapping of
        # content in asset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the annotation.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
        # @!attribute [rw] user_specified_annotation
        #   @return [::Google::Cloud::VisionAI::V1::UserSpecifiedAnnotation]
        #     User provided annotation.
        class Annotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Annotation provided by users.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. Key of the annotation. The key must be set with type by
        #     CreateDataSchema.
        # @!attribute [rw] value
        #   @return [::Google::Cloud::VisionAI::V1::AnnotationValue]
        #     Value of the annotation. The value must be able to convert
        #     to the type according to the data schema.
        # @!attribute [rw] partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition]
        #     Partition information in time and space for the sub-asset level annotation.
        class UserSpecifiedAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location Coordinate Representation
        # @!attribute [rw] latitude
        #   @return [::Float]
        #     Latitude Coordinate. Degrees [-90 .. 90]
        # @!attribute [rw] longitude
        #   @return [::Float]
        #     Longitude Coordinate. Degrees [-180 .. 180]
        class GeoCoordinate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Value of annotation, including all types available in data schema.
        # @!attribute [rw] int_value
        #   @return [::Integer]
        #     Value of int type annotation.
        #
        #     Note: The following fields are mutually exclusive: `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] float_value
        #   @return [::Float]
        #     Value of float type annotation.
        #
        #     Note: The following fields are mutually exclusive: `float_value`, `int_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] str_value
        #   @return [::String]
        #     Value of string type annotation.
        #
        #     Note: The following fields are mutually exclusive: `str_value`, `int_value`, `float_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] datetime_value
        #   @return [::String]
        #     Value of date time type annotation.
        #
        #     Note: The following fields are mutually exclusive: `datetime_value`, `int_value`, `float_value`, `str_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] geo_coordinate
        #   @return [::Google::Cloud::VisionAI::V1::GeoCoordinate]
        #     Value of geo coordinate type annotation.
        #
        #     Note: The following fields are mutually exclusive: `geo_coordinate`, `int_value`, `float_value`, `str_value`, `datetime_value`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] proto_any_value
        #   @return [::Google::Protobuf::Any]
        #     Value of any proto value.
        #
        #     Note: The following fields are mutually exclusive: `proto_any_value`, `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `bool_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     Value of boolean type annotation.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `customized_struct_data_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customized_struct_data_value
        #   @return [::Google::Protobuf::Struct]
        #     Value of customized struct annotation. This field does not have effects.
        #     Use customized_struct_value instead for customized struct annotation.
        #
        #     Note: The following fields are mutually exclusive: `customized_struct_data_value`, `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `list_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] list_value
        #   @return [::Google::Cloud::VisionAI::V1::AnnotationList]
        #     Value of list type annotation.
        #
        #     Note: The following fields are mutually exclusive: `list_value`, `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `customized_struct_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customized_struct_value
        #   @return [::Google::Cloud::VisionAI::V1::AnnotationCustomizedStruct]
        #     Value of custom struct type annotation.
        #
        #     Note: The following fields are mutually exclusive: `customized_struct_value`, `int_value`, `float_value`, `str_value`, `datetime_value`, `geo_coordinate`, `proto_any_value`, `bool_value`, `customized_struct_data_value`, `list_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AnnotationValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List representation in annotation.
        # @!attribute [rw] values
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AnnotationValue>]
        #     The values of `LIST` data type annotation.
        class AnnotationList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Customized struct represnation in annotation.
        # @!attribute [rw] elements
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::VisionAI::V1::AnnotationValue}]
        #     A map from elements' keys to element's annotation value.
        class AnnotationCustomizedStruct
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::VisionAI::V1::AnnotationValue]
          class ElementsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for GetAnnotation API.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent, which owns this collection of annotations.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of annotations to return. The service may return fewer
        #     than this value. If unspecified, at most 50 annotations will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAnnotations` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAnnotations` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The filter applied to the returned list.
        #     We only support filtering for the following fields:
        #     For corpus of STREAM_VIDEO type:
        #     `partition.temporal_partition.start_time`,
        #     `partition.temporal_partition.end_time`, and `key`.
        #     For corpus of VIDEO_ON_DEMAND type,
        #     `partition.relative_temporal_partition.start_offset`,
        #     `partition.relative_temporal_partition.end_offset`, and `key`.
        #     For corpus of IMAGE type, only `key` is supported.
        #     Timestamps are specified in the RFC-3339 format, and only one restriction
        #     may be applied per field, joined by conjunctions.
        #     Format:
        #     "partition.temporal_partition.start_time > "2012-04-21T11:30:00-04:00" AND
        #     partition.temporal_partition.end_time < "2012-04-22T11:30:00-04:00" AND
        #     key = "example_key""
        class ListAnnotationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListAnnotations API.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Annotation>]
        #     The annotations from the specified asset.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAnnotationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetAnnotation API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the annotation to retrieve.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
        class GetAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateAnnotation API.
        # @!attribute [rw] annotation
        #   @return [::Google::Cloud::VisionAI::V1::Annotation]
        #     Required. The annotation to update.
        #     The annotation's `name` field is used to identify the annotation to be
        #     updated. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated.
        class UpdateAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteAnnotation API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the annotation to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
        class DeleteAnnotationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for ImportAssets.
        # @!attribute [rw] assets_gcs_uri
        #   @return [::String]
        #     The file contains all assets information to be imported.
        #     * The file is in JSONL format.
        #     * Each line corresponding to one asset.
        #     * Each line will be converted into InputImageAsset proto.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent corpus resource where the assets will be imported.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        class ImportAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata message for ImportAssets LRO.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     The metadata of the operation.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::VisionAI::V1::BatchOperationStatus]
        #     The importing status including partial failures, if the implementation can
        #     provide such information during the progress of the ImportAssets.
        class ImportAssetsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch operation status.
        # @!attribute [rw] success_count
        #   @return [::Integer]
        #     The count of assets (together with their annotations if any) successfully
        #     ingested.
        # @!attribute [rw] failure_count
        #   @return [::Integer]
        #     The count of assets failed to ingested; it might be due to the annotation
        #     ingestion error.
        class BatchOperationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for ImportAssets LRO.
        class ImportAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateSearchConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this search configuration will be
        #     created. Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] search_config
        #   @return [::Google::Cloud::VisionAI::V1::SearchConfig]
        #     Required. The search config to create.
        # @!attribute [rw] search_config_id
        #   @return [::String]
        #     Required. ID to use for the new search config. Will become the final
        #     component of the SearchConfig's resource name. This value should be up to
        #     63 characters, and valid characters are /[a-z][0-9]-_/. The first character
        #     must be a letter, the last could be a letter or a number.
        class CreateSearchConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateSearchConfig.
        # @!attribute [rw] search_config
        #   @return [::Google::Cloud::VisionAI::V1::SearchConfig]
        #     Required. The search configuration to update.
        #
        #     The search configuration's `name` field is used to identify the resource to
        #     be updated. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If left unset, all field paths will be
        #     updated/overwritten.
        class UpdateSearchConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetSearchConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the search configuration to retrieve.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
        class GetSearchConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteSearchConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the search configuration to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
        class DeleteSearchConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSearchConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of search configurations.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of search configurations to return. The service may
        #     return fewer than this value. If unspecified, a page size of 50 will be
        #     used. The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListSearchConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListSearchConfigs` must match the call that provided the page
        #     token.
        class ListSearchConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSearchConfigs.
        # @!attribute [rw] search_configs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SearchConfig>]
        #     The search configurations from the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSearchConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SearchConfig stores different properties that will affect search
        # behaviors and search results.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the search configuration.
        #     For CustomSearchCriteria, search_config would be the search
        #     operator name. For Facets, search_config would be the facet
        #     dimension name.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
        # @!attribute [rw] facet_property
        #   @return [::Google::Cloud::VisionAI::V1::FacetProperty]
        #     Establishes a FacetDimension and associated specifications.
        # @!attribute [rw] search_criteria_property
        #   @return [::Google::Cloud::VisionAI::V1::SearchCriteriaProperty]
        #     Creates a mapping between a custom SearchCriteria and one or more UGA keys.
        class SearchConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing IndexEndpoint resource. Indexes are deployed into it.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the IndexEndpoint.
        #     Format:
        #     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name of the IndexEndpoint. Can be up to 32 characters
        #     long.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the IndexEndpoint. Can be up to 25000 characters
        #     long.
        # @!attribute [r] deployed_index
        #   @return [::Google::Cloud::VisionAI::V1::DeployedIndex]
        #     Output only. The Index deployed in this IndexEndpoint.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VisionAI::V1::IndexEndpoint::State]
        #     Output only. IndexEndpoint state.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels applied to a resource must meet the following
        #     requirements:
        #
        #     * Each resource can have multiple labels, up to a maximum of 64.
        #     * Each label must be a key-value pair.
        #     * Keys have a minimum length of 1 character and a maximum length of 63
        #       characters and cannot be empty. Values can be empty and have a maximum
        #       length of 63 characters.
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #       underscores, and dashes. All characters must use UTF-8 encoding, and
        #       international characters are allowed.
        #     * The key portion of a label must be unique. However, you can use the same
        #       key with multiple resources.
        #     * Keys must start with a lowercase letter or international character.
        #
        #     See [Google Cloud
        #     Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
        #     for more details.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Update timestamp.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Separation enabled via an Org Policy constraint. It is set to true
        #     when the index endpoint is a valid zone separated index endpoint and false
        #     if it isn't.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. This boolean field is only set for projects that have Physical
        #     Zone Isolation enabled via an Org Policy constraint. It is set to true when
        #     the index endpoint is a valid zone isolated index endpoint and false if it
        #     isn't.
        class IndexEndpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # IndexEndpoint stage.
          module State
            # The default value. Should not be used.
            STATE_UNSPECIFIED = 0

            # State CREATING.
            CREATING = 1

            # State CREATED.
            CREATED = 2

            # State UPDATING.
            UPDATING = 3

            # State FAILED.
            FAILED = 4
          end
        end

        # Request message for CreateIndexEndpoint.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] index_endpoint_id
        #   @return [::String]
        #     Optional. The ID to use for the IndexEndpoint, which will become the final
        #     component of the IndexEndpoint's resource name if the user specifies it.
        #     Otherwise, IndexEndpoint id will be autogenerated.
        #
        #     This value should be up to 63 characters, and valid characters
        #     are a-z, 0-9 and dash (-). The first character must be a letter, the last
        #     must be a letter or a number.
        # @!attribute [rw] index_endpoint
        #   @return [::Google::Cloud::VisionAI::V1::IndexEndpoint]
        #     Required. The resource being created.
        class CreateIndexEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for CreateIndexEndpoint.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class CreateIndexEndpointMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetIndexEndpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the IndexEndpoint resource.
        class GetIndexEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListIndexEndpoints.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. The service may return fewer than this value. If unspecified, a
        #     page size of 50 will be used. The maximum value is 1000; values above 1000
        #     will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter applied to the returned list.
        #     We only support filtering for the `deployed_image_index.image_index` field.
        #     However, to filter by a corpus instead of an image index, simply use
        #     `deployed_image_index.corpus`, which will return all endpoints with
        #     `deployed_image_index.image_index` inside of the given corpus.
        #     A basic filter on image index would look like:
        #       deployed_image_index.image_index =
        #         "projects/123/locations/us-central1/corpora/my_corpus/imageIndexes/my_image_index"
        #     A basic filter on corpus would look like:
        #       deployed_image_index.corpus =
        #         "projects/123/locations/us-central1/corpora/my_corpus"
        class ListIndexEndpointsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListIndexEndpoints.
        # @!attribute [rw] index_endpoints
        #   @return [::Array<::Google::Cloud::VisionAI::V1::IndexEndpoint>]
        #     The list of IndexEndpoints.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListIndexEndpointsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateIndexEndpoint.
        # @!attribute [rw] index_endpoint
        #   @return [::Google::Cloud::VisionAI::V1::IndexEndpoint]
        #     Required. The resource being updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     IndexEndpoint resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request.
        #     A field of the resource will be overwritten if it is in the mask.
        #     Empty field mask is not allowed.
        #     If the mask is "*", then this is a full replacement of the resource.
        class UpdateIndexEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for UpdateIndexEndpoint.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class UpdateIndexEndpointMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteIndexEndpoint.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class DeleteIndexEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for DeleteIndexEndpoint.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        class DeleteIndexEndpointMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeployIndex.
        # @!attribute [rw] index_endpoint
        #   @return [::String]
        #     Required. IndexEndpoint the index is deployed to.
        #     Format:
        #     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
        # @!attribute [rw] deployed_index
        #   @return [::Google::Cloud::VisionAI::V1::DeployedIndex]
        #     Required. Index to deploy.
        class DeployIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeployIndex response once the operation is done.
        class DeployIndexResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for DeployIndex.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        # @!attribute [r] deployed_index
        #   @return [::String]
        #     Output only. The index being deployed.
        class DeployIndexMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for UndeployIndex.
        # @!attribute [rw] operation_metadata
        #   @return [::Google::Cloud::VisionAI::V1::OperationMetadata]
        #     Common metadata of the long-running operation.
        # @!attribute [r] deployed_index
        #   @return [::String]
        #     Output only. The index being undeployed.
        class UndeployIndexMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UndeployIndexEndpoint.
        # @!attribute [rw] index_endpoint
        #   @return [::String]
        #     Required. Resource name of the IndexEndpoint resource on which the
        #     undeployment will act. Format:
        #     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
        class UndeployIndexRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UndeployIndex response once the operation is done.
        class UndeployIndexResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A deployment of an Index.
        # @!attribute [rw] index
        #   @return [::String]
        #     Required. Name of the deployed Index.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
        class DeployedIndex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Central configuration for a facet.
        # @!attribute [rw] fixed_range_bucket_spec
        #   @return [::Google::Cloud::VisionAI::V1::FacetProperty::FixedRangeBucketSpec]
        #     Fixed range facet bucket config.
        #
        #     Note: The following fields are mutually exclusive: `fixed_range_bucket_spec`, `custom_range_bucket_spec`, `datetime_bucket_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_range_bucket_spec
        #   @return [::Google::Cloud::VisionAI::V1::FacetProperty::CustomRangeBucketSpec]
        #     Custom range facet bucket config.
        #
        #     Note: The following fields are mutually exclusive: `custom_range_bucket_spec`, `fixed_range_bucket_spec`, `datetime_bucket_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] datetime_bucket_spec
        #   @return [::Google::Cloud::VisionAI::V1::FacetProperty::DateTimeBucketSpec]
        #     Datetime range facet bucket config.
        #
        #     Note: The following fields are mutually exclusive: `datetime_bucket_spec`, `fixed_range_bucket_spec`, `custom_range_bucket_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mapped_fields
        #   @return [::Array<::String>]
        #     Name of the facets, which are the dimensions users want to use to refine
        #     search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
        #
        #     For example, user can add a bunch of UGAs with the same key, such as
        #     player:adam, player:bob, player:charles. When multiple mapped_fields are
        #     specified, will merge their value together as final facet value. E.g.
        #     home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
        #     [home_team, away_team], facet_value will be [a, b, c].
        #
        #     UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
        #     mapped_field equals the parent SearchConfig.name, the parent must
        #     also contain a SearchCriteriaProperty that maps to the same fields.
        #     mapped_fields must not be empty.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of the facet. To be used by UI for facet rendering.
        # @!attribute [rw] result_size
        #   @return [::Integer]
        #     Maximum number of unique bucket to return for one facet. Bucket number can
        #     be large for high-cardinality facet such as "player". We only return top-n
        #     most related ones to user. If it's <= 0, the server will decide the
        #     appropriate result_size.
        # @!attribute [rw] bucket_type
        #   @return [::Google::Cloud::VisionAI::V1::FacetBucketType]
        #     Facet bucket type e.g. value, range.
        class FacetProperty
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # If bucket type is FIXED_RANGE, specify how values are bucketized. Use
          # FixedRangeBucketSpec when you want to create multiple buckets with equal
          # granularities. Using integer bucket value as an example, when
          # bucket_start = 0, bucket_granularity = 10, bucket_count = 5, this facet
          # will be aggregated via the following buckets:
          # [-inf, 0), [0, 10), [10, 20), [20, 30), [30, inf).
          # Notably, bucket_count <= 1 is an invalid spec.
          # @!attribute [rw] bucket_start
          #   @return [::Google::Cloud::VisionAI::V1::FacetValue]
          #     Lower bound of the bucket. NOTE: Only integer type is currently supported
          #     for this field.
          # @!attribute [rw] bucket_granularity
          #   @return [::Google::Cloud::VisionAI::V1::FacetValue]
          #     Bucket granularity. NOTE: Only integer type is currently supported for
          #     this field.
          # @!attribute [rw] bucket_count
          #   @return [::Integer]
          #     Total number of buckets.
          class FixedRangeBucketSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # If bucket type is CUSTOM_RANGE, specify how values are bucketized. Use
          # integer bucket value as an example, when the endpoints are 0, 10, 100, and
          # 1000, we will generate the following facets:
          # [-inf, 0), [0, 10), [10, 100), [100, 1000), [1000, inf).
          # Notably:
          # - endpoints must be listed in ascending order. Otherwise, the SearchConfig
          #   API will reject the facet config.
          # - < 1 endpoints is an invalid spec.
          # @!attribute [rw] endpoints
          #   @return [::Array<::Google::Cloud::VisionAI::V1::FacetValue>]
          #     Currently, only integer type is supported for this field.
          class CustomRangeBucketSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # If bucket type is DATE, specify how date values are bucketized.
          # @!attribute [rw] granularity
          #   @return [::Google::Cloud::VisionAI::V1::FacetProperty::DateTimeBucketSpec::Granularity]
          #     Granularity of date type facet.
          class DateTimeBucketSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Granularity enum for the datetime bucket.
            module Granularity
              # Unspecified granularity.
              GRANULARITY_UNSPECIFIED = 0

              # Granularity is year.
              YEAR = 1

              # Granularity is month.
              MONTH = 2

              # Granularity is day.
              DAY = 3
            end
          end
        end

        # Search resource: SearchHypernym.
        # For example,
        # { hypernym: "vehicle"
        #   hyponyms: ["sedan", "truck"] }
        # This means in SMART_SEARCH mode, searching for "vehicle" will also return
        # results with "sedan" or "truck" as annotations.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the SearchHypernym.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
        # @!attribute [rw] hypernym
        #   @return [::String]
        #     Optional. The hypernym.
        # @!attribute [rw] hyponyms
        #   @return [::Array<::String>]
        #     Optional. Hyponyms that the hypernym is mapped to.
        class SearchHypernym
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating SearchHypernym.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this SearchHypernym will be created.
        #     Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] search_hypernym
        #   @return [::Google::Cloud::VisionAI::V1::SearchHypernym]
        #     Required. The SearchHypernym to create.
        # @!attribute [rw] search_hypernym_id
        #   @return [::String]
        #     Optional. The search hypernym id.
        #     If omitted, a random UUID will be generated.
        class CreateSearchHypernymRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating SearchHypernym.
        # @!attribute [rw] search_hypernym
        #   @return [::Google::Cloud::VisionAI::V1::SearchHypernym]
        #     Required. The SearchHypernym to update.
        #     The search hypernym's `name` field is used to identify the search hypernym
        #     to be updated. Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. If left unset, all field paths will be
        #     updated/overwritten.
        class UpdateSearchHypernymRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting SearchHypernym.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SearchHypernym to retrieve.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
        class GetSearchHypernymRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting SearchHypernym.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the SearchHypernym to delete.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
        class DeleteSearchHypernymRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing SearchHypernyms.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of SearchHypernyms.
        #     Format:
        #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of SearchHypernyms returned. The service may
        #     return fewer than this value. If unspecified, a page size of 50 will be
        #     used. The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `SearchHypernym` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `SearchHypernym` must match the call that provided the page
        #     token.
        class ListSearchHypernymsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing SearchHypernyms.
        # @!attribute [rw] search_hypernyms
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SearchHypernym>]
        #     The SearchHypernyms from the specified corpus.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSearchHypernymsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Central configuration for custom search criteria.
        # @!attribute [rw] mapped_fields
        #   @return [::Array<::String>]
        #     Each mapped_field corresponds to a UGA key. To understand how this property
        #     works, take the following example. In the SearchConfig table, the
        #     user adds this entry:
        #       search_config {
        #         name: "person"
        #         search_criteria_property {
        #           mapped_fields: "player"
        #           mapped_fields: "coach"
        #         }
        #       }
        #
        #     Now, when a user issues a query like:
        #       criteria {
        #         field: "person"
        #         text_array {
        #           txt_values: "Tom Brady"
        #           txt_values: "Bill Belichick"
        #         }
        #       }
        #
        #     MWH search will return search documents where (player=Tom Brady ||
        #     coach=Tom Brady || player=Bill Belichick || coach=Bill Belichick).
        class SearchCriteriaProperty
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Definition of a single value with generic type.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     String type value.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `integer_value`, `datetime_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] integer_value
        #   @return [::Integer]
        #     Integer type value.
        #
        #     Note: The following fields are mutually exclusive: `integer_value`, `string_value`, `datetime_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] datetime_value
        #   @return [::Google::Type::DateTime]
        #     Datetime type value.
        #
        #     Note: The following fields are mutually exclusive: `datetime_value`, `string_value`, `integer_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FacetValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Holds the facet value, selections state, and metadata.
        # @!attribute [rw] value
        #   @return [::Google::Cloud::VisionAI::V1::FacetValue]
        #     Singular value.
        #
        #     Note: The following fields are mutually exclusive: `value`, `range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] range
        #   @return [::Google::Cloud::VisionAI::V1::FacetBucket::Range]
        #     Range value.
        #
        #     Note: The following fields are mutually exclusive: `range`, `value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] selected
        #   @return [::Boolean]
        #     Whether one facet bucket is selected. This field represents user's facet
        #     selection. It is set by frontend in SearchVideosRequest.
        class FacetBucket
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The range of values [start, end) for which faceting is applied.
          # @!attribute [rw] start
          #   @return [::Google::Cloud::VisionAI::V1::FacetValue]
          #     Start of the range. Non-existence indicates some bound (e.g. -inf).
          # @!attribute [rw] end
          #   @return [::Google::Cloud::VisionAI::V1::FacetValue]
          #     End of the range. Non-existence indicates some bound (e.g. inf).
          class Range
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A group of facet buckets to be passed back and forth between backend &
        # frontend.
        # @!attribute [rw] facet_id
        #   @return [::String]
        #     Unique id of the facet group.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of the facet. To be used by UI for facet rendering.
        # @!attribute [rw] buckets
        #   @return [::Array<::Google::Cloud::VisionAI::V1::FacetBucket>]
        #     Buckets associated with the facet. E.g. for "Team" facet, the bucket
        #     can be 49ers, patriots, etc.
        # @!attribute [rw] bucket_type
        #   @return [::Google::Cloud::VisionAI::V1::FacetBucketType]
        #     Facet bucket type.
        # @!attribute [rw] fetch_matched_annotations
        #   @return [::Boolean]
        #     If true, return query matched annotations for this facet group's selection.
        #     This option is only applicable for facets based on partition level
        #     annotations. It supports the following facet values:
        #      - INTEGER
        #      - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
        class FacetGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for IngestAsset API.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::VisionAI::V1::IngestAssetRequest::Config]
        #     Provides information for the data and the asset resource name that the
        #     data belongs to. The first `IngestAssetRequest` message must only contain
        #     a `Config` message.
        #
        #     Note: The following fields are mutually exclusive: `config`, `time_indexed_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] time_indexed_data
        #   @return [::Google::Cloud::VisionAI::V1::IngestAssetRequest::TimeIndexedData]
        #     Data to be ingested.
        #
        #     Note: The following fields are mutually exclusive: `time_indexed_data`, `config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class IngestAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for the data.
          # @!attribute [rw] video_type
          #   @return [::Google::Cloud::VisionAI::V1::IngestAssetRequest::Config::VideoType]
          #     Type information for video data.
          # @!attribute [rw] asset
          #   @return [::String]
          #     Required. The resource name of the asset that the ingested data belongs
          #     to.
          class Config
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Type information for video data.
            # @!attribute [rw] container_format
            #   @return [::Google::Cloud::VisionAI::V1::IngestAssetRequest::Config::VideoType::ContainerFormat]
            #     Container format of the video data.
            class VideoType
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Container format of the video.
              module ContainerFormat
                # The default type, not supposed to be used.
                CONTAINER_FORMAT_UNSPECIFIED = 0

                # Mp4 container format.
                CONTAINER_FORMAT_MP4 = 1
              end
            end
          end

          # Contains the data and the corresponding time range this data is for.
          # @!attribute [rw] data
          #   @return [::String]
          #     Data to be ingested.
          # @!attribute [rw] temporal_partition
          #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
          #     Time range of the data.
          class TimeIndexedData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for IngestAsset API.
        # @!attribute [rw] successfully_ingested_partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
        #     Time range of the data that has been successfully ingested.
        class IngestAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ClipAsset API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to request clips for.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] temporal_partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
        #     Required. The time range to request clips for.
        class ClipAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ClipAsset API.
        # @!attribute [rw] time_indexed_uris
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ClipAssetResponse::TimeIndexedUri>]
        #     A list of signed uris to download the video clips that cover the requested
        #     time range ordered by time.
        class ClipAssetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Signed uri with corresponding time range.
          # @!attribute [rw] temporal_partition
          #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
          #     Time range of the video that the uri is for.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Signed uri to download the video clip.
          class TimeIndexedUri
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for GenerateHlsUri API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset to request clips for.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] temporal_partitions
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Partition::TemporalPartition>]
        #     The time range to request clips for. Will be ignored if `get_live_view` is
        #     set to True. The total time range requested should be smaller than 24h.
        # @!attribute [rw] live_view_enabled
        #   @return [::Boolean]
        #     Option to exclusively show a livestream of the asset with up to 3 minutes
        #     of backlog data.
        class GenerateHlsUriRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for GenerateHlsUri API.
        # @!attribute [rw] uri
        #   @return [::String]
        #     A signed uri to download the HLS manifest corresponding to the requested
        #     times.
        # @!attribute [rw] temporal_partitions
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Partition::TemporalPartition>]
        #     A list of temporal partitions of the content returned in the order they
        #     appear in the stream.
        class GenerateHlsUriResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for SearchAssets.
        # @!attribute [rw] schema_key_sorting_strategy
        #   @return [::Google::Cloud::VisionAI::V1::SchemaKeySortingStrategy]
        #     Sort by the value under the data schema key.
        # @!attribute [rw] corpus
        #   @return [::String]
        #     Required. The parent corpus to search.
        #     Format: `projects/{project_id}/locations/{location_id}/corpora/{corpus_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of results to be returned in this page. If it's 0, the server
        #     will decide the appropriate page_size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The continuation token to fetch the next page. If empty, it means it is
        #     fetching the first page.
        # @!attribute [rw] content_time_ranges
        #   @return [::Google::Cloud::VisionAI::V1::DateTimeRangeArray]
        #     Time ranges that matching video content must fall within. If no ranges are
        #     provided, there will be no time restriction. This field is treated just
        #     like the criteria below, but defined separately for convenience as it is
        #     used frequently. Note that if the end_time is in the future, it will be
        #     clamped to the time the request was received.
        # @!attribute [rw] criteria
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Criteria>]
        #     Criteria applied to search results.
        # @!attribute [rw] facet_selections
        #   @return [::Array<::Google::Cloud::VisionAI::V1::FacetGroup>]
        #     Stores most recent facet selection state. Only facet groups with user's
        #     selection will be presented here. Selection state is either selected or
        #     unselected. Only selected facet buckets will be used as search criteria.
        # @!attribute [rw] result_annotation_keys
        #   @return [::Array<::String>]
        #     A list of annotation keys to specify the annotations to be retrieved and
        #     returned with each search result.
        #     Annotation granularity must be GRANULARITY_ASSET_LEVEL and its search
        #     strategy must not be NO_SEARCH.
        # @!attribute [rw] search_query
        #   @return [::String]
        #     Global search query. Allows user to search assets without needing to
        #     specify which field the value belongs to.
        class SearchAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for SearchIndexEndpoint.
        # @!attribute [rw] image_query
        #   @return [::Google::Cloud::VisionAI::V1::ImageQuery]
        #     An image-only query.
        #
        #     Note: The following fields are mutually exclusive: `image_query`, `text_query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_query
        #   @return [::String]
        #     A text-only query.
        #
        #     Note: The following fields are mutually exclusive: `text_query`, `image_query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] index_endpoint
        #   @return [::String]
        #     Required. The index endpoint to search.
        #     Format:
        #     `projects/{project_id}/locations/{location_id}/indexEndpoints/{index_endpoint_id}`
        # @!attribute [rw] criteria
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Criteria>]
        #     Criteria applied to search results.
        # @!attribute [rw] exclusion_criteria
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Criteria>]
        #     Criteria to exclude from search results.
        #     Note that `fetch_matched_annotations` will be ignored.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. API may return fewer results than requested.
        #     If negative, INVALID_ARGUMENT error will be returned.
        #     If unspecified or 0, API will pick a default size, which is 10.
        #     If the requested page size is larger than the maximum size, API will pick
        #     the maximum size, which is 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The continuation token to fetch the next page. If empty, it means it is
        #     fetching the first page.
        class SearchIndexEndpointRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Image query for search endpoint request.
        # @!attribute [rw] input_image
        #   @return [::String]
        #     Input image in raw bytes.
        #
        #     Note: The following fields are mutually exclusive: `input_image`, `asset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] asset
        #   @return [::String]
        #     Resource name of the asset. Only supported in IMAGE corpus type.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        #
        #     Note: The following fields are mutually exclusive: `asset`, `input_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ImageQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A strategy to specify how to sort by data schema key.
        # @!attribute [rw] options
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SchemaKeySortingStrategy::Option>]
        #     Options in the front have high priority than those in the back.
        class SchemaKeySortingStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Option for one data schema key.
          # @!attribute [rw] data_schema_key
          #   @return [::String]
          #     The data used to sort.
          # @!attribute [rw] sort_decreasing
          #   @return [::Boolean]
          #     Whether to sort in decreasing order or increasing order.
          #     By default, results are sorted in incresing order.
          # @!attribute [rw] aggregate_method
          #   @return [::Google::Cloud::VisionAI::V1::SchemaKeySortingStrategy::Option::AggregateMethod]
          #     Aggregate method for the current data schema key.
          class Option
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # When one result has multiple values with the same key, specify
            # which value is used to sort. By default, AGGREGATE_METHOD_LARGEST
            # is used when results are sorted in decreasing order,
            # AGGREGATE_METHOD_SMALLEST is used when results are sorted in
            # incresing order.
            module AggregateMethod
              # The unspecified aggregate method will be overwritten as mentioned
              # above.
              AGGREGATE_METHOD_UNSPECIFIED = 0

              # Take the (lexicographical or numerical) largest value to sort.
              AGGREGATE_METHOD_LARGEST = 1

              # Take the (lexicographical or numerical) smallest value to sort.
              AGGREGATE_METHOD_SMALLEST = 2
            end
          end
        end

        # The metadata for DeleteAsset API that embeds in
        # {::Google::Longrunning::Operation#metadata metadata} field.
        class DeleteAssetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Stores the criteria-annotation matching results for each search result item.
        # @!attribute [rw] criteria
        #   @return [::Google::Cloud::VisionAI::V1::Criteria]
        #     The criteria used for matching. It can be an input search criteria or a
        #     criteria converted from a facet selection.
        # @!attribute [rw] matched_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Annotation>]
        #     Matched annotations for the criteria.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     Status of the match result. Possible values:
        #     FAILED_PRECONDITION - the criteria is not eligible for match.
        #     OK - matching is performed.
        class AnnotationMatchingResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Search result contains asset name and corresponding time ranges.
        # @!attribute [rw] asset
        #   @return [::String]
        #     The resource name of the asset.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
        # @!attribute [rw] segments
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Partition::TemporalPartition>]
        #     The matched asset segments.
        #     Deprecated: please use singular `segment` field.
        # @!attribute [rw] segment
        #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
        #     The matched asset segment.
        # @!attribute [rw] relevance
        #   @return [::Float]
        #     Available to IMAGE corpus types.
        #     Relevance of this `SearchResultItem` to user search query (text query or
        #     image query).
        #     By default this represents cosine similarity between the query and the
        #     retrieved media content. The value is in the range of [-1, 1].
        #     Note that search ranking is not only decided by this relevance score,
        #     but also other factors such as the match of annotations.
        # @!attribute [rw] requested_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Annotation>]
        #     Search result annotations specified by result_annotation_keys in search
        #     request.
        # @!attribute [rw] annotation_matching_results
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AnnotationMatchingResult>]
        #     Criteria or facet-selection based annotation matching results associated to
        #     this search result item. Only contains results for criteria or
        #     facet_selections with fetch_matched_annotations=true.
        class SearchResultItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for SearchAssets.
        # @!attribute [rw] search_result_items
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SearchResultItem>]
        #     Returned search results.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next-page continuation token.
        # @!attribute [rw] facet_results
        #   @return [::Array<::Google::Cloud::VisionAI::V1::FacetGroup>]
        #     Facet search results of a given query, which contains user's
        #     already-selected facet values and updated facet search results.
        class SearchAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for SearchIndexEndpoint.
        # @!attribute [rw] search_result_items
        #   @return [::Array<::Google::Cloud::VisionAI::V1::SearchResultItem>]
        #     Returned search results.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next-page continuation token.
        #     If this field is omitted, there are no subsequent pages.
        class SearchIndexEndpointResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Integer range type.
        # @!attribute [rw] start
        #   @return [::Integer]
        #     Start of the int range.
        # @!attribute [rw] end
        #   @return [::Integer]
        #     End of the int range.
        class IntRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Float range type.
        # @!attribute [rw] start
        #   @return [::Float]
        #     Start of the float range.
        # @!attribute [rw] end
        #   @return [::Float]
        #     End of the float range.
        class FloatRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of string-type values.
        # @!attribute [rw] txt_values
        #   @return [::Array<::String>]
        #     String type values.
        class StringArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of integer range values.
        # @!attribute [rw] int_ranges
        #   @return [::Array<::Google::Cloud::VisionAI::V1::IntRange>]
        #     Int range values.
        class IntRangeArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of float range values.
        # @!attribute [rw] float_ranges
        #   @return [::Array<::Google::Cloud::VisionAI::V1::FloatRange>]
        #     Float range values.
        class FloatRangeArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Datetime range type.
        # @!attribute [rw] start
        #   @return [::Google::Type::DateTime]
        #     Start date time.
        # @!attribute [rw] end
        #   @return [::Google::Type::DateTime]
        #     End data time.
        class DateTimeRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of datetime range values.
        # @!attribute [rw] date_time_ranges
        #   @return [::Array<::Google::Cloud::VisionAI::V1::DateTimeRange>]
        #     Date time ranges.
        class DateTimeRangeArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Representation of a circle area.
        # @!attribute [rw] latitude
        #   @return [::Float]
        #     Latitude of circle area's center. Degrees [-90 .. 90]
        # @!attribute [rw] longitude
        #   @return [::Float]
        #     Longitude of circle area's center. Degrees [-180 .. 180]
        # @!attribute [rw] radius_meter
        #   @return [::Float]
        #     Radius of the circle area in meters.
        class CircleArea
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of locations.
        # @!attribute [rw] circle_areas
        #   @return [::Array<::Google::Cloud::VisionAI::V1::CircleArea>]
        #     A list of circle areas.
        class GeoLocationArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] value
        #   @return [::Boolean]
        class BoolValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Filter criteria applied to current search results.
        # @!attribute [rw] text_array
        #   @return [::Google::Cloud::VisionAI::V1::StringArray]
        #     The text values associated with the field.
        #
        #     Note: The following fields are mutually exclusive: `text_array`, `int_range_array`, `float_range_array`, `date_time_range_array`, `geo_location_array`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int_range_array
        #   @return [::Google::Cloud::VisionAI::V1::IntRangeArray]
        #     The integer ranges associated with the field.
        #
        #     Note: The following fields are mutually exclusive: `int_range_array`, `text_array`, `float_range_array`, `date_time_range_array`, `geo_location_array`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] float_range_array
        #   @return [::Google::Cloud::VisionAI::V1::FloatRangeArray]
        #     The float ranges associated with the field.
        #
        #     Note: The following fields are mutually exclusive: `float_range_array`, `text_array`, `int_range_array`, `date_time_range_array`, `geo_location_array`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] date_time_range_array
        #   @return [::Google::Cloud::VisionAI::V1::DateTimeRangeArray]
        #     The datetime ranges associated with the field.
        #
        #     Note: The following fields are mutually exclusive: `date_time_range_array`, `text_array`, `int_range_array`, `float_range_array`, `geo_location_array`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] geo_location_array
        #   @return [::Google::Cloud::VisionAI::V1::GeoLocationArray]
        #     Geo Location array.
        #
        #     Note: The following fields are mutually exclusive: `geo_location_array`, `text_array`, `int_range_array`, `float_range_array`, `date_time_range_array`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Google::Cloud::VisionAI::V1::BoolValue]
        #     A Boolean value.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `text_array`, `int_range_array`, `float_range_array`, `date_time_range_array`, `geo_location_array`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] field
        #   @return [::String]
        #     The UGA field or ML field to apply filtering criteria.
        # @!attribute [rw] fetch_matched_annotations
        #   @return [::Boolean]
        #     If true, return query matched annotations for this criteria.
        #     This option is only applicable for inclusion criteria, i.e., not exclusion
        #     criteria, with partition level annotations.  It supports the following data
        #     types:
        #      - INTEGER
        #      - FLOAT
        #      - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
        #      - BOOLEAN
        class Criteria
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Partition to specify the partition in time and space for sub-asset level
        # annotation.
        # @!attribute [rw] temporal_partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition]
        #     Partition of asset in time.
        # @!attribute [rw] spatial_partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition::SpatialPartition]
        #     Partition of asset in space.
        # @!attribute [rw] relative_temporal_partition
        #   @return [::Google::Cloud::VisionAI::V1::Partition::RelativeTemporalPartition]
        #     Partition of asset in time.
        class Partition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Partition of asset in UTC Epoch time. Supported by STREAM_VIDEO corpus
          # type.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Start time of the partition.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     End time of the partition.
          class TemporalPartition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Partition of asset in space.
          # @!attribute [rw] x_min
          #   @return [::Integer]
          #     The minimum x coordinate value.
          # @!attribute [rw] y_min
          #   @return [::Integer]
          #     The minimum y coordinate value.
          # @!attribute [rw] x_max
          #   @return [::Integer]
          #     The maximum x coordinate value.
          # @!attribute [rw] y_max
          #   @return [::Integer]
          #     The maximum y coordinate value.
          class SpatialPartition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Partition of asset in relative time. Supported by VIDEO_ON_DEMAND corpus
          # type.
          # @!attribute [rw] start_offset
          #   @return [::Google::Protobuf::Duration]
          #     Start time offset of the partition.
          # @!attribute [rw] end_offset
          #   @return [::Google::Protobuf::Duration]
          #     End time offset of the partition.
          class RelativeTemporalPartition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Different types for a facet bucket.
        module FacetBucketType
          # Unspecified type.
          FACET_BUCKET_TYPE_UNSPECIFIED = 0

          # Value type.
          FACET_BUCKET_TYPE_VALUE = 1

          # Datetime type.
          FACET_BUCKET_TYPE_DATETIME = 2

          # Fixed Range type.
          FACET_BUCKET_TYPE_FIXED_RANGE = 3

          # Custom Range type.
          FACET_BUCKET_TYPE_CUSTOM_RANGE = 4
        end
      end
    end
  end
end
