# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Message describing the Stream object. The Stream and the Event resources are
        # many to many; i.e., each Stream resource can associate to many Event
        # resources and each Event resource can associate to many Stream resources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow clients to store small amounts of arbitrary data.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name for the stream resource.
        # @!attribute [rw] enable_hls_playback
        #   @return [::Boolean]
        #     Whether to enable the HLS playback service on this stream.
        # @!attribute [rw] media_warehouse_asset
        #   @return [::String]
        #     The name of the media warehouse asset for long term storage of stream data.
        #     Format: projects/$\\{p_id}/locations/$\\{l_id}/corpora/$\\{c_id}/assets/$\\{a_id}
        #     Remain empty if the media warehouse storage is not needed for the stream.
        class Stream
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing the Event object.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow clients to store small amounts of arbitrary data.
        # @!attribute [rw] alignment_clock
        #   @return [::Google::Cloud::VisionAI::V1::Event::Clock]
        #     The clock used for joining streams.
        # @!attribute [rw] grace_period
        #   @return [::Google::Protobuf::Duration]
        #     Grace period for cleaning up the event. This is the time the controller
        #     waits for before deleting the event. During this period, if there is any
        #     active channel on the event. The deletion of the event after grace_period
        #     will be ignored.
        class Event
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Clock that will be used for joining streams.
          module Clock
            # Clock is not specified.
            CLOCK_UNSPECIFIED = 0

            # Use the timestamp when the data is captured. Clients need to sync the
            # clock.
            CAPTURE = 1

            # Use the timestamp when the data is received.
            INGEST = 2
          end
        end

        # Message describing the Series object.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow clients to store small amounts of arbitrary data.
        # @!attribute [rw] stream
        #   @return [::String]
        #     Required. Stream that is associated with this series.
        # @!attribute [rw] event
        #   @return [::String]
        #     Required. Event that is associated with this series.
        class Series
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing the Channel object.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Annotations to allow clients to store small amounts of arbitrary data.
        # @!attribute [rw] stream
        #   @return [::String]
        #     Required. Stream that is associated with this series.
        # @!attribute [rw] event
        #   @return [::String]
        #     Required. Event that is associated with this series.
        class Channel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
