# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Request message for ReceiveEvents.
        # @!attribute [rw] setup_request
        #   @return [::Google::Cloud::VisionAI::V1::ReceiveEventsRequest::SetupRequest]
        #     The setup request to setup the RPC connection.
        #
        #     Note: The following fields are mutually exclusive: `setup_request`, `commit_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] commit_request
        #   @return [::Google::Cloud::VisionAI::V1::CommitRequest]
        #     This request checkpoints the consumer's read progress.
        #
        #     Note: The following fields are mutually exclusive: `commit_request`, `setup_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceiveEventsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # SetupRequest is the first message sent to the service to setup the RPC
          # connection.
          # @!attribute [rw] cluster
          #   @return [::String]
          #     The cluster name.
          # @!attribute [rw] stream
          #   @return [::String]
          #     The stream name. The service will return the events for the given stream.
          # @!attribute [rw] receiver
          #   @return [::String]
          #     A name for the receiver to self-identify.
          #
          #     This is used to keep track of a receiver's read progress.
          # @!attribute [rw] controlled_mode
          #   @return [::Google::Cloud::VisionAI::V1::ControlledMode]
          #     Controller mode configuration for receiving events from the server.
          # @!attribute [rw] heartbeat_interval
          #   @return [::Google::Protobuf::Duration]
          #     The maximum duration of server silence before the client determines the
          #     server unreachable.
          #
          #     The client must either receive an `Event` update or a heart beat message
          #     before this duration expires; otherwise, the client will automatically
          #     cancel the current connection and retry.
          # @!attribute [rw] writes_done_grace_period
          #   @return [::Google::Protobuf::Duration]
          #     The grace period after which a `writes_done_request` is issued, that a
          #     `WritesDone` is expected from the client.
          #
          #     The server is free to cancel the RPC should this expire.
          #
          #     A system default will be chosen if unset.
          class SetupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The event update message.
        # @!attribute [rw] stream
        #   @return [::String]
        #     The name of the stream that the event is attached to.
        # @!attribute [rw] event
        #   @return [::String]
        #     The name of the event.
        # @!attribute [rw] series
        #   @return [::String]
        #     The name of the series.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the Event update happens.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     The offset of the message that will be used to acknowledge of the message
        #     receiving.
        class EventUpdate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Control message for a ReceiveEventsResponse.
        # @!attribute [rw] heartbeat
        #   @return [::Boolean]
        #     A server heartbeat.
        #
        #     Note: The following fields are mutually exclusive: `heartbeat`, `writes_done_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] writes_done_request
        #   @return [::Boolean]
        #     A request to the receiver to complete any final writes followed by a
        #     `WritesDone`; e.g. issue any final `CommitRequest`s.
        #
        #     May be ignored if `WritesDone` has already been issued at any point
        #     prior to receiving this message.
        #
        #     If `WritesDone` does not get issued, then the server will forcefully
        #     cancel the connection, and the receiver will likely receive an
        #     uninformative after `Read` returns `false` and `Finish` is called.
        #
        #     Note: The following fields are mutually exclusive: `writes_done_request`, `heartbeat`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceiveEventsControlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the ReceiveEvents.
        # @!attribute [rw] event_update
        #   @return [::Google::Cloud::VisionAI::V1::EventUpdate]
        #     The event update message.
        #
        #     Note: The following fields are mutually exclusive: `event_update`, `control`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] control
        #   @return [::Google::Cloud::VisionAI::V1::ReceiveEventsControlResponse]
        #     A control message from the server.
        #
        #     Note: The following fields are mutually exclusive: `control`, `event_update`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceiveEventsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The lease message.
        # @!attribute [rw] id
        #   @return [::String]
        #     The lease id.
        # @!attribute [rw] series
        #   @return [::String]
        #     The series name.
        # @!attribute [rw] owner
        #   @return [::String]
        #     The owner name.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The lease expire time.
        # @!attribute [rw] lease_type
        #   @return [::Google::Cloud::VisionAI::V1::LeaseType]
        #     The lease type.
        class Lease
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for acquiring a lease.
        # @!attribute [rw] series
        #   @return [::String]
        #     The series name.
        # @!attribute [rw] owner
        #   @return [::String]
        #     The owner name.
        # @!attribute [rw] term
        #   @return [::Google::Protobuf::Duration]
        #     The lease term.
        # @!attribute [rw] lease_type
        #   @return [::Google::Cloud::VisionAI::V1::LeaseType]
        #     The lease type.
        class AcquireLeaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for renewing a lease.
        # @!attribute [rw] id
        #   @return [::String]
        #     Lease id.
        # @!attribute [rw] series
        #   @return [::String]
        #     Series name.
        # @!attribute [rw] owner
        #   @return [::String]
        #     Lease owner.
        # @!attribute [rw] term
        #   @return [::Google::Protobuf::Duration]
        #     Lease term.
        class RenewLeaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for releasing lease.
        # @!attribute [rw] id
        #   @return [::String]
        #     Lease id.
        # @!attribute [rw] series
        #   @return [::String]
        #     Series name.
        # @!attribute [rw] owner
        #   @return [::String]
        #     Lease owner.
        class ReleaseLeaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for release lease.
        class ReleaseLeaseResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RequestMetadata is the metadata message for the request.
        # @!attribute [rw] stream
        #   @return [::String]
        #     Stream name.
        # @!attribute [rw] event
        #   @return [::String]
        #     Evevt name.
        # @!attribute [rw] series
        #   @return [::String]
        #     Series name.
        # @!attribute [rw] lease_id
        #   @return [::String]
        #     Lease id.
        # @!attribute [rw] owner
        #   @return [::String]
        #     Owner name.
        # @!attribute [rw] lease_term
        #   @return [::Google::Protobuf::Duration]
        #     Lease term specifies how long the client wants the session to be maintained
        #     by the server after the client leaves. If the lease term is not set, the
        #     server will release the session immediately and the client cannot reconnect
        #     to the same session later.
        class RequestMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for sending packets.
        # @!attribute [rw] packet
        #   @return [::Google::Cloud::VisionAI::V1::Packet]
        #     Packets sent over the streaming rpc.
        #
        #     Note: The following fields are mutually exclusive: `packet`, `metadata`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::VisionAI::V1::RequestMetadata]
        #     The first message of the streaming rpc including the request metadata.
        #
        #     Note: The following fields are mutually exclusive: `metadata`, `packet`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SendPacketsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for sending packets.
        class SendPacketsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for receiving packets.
        # @!attribute [rw] setup_request
        #   @return [::Google::Cloud::VisionAI::V1::ReceivePacketsRequest::SetupRequest]
        #     The request to setup the initial state of session.
        #
        #     The client must send and only send this as the first message.
        #
        #     Note: The following fields are mutually exclusive: `setup_request`, `commit_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] commit_request
        #   @return [::Google::Cloud::VisionAI::V1::CommitRequest]
        #     This request checkpoints the consumer's read progress.
        #
        #     Note: The following fields are mutually exclusive: `commit_request`, `setup_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceivePacketsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The message specifying the initial settings for the ReceivePackets session.
          # @!attribute [rw] eager_receive_mode
          #   @return [::Google::Cloud::VisionAI::V1::EagerMode]
          #     Options for configuring eager mode.
          #
          #     Note: The following fields are mutually exclusive: `eager_receive_mode`, `controlled_receive_mode`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] controlled_receive_mode
          #   @return [::Google::Cloud::VisionAI::V1::ControlledMode]
          #     Options for configuring controlled mode.
          #
          #     Note: The following fields are mutually exclusive: `controlled_receive_mode`, `eager_receive_mode`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] metadata
          #   @return [::Google::Cloud::VisionAI::V1::RequestMetadata]
          #     The configurations that specify where packets are retrieved.
          # @!attribute [rw] receiver
          #   @return [::String]
          #     A name for the receiver to self-identify.
          #
          #     This is used to keep track of a receiver's read progress.
          # @!attribute [rw] heartbeat_interval
          #   @return [::Google::Protobuf::Duration]
          #     The maximum duration of server silence before the client determines the
          #     server unreachable.
          #
          #     The client must either receive a `Packet` or a heart beat message before
          #     this duration expires; otherwise, the client will automatically cancel
          #     the current connection and retry.
          # @!attribute [rw] writes_done_grace_period
          #   @return [::Google::Protobuf::Duration]
          #     The grace period after which a `writes_done_request` is issued, that a
          #     `WritesDone` is expected from the client.
          #
          #     The server is free to cancel the RPC should this expire.
          #
          #     A system default will be chosen if unset.
          class SetupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Control message for a ReceivePacketsResponse.
        # @!attribute [rw] heartbeat
        #   @return [::Boolean]
        #     A server heartbeat.
        #
        #     Note: The following fields are mutually exclusive: `heartbeat`, `writes_done_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] writes_done_request
        #   @return [::Boolean]
        #     A request to the receiver to complete any final writes followed by a
        #     `WritesDone`; e.g. issue any final `CommitRequest`s.
        #
        #     May be ignored if `WritesDone` has already been issued at any point
        #     prior to receiving this message.
        #
        #     If `WritesDone` does not get issued, then the server will forcefully
        #     cancel the connection, and the receiver will likely receive an
        #     uninformative after `Read` returns `false` and `Finish` is called.
        #
        #     Note: The following fields are mutually exclusive: `writes_done_request`, `heartbeat`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceivePacketsControlResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message from ReceivePackets.
        # @!attribute [rw] packet
        #   @return [::Google::Cloud::VisionAI::V1::Packet]
        #     A genuine data payload originating from the sender.
        #
        #     Note: The following fields are mutually exclusive: `packet`, `control`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] control
        #   @return [::Google::Cloud::VisionAI::V1::ReceivePacketsControlResponse]
        #     A control message from the server.
        #
        #     Note: The following fields are mutually exclusive: `control`, `packet`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ReceivePacketsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The options for receiver under the eager mode.
        class EagerMode
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The options for receiver under the controlled mode.
        # @!attribute [rw] starting_logical_offset
        #   @return [::String]
        #     This can be set to the following logical starting points:
        #
        #     "begin": This will read from the earliest available message.
        #
        #     "most-recent": This will read from the latest available message.
        #
        #     "end": This will read only future messages.
        #
        #     "stored": This will resume reads one past the last committed offset.
        #               It is the only option that resumes progress; all others
        #               jump unilaterally.
        # @!attribute [rw] fallback_starting_offset
        #   @return [::String]
        #     This is the logical starting point to fallback upon should the
        #     specified starting offset be unavailable.
        #
        #     This can be one of the following values:
        #
        #     "begin": This will read from the earliest available message.
        #
        #     "end": This will read only future messages.
        class ControlledMode
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message for explicitly committing the read progress.
        #
        # This may only be used when `ReceivePacketsControlledMode` is set in the
        # initial setup request.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     The offset to commit.
        class CommitRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The lease type.
        module LeaseType
          # Lease type unspecified.
          LEASE_TYPE_UNSPECIFIED = 0

          # Lease for stream reader.
          LEASE_TYPE_READER = 1

          # Lease for stream writer.
          LEASE_TYPE_WRITER = 2
        end
      end
    end
  end
end
