# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # The descriptor for a gstreamer buffer payload.
        # @!attribute [rw] caps_string
        #   @return [::String]
        #     The caps string of the payload.
        # @!attribute [rw] is_key_frame
        #   @return [::Boolean]
        #     Whether the buffer is a key frame.
        # @!attribute [rw] pts_time
        #   @return [::Google::Protobuf::Timestamp]
        #     PTS of the frame.
        # @!attribute [rw] dts_time
        #   @return [::Google::Protobuf::Timestamp]
        #     DTS of the frame.
        # @!attribute [rw] duration
        #   @return [::Google::Protobuf::Duration]
        #     Duration of the frame.
        class GstreamerBufferDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The descriptor for a raw image.
        # @!attribute [rw] format
        #   @return [::String]
        #     Raw image format. Its possible values are: "srgb".
        # @!attribute [rw] height
        #   @return [::Integer]
        #     The height of the image.
        # @!attribute [rw] width
        #   @return [::Integer]
        #     The width of the image.
        class RawImageDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message that represents the data type of a packet.
        # @!attribute [rw] type_class
        #   @return [::String]
        #     The type class of the packet. Its possible values are:
        #     "gst", "protobuf", and "string".
        # @!attribute [rw] type_descriptor
        #   @return [::Google::Cloud::VisionAI::V1::PacketType::TypeDescriptor]
        #     The type descriptor.
        class PacketType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The message that fully specifies the type of the packet.
          # @!attribute [rw] gstreamer_buffer_descriptor
          #   @return [::Google::Cloud::VisionAI::V1::GstreamerBufferDescriptor]
          #     GstreamerBufferDescriptor is the descriptor for gstreamer buffer type.
          #
          #     Note: The following fields are mutually exclusive: `gstreamer_buffer_descriptor`, `raw_image_descriptor`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] raw_image_descriptor
          #   @return [::Google::Cloud::VisionAI::V1::RawImageDescriptor]
          #     RawImageDescriptor is the descriptor for the raw image type.
          #
          #     Note: The following fields are mutually exclusive: `raw_image_descriptor`, `gstreamer_buffer_descriptor`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] type
          #   @return [::String]
          #     The type of the packet. Its possible values is codec dependent.
          #
          #     The fully qualified type name is always the concatenation of the
          #     value in `type_class` together with the value in `type`, separated by a
          #     '/'.
          #
          #     Note that specific codecs can define their own type hierarchy, and so the
          #     type string here can in fact be separated by multiple '/'s of its own.
          #
          #     Please see the open source SDK for specific codec documentation.
          class TypeDescriptor
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The message that represents server metadata.
        # @!attribute [rw] offset
        #   @return [::Integer]
        #     The offset position for the packet in its stream.
        # @!attribute [rw] ingest_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp at which the stream server receives this packet. This is
        #     based on the local clock of on the server side. It is guaranteed to be
        #     monotonically increasing for the packets within each session; however
        #     this timestamp is not comparable across packets sent to the same stream
        #     different sessions. Session here refers to one individual gRPC streaming
        #     request to the stream server.
        class ServerMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message that represents series metadata.
        # @!attribute [rw] series
        #   @return [::String]
        #     Series name. It's in the format of
        #     "projects/\\{project}/locations/\\{location}/clusters/\\{cluster}/series/\\{stream}".
        class SeriesMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message that represents packet header.
        # @!attribute [rw] capture_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Input only. The capture time of the packet.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::PacketType]
        #     Input only. Immutable. The type of the payload.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Struct]
        #     Input only. This field is for users to attach user managed metadata.
        # @!attribute [r] server_metadata
        #   @return [::Google::Cloud::VisionAI::V1::ServerMetadata]
        #     Output only. Metadata that the server appends to each packet before sending
        #     it to receivers. You don't need to set a value for this field when sending
        #     packets.
        # @!attribute [rw] series_metadata
        #   @return [::Google::Cloud::VisionAI::V1::SeriesMetadata]
        #     Input only. Immutable. Metadata that the server needs to know where to
        #     write the packets to. It's only required for the first packet.
        # @!attribute [rw] flags
        #   @return [::Integer]
        #     Immutable. Packet flag set. SDK will set the flag automatically.
        # @!attribute [rw] trace_context
        #   @return [::String]
        #     Immutable. Header string for tracing across services. It should be set when
        #     the packet is first arrived in the stream server.
        #
        #     The input format is a lowercase hex string:
        #       - version_id: 1 byte, currently must be zero - hex encoded (2 characters)
        #       - trace_id: 16 bytes (opaque blob) - hex encoded (32 characters)
        #       - span_id: 8 bytes (opaque blob) - hex encoded (16 characters)
        #       - trace_options: 1 byte (LSB means tracing enabled) - hex encoded (2
        #       characters)
        #     Example: "00-404142434445464748494a4b4c4d4e4f-6162636465666768-01"
        #               v  trace_id                         span_id          options
        class PacketHeader
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The quanta of datum that the series accepts.
        # @!attribute [rw] header
        #   @return [::Google::Cloud::VisionAI::V1::PacketHeader]
        #     The packet header.
        # @!attribute [rw] payload
        #   @return [::String]
        #     The payload of the packet.
        class Packet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
