# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Message for DeleteApplicationInstance Response.
        class DeleteApplicationInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for CreateApplicationInstance Response.
        class CreateApplicationInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for UpdateApplicationInstances Response.
        class UpdateApplicationInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for adding stream input to an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] application_instances
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ApplicationInstance>]
        #     Required. The resources being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateApplicationInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for removing stream input from an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] instance_ids
        #   @return [::Array<::String>]
        #     Required. Id of the requesting object.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteApplicationInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RPC Request Messages.
        # Message for DeployApplication Response.
        class DeployApplicationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for UndeployApplication Response.
        class UndeployApplicationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for RemoveApplicationStreamInput Response.
        class RemoveApplicationStreamInputResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for AddApplicationStreamInput Response.
        class AddApplicationStreamInputResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for AddApplicationStreamInput Response.
        class UpdateApplicationStreamInputResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Applications.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListApplicationsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListApplicationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Applications.
        # @!attribute [rw] applications
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Application>]
        #     The list of Application.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListApplicationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Application.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] application_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] application
        #   @return [::Google::Cloud::VisionAI::V1::Application]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating an Application.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Application resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] application
        #   @return [::Google::Cloud::VisionAI::V1::Application]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any instances and drafts from this application
        #     will also be deleted. (Otherwise, the request will only work if the
        #     application has no instances and drafts.)
        class DeleteApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deploying an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the application graph, but do not
        #     actually deploy it.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] enable_monitoring
        #   @return [::Boolean]
        #     Optional. Whether or not to enable monitoring for the application on
        #     deployment.
        class DeployApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for undeploying an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UndeployApplicationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message about a single stream input config.
        # @!attribute [rw] stream_with_annotation
        #   @return [::Google::Cloud::VisionAI::V1::StreamWithAnnotation]
        class ApplicationStreamInput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for adding stream input to an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] application_stream_inputs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ApplicationStreamInput>]
        #     The stream inputs to add, the stream resource name is the key of each
        #     StreamInput, and it must be unique within each application.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class AddApplicationStreamInputRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating stream input to an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] application_stream_inputs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ApplicationStreamInput>]
        #     The stream inputs to update, the stream resource name is the key of each
        #     StreamInput, and it must be unique within each application.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If true, UpdateApplicationStreamInput will insert stream input to
        #     application even if the target stream is not included in the application.
        class UpdateApplicationStreamInputRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for removing stream input from an Application.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] target_stream_inputs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::RemoveApplicationStreamInputRequest::TargetStreamInput>]
        #     The target stream to remove.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class RemoveApplicationStreamInputRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message about target streamInput to remove.
          # @!attribute [rw] stream
          #   @return [::String]
          class TargetStreamInput
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for requesting list of Instances.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListInstancesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Instances.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Instance>]
        #     The list of Instance.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Drafts.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListDraftsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListDraftsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Drafts.
        # @!attribute [rw] drafts
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Draft>]
        #     The list of Draft.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDraftsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Draft.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetDraftRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Draft.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] draft_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] draft
        #   @return [::Google::Cloud::VisionAI::V1::Draft]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDraftRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Draft.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Draft resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] draft
        #   @return [::Google::Cloud::VisionAI::V1::Draft]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If true, UpdateDraftRequest will create one resource if the target resource
        #     doesn't exist, this time, the field_mask will be ignored.
        class UpdateDraftRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating an ApplicationInstance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. the name of the application to retrieve.
        #     Format:
        #     "projects/\\{project}/locations/\\{location}/applications/\\{application}"
        # @!attribute [rw] application_instances
        #   @return [::Array<::Google::Cloud::VisionAI::V1::UpdateApplicationInstancesRequest::UpdateApplicationInstance>]
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If true, Update Request will create one resource if the target resource
        #     doesn't exist, this time, the field_mask will be ignored.
        class UpdateApplicationInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. Field mask is used to specify the fields to be overwritten in
          #     the Draft resource by the update. The fields specified in the update_mask
          #     are relative to the resource, not the full request. A field will be
          #     overwritten if it is in the mask. If the user does not provide a mask
          #     then all fields will be overwritten.
          # @!attribute [rw] instance
          #   @return [::Google::Cloud::VisionAI::V1::Instance]
          #     Required. The resource being updated.
          # @!attribute [rw] instance_id
          #   @return [::String]
          #     Required. The id of the instance.
          class UpdateApplicationInstance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for deleting a Draft.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteDraftRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Processors.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListProcessorsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListProcessorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Processors.
        # @!attribute [rw] processors
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Processor>]
        #     The list of Processor.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListProcessorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request Message for listing Prebuilt Processors.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent path.
        class ListPrebuiltProcessorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response Message for listing Prebuilt Processors.
        # @!attribute [rw] processors
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Processor>]
        #     The list of Processor.
        class ListPrebuiltProcessorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Processor.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Processor.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] processor_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] processor
        #   @return [::Google::Cloud::VisionAI::V1::Processor]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Processor.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Processor resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] processor
        #   @return [::Google::Cloud::VisionAI::V1::Processor]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Processor.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Application object
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. A user friendly display name for the solution.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description for this application.
        # @!attribute [rw] application_configs
        #   @return [::Google::Cloud::VisionAI::V1::ApplicationConfigs]
        #     Application graph configuration.
        # @!attribute [r] runtime_info
        #   @return [::Google::Cloud::VisionAI::V1::Application::ApplicationRuntimeInfo]
        #     Output only. Application graph runtime info. Only exists when application
        #     state equals to DEPLOYED.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VisionAI::V1::Application::State]
        #     Output only. State of the application.
        # @!attribute [rw] billing_mode
        #   @return [::Google::Cloud::VisionAI::V1::Application::BillingMode]
        #     Billing mode of the application.
        class Application
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message storing the runtime information of the application.
          # @!attribute [rw] deploy_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Timestamp when the engine be deployed
          # @!attribute [rw] global_output_resources
          #   @return [::Array<::Google::Cloud::VisionAI::V1::Application::ApplicationRuntimeInfo::GlobalOutputResource>]
          #     Globally created resources like warehouse dataschemas.
          # @!attribute [rw] monitoring_config
          #   @return [::Google::Cloud::VisionAI::V1::Application::ApplicationRuntimeInfo::MonitoringConfig]
          #     Monitoring-related configuration for this application.
          class ApplicationRuntimeInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Message about output resources from application.
            # @!attribute [rw] output_resource
            #   @return [::String]
            #     The full resource name of the outputted resources.
            # @!attribute [rw] producer_node
            #   @return [::String]
            #     The name of graph node who produces the output resource name.
            #     For example:
            #     output_resource:
            #     /projects/123/locations/us-central1/corpora/my-corpus/dataSchemas/my-schema
            #     producer_node: occupancy-count
            # @!attribute [rw] key
            #   @return [::String]
            #     The key of the output resource, it has to be unique within the same
            #     producer node. One producer node can output several output resources,
            #     the key can be used to match corresponding output resources.
            class GlobalOutputResource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Monitoring-related configuration for an application.
            # @!attribute [rw] enabled
            #   @return [::Boolean]
            #     Whether this application has monitoring enabled.
            class MonitoringConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the Application
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # State CREATED.
            CREATED = 1

            # State DEPLOYING.
            DEPLOYING = 2

            # State DEPLOYED.
            DEPLOYED = 3

            # State UNDEPLOYING.
            UNDEPLOYING = 4

            # State DELETED.
            DELETED = 5

            # State ERROR.
            ERROR = 6

            # State CREATING.
            CREATING = 7

            # State Updating.
            UPDATING = 8

            # State Deleting.
            DELETING = 9

            # State Fixing.
            FIXING = 10
          end

          # Billing mode of the Application
          module BillingMode
            # The default value.
            BILLING_MODE_UNSPECIFIED = 0

            # Pay as you go billing mode.
            PAYG = 1

            # Monthly billing mode.
            MONTHLY = 2
          end
        end

        # Message storing the graph of the application.
        # @!attribute [rw] nodes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Node>]
        #     A list of nodes  in the application graph.
        # @!attribute [rw] event_delivery_config
        #   @return [::Google::Cloud::VisionAI::V1::ApplicationConfigs::EventDeliveryConfig]
        #     Event-related configuration for this application.
        class ApplicationConfigs
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # message storing the config for event delivery
          # @!attribute [rw] channel
          #   @return [::String]
          #     The delivery channel for the event notification, only pub/sub topic is
          #     supported now.
          #     Example channel:
          #     [//pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic]
          # @!attribute [rw] minimal_delivery_interval
          #   @return [::Google::Protobuf::Duration]
          #     The expected delivery interval for the same event. The same event won't
          #     be notified multiple times during this internal event that it is
          #     happening multiple times during the period of time.The same event is
          #     identified by <event_id, app_platform_metadata>.
          class EventDeliveryConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing node object.
        # @!attribute [rw] output_all_output_channels_to_stream
        #   @return [::Boolean]
        #     By default, the output of the node will only be available to downstream
        #     nodes. To consume the direct output from the application node, the output
        #     must be sent to Vision AI Streams at first.
        #
        #     By setting output_all_output_channels_to_stream to true, App Platform
        #     will automatically send all the outputs of the current node to Vision AI
        #     Stream resources (one stream per output channel). The output stream
        #     resource will be created by App Platform automatically during deployment
        #     and deleted after application un-deployment.
        #     Note that this config applies to all the Application Instances.
        #
        #     The output stream can be override at instance level by
        #     configuring the `output_resources` section of Instance resource.
        #     `producer_node` should be current node, `output_resource_binding` should
        #     be the output channel name (or leave it blank if there is only 1 output
        #     channel of the processor) and `output_resource` should be the target
        #     output stream.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A unique name for the node.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A user friendly display name for the node.
        # @!attribute [rw] node_config
        #   @return [::Google::Cloud::VisionAI::V1::ProcessorConfig]
        #     Node config.
        # @!attribute [rw] processor
        #   @return [::String]
        #     Processor name refer to the chosen processor resource.
        # @!attribute [rw] parents
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Node::InputEdge>]
        #     Parent node. Input node should not have parent node. For V1 Alpha1/Beta
        #     only media warehouse node can have multiple parents, other types of nodes
        #     will only have one parent.
        class Node
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describing one edge pointing into a node.
          # @!attribute [rw] parent_node
          #   @return [::String]
          #     The name of the parent node.
          # @!attribute [rw] parent_output_channel
          #   @return [::String]
          #     The connected output artifact of the parent node.
          #     It can be omitted if target processor only has 1 output artifact.
          # @!attribute [rw] connected_input_channel
          #   @return [::String]
          #     The connected input channel of the current node's processor.
          #     It can be omitted if target processor only has 1 input channel.
          class InputEdge
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing Draft object
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. A user friendly display name for the solution.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description for this application.
        # @!attribute [rw] draft_application_configs
        #   @return [::Google::Cloud::VisionAI::V1::ApplicationConfigs]
        #     The draft application configs which haven't been updated to an application.
        class Draft
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing Instance object
        # Next ID: 12
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. name of resource
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. A user friendly display name for the solution.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description for this instance.
        # @!attribute [rw] instance_type
        #   @return [::Google::Cloud::VisionAI::V1::Instance::InstanceType]
        #     The instance type for the current instance.
        # @!attribute [rw] input_resources
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Instance::InputResource>]
        #     The input resources for the current application instance.
        #     For example:
        #     input_resources:
        #     visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/stream-a
        # @!attribute [rw] output_resources
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Instance::OutputResource>]
        #     All the output resources associated to one application instance.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::VisionAI::V1::Instance::State]
        #     State of the instance.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message of input resource used in one application instance.
          # @!attribute [rw] input_resource
          #   @return [::String]
          #     The direct input resource name.
          #     If the instance type is STREAMING_PREDICTION, the input resource is in
          #     format of
          #     "projects/123/locations/us-central1/clusters/456/streams/stream-a".
          #     If the instance type is BATCH_PREDICTION from Cloud Storage input
          #     container, the input resource is in format of "gs://bucket-a".
          #
          #     Note: The following fields are mutually exclusive: `input_resource`, `annotated_stream`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] annotated_stream
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::VisionAI::V1::StreamWithAnnotation]
          #     If the input resource is VisionAI Stream, the associated annotations
          #     can be specified using annotated_stream instead.
          #
          #     Note: The following fields are mutually exclusive: `annotated_stream`, `input_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::VisionAI::V1::DataType]
          #     Data type for the current input resource.
          # @!attribute [rw] consumer_node
          #   @return [::String]
          #     The name of graph node who receives the input resource.
          #     For example:
          #     input_resource:
          #     visionai.googleapis.com/v1/projects/123/locations/us-central1/clusters/456/streams/input-stream-a
          #     consumer_node: stream-input
          # @!attribute [rw] input_resource_binding
          #   @return [::String]
          #     The specific input resource binding which will consume the current Input
          #     Resource, can be ignored is there is only 1 input binding.
          # @!attribute [rw] annotations
          #   @return [::Google::Cloud::VisionAI::V1::ResourceAnnotations]
          #     Contains resource annotations.
          class InputResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message of output resource used in one application instance.
          # @!attribute [rw] output_resource
          #   @return [::String]
          #     The output resource name for the current application instance.
          # @!attribute [rw] producer_node
          #   @return [::String]
          #     The name of graph node who produces the output resource name.
          #     For example:
          #     output_resource:
          #     /projects/123/locations/us-central1/clusters/456/streams/output-application-789-stream-a-occupancy-counting
          #     producer_node: occupancy-counting
          # @!attribute [rw] output_resource_binding
          #   @return [::String]
          #     The specific output resource binding which produces the current
          #     OutputResource.
          # @!attribute [r] is_temporary
          #   @return [::Boolean]
          #     Output only. Whether the output resource is temporary which means the
          #     resource is generated during the deployment of the application. Temporary
          #     resource will be deleted during the undeployment of the application.
          # @!attribute [r] autogen
          #   @return [::Boolean]
          #     Output only. Whether the output resource is created automatically by the
          #     Vision AI App Platform.
          class OutputResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # All the supported instance types.
          module InstanceType
            # Unspecified instance type.
            # If the instance type is not specified, the default one is
            # STREAMING_PREDICTION.
            INSTANCE_TYPE_UNSPECIFIED = 0

            # Instance type for streaming prediction.
            STREAMING_PREDICTION = 1

            # Instance type for batch prediction.
            BATCH_PREDICTION = 2

            # Instance type for online prediction.
            ONLINE_PREDICTION = 3
          end

          # State of the Instance
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # State CREATING.
            CREATING = 1

            # State CREATED.
            CREATED = 2

            # State DEPLOYING.
            DEPLOYING = 3

            # State DEPLOYED.
            DEPLOYED = 4

            # State UNDEPLOYING.
            UNDEPLOYING = 5

            # State DELETED.
            DELETED = 6

            # State ERROR.
            ERROR = 7

            # State Updating
            UPDATING = 8

            # State Deleting.
            DELETING = 9

            # State Fixing.
            FIXING = 10

            # State Finished.
            FINISHED = 11
          end
        end

        # Message for creating a Instance.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::VisionAI::V1::Instance]
        #     Required. The resource being created.
        class ApplicationInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Processor object.
        # Next ID: 19
        # @!attribute [rw] name
        #   @return [::String]
        #     name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. [Output only] Update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. A user friendly display name for the processor.
        # @!attribute [rw] description
        #   @return [::String]
        #     Illustrative sentences for describing the functionality of the processor.
        # @!attribute [r] processor_type
        #   @return [::Google::Cloud::VisionAI::V1::Processor::ProcessorType]
        #     Output only. Processor Type.
        # @!attribute [rw] model_type
        #   @return [::Google::Cloud::VisionAI::V1::ModelType]
        #     Model Type.
        # @!attribute [rw] custom_processor_source_info
        #   @return [::Google::Cloud::VisionAI::V1::CustomProcessorSourceInfo]
        #     Source info for customer created processor.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VisionAI::V1::Processor::ProcessorState]
        #     Output only. State of the Processor.
        # @!attribute [r] processor_io_spec
        #   @return [::Google::Cloud::VisionAI::V1::ProcessorIOSpec]
        #     Output only. [Output only] The input / output specifications of a
        #     processor, each type of processor has fixed input / output specs which
        #     cannot be altered by customer.
        # @!attribute [r] configuration_typeurl
        #   @return [::String]
        #     Output only. The corresponding configuration can be used in the Application
        #     to customize the behavior of the processor.
        # @!attribute [r] supported_annotation_types
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotationType>]
        # @!attribute [rw] supports_post_processing
        #   @return [::Boolean]
        #     Indicates if the processor supports post processing.
        # @!attribute [rw] supported_instance_types
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Instance::InstanceType>]
        #     Which instance types this processor supports; if empty, this default to
        #     STREAMING_PREDICTION.
        class Processor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Type
          module ProcessorType
            # Processor Type UNSPECIFIED.
            PROCESSOR_TYPE_UNSPECIFIED = 0

            # Processor Type PRETRAINED.
            # Pretrained processor is developed by Vision AI App Platform with
            # state-of-the-art vision data processing functionality, like occupancy
            # counting or person blur. Pretrained processor is usually publicly
            # available.
            PRETRAINED = 1

            # Processor Type CUSTOM.
            # Custom processors are specialized processors which are either uploaded by
            # customers or imported from other GCP platform (for example Vertex AI).
            # Custom processor is only visible to the creator.
            CUSTOM = 2

            # Processor Type CONNECTOR.
            # Connector processors are special processors which perform I/O for the
            # application, they do not processing the data but either deliver the data
            # to other processors or receive data from other processors.
            CONNECTOR = 3
          end

          module ProcessorState
            # Unspecified Processor state.
            PROCESSOR_STATE_UNSPECIFIED = 0

            # Processor is being created (not ready for use).
            CREATING = 1

            # Processor is and ready for use.
            ACTIVE = 2

            # Processor is being deleted (not ready for use).
            DELETING = 3

            # Processor deleted or creation failed .
            FAILED = 4
          end
        end

        # Message describing the input / output specifications of a processor.
        # @!attribute [rw] graph_input_channel_specs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ProcessorIOSpec::GraphInputChannelSpec>]
        #     For processors with input_channel_specs, the processor must be explicitly
        #     connected to another processor.
        # @!attribute [rw] graph_output_channel_specs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ProcessorIOSpec::GraphOutputChannelSpec>]
        #     The output artifact specifications for the current processor.
        # @!attribute [rw] instance_resource_input_binding_specs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ProcessorIOSpec::InstanceResourceInputBindingSpec>]
        #     The input resource that needs to be fed from the application instance.
        # @!attribute [rw] instance_resource_output_binding_specs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ProcessorIOSpec::InstanceResourceOutputBindingSpec>]
        #     The output resource that the processor will generate per instance.
        #     Other than the explicitly listed output bindings here, all the processors'
        #     GraphOutputChannels can be binded to stream resource. The bind name then is
        #     the same as the GraphOutputChannel's name.
        class ProcessorIOSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message for input channel specification.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the current input channel.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::VisionAI::V1::DataType]
          #     The data types of the current input channel.
          #     When this field has more than 1 value, it means this input channel can be
          #     connected to either of these different data types.
          # @!attribute [rw] accepted_data_type_uris
          #   @return [::Array<::String>]
          #     If specified, only those detailed data types can be connected to the
          #     processor. For example, jpeg stream for MEDIA, or PredictionResult proto
          #     for PROTO type. If unspecified, then any proto is accepted.
          # @!attribute [rw] required
          #   @return [::Boolean]
          #     Whether the current input channel is required by the processor.
          #     For example, for a processor with required video input and optional audio
          #     input, if video input is missing, the application will be rejected while
          #     the audio input can be missing as long as the video input exists.
          # @!attribute [rw] max_connection_allowed
          #   @return [::Integer]
          #     How many input edges can be connected to this input channel. 0 means
          #     unlimited.
          class GraphInputChannelSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for output channel specification.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the current output channel.
          # @!attribute [rw] data_type
          #   @return [::Google::Cloud::VisionAI::V1::DataType]
          #     The data type of the current output channel.
          # @!attribute [rw] data_type_uri
          #   @return [::String]
          class GraphOutputChannelSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for instance resource channel specification.
          # External resources are virtual nodes which are not expressed in the
          # application graph. Each processor expresses its out-graph spec, so customer
          # is able to override the external source or destinations to the
          # @!attribute [rw] config_type_uri
          #   @return [::String]
          #     The configuration proto that includes the Googleapis resources. I.e.
          #     type.googleapis.com/google.cloud.vision.v1.StreamWithAnnotation
          #
          #     Note: The following fields are mutually exclusive: `config_type_uri`, `resource_type_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] resource_type_uri
          #   @return [::String]
          #     The direct type url of Googleapis resource. i.e.
          #     type.googleapis.com/google.cloud.vision.v1.Asset
          #
          #     Note: The following fields are mutually exclusive: `resource_type_uri`, `config_type_uri`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the input binding, unique within the processor.
          class InstanceResourceInputBindingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the output binding, unique within the processor.
          # @!attribute [rw] resource_type_uri
          #   @return [::String]
          #     The resource type uri of the acceptable output resource.
          # @!attribute [rw] explicit
          #   @return [::Boolean]
          #     Whether the output resource needs to be explicitly set in the instance.
          #     If it is false, the processor will automatically generate it if required.
          class InstanceResourceOutputBindingSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes the source info for a custom processor.
        # @!attribute [rw] vertex_model
        #   @return [::String]
        #     The resource name original model hosted in the vertex AI platform.
        #
        #     Note: The following fields are mutually exclusive: `vertex_model`, `product_recognizer_artifact`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_recognizer_artifact
        #   @return [::Google::Cloud::VisionAI::V1::CustomProcessorSourceInfo::ProductRecognizerArtifact]
        #     Artifact for product recognizer.
        #
        #     Note: The following fields are mutually exclusive: `product_recognizer_artifact`, `vertex_model`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::VisionAI::V1::CustomProcessorSourceInfo::SourceType]
        #     The original product which holds the custom processor's functionality.
        # @!attribute [r] additional_info
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Additional info related to the imported custom processor.
        #     Data is filled in by app platform during the processor creation.
        # @!attribute [rw] model_schema
        #   @return [::Google::Cloud::VisionAI::V1::CustomProcessorSourceInfo::ModelSchema]
        #     Model schema files which specifies the signature of the model.
        #     For VERTEX_CUSTOM models, instances schema is required.
        #     If instances schema is not specified during the processor creation,
        #     VisionAI Platform will try to get it from Vertex, if it doesn't exist, the
        #     creation will fail.
        class CustomProcessorSourceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describes product recognizer artifact.
          # @!attribute [rw] retail_product_recognition_index
          #   @return [::String]
          #     Required. Resource name of RetailProductRecognitionIndex.
          #     Format is
          #     'projects/*/locations/*/retailCatalogs/*/retailProductRecognitionIndexes/*'
          # @!attribute [rw] vertex_model
          #   @return [::String]
          #     Optional. The resource name of embedding model hosted in Vertex AI
          #     Platform.
          class ProductRecognizerArtifact
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The schema is defined as an OpenAPI 3.0.2 [Schema
          # Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
          # @!attribute [rw] instances_schema
          #   @return [::Google::Cloud::VisionAI::V1::GcsSource]
          #     Cloud Storage location to a YAML file that defines the format of a single
          #     instance used in prediction and explanation requests.
          # @!attribute [rw] parameters_schema
          #   @return [::Google::Cloud::VisionAI::V1::GcsSource]
          #     Cloud Storage location to a YAML file that defines the prediction and
          #     explanation parameters.
          # @!attribute [rw] predictions_schema
          #   @return [::Google::Cloud::VisionAI::V1::GcsSource]
          #     Cloud Storage location to a YAML file that defines the format of a single
          #     prediction or explanation.
          class ModelSchema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AdditionalInfoEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Source type of the imported custom processor.
          module SourceType
            # Source type unspecified.
            SOURCE_TYPE_UNSPECIFIED = 0

            # Custom processors coming from Vertex AutoML product.
            VERTEX_AUTOML = 1

            # Custom processors coming from general custom models from Vertex.
            VERTEX_CUSTOM = 2

            # Source for Product Recognizer.
            PRODUCT_RECOGNIZER = 3
          end
        end

        # Next ID: 35
        # @!attribute [rw] video_stream_input_config
        #   @return [::Google::Cloud::VisionAI::V1::VideoStreamInputConfig]
        #     Configs of stream input processor.
        #
        #     Note: The following fields are mutually exclusive: `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ai_enabled_devices_input_config
        #   @return [::Google::Cloud::VisionAI::V1::AIEnabledDevicesInputConfig]
        #     Config of AI-enabled input devices.
        #
        #     Note: The following fields are mutually exclusive: `ai_enabled_devices_input_config`, `video_stream_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] media_warehouse_config
        #   @return [::Google::Cloud::VisionAI::V1::MediaWarehouseConfig]
        #     Configs of media warehouse processor.
        #
        #     Note: The following fields are mutually exclusive: `media_warehouse_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] person_blur_config
        #   @return [::Google::Cloud::VisionAI::V1::PersonBlurConfig]
        #     Configs of person blur processor.
        #
        #     Note: The following fields are mutually exclusive: `person_blur_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] occupancy_count_config
        #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountConfig]
        #     Configs of occupancy count processor.
        #
        #     Note: The following fields are mutually exclusive: `occupancy_count_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] person_vehicle_detection_config
        #   @return [::Google::Cloud::VisionAI::V1::PersonVehicleDetectionConfig]
        #     Configs of Person Vehicle Detection processor.
        #
        #     Note: The following fields are mutually exclusive: `person_vehicle_detection_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_automl_vision_config
        #   @return [::Google::Cloud::VisionAI::V1::VertexAutoMLVisionConfig]
        #     Configs of Vertex AutoML vision processor.
        #
        #     Note: The following fields are mutually exclusive: `vertex_automl_vision_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_automl_video_config
        #   @return [::Google::Cloud::VisionAI::V1::VertexAutoMLVideoConfig]
        #     Configs of Vertex AutoML video processor.
        #
        #     Note: The following fields are mutually exclusive: `vertex_automl_video_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_custom_config
        #   @return [::Google::Cloud::VisionAI::V1::VertexCustomConfig]
        #     Configs of Vertex Custom processor.
        #
        #     Note: The following fields are mutually exclusive: `vertex_custom_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] general_object_detection_config
        #   @return [::Google::Cloud::VisionAI::V1::GeneralObjectDetectionConfig]
        #     Configs of General Object Detection processor.
        #
        #     Note: The following fields are mutually exclusive: `general_object_detection_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] big_query_config
        #   @return [::Google::Cloud::VisionAI::V1::BigQueryConfig]
        #     Configs of BigQuery processor.
        #
        #     Note: The following fields are mutually exclusive: `big_query_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_output_config
        #   @return [::Google::Cloud::VisionAI::V1::GcsOutputConfig]
        #     Configs of Cloud Storage output processor.
        #
        #     Note: The following fields are mutually exclusive: `gcs_output_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_recognizer_config
        #   @return [::Google::Cloud::VisionAI::V1::ProductRecognizerConfig]
        #     Runtime configs of Product Recognizer processor.
        #
        #     Note: The following fields are mutually exclusive: `product_recognizer_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] personal_protective_equipment_detection_config
        #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionConfig]
        #     Configs of personal_protective_equipment_detection_config
        #
        #     Note: The following fields are mutually exclusive: `personal_protective_equipment_detection_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `tag_recognizer_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_recognizer_config
        #   @return [::Google::Cloud::VisionAI::V1::TagRecognizerConfig]
        #     Runtime configs of Tag Recognizer processor.
        #
        #     Note: The following fields are mutually exclusive: `tag_recognizer_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `universal_input_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] universal_input_config
        #   @return [::Google::Cloud::VisionAI::V1::UniversalInputConfig]
        #     Runtime configs of UniversalInput processor.
        #
        #     Note: The following fields are mutually exclusive: `universal_input_config`, `video_stream_input_config`, `ai_enabled_devices_input_config`, `media_warehouse_config`, `person_blur_config`, `occupancy_count_config`, `person_vehicle_detection_config`, `vertex_automl_vision_config`, `vertex_automl_video_config`, `vertex_custom_config`, `general_object_detection_config`, `big_query_config`, `gcs_output_config`, `product_recognizer_config`, `personal_protective_equipment_detection_config`, `tag_recognizer_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] experimental_config
        #   @return [::Google::Protobuf::Struct]
        #     Experimental configurations. Structured object containing not-yet-stable
        #     processor parameters.
        class ProcessorConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Vision AI stream with application specific annotations.
        # All the StreamAnnotation object inside this message MUST have unique id.
        # @!attribute [rw] stream
        #   @return [::String]
        #     Vision AI Stream resource name.
        # @!attribute [rw] application_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotation>]
        #     Annotations that will be applied to the whole application.
        # @!attribute [rw] node_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamWithAnnotation::NodeAnnotation>]
        #     Annotations that will be applied to the specific node of the application.
        #     If the same type of the annotations is applied to both application and
        #     node, the node annotation will be added in addition to the global
        #     application one.
        #     For example, if there is one active zone annotation for the whole
        #     application and one active zone annotation for the Occupancy Analytic
        #     processor, then the Occupancy Analytic processor will have two active zones
        #     defined.
        class StreamWithAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describing annotations specific to application node.
          # @!attribute [rw] node
          #   @return [::String]
          #     The node name of the application graph.
          # @!attribute [rw] annotations
          #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotation>]
          #     The node specific stream annotations.
          class NodeAnnotation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing annotations specific to application node.
        # This message is a duplication of StreamWithAnnotation.NodeAnnotation.
        # @!attribute [rw] node
        #   @return [::String]
        #     The node name of the application graph.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotation>]
        #     The node specific stream annotations.
        class ApplicationNodeAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing general annotation for resources.
        # @!attribute [rw] application_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotation>]
        #     Annotations that will be applied to the whole application.
        # @!attribute [rw] node_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ApplicationNodeAnnotation>]
        #     Annotations that will be applied to the specific node of the application.
        #     If the same type of the annotations is applied to both application and
        #     node, the node annotation will be added in addition to the global
        #     application one.
        #     For example, if there is one active zone annotation for the whole
        #     application and one active zone annotation for the Occupancy Analytic
        #     processor, then the Occupancy Analytic processor will have two active zones
        #     defined.
        class ResourceAnnotations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing Video Stream Input Config.
        # This message should only be used as a placeholder for builtin:stream-input
        # processor, actual stream binding should be specified using corresponding
        # API.
        # @!attribute [rw] streams
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::String>]
        # @!attribute [rw] streams_with_annotation
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamWithAnnotation>]
        class VideoStreamInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing AI-enabled Devices Input Config.
        class AIEnabledDevicesInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing MediaWarehouseConfig.
        # @!attribute [rw] corpus
        #   @return [::String]
        #     Resource name of the Media Warehouse corpus.
        #     Format:
        #     projects/$\\{project_id}/locations/$\\{location_id}/corpora/$\\{corpus_id}
        # @!attribute [rw] region
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Deprecated.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     The duration for which all media assets, associated metadata, and search
        #     documents can exist.
        class MediaWarehouseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing FaceBlurConfig.
        # @!attribute [rw] person_blur_type
        #   @return [::Google::Cloud::VisionAI::V1::PersonBlurConfig::PersonBlurType]
        #     Person blur type.
        # @!attribute [rw] faces_only
        #   @return [::Boolean]
        #     Whether only blur faces other than the whole object in the processor.
        class PersonBlurConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of Person Blur
          module PersonBlurType
            # PersonBlur Type UNSPECIFIED.
            PERSON_BLUR_TYPE_UNSPECIFIED = 0

            # FaceBlur Type full occlusion.
            FULL_OCCULUSION = 1

            # FaceBlur Type blur filter.
            BLUR_FILTER = 2
          end
        end

        # Message describing OccupancyCountConfig.
        # @!attribute [rw] enable_people_counting
        #   @return [::Boolean]
        #     Whether to count the appearances of people, output counts have 'people' as
        #     the key.
        # @!attribute [rw] enable_vehicle_counting
        #   @return [::Boolean]
        #     Whether to count the appearances of vehicles, output counts will have
        #     'vehicle' as the key.
        # @!attribute [rw] enable_dwelling_time_tracking
        #   @return [::Boolean]
        #     Whether to track each invidual object's loitering time inside the scene or
        #     specific zone.
        class OccupancyCountConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing PersonVehicleDetectionConfig.
        # @!attribute [rw] enable_people_counting
        #   @return [::Boolean]
        #     At least one of enable_people_counting and enable_vehicle_counting fields
        #     must be set to true.
        #     Whether to count the appearances of people, output counts have 'people' as
        #     the key.
        # @!attribute [rw] enable_vehicle_counting
        #   @return [::Boolean]
        #     Whether to count the appearances of vehicles, output counts will have
        #     'vehicle' as the key.
        class PersonVehicleDetectionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing PersonalProtectiveEquipmentDetectionConfig.
        # @!attribute [rw] enable_face_coverage_detection
        #   @return [::Boolean]
        #     Whether to enable face coverage detection.
        # @!attribute [rw] enable_head_coverage_detection
        #   @return [::Boolean]
        #     Whether to enable head coverage detection.
        # @!attribute [rw] enable_hands_coverage_detection
        #   @return [::Boolean]
        #     Whether to enable hands coverage detection.
        class PersonalProtectiveEquipmentDetectionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message of configurations for General Object Detection processor.
        class GeneralObjectDetectionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message of configurations for BigQuery processor.
        # @!attribute [rw] table
        #   @return [::String]
        #     BigQuery table resource for Vision AI Platform to ingest annotations to.
        # @!attribute [rw] cloud_function_mapping
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Data Schema
        #     By default, Vision AI Application will try to write annotations to the
        #     target BigQuery table using the following schema:
        #
        #     ingestion_time: TIMESTAMP, the ingestion time of the original data.
        #
        #     application: STRING, name of the application which produces the annotation.
        #
        #     instance: STRING, Id of the instance which produces the annotation.
        #
        #     node: STRING, name of the application graph node which produces the
        #     annotation.
        #
        #     annotation: STRING or JSON, the actual annotation protobuf will be
        #     converted to json string with bytes field as 64 encoded string. It can be
        #     written to both String or Json type column.
        #
        #     To forward annotation data to an existing BigQuery table, customer needs to
        #     make sure the compatibility of the schema.
        #     The map maps application node name to its corresponding cloud function
        #     endpoint to transform the annotations directly to the
        #     google.cloud.bigquery.storage.v1.AppendRowsRequest (only avro_rows or
        #     proto_rows should be set). If configured, annotations produced by
        #     corresponding application node will sent to the Cloud Function at first
        #     before be forwarded to BigQuery.
        #
        #     If the default table schema doesn't fit, customer is able to transform the
        #     annotation output from Vision AI Application to arbitrary BigQuery table
        #     schema with CloudFunction.
        #     * The cloud function will receive AppPlatformCloudFunctionRequest where
        #     the annotations field will be the json format of Vision AI annotation.
        #     * The cloud function should return AppPlatformCloudFunctionResponse with
        #     AppendRowsRequest stored in the annotations field.
        #     * To drop the annotation, simply clear the annotations field in the
        #     returned AppPlatformCloudFunctionResponse.
        # @!attribute [rw] create_default_table_if_not_exists
        #   @return [::Boolean]
        #     If true, App Platform will create the BigQuery DataSet and the
        #     BigQuery Table with default schema if the specified table doesn't exist.
        #     This doesn't work if any cloud function customized schema is specified
        #     since the system doesn't know your desired schema.
        #     JSON column will be used in the default table created by App Platform.
        class BigQueryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class CloudFunctionMappingEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message of configurations of Vertex AutoML Vision Processors.
        # @!attribute [rw] confidence_threshold
        #   @return [::Float]
        #     Only entities with higher score than the threshold will be returned.
        #     Value 0.0 means to return all the detected entities.
        # @!attribute [rw] max_predictions
        #   @return [::Integer]
        #     At most this many predictions will be returned per output frame.
        #     Value 0 means to return all the detected entities.
        class VertexAutoMLVisionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing VertexAutoMLVideoConfig.
        # @!attribute [rw] confidence_threshold
        #   @return [::Float]
        #     Only entities with higher score than the threshold will be returned.
        #     Value 0.0 means returns all the detected entities.
        # @!attribute [rw] blocked_labels
        #   @return [::Array<::String>]
        #     Labels specified in this field won't be returned.
        # @!attribute [rw] max_predictions
        #   @return [::Integer]
        #     At most this many predictions will be returned per output frame.
        #     Value 0 means to return all the detected entities.
        # @!attribute [rw] bounding_box_size_limit
        #   @return [::Float]
        #     Only Bounding Box whose size is larger than this limit will be returned.
        #     Object Tracking only.
        #     Value 0.0 means to return all the detected entities.
        class VertexAutoMLVideoConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing VertexCustomConfig.
        # @!attribute [rw] max_prediction_fps
        #   @return [::Integer]
        #     The max prediction frame per second. This attribute sets how fast the
        #     operator sends prediction requests to Vertex AI endpoint. Default value is
        #     0, which means there is no max prediction fps limit. The operator sends
        #     prediction requests at input fps.
        # @!attribute [rw] dedicated_resources
        #   @return [::Google::Cloud::VisionAI::V1::DedicatedResources]
        #     A description of resources that are dedicated to the DeployedModel, and
        #     that need a higher degree of manual configuration.
        # @!attribute [rw] post_processing_cloud_function
        #   @return [::String]
        #     If not empty, the prediction result will be sent to the specified cloud
        #     function for post processing.
        #     * The cloud function will receive AppPlatformCloudFunctionRequest where
        #     the annotations field will be the json format of proto PredictResponse.
        #     * The cloud function should return AppPlatformCloudFunctionResponse with
        #     PredictResponse stored in the annotations field.
        #     * To drop the prediction output, simply clear the payload field in the
        #     returned AppPlatformCloudFunctionResponse.
        # @!attribute [rw] attach_application_metadata
        #   @return [::Boolean]
        #     If true, the prediction request received by custom model will also contain
        #     metadata with the following schema:
        #     'appPlatformMetadata': {
        #           'ingestionTime': DOUBLE; (UNIX timestamp)
        #           'application': STRING;
        #           'instanceId': STRING;
        #           'node': STRING;
        #           'processor': STRING;
        #      }
        # @!attribute [rw] dynamic_config_input_topic
        #   @return [::String]
        #     Optional. By setting the configuration_input_topic, processor will
        #     subscribe to given topic, only pub/sub topic is supported now. Example
        #     channel:
        #     //pubsub.googleapis.com/projects/visionai-testing-stable/topics/test-topic
        #     message schema should be:
        #     message Message {
        #     // The ID of the stream that associates with the application instance.
        #     string stream_id = 1;
        #     // The target fps. By default, the custom processor will *not* send any
        #     data to the Vertex Prediction container. Note that once the
        #     dynamic_config_input_topic is set, max_prediction_fps will not work and be
        #     preceded by the fps set inside the topic.
        #     int32 fps = 2;
        #     }
        class VertexCustomConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing GcsOutputConfig.
        # @!attribute [rw] gcs_path
        #   @return [::String]
        #     The Cloud Storage path for Vision AI Platform to ingest annotations to.
        class GcsOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing UniversalInputConfig.
        class UniversalInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification of a single machine.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Immutable. The type of the machine.
        #
        #     See the [list of machine types supported for
        #     prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types)
        #
        #     See the [list of machine types supported for custom
        #     training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types).
        #
        #     For [DeployedModel][] this field is optional, and the default
        #     value is `n1-standard-2`. For [BatchPredictionJob][] or as part of
        #     [WorkerPoolSpec][] this field is required.
        # @!attribute [rw] accelerator_type
        #   @return [::Google::Cloud::VisionAI::V1::AcceleratorType]
        #     Immutable. The type of accelerator(s) that may be attached to the machine
        #     as per
        #     {::Google::Cloud::VisionAI::V1::MachineSpec#accelerator_count accelerator_count}.
        # @!attribute [rw] accelerator_count
        #   @return [::Integer]
        #     The number of accelerators to attach to the machine.
        class MachineSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metric specification that defines the target resource utilization
        # (CPU utilization, accelerator's duty cycle, and so on) for calculating the
        # desired replica count.
        # @!attribute [rw] metric_name
        #   @return [::String]
        #     Required. The resource metric name.
        #     Supported metrics:
        #
        #     * For Online Prediction:
        #     * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
        #     * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        # @!attribute [rw] target
        #   @return [::Integer]
        #     The target resource utilization in percentage (1% - 100%) for the given
        #     metric; once the real usage deviates from the target by a certain
        #     percentage, the machine replicas change. The default value is 60
        #     (representing 60%) if not provided.
        class AutoscalingMetricSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A description of resources that are dedicated to a DeployedModel, and
        # that need a higher degree of manual configuration.
        # @!attribute [rw] machine_spec
        #   @return [::Google::Cloud::VisionAI::V1::MachineSpec]
        #     Required. Immutable. The specification of a single machine used by the
        #     prediction.
        # @!attribute [rw] min_replica_count
        #   @return [::Integer]
        #     Required. Immutable. The minimum number of machine replicas this
        #     DeployedModel will be always deployed on. This value must be greater than
        #     or equal to 1.
        #
        #     If traffic against the DeployedModel increases, it may dynamically be
        #     deployed onto more replicas, and as traffic decreases, some of these extra
        #     replicas may be freed.
        # @!attribute [rw] max_replica_count
        #   @return [::Integer]
        #     Immutable. The maximum number of replicas this DeployedModel may be
        #     deployed on when the traffic against it increases. If the requested value
        #     is too large, the deployment will error, but if deployment succeeds then
        #     the ability to scale the model to that many replicas is guaranteed (barring
        #     service outages). If traffic against the DeployedModel increases beyond
        #     what its replicas at maximum may handle, a portion of the traffic will be
        #     dropped. If this value is not provided, will use
        #     {::Google::Cloud::VisionAI::V1::DedicatedResources#min_replica_count min_replica_count}
        #     as the default value.
        #
        #     The value of this field impacts the charge against Vertex CPU and GPU
        #     quotas. Specifically, you will be charged for max_replica_count *
        #     number of cores in the selected machine type) and (max_replica_count *
        #     number of GPUs per replica in the selected machine type).
        # @!attribute [rw] autoscaling_metric_specs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AutoscalingMetricSpec>]
        #     Immutable. The metric specifications that overrides a resource
        #     utilization metric (CPU utilization, accelerator's duty cycle, and so on)
        #     target value (default to 60 if not set). At most one entry is allowed per
        #     metric.
        #
        #     If
        #     {::Google::Cloud::VisionAI::V1::MachineSpec#accelerator_count machine_spec.accelerator_count}
        #     is above 0, the autoscaling will be based on both CPU utilization and
        #     accelerator's duty cycle metrics and scale up when either metrics exceeds
        #     its target value while scale down if both metrics are under their target
        #     value. The default target value is 60 for both metrics.
        #
        #     If
        #     {::Google::Cloud::VisionAI::V1::MachineSpec#accelerator_count machine_spec.accelerator_count}
        #     is 0, the autoscaling will be based on CPU utilization metric only with
        #     default target value 60 if not explicitly set.
        #
        #     For example, in the case of Online Prediction, if you want to override
        #     target CPU utilization to 80, you should set
        #     {::Google::Cloud::VisionAI::V1::AutoscalingMetricSpec#metric_name autoscaling_metric_specs.metric_name}
        #     to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
        #     {::Google::Cloud::VisionAI::V1::AutoscalingMetricSpec#target autoscaling_metric_specs.target}
        #     to `80`.
        class DedicatedResources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing ProductRecognizerConfig.
        # @!attribute [rw] retail_endpoint
        #   @return [::String]
        #     The resource name of retail endpoint to use.
        # @!attribute [rw] recognition_confidence_threshold
        #   @return [::Float]
        #     Confidence threshold to filter detection results. If not set, a system
        #     default value will be used.
        class ProductRecognizerConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message describing TagRecognizerConfig.
        # @!attribute [rw] entity_detection_confidence_threshold
        #   @return [::Float]
        #     Confidence threshold to filter detection results. If not set, a system
        #     default value will be used.
        # @!attribute [rw] tag_parsing_config
        #   @return [::Google::Cloud::VisionAI::V1::TagParsingConfig]
        #     Configuration to customize how tags are parsed.
        class TagRecognizerConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for tag parsing.
        # @!attribute [rw] entity_parsing_configs
        #   @return [::Array<::Google::Cloud::VisionAI::V1::TagParsingConfig::EntityParsingConfig>]
        #     Each tag entity class may have an optional EntityParsingConfig which is
        #     used to help parse the entities of the class.
        class TagParsingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for parsing a tag entity class.
          # @!attribute [rw] entity_class
          #   @return [::String]
          #     Required. The tag entity class name. This should match the class name
          #     produced by the tag entity detection model.
          # @!attribute [rw] regex
          #   @return [::String]
          #     Optional. An regular expression hint.
          # @!attribute [rw] entity_matching_strategy
          #   @return [::Google::Cloud::VisionAI::V1::TagParsingConfig::EntityParsingConfig::EntityMatchingStrategy]
          #     Optional. Entity matching strategy.
          class EntityParsingConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Type of entity matching strategy.
            module EntityMatchingStrategy
              # If unspecified, multi-line matching will be used by default.
              ENTITY_MATCHING_STRATEGY_UNSPECIFIED = 0

              # Matches multiple lines of text.
              MULTI_LINE_MATCHING = 1

              # Matches the line with the maximum overlap area with entity bounding
              # box.
              MAX_OVERLAP_AREA = 2
            end
          end
        end

        # All the supported model types in Vision AI App Platform.
        module ModelType
          # Processor Type UNSPECIFIED.
          MODEL_TYPE_UNSPECIFIED = 0

          # Model Type Image Classification.
          IMAGE_CLASSIFICATION = 1

          # Model Type Object Detection.
          OBJECT_DETECTION = 2

          # Model Type Video Classification.
          VIDEO_CLASSIFICATION = 3

          # Model Type Object Tracking.
          VIDEO_OBJECT_TRACKING = 4

          # Model Type Action Recognition.
          VIDEO_ACTION_RECOGNITION = 5

          # Model Type Occupancy Counting.
          OCCUPANCY_COUNTING = 6

          # Model Type Person Blur.
          PERSON_BLUR = 7

          # Model Type Vertex Custom.
          VERTEX_CUSTOM = 8

          # Model Type Product Recognizer.
          PRODUCT_RECOGNIZER = 9

          # Model Type Tag Recognizer.
          TAG_RECOGNIZER = 10

          # Model Type SynthID.
          SYNTH_ID = 15
        end

        # Represents a hardware accelerator type.
        module AcceleratorType
          # Unspecified accelerator type, which means no accelerator.
          ACCELERATOR_TYPE_UNSPECIFIED = 0

          # Nvidia Tesla K80 GPU.
          NVIDIA_TESLA_K80 = 1

          # Nvidia Tesla P100 GPU.
          NVIDIA_TESLA_P100 = 2

          # Nvidia Tesla V100 GPU.
          NVIDIA_TESLA_V100 = 3

          # Nvidia Tesla P4 GPU.
          NVIDIA_TESLA_P4 = 4

          # Nvidia Tesla T4 GPU.
          NVIDIA_TESLA_T4 = 5

          # Nvidia Tesla A100 GPU.
          NVIDIA_TESLA_A100 = 8

          # TPU v2.
          TPU_V2 = 6

          # TPU v3.
          TPU_V3 = 7
        end

        # All supported data types.
        module DataType
          # The default value of DataType.
          DATA_TYPE_UNSPECIFIED = 0

          # Video data type like H264.
          VIDEO = 1

          # Image data type.
          IMAGE = 3

          # Protobuf data type, usually used for general data blob.
          PROTO = 2

          # A placeholder data type, applicable for the universal input processor which
          # supports any data type. This will be instantiated and replaced by a
          # concrete underlying `DataType` during instance deployment.
          PLACEHOLDER = 4
        end
      end
    end
  end
end
