# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Message for requesting list of Operators.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListOperatorsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListOperatorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Operators.
        # @!attribute [rw] operators
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Operator>]
        #     The list of Operator
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListOperatorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Operator.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetOperatorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Operator.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] operator_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] operator
        #   @return [::Google::Cloud::VisionAI::V1::Operator]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateOperatorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Operator.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Operator resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] operator
        #   @return [::Google::Cloud::VisionAI::V1::Operator]
        #     Required. The resource being updated
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateOperatorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Operator
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteOperatorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Analyses
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListAnalysesRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListAnalysesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Analyses
        # @!attribute [rw] analyses
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Analysis>]
        #     The list of Analysis
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAnalysesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting an Analysis.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating an Analysis.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] analysis_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::VisionAI::V1::Analysis]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating an Analysis.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Analysis resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] analysis
        #   @return [::Google::Cloud::VisionAI::V1::Analysis]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting an Analysis.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteAnalysisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for requesting list of Processes.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListProcessesRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListProcessesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for response to listing Processes.
        # @!attribute [rw] processes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Process>]
        #     The list of Processes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListProcessesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for getting a Process.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        class GetProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a Process.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] process_id
        #   @return [::String]
        #     Required. Id of the requesting object.
        # @!attribute [rw] process
        #   @return [::Google::Cloud::VisionAI::V1::Process]
        #     Required. The resource being created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for updating a Process.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Process resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] process
        #   @return [::Google::Cloud::VisionAI::V1::Process]
        #     Required. The resource being updated.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a Process.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for running the processes in a batch.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource shared by all processes being created.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::VisionAI::V1::CreateProcessRequest>]
        #     Required. The create process requests.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::VisionAI::V1::BatchRunProcessRequest::BatchRunProcessOptions]
        #     Optional. Options for batch processes.
        # @!attribute [r] batch_id
        #   @return [::String]
        #     Output only. The batch ID.
        class BatchRunProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Options for batch processes.
          # @!attribute [rw] retry_count
          #   @return [::Integer]
          #     The retry counts per process. Default: 3.
          # @!attribute [rw] batch_size
          #   @return [::Integer]
          #     The batch size. Default: 5, maximum: 100.
          class BatchRunProcessOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for running the processes in a batch.
        # @!attribute [rw] batch_id
        #   @return [::String]
        #     The batch ID.
        # @!attribute [rw] processes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Process>]
        #     Processes created.
        class BatchRunProcessResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for querying operator info.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ResolveOperatorInfoRequest.
        # @!attribute [rw] queries
        #   @return [::Array<::Google::Cloud::VisionAI::V1::OperatorQuery>]
        #     Required. The operator queries.
        class ResolveOperatorInfoRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # OperatorQuery represents one query to a Operator.
        # @!attribute [rw] operator
        #   @return [::String]
        #     Required. The canonical Name of the operator. e.g. OccupancyCounting.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Optional. Tag of the operator.
        # @!attribute [rw] registry
        #   @return [::Google::Cloud::VisionAI::V1::Registry]
        #     Optional. Registry of the operator.
        class OperatorQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message of ResolveOperatorInfo API.
        # @!attribute [rw] operators
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Operator>]
        #     Operators with detailed information.
        class ResolveOperatorInfoResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message of ListPublicOperatorsRequest API.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListPublicOperatorsRequest.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results.
        class ListPublicOperatorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message of ListPublicOperators API.
        # @!attribute [rw] operators
        #   @return [::Array<::Google::Cloud::VisionAI::V1::Operator>]
        #     The list of Operator
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        class ListPublicOperatorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The enum of the types of the Registry.
        module Registry
          # Registry is unspecified.
          REGISTRY_UNSPECIFIED = 0

          # Public Registry containing the public Operators released by Google.
          PUBLIC = 1

          # Private Registry containing the local registered operators.
          PRIVATE = 2
        end
      end
    end
  end
end
