# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Message describing the Operator object.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] operator_definition
        #   @return [::Google::Cloud::VisionAI::V1::OperatorDefinition]
        #     The definition of the operator.
        # @!attribute [rw] docker_image
        #   @return [::String]
        #     The link to the docker image of the operator.
        class Operator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing the Analysis object.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels as key value pairs.
        # @!attribute [rw] analysis_definition
        #   @return [::Google::Cloud::VisionAI::V1::AnalysisDefinition]
        #     The definition of the analysis.
        # @!attribute [rw] input_streams_mapping
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map from the input parameter in the definition to the real stream.
        #     E.g., suppose you had a stream source operator named "input-0" and you try
        #     to receive from the real stream "stream-0". You can add the following
        #     mapping: [input-0: stream-0].
        # @!attribute [rw] output_streams_mapping
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map from the output parameter in the definition to the real stream.
        #     E.g., suppose you had a stream sink operator named "output-0" and you try
        #     to send to the real stream "stream-0". You can add the following
        #     mapping: [output-0: stream-0].
        # @!attribute [rw] disable_event_watch
        #   @return [::Boolean]
        #     Boolean flag to indicate whether you would like to disable the ability
        #     to automatically start a Process when new event happening in the input
        #     Stream. If you would like to start a Process manually, the field needs
        #     to be set to true.
        class Analysis
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class InputStreamsMappingEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class OutputStreamsMappingEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message describing the Process object.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp.
        # @!attribute [rw] analysis
        #   @return [::String]
        #     Required. Reference to an existing Analysis resource.
        # @!attribute [rw] attribute_overrides
        #   @return [::Array<::String>]
        #     Optional. Attribute overrides of the Analyzers.
        #     Format for each single override item:
        #     "\\{analyzer_name}:\\{attribute_key}=\\{value}"
        # @!attribute [rw] run_status
        #   @return [::Google::Cloud::VisionAI::V1::RunStatus]
        #     Optional. Status of the Process.
        # @!attribute [rw] run_mode
        #   @return [::Google::Cloud::VisionAI::V1::RunMode]
        #     Optional. Run mode of the Process.
        # @!attribute [rw] event_id
        #   @return [::String]
        #     Optional. Event ID of the input/output streams.
        #     This is useful when you have a StreamSource/StreamSink operator in the
        #     Analysis, and you want to manually specify the Event to read from/write to.
        # @!attribute [rw] batch_id
        #   @return [::String]
        #     Optional. Optional: Batch ID of the Process.
        # @!attribute [rw] retry_count
        #   @return [::Integer]
        #     Optional. Optional: The number of retries for a process in submission mode
        #     the system should try before declaring failure. By default, no retry will
        #     be performed.
        class Process
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
