# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        # Output format for Personal Protective Equipment Detection Operator.
        # @!attribute [rw] current_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Current timestamp.
        # @!attribute [rw] detected_persons
        #   @return [::Array<::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::DetectedPerson>]
        #     A list of DetectedPersons.
        class PersonalProtectiveEquipmentDetectionOutput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The entity info for annotations from person detection prediction result.
          # @!attribute [rw] person_entity_id
          #   @return [::Integer]
          #     Entity id.
          class PersonEntity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The entity info for annotations from PPE detection prediction result.
          # @!attribute [rw] ppe_label_id
          #   @return [::Integer]
          #     Label id.
          # @!attribute [rw] ppe_label_string
          #   @return [::String]
          #     Human readable string of the label (Examples: helmet, glove, mask).
          # @!attribute [rw] ppe_supercategory_label_string
          #   @return [::String]
          #     Human readable string of the super category label (Examples: head_cover,
          #     hands_cover, face_cover).
          # @!attribute [rw] ppe_entity_id
          #   @return [::Integer]
          #     Entity id.
          class PPEEntity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Bounding Box in the normalized coordinates.
          # @!attribute [rw] xmin
          #   @return [::Float]
          #     Min in x coordinate.
          # @!attribute [rw] ymin
          #   @return [::Float]
          #     Min in y coordinate.
          # @!attribute [rw] width
          #   @return [::Float]
          #     Width of the bounding box.
          # @!attribute [rw] height
          #   @return [::Float]
          #     Height of the bounding box.
          class NormalizedBoundingBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PersonIdentified box contains the location and the entity info of the
          # person.
          # @!attribute [rw] box_id
          #   @return [::Integer]
          #     An unique id for this box.
          # @!attribute [rw] normalized_bounding_box
          #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::NormalizedBoundingBox]
          #     Bounding Box in the normalized coordinates.
          # @!attribute [rw] confidence_score
          #   @return [::Float]
          #     Confidence score associated with this box.
          # @!attribute [rw] person_entity
          #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::PersonEntity]
          #     Person entity info.
          class PersonIdentifiedBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PPEIdentified box contains the location and the entity info of the PPE.
          # @!attribute [rw] box_id
          #   @return [::Integer]
          #     An unique id for this box.
          # @!attribute [rw] normalized_bounding_box
          #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::NormalizedBoundingBox]
          #     Bounding Box in the normalized coordinates.
          # @!attribute [rw] confidence_score
          #   @return [::Float]
          #     Confidence score associated with this box.
          # @!attribute [rw] ppe_entity
          #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::PPEEntity]
          #     PPE entity info.
          class PPEIdentifiedBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Detected Person contains the detected person and their associated
          # ppes and their protecting information.
          # @!attribute [rw] person_id
          #   @return [::Integer]
          #     The id of detected person.
          # @!attribute [rw] detected_person_identified_box
          #   @return [::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::PersonIdentifiedBox]
          #     The info of detected person identified box.
          # @!attribute [rw] detected_ppe_identified_boxes
          #   @return [::Array<::Google::Cloud::VisionAI::V1::PersonalProtectiveEquipmentDetectionOutput::PPEIdentifiedBox>]
          #     The info of detected person associated ppe identified boxes.
          # @!attribute [rw] face_coverage_score
          #   @return [::Float]
          #     Coverage score for each body part.
          #     Coverage score for face.
          # @!attribute [rw] eyes_coverage_score
          #   @return [::Float]
          #     Coverage score for eyes.
          # @!attribute [rw] head_coverage_score
          #   @return [::Float]
          #     Coverage score for head.
          # @!attribute [rw] hands_coverage_score
          #   @return [::Float]
          #     Coverage score for hands.
          # @!attribute [rw] body_coverage_score
          #   @return [::Float]
          #     Coverage score for body.
          # @!attribute [rw] feet_coverage_score
          #   @return [::Float]
          #     Coverage score for feet.
          class DetectedPerson
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Prediction output format for Generic Object Detection.
        # @!attribute [rw] current_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Current timestamp.
        # @!attribute [rw] identified_boxes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::ObjectDetectionPredictionResult::IdentifiedBox>]
        #     A list of identified boxes.
        class ObjectDetectionPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The entity info for annotations from object detection prediction result.
          # @!attribute [rw] label_id
          #   @return [::Integer]
          #     Label id.
          # @!attribute [rw] label_string
          #   @return [::String]
          #     Human readable string of the label.
          class Entity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Identified box contains location and the entity of the object.
          # @!attribute [rw] box_id
          #   @return [::Integer]
          #     An unique id for this box.
          # @!attribute [rw] normalized_bounding_box
          #   @return [::Google::Cloud::VisionAI::V1::ObjectDetectionPredictionResult::IdentifiedBox::NormalizedBoundingBox]
          #     Bounding Box in the normalized coordinates.
          # @!attribute [rw] confidence_score
          #   @return [::Float]
          #     Confidence score associated with this box.
          # @!attribute [rw] entity
          #   @return [::Google::Cloud::VisionAI::V1::ObjectDetectionPredictionResult::Entity]
          #     Entity of this box.
          class IdentifiedBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Bounding Box in the normalized coordinates.
            # @!attribute [rw] xmin
            #   @return [::Float]
            #     Min in x coordinate.
            # @!attribute [rw] ymin
            #   @return [::Float]
            #     Min in y coordinate.
            # @!attribute [rw] width
            #   @return [::Float]
            #     Width of the bounding box.
            # @!attribute [rw] height
            #   @return [::Float]
            #     Height of the bounding box.
            class NormalizedBoundingBox
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Prediction output format for Image Object Detection.
        # @!attribute [rw] ids
        #   @return [::Array<::Integer>]
        #     The resource IDs of the AnnotationSpecs that had been identified, ordered
        #     by the confidence score descendingly. It is the id segment instead of full
        #     resource name.
        # @!attribute [rw] display_names
        #   @return [::Array<::String>]
        #     The display names of the AnnotationSpecs that had been identified, order
        #     matches the IDs.
        # @!attribute [rw] confidences
        #   @return [::Array<::Float>]
        #     The Model's confidences in correctness of the predicted IDs, higher value
        #     means higher confidence. Order matches the Ids.
        # @!attribute [rw] bboxes
        #   @return [::Array<::Google::Protobuf::ListValue>]
        #     Bounding boxes, i.e. the rectangles over the image, that pinpoint
        #     the found AnnotationSpecs. Given in order that matches the IDs. Each
        #     bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
        #     `yMax`, which represent the extremal coordinates of the box. They are
        #     relative to the image size, and the point 0,0 is in the top left
        #     of the image.
        class ImageObjectDetectionPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Prediction output format for Image and Text Classification.
        # @!attribute [rw] ids
        #   @return [::Array<::Integer>]
        #     The resource IDs of the AnnotationSpecs that had been identified.
        # @!attribute [rw] display_names
        #   @return [::Array<::String>]
        #     The display names of the AnnotationSpecs that had been identified, order
        #     matches the IDs.
        # @!attribute [rw] confidences
        #   @return [::Array<::Float>]
        #     The Model's confidences in correctness of the predicted IDs, higher value
        #     means higher confidence. Order matches the Ids.
        class ClassificationPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Prediction output format for Image Segmentation.
        # @!attribute [rw] category_mask
        #   @return [::String]
        #     A PNG image where each pixel in the mask represents the category in which
        #     the pixel in the original image was predicted to belong to. The size of
        #     this image will be the same as the original image. The mapping between the
        #     AnntoationSpec and the color can be found in model's metadata. The model
        #     will choose the most likely category and if none of the categories reach
        #     the confidence threshold, the pixel will be marked as background.
        # @!attribute [rw] confidence_mask
        #   @return [::String]
        #     A one channel image which is encoded as an 8bit lossless PNG. The size of
        #     the image will be the same as the original image. For a specific pixel,
        #     darker color means less confidence in correctness of the cateogry in the
        #     categoryMask for the corresponding pixel. Black means no confidence and
        #     white means complete confidence.
        class ImageSegmentationPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Prediction output format for Video Action Recognition.
        # @!attribute [rw] segment_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The beginning, inclusive, of the video's time segment in which the
        #     actions have been identified.
        # @!attribute [rw] segment_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end, inclusive, of the video's time segment in which the actions have
        #     been identified. Particularly, if the end is the same as the start, it
        #     means the identification happens on a specific video frame.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::VisionAI::V1::VideoActionRecognitionPredictionResult::IdentifiedAction>]
        #     All of the actions identified in the time range.
        class VideoActionRecognitionPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Each IdentifiedAction is one particular identification of an action
          # specified with the AnnotationSpec id, display_name and the associated
          # confidence score.
          # @!attribute [rw] id
          #   @return [::String]
          #     The resource ID of the AnnotationSpec that had been identified.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the AnnotationSpec that had been identified.
          # @!attribute [rw] confidence
          #   @return [::Float]
          #     The Model's confidence in correction of this identification, higher
          #     value means higher confidence.
          class IdentifiedAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Prediction output format for Video Object Tracking.
        # @!attribute [rw] segment_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The beginning, inclusive, of the video's time segment in which the
        #     current identifications happens.
        # @!attribute [rw] segment_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end, inclusive, of the video's time segment in which the current
        #     identifications happen. Particularly, if the end is the same as the start,
        #     it means the identifications happen on a specific video frame.
        # @!attribute [rw] objects
        #   @return [::Array<::Google::Cloud::VisionAI::V1::VideoObjectTrackingPredictionResult::DetectedObject>]
        #     All of the objects detected in the specified time range.
        class VideoObjectTrackingPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Boundingbox for detected object. I.e. the rectangle over the video frame
          # pinpointing the found AnnotationSpec. The coordinates are relative to the
          # frame size, and the point 0,0 is in the top left of the frame.
          # @!attribute [rw] x_min
          #   @return [::Float]
          #     The leftmost coordinate of the bounding box.
          # @!attribute [rw] x_max
          #   @return [::Float]
          #     The rightmost coordinate of the bounding box.
          # @!attribute [rw] y_min
          #   @return [::Float]
          #     The topmost coordinate of the bounding box.
          # @!attribute [rw] y_max
          #   @return [::Float]
          #     The bottommost coordinate of the bounding box.
          class BoundingBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Each DetectedObject is one particular identification of an object
          # specified with the AnnotationSpec id and display_name, the bounding box,
          # the associated confidence score and the corresponding track_id.
          # @!attribute [rw] id
          #   @return [::String]
          #     The resource ID of the AnnotationSpec that had been identified.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the AnnotationSpec that had been identified.
          # @!attribute [rw] bounding_box
          #   @return [::Google::Cloud::VisionAI::V1::VideoObjectTrackingPredictionResult::BoundingBox]
          #     Boundingbox.
          # @!attribute [rw] confidence
          #   @return [::Float]
          #     The Model's confidence in correction of this identification, higher
          #     value means higher confidence.
          # @!attribute [rw] track_id
          #   @return [::Integer]
          #     The same object may be identified on muitiple frames which are typical
          #     adjacent. The set of frames where a particular object has been detected
          #     form a track. This track_id can be used to trace down all frames for an
          #     detected object.
          class DetectedObject
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Prediction output format for Video Classification.
        # @!attribute [rw] segment_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The beginning, inclusive, of the video's time segment in which the
        #     classifications have been identified.
        # @!attribute [rw] segment_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end, inclusive, of the video's time segment in which the
        #     classifications have been identified. Particularly, if the end is the same
        #     as the start, it means the identification happens on a specific video
        #     frame.
        # @!attribute [rw] classifications
        #   @return [::Array<::Google::Cloud::VisionAI::V1::VideoClassificationPredictionResult::IdentifiedClassification>]
        #     All of the classifications identified in the time range.
        class VideoClassificationPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Each IdentifiedClassification is one particular identification of an
          # classification specified with the AnnotationSpec id and display_name,
          # and the associated confidence score.
          # @!attribute [rw] id
          #   @return [::String]
          #     The resource ID of the AnnotationSpec that had been identified.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the AnnotationSpec that had been identified.
          # @!attribute [rw] confidence
          #   @return [::Float]
          #     The Model's confidence in correction of this identification, higher
          #     value means higher confidence.
          class IdentifiedClassification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The prediction result proto for occupancy counting.
        # @!attribute [rw] current_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Current timestamp.
        # @!attribute [rw] identified_boxes
        #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::IdentifiedBox>]
        #     A list of identified boxes.
        # @!attribute [rw] stats
        #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats]
        #     Detection statistics.
        # @!attribute [rw] track_info
        #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::TrackInfo>]
        #     Track related information. All the tracks that are live at this timestamp.
        #     It only exists if tracking is enabled.
        # @!attribute [rw] dwell_time_info
        #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::DwellTimeInfo>]
        #     Dwell time related information. All the tracks that are live in a given
        #     zone with a start and end dwell time timestamp
        # @!attribute [rw] pts
        #   @return [::Integer]
        #     The presentation timestamp of the frame.
        class OccupancyCountingPredictionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The entity info for annotations from occupancy counting operator.
          # @!attribute [rw] label_id
          #   @return [::Integer]
          #     Label id.
          # @!attribute [rw] label_string
          #   @return [::String]
          #     Human readable string of the label.
          class Entity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Identified box contains location and the entity of the object.
          # @!attribute [rw] box_id
          #   @return [::Integer]
          #     An unique id for this box.
          # @!attribute [rw] normalized_bounding_box
          #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::IdentifiedBox::NormalizedBoundingBox]
          #     Bounding Box in the normalized coordinates.
          # @!attribute [rw] score
          #   @return [::Float]
          #     Confidence score associated with this box.
          # @!attribute [rw] entity
          #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Entity]
          #     Entity of this box.
          # @!attribute [rw] track_id
          #   @return [::Integer]
          #     An unique id to identify a track. It should be consistent across frames.
          #     It only exists if tracking is enabled.
          class IdentifiedBox
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Bounding Box in the normalized coordinates.
            # @!attribute [rw] xmin
            #   @return [::Float]
            #     Min in x coordinate.
            # @!attribute [rw] ymin
            #   @return [::Float]
            #     Min in y coordinate.
            # @!attribute [rw] width
            #   @return [::Float]
            #     Width of the bounding box.
            # @!attribute [rw] height
            #   @return [::Float]
            #     Height of the bounding box.
            class NormalizedBoundingBox
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The statistics info for annotations from occupancy counting operator.
          # @!attribute [rw] full_frame_count
          #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ObjectCount>]
          #     Counts of the full frame.
          # @!attribute [rw] crossing_line_counts
          #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::CrossingLineCount>]
          #     Crossing line counts.
          # @!attribute [rw] active_zone_counts
          #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ActiveZoneCount>]
          #     Active zone counts.
          class Stats
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The object info and instant count for annotations from occupancy counting
            # operator.
            # @!attribute [rw] entity
            #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Entity]
            #     Entity of this object.
            # @!attribute [rw] count
            #   @return [::Integer]
            #     Count of the object.
            class ObjectCount
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The object info and accumulated count for annotations from occupancy
            # counting operator.
            # @!attribute [rw] start_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The start time of the accumulated count.
            # @!attribute [rw] object_count
            #   @return [::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ObjectCount]
            #     The object count for the accumulated count.
            class AccumulatedObjectCount
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Message for Crossing line count.
            # @!attribute [rw] annotation
            #   @return [::Google::Cloud::VisionAI::V1::StreamAnnotation]
            #     Line annotation from the user.
            # @!attribute [rw] positive_direction_counts
            #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ObjectCount>]
            #     The direction that follows the right hand rule.
            # @!attribute [rw] negative_direction_counts
            #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ObjectCount>]
            #     The direction that is opposite to the right hand rule.
            # @!attribute [rw] accumulated_positive_direction_counts
            #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::AccumulatedObjectCount>]
            #     The accumulated positive count.
            # @!attribute [rw] accumulated_negative_direction_counts
            #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::AccumulatedObjectCount>]
            #     The accumulated negative count.
            class CrossingLineCount
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Message for the active zone count.
            # @!attribute [rw] annotation
            #   @return [::Google::Cloud::VisionAI::V1::StreamAnnotation]
            #     Active zone annotation from the user.
            # @!attribute [rw] counts
            #   @return [::Array<::Google::Cloud::VisionAI::V1::OccupancyCountingPredictionResult::Stats::ObjectCount>]
            #     Counts in the zone.
            class ActiveZoneCount
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The track info for annotations from occupancy counting operator.
          # @!attribute [rw] track_id
          #   @return [::String]
          #     An unique id to identify a track. It should be consistent across frames.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Start timestamp of this track.
          class TrackInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The dwell time info for annotations from occupancy counting operator.
          # @!attribute [rw] track_id
          #   @return [::String]
          #     An unique id to identify a track. It should be consistent across frames.
          # @!attribute [rw] zone_id
          #   @return [::String]
          #     The unique id for the zone in which the object is dwelling/waiting.
          # @!attribute [rw] dwell_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The beginning time when a dwelling object has been identified in a zone.
          # @!attribute [rw] dwell_end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The end time when a dwelling object has exited in a zone.
          class DwellTimeInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # message about annotations about Vision AI stream resource.
        # @!attribute [rw] active_zone
        #   @return [::Google::Cloud::VisionAI::V1::NormalizedPolygon]
        #     Annotation for type ACTIVE_ZONE
        #
        #     Note: The following fields are mutually exclusive: `active_zone`, `crossing_line`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] crossing_line
        #   @return [::Google::Cloud::VisionAI::V1::NormalizedPolyline]
        #     Annotation for type CROSSING_LINE
        #
        #     Note: The following fields are mutually exclusive: `crossing_line`, `active_zone`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] id
        #   @return [::String]
        #     ID of the annotation. It must be unique when used in the certain context.
        #     For example, all the annotations to one input streams of a Vision AI
        #     application.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User-friendly name for the annotation.
        # @!attribute [rw] source_stream
        #   @return [::String]
        #     The Vision AI stream resource name.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VisionAI::V1::StreamAnnotationType]
        #     The actual type of Annotation.
        class StreamAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A wrapper of repeated StreamAnnotation.
        # @!attribute [rw] stream_annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::StreamAnnotation>]
        #     Multiple annotations.
        class StreamAnnotations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Normalized Polygon.
        # @!attribute [rw] normalized_vertices
        #   @return [::Array<::Google::Cloud::VisionAI::V1::NormalizedVertex>]
        #     The bounding polygon normalized vertices. Top left corner of the image
        #     will be [0, 0].
        class NormalizedPolygon
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Normalized Pplyline, which represents a curve consisting of connected
        # straight-line segments.
        # @!attribute [rw] normalized_vertices
        #   @return [::Array<::Google::Cloud::VisionAI::V1::NormalizedVertex>]
        #     A sequence of vertices connected by straight lines.
        class NormalizedPolyline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A vertex represents a 2D point in the image.
        # NOTE: the normalized vertex coordinates are relative to the original image
        # and range from 0 to 1.
        # @!attribute [rw] x
        #   @return [::Float]
        #     X coordinate.
        # @!attribute [rw] y
        #   @return [::Float]
        #     Y coordinate.
        class NormalizedVertex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message of essential metadata of App Platform.
        # This message is usually attached to a certain processor output annotation for
        # customer to identify the source of the data.
        # @!attribute [rw] application
        #   @return [::String]
        #     The application resource name.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     The instance resource id. Instance is the nested resource of application
        #     under collection 'instances'.
        # @!attribute [rw] node
        #   @return [::String]
        #     The node name of the application graph.
        # @!attribute [rw] processor
        #   @return [::String]
        #     The referred processor resource name of the application node.
        class AppPlatformMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # For any cloud function based customer processing logic, customer's cloud
        # function is expected to receive AppPlatformCloudFunctionRequest as request
        # and send back AppPlatformCloudFunctionResponse as response.
        # Message of request from AppPlatform to Cloud Function.
        # @!attribute [rw] app_platform_metadata
        #   @return [::Google::Cloud::VisionAI::V1::AppPlatformMetadata]
        #     The metadata of the AppPlatform for customer to identify the source of the
        #     payload.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AppPlatformCloudFunctionRequest::StructedInputAnnotation>]
        #     The actual annotations to be processed by the customized Cloud Function.
        class AppPlatformCloudFunctionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A general annotation message that uses struct format to represent different
          # concrete annotation protobufs.
          # @!attribute [rw] ingestion_time_micros
          #   @return [::Integer]
          #     The ingestion time of the current annotation.
          # @!attribute [rw] annotation
          #   @return [::Google::Protobuf::Struct]
          #     The struct format of the actual annotation.
          class StructedInputAnnotation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message of the response from customer's Cloud Function to AppPlatform.
        # @!attribute [rw] annotations
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AppPlatformCloudFunctionResponse::StructedOutputAnnotation>]
        #     The modified annotations that is returned back to AppPlatform.
        #     If the annotations fields are empty, then those annotations will be dropped
        #     by AppPlatform.
        # @!attribute [rw] annotation_passthrough
        #   @return [::Boolean]
        #     If set to true, AppPlatform will use original annotations instead of
        #     dropping them, even if it is empty in the annotations filed.
        # @!attribute [rw] events
        #   @return [::Array<::Google::Cloud::VisionAI::V1::AppPlatformEventBody>]
        #     The event notifications that is returned back to AppPlatform. Typically it
        #     will then be configured to be consumed/forwared to a operator that handles
        #     events, such as Pub/Sub operator.
        class AppPlatformCloudFunctionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A general annotation message that uses struct format to represent different
          # concrete annotation protobufs.
          # @!attribute [rw] annotation
          #   @return [::Google::Protobuf::Struct]
          #     The struct format of the actual annotation.
          class StructedOutputAnnotation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message of content of appPlatform event
        # @!attribute [rw] event_message
        #   @return [::String]
        #     Human readable string of the event like "There are more than 6 people in
        #     the scene". or "Shelf is empty!".
        # @!attribute [rw] payload
        #   @return [::Google::Protobuf::Struct]
        #     For the case of Pub/Sub, it will be stored in the message attributes.
        #     ​​pubsub.proto
        # @!attribute [rw] event_id
        #   @return [::String]
        #     User defined Event Id, used to classify event, within a delivery interval,
        #     events from the same application instance with the same id will be
        #     de-duplicated & only first one will be sent out. Empty event_id will be
        #     treated as "".
        class AppPlatformEventBody
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Enum describing all possible types of a stream annotation.
        module StreamAnnotationType
          # Type UNSPECIFIED.
          STREAM_ANNOTATION_TYPE_UNSPECIFIED = 0

          # active_zone annotation defines a polygon on top of the content from an
          # image/video based stream, following processing will only focus on the
          # content inside the active zone.
          STREAM_ANNOTATION_TYPE_ACTIVE_ZONE = 1

          # crossing_line annotation defines a polyline on top of the content from an
          # image/video based Vision AI stream, events happening across the line will
          # be captured. For example, the counts of people who goes acroos the line
          # in Occupancy Analytic Processor.
          STREAM_ANNOTATION_TYPE_CROSSING_LINE = 2
        end
      end
    end
  end
end
