# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/visionai/v1/warehouse.proto for package 'Google.Cloud.VisionAI.V1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/visionai/v1/warehouse_pb'

module Google
  module Cloud
    module VisionAI
      module V1
        module Warehouse
          # Service that manages media content + metadata for streaming.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.visionai.v1.Warehouse'

            # Creates an asset inside corpus.
            rpc :CreateAsset, ::Google::Cloud::VisionAI::V1::CreateAssetRequest, ::Google::Cloud::VisionAI::V1::Asset
            # Updates an asset inside corpus.
            rpc :UpdateAsset, ::Google::Cloud::VisionAI::V1::UpdateAssetRequest, ::Google::Cloud::VisionAI::V1::Asset
            # Reads an asset inside corpus.
            rpc :GetAsset, ::Google::Cloud::VisionAI::V1::GetAssetRequest, ::Google::Cloud::VisionAI::V1::Asset
            # Lists an list of assets inside corpus.
            rpc :ListAssets, ::Google::Cloud::VisionAI::V1::ListAssetsRequest, ::Google::Cloud::VisionAI::V1::ListAssetsResponse
            # Deletes asset inside corpus.
            rpc :DeleteAsset, ::Google::Cloud::VisionAI::V1::DeleteAssetRequest, ::Google::Longrunning::Operation
            # Upload asset by specifing the asset Cloud Storage uri.
            # For video warehouse, it requires users who call this API have read access
            # to the cloud storage file. Once it is uploaded, it can be retrieved by
            # GenerateRetrievalUrl API which by default, only can retrieve cloud storage
            # files from the same project of the warehouse. To allow retrieval cloud
            # storage files that are in a separate project, it requires to find the
            # vision ai service account (Go to IAM, check checkbox to show "Include
            # Google-provided role grants", search for "Cloud Vision AI Service Agent")
            # and grant the read access of the cloud storage files to that service
            # account.
            rpc :UploadAsset, ::Google::Cloud::VisionAI::V1::UploadAssetRequest, ::Google::Longrunning::Operation
            # Generates a signed url for downloading the asset.
            # For video warehouse, please see comment of UploadAsset about how to allow
            # retrieval of cloud storage files in a different project.
            rpc :GenerateRetrievalUrl, ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest, ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse
            # Analyze asset to power search capability.
            rpc :AnalyzeAsset, ::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest, ::Google::Longrunning::Operation
            # Index one asset for search.
            # Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
            rpc :IndexAsset, ::Google::Cloud::VisionAI::V1::IndexAssetRequest, ::Google::Longrunning::Operation
            # Remove one asset's index data for search.
            # Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
            rpc :RemoveIndexAsset, ::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest, ::Google::Longrunning::Operation
            # Lists assets inside an index.
            rpc :ViewIndexedAssets, ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest, ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsResponse
            # Creates an Index under the corpus.
            rpc :CreateIndex, ::Google::Cloud::VisionAI::V1::CreateIndexRequest, ::Google::Longrunning::Operation
            # Updates an Index under the corpus.
            # Users can perform a metadata-only update or trigger a full index rebuild
            # with different update_mask values.
            rpc :UpdateIndex, ::Google::Cloud::VisionAI::V1::UpdateIndexRequest, ::Google::Longrunning::Operation
            # Gets the details of a single Index under a Corpus.
            rpc :GetIndex, ::Google::Cloud::VisionAI::V1::GetIndexRequest, ::Google::Cloud::VisionAI::V1::Index
            # List all Indexes in a given Corpus.
            rpc :ListIndexes, ::Google::Cloud::VisionAI::V1::ListIndexesRequest, ::Google::Cloud::VisionAI::V1::ListIndexesResponse
            # Delete a single Index. In order to delete an index, the caller must
            # make sure that it is not deployed to any index endpoint.
            rpc :DeleteIndex, ::Google::Cloud::VisionAI::V1::DeleteIndexRequest, ::Google::Longrunning::Operation
            # Creates a corpus inside a project.
            rpc :CreateCorpus, ::Google::Cloud::VisionAI::V1::CreateCorpusRequest, ::Google::Longrunning::Operation
            # Gets corpus details inside a project.
            rpc :GetCorpus, ::Google::Cloud::VisionAI::V1::GetCorpusRequest, ::Google::Cloud::VisionAI::V1::Corpus
            # Updates a corpus in a project.
            rpc :UpdateCorpus, ::Google::Cloud::VisionAI::V1::UpdateCorpusRequest, ::Google::Cloud::VisionAI::V1::Corpus
            # Lists all corpora in a project.
            rpc :ListCorpora, ::Google::Cloud::VisionAI::V1::ListCorporaRequest, ::Google::Cloud::VisionAI::V1::ListCorporaResponse
            # Deletes a corpus only if its empty.
            # Returns empty response.
            rpc :DeleteCorpus, ::Google::Cloud::VisionAI::V1::DeleteCorpusRequest, ::Google::Protobuf::Empty
            # Analyzes a corpus.
            rpc :AnalyzeCorpus, ::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest, ::Google::Longrunning::Operation
            # Creates data schema inside corpus.
            rpc :CreateDataSchema, ::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest, ::Google::Cloud::VisionAI::V1::DataSchema
            # Updates data schema inside corpus.
            rpc :UpdateDataSchema, ::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest, ::Google::Cloud::VisionAI::V1::DataSchema
            # Gets data schema inside corpus.
            rpc :GetDataSchema, ::Google::Cloud::VisionAI::V1::GetDataSchemaRequest, ::Google::Cloud::VisionAI::V1::DataSchema
            # Deletes data schema inside corpus.
            rpc :DeleteDataSchema, ::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest, ::Google::Protobuf::Empty
            # Lists a list of data schemas inside corpus.
            rpc :ListDataSchemas, ::Google::Cloud::VisionAI::V1::ListDataSchemasRequest, ::Google::Cloud::VisionAI::V1::ListDataSchemasResponse
            # Creates annotation inside asset.
            rpc :CreateAnnotation, ::Google::Cloud::VisionAI::V1::CreateAnnotationRequest, ::Google::Cloud::VisionAI::V1::Annotation
            # Reads annotation inside asset.
            rpc :GetAnnotation, ::Google::Cloud::VisionAI::V1::GetAnnotationRequest, ::Google::Cloud::VisionAI::V1::Annotation
            # Lists a list of annotations inside asset.
            rpc :ListAnnotations, ::Google::Cloud::VisionAI::V1::ListAnnotationsRequest, ::Google::Cloud::VisionAI::V1::ListAnnotationsResponse
            # Updates annotation inside asset.
            rpc :UpdateAnnotation, ::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest, ::Google::Cloud::VisionAI::V1::Annotation
            # Deletes annotation inside asset.
            rpc :DeleteAnnotation, ::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest, ::Google::Protobuf::Empty
            # Ingests data for the asset. It is not allowed to ingest a data chunk which
            # is already expired according to TTL.
            # This method is only available via the gRPC API (not HTTP since
            # bi-directional streaming is not supported via HTTP).
            rpc :IngestAsset, stream(::Google::Cloud::VisionAI::V1::IngestAssetRequest), stream(::Google::Cloud::VisionAI::V1::IngestAssetResponse)
            # Supported by STREAM_VIDEO corpus type.
            # Generates clips for downloading. The api takes in a time range, and
            # generates a clip of the first content available after start_time and
            # before end_time, which may overflow beyond these bounds.
            # Returned clips are truncated if the total size of the clips are larger
            # than 100MB.
            rpc :ClipAsset, ::Google::Cloud::VisionAI::V1::ClipAssetRequest, ::Google::Cloud::VisionAI::V1::ClipAssetResponse
            # Generates a uri for an HLS manifest. The api takes in a collection of time
            # ranges, and generates a URI for an HLS manifest that covers all the
            # requested time ranges.
            rpc :GenerateHlsUri, ::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest, ::Google::Cloud::VisionAI::V1::GenerateHlsUriResponse
            # Imports assets (images plus annotations) from a meta file on cloud storage.
            # Each row in the meta file is corresponding to an image (specified by a
            # cloud storage uri) and its annotations.
            rpc :ImportAssets, ::Google::Cloud::VisionAI::V1::ImportAssetsRequest, ::Google::Longrunning::Operation
            # Creates a search configuration inside a corpus.
            #
            # Please follow the rules below to create a valid CreateSearchConfigRequest.
            # --- General Rules ---
            # 1. Request.search_config_id must not be associated with an existing
            #    SearchConfig.
            # 2. Request must contain at least one non-empty search_criteria_property or
            #    facet_property.
            # 3. mapped_fields must not be empty, and must map to existing UGA keys.
            # 4. All mapped_fields must be of the same type.
            # 5. All mapped_fields must share the same granularity.
            # 6. All mapped_fields must share the same semantic SearchConfig match
            #    options.
            # For property-specific rules, please reference the comments for
            # FacetProperty and SearchCriteriaProperty.
            rpc :CreateSearchConfig, ::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest, ::Google::Cloud::VisionAI::V1::SearchConfig
            # Updates a search configuration inside a corpus.
            #
            # Please follow the rules below to create a valid UpdateSearchConfigRequest.
            # --- General Rules ---
            # 1. Request.search_configuration.name must already exist.
            # 2. Request must contain at least one non-empty search_criteria_property or
            # facet_property.
            # 3. mapped_fields must not be empty, and must map to existing UGA keys.
            # 4. All mapped_fields must be of the same type.
            # 5. All mapped_fields must share the same granularity.
            # 6. All mapped_fields must share the same semantic SearchConfig match
            #    options.
            # For property-specific rules, please reference the comments for
            # FacetProperty and SearchCriteriaProperty.
            rpc :UpdateSearchConfig, ::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest, ::Google::Cloud::VisionAI::V1::SearchConfig
            # Gets a search configuration inside a corpus.
            rpc :GetSearchConfig, ::Google::Cloud::VisionAI::V1::GetSearchConfigRequest, ::Google::Cloud::VisionAI::V1::SearchConfig
            # Deletes a search configuration inside a corpus.
            #
            # For a DeleteSearchConfigRequest to be valid,
            # Request.search_configuration.name must already exist.
            rpc :DeleteSearchConfig, ::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest, ::Google::Protobuf::Empty
            # Lists all search configurations inside a corpus.
            rpc :ListSearchConfigs, ::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest, ::Google::Cloud::VisionAI::V1::ListSearchConfigsResponse
            # Creates a SearchHypernym inside a corpus.
            rpc :CreateSearchHypernym, ::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest, ::Google::Cloud::VisionAI::V1::SearchHypernym
            # Updates a SearchHypernym inside a corpus.
            rpc :UpdateSearchHypernym, ::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest, ::Google::Cloud::VisionAI::V1::SearchHypernym
            # Gets a SearchHypernym inside a corpus.
            rpc :GetSearchHypernym, ::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest, ::Google::Cloud::VisionAI::V1::SearchHypernym
            # Deletes a SearchHypernym inside a corpus.
            rpc :DeleteSearchHypernym, ::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest, ::Google::Protobuf::Empty
            # Lists SearchHypernyms inside a corpus.
            rpc :ListSearchHypernyms, ::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest, ::Google::Cloud::VisionAI::V1::ListSearchHypernymsResponse
            # Search media asset.
            rpc :SearchAssets, ::Google::Cloud::VisionAI::V1::SearchAssetsRequest, ::Google::Cloud::VisionAI::V1::SearchAssetsResponse
            # Search a deployed index endpoint (IMAGE corpus type only).
            rpc :SearchIndexEndpoint, ::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest, ::Google::Cloud::VisionAI::V1::SearchIndexEndpointResponse
            # Creates an IndexEndpoint.
            rpc :CreateIndexEndpoint, ::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest, ::Google::Longrunning::Operation
            # Gets an IndexEndpoint.
            rpc :GetIndexEndpoint, ::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest, ::Google::Cloud::VisionAI::V1::IndexEndpoint
            # Lists all IndexEndpoints in a project.
            rpc :ListIndexEndpoints, ::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest, ::Google::Cloud::VisionAI::V1::ListIndexEndpointsResponse
            # Updates an IndexEndpoint.
            rpc :UpdateIndexEndpoint, ::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest, ::Google::Longrunning::Operation
            # Deletes an IndexEndpoint.
            rpc :DeleteIndexEndpoint, ::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest, ::Google::Longrunning::Operation
            # Deploys an Index to IndexEndpoint.
            rpc :DeployIndex, ::Google::Cloud::VisionAI::V1::DeployIndexRequest, ::Google::Longrunning::Operation
            # Undeploys an Index from IndexEndpoint.
            rpc :UndeployIndex, ::Google::Cloud::VisionAI::V1::UndeployIndexRequest, ::Google::Longrunning::Operation
            # Creates a collection.
            rpc :CreateCollection, ::Google::Cloud::VisionAI::V1::CreateCollectionRequest, ::Google::Longrunning::Operation
            # Deletes a collection.
            rpc :DeleteCollection, ::Google::Cloud::VisionAI::V1::DeleteCollectionRequest, ::Google::Longrunning::Operation
            # Gets a collection.
            rpc :GetCollection, ::Google::Cloud::VisionAI::V1::GetCollectionRequest, ::Google::Cloud::VisionAI::V1::Collection
            # Updates a collection.
            rpc :UpdateCollection, ::Google::Cloud::VisionAI::V1::UpdateCollectionRequest, ::Google::Cloud::VisionAI::V1::Collection
            # Lists collections inside a corpus.
            rpc :ListCollections, ::Google::Cloud::VisionAI::V1::ListCollectionsRequest, ::Google::Cloud::VisionAI::V1::ListCollectionsResponse
            # Adds an item into a Collection.
            rpc :AddCollectionItem, ::Google::Cloud::VisionAI::V1::AddCollectionItemRequest, ::Google::Cloud::VisionAI::V1::AddCollectionItemResponse
            # Removes an item from a collection.
            rpc :RemoveCollectionItem, ::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest, ::Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse
            # View items inside a collection.
            rpc :ViewCollectionItems, ::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest, ::Google::Cloud::VisionAI::V1::ViewCollectionItemsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
