# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/visionai/v1/streams_service.proto for package 'Google.Cloud.VisionAI.V1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/visionai/v1/streams_service_pb'

module Google
  module Cloud
    module VisionAI
      module V1
        module StreamsService
          # Service describing handlers for resources.
          # Vision API and Vision AI API are two independent APIs developed by the same
          # team. Vision API is for people to annotate their image while Vision AI is an
          # e2e solution for customer to build their own computer vision application.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.visionai.v1.StreamsService'

            # Lists Clusters in a given project and location.
            rpc :ListClusters, ::Google::Cloud::VisionAI::V1::ListClustersRequest, ::Google::Cloud::VisionAI::V1::ListClustersResponse
            # Gets details of a single Cluster.
            rpc :GetCluster, ::Google::Cloud::VisionAI::V1::GetClusterRequest, ::Google::Cloud::VisionAI::V1::Cluster
            # Creates a new Cluster in a given project and location.
            rpc :CreateCluster, ::Google::Cloud::VisionAI::V1::CreateClusterRequest, ::Google::Longrunning::Operation
            # Updates the parameters of a single Cluster.
            rpc :UpdateCluster, ::Google::Cloud::VisionAI::V1::UpdateClusterRequest, ::Google::Longrunning::Operation
            # Deletes a single Cluster.
            rpc :DeleteCluster, ::Google::Cloud::VisionAI::V1::DeleteClusterRequest, ::Google::Longrunning::Operation
            # Lists Streams in a given project and location.
            rpc :ListStreams, ::Google::Cloud::VisionAI::V1::ListStreamsRequest, ::Google::Cloud::VisionAI::V1::ListStreamsResponse
            # Gets details of a single Stream.
            rpc :GetStream, ::Google::Cloud::VisionAI::V1::GetStreamRequest, ::Google::Cloud::VisionAI::V1::Stream
            # Creates a new Stream in a given project and location.
            rpc :CreateStream, ::Google::Cloud::VisionAI::V1::CreateStreamRequest, ::Google::Longrunning::Operation
            # Updates the parameters of a single Stream.
            rpc :UpdateStream, ::Google::Cloud::VisionAI::V1::UpdateStreamRequest, ::Google::Longrunning::Operation
            # Deletes a single Stream.
            rpc :DeleteStream, ::Google::Cloud::VisionAI::V1::DeleteStreamRequest, ::Google::Longrunning::Operation
            # Gets the thumbnail (image snapshot) of a single Stream.
            rpc :GetStreamThumbnail, ::Google::Cloud::VisionAI::V1::GetStreamThumbnailRequest, ::Google::Longrunning::Operation
            # Generate the JWT auth token required to get the stream HLS contents.
            rpc :GenerateStreamHlsToken, ::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenRequest, ::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenResponse
            # Lists Events in a given project and location.
            rpc :ListEvents, ::Google::Cloud::VisionAI::V1::ListEventsRequest, ::Google::Cloud::VisionAI::V1::ListEventsResponse
            # Gets details of a single Event.
            rpc :GetEvent, ::Google::Cloud::VisionAI::V1::GetEventRequest, ::Google::Cloud::VisionAI::V1::Event
            # Creates a new Event in a given project and location.
            rpc :CreateEvent, ::Google::Cloud::VisionAI::V1::CreateEventRequest, ::Google::Longrunning::Operation
            # Updates the parameters of a single Event.
            rpc :UpdateEvent, ::Google::Cloud::VisionAI::V1::UpdateEventRequest, ::Google::Longrunning::Operation
            # Deletes a single Event.
            rpc :DeleteEvent, ::Google::Cloud::VisionAI::V1::DeleteEventRequest, ::Google::Longrunning::Operation
            # Lists Series in a given project and location.
            rpc :ListSeries, ::Google::Cloud::VisionAI::V1::ListSeriesRequest, ::Google::Cloud::VisionAI::V1::ListSeriesResponse
            # Gets details of a single Series.
            rpc :GetSeries, ::Google::Cloud::VisionAI::V1::GetSeriesRequest, ::Google::Cloud::VisionAI::V1::Series
            # Creates a new Series in a given project and location.
            rpc :CreateSeries, ::Google::Cloud::VisionAI::V1::CreateSeriesRequest, ::Google::Longrunning::Operation
            # Updates the parameters of a single Event.
            rpc :UpdateSeries, ::Google::Cloud::VisionAI::V1::UpdateSeriesRequest, ::Google::Longrunning::Operation
            # Deletes a single Series.
            rpc :DeleteSeries, ::Google::Cloud::VisionAI::V1::DeleteSeriesRequest, ::Google::Longrunning::Operation
            # Materialize a channel.
            rpc :MaterializeChannel, ::Google::Cloud::VisionAI::V1::MaterializeChannelRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
