# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/visionai/v1/warehouse_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module VisionAI
      module V1
        module Warehouse
          ##
          # Client for the Warehouse service.
          #
          # Service that manages media content + metadata for streaming.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "visionai.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :warehouse_stub

            ##
            # Configure the Warehouse Client class.
            #
            # See {::Google::Cloud::VisionAI::V1::Warehouse::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Warehouse clients
            #   ::Google::Cloud::VisionAI::V1::Warehouse::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "VisionAI", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_asset.timeout = 120.0
                default_config.rpcs.create_asset.retry_policy = {
                  initial_delay: 1.0, max_delay: 120.0, multiplier: 2.5, retry_codes: [14]
                }

                default_config.rpcs.create_corpus.timeout = 120.0
                default_config.rpcs.create_corpus.retry_policy = {
                  initial_delay: 1.0, max_delay: 120.0, multiplier: 2.5, retry_codes: [14]
                }

                default_config.rpcs.create_data_schema.timeout = 120.0
                default_config.rpcs.create_data_schema.retry_policy = {
                  initial_delay: 1.0, max_delay: 120.0, multiplier: 2.5, retry_codes: [14]
                }

                default_config.rpcs.create_annotation.timeout = 120.0
                default_config.rpcs.create_annotation.retry_policy = {
                  initial_delay: 1.0, max_delay: 120.0, multiplier: 2.5, retry_codes: [14]
                }

                default_config.rpcs.ingest_asset.timeout = 120.0
                default_config.rpcs.ingest_asset.retry_policy = {
                  initial_delay: 1.0, max_delay: 120.0, multiplier: 2.5, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Warehouse Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::VisionAI::V1::Warehouse::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @warehouse_stub.universe_domain
            end

            ##
            # Create a new Warehouse client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Warehouse client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/visionai/v1/warehouse_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @warehouse_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::VisionAI::V1::Warehouse::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @warehouse_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @warehouse_stub.endpoint
                config.universe_domain = @warehouse_stub.universe_domain
                config.logger = @warehouse_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @warehouse_stub.endpoint
                config.universe_domain = @warehouse_stub.universe_domain
                config.logger = @warehouse_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::VisionAI::V1::Warehouse::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @warehouse_stub.logger
            end

            # Service calls

            ##
            # Creates an asset inside corpus.
            #
            # @overload create_asset(request, options = nil)
            #   Pass arguments to `create_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_asset(parent: nil, asset: nil, asset_id: nil)
            #   Pass arguments to `create_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this asset will be created.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #   @param asset [::Google::Cloud::VisionAI::V1::Asset, ::Hash]
            #     Required. The asset to create.
            #   @param asset_id [::String]
            #     Optional. The ID to use for the asset, which will become the final
            #     component of the asset's resource name if user choose to specify.
            #     Otherwise, asset id will be generated by system.
            #
            #     This value should be up to 63 characters, and valid characters
            #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
            #     a letter or a number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Asset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Asset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateAssetRequest.new
            #
            #   # Call the create_asset method.
            #   result = client.create_asset request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Asset.
            #   p result
            #
            def create_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_asset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an asset inside corpus.
            #
            # @overload update_asset(request, options = nil)
            #   Pass arguments to `update_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_asset(asset: nil, update_mask: nil)
            #   Pass arguments to `update_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param asset [::Google::Cloud::VisionAI::V1::Asset, ::Hash]
            #     Required. The asset to update.
            #
            #     The asset's `name` field is used to identify the asset to be updated.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Asset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Asset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateAssetRequest.new
            #
            #   # Call the update_asset method.
            #   result = client.update_asset request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Asset.
            #   p result
            #
            def update_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.asset&.name
                header_params["asset.name"] = request.asset.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_asset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Reads an asset inside corpus.
            #
            # @overload get_asset(request, options = nil)
            #   Pass arguments to `get_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_asset(name: nil)
            #   Pass arguments to `get_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the asset to retrieve.
            #     Format:
            #     projects/\\{project_number}/locations/\\{location}/corpora/\\{corpus}/assets/\\{asset}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Asset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Asset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetAssetRequest.new
            #
            #   # Call the get_asset method.
            #   result = client.get_asset request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Asset.
            #   p result
            #
            def get_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_asset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists an list of assets inside corpus.
            #
            # @overload list_assets(request, options = nil)
            #   Pass arguments to `list_assets` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_assets(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of assets.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param page_size [::Integer]
            #     The maximum number of assets to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 50 assets will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListAssets` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListAssets` must match
            #     the call that provided the page token.
            #   @param filter [::String]
            #     The filter applied to the returned list.
            #     Only the following filterings are supported:
            #     "assets_with_contents = true", which returns assets with contents uploaded;
            #     "assets_with_contents = false", which returns assets without contents.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Asset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Asset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListAssetsRequest.new
            #
            #   # Call the list_assets method.
            #   result = client.list_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::Asset.
            #     p item
            #   end
            #
            def list_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes asset inside corpus.
            #
            # @overload delete_asset(request, options = nil)
            #   Pass arguments to `delete_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_asset(name: nil)
            #   Pass arguments to `delete_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the asset to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteAssetRequest.new
            #
            #   # Call the delete_asset method.
            #   result = client.delete_asset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_asset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Upload asset by specifing the asset Cloud Storage uri.
            # For video warehouse, it requires users who call this API have read access
            # to the cloud storage file. Once it is uploaded, it can be retrieved by
            # GenerateRetrievalUrl API which by default, only can retrieve cloud storage
            # files from the same project of the warehouse. To allow retrieval cloud
            # storage files that are in a separate project, it requires to find the
            # vision ai service account (Go to IAM, check checkbox to show "Include
            # Google-provided role grants", search for "Cloud Vision AI Service Agent")
            # and grant the read access of the cloud storage files to that service
            # account.
            #
            # @overload upload_asset(request, options = nil)
            #   Pass arguments to `upload_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UploadAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UploadAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upload_asset(name: nil, asset_source: nil)
            #   Pass arguments to `upload_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to upload.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param asset_source [::Google::Cloud::VisionAI::V1::AssetSource, ::Hash]
            #     The source of the asset.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UploadAssetRequest.new
            #
            #   # Call the upload_asset method.
            #   result = client.upload_asset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upload_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UploadAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upload_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upload_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upload_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :upload_asset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates a signed url for downloading the asset.
            # For video warehouse, please see comment of UploadAsset about how to allow
            # retrieval of cloud storage files in a different project.
            #
            # @overload generate_retrieval_url(request, options = nil)
            #   Pass arguments to `generate_retrieval_url` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_retrieval_url(name: nil)
            #   Pass arguments to `generate_retrieval_url` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to request signed url for.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest.new
            #
            #   # Call the generate_retrieval_url method.
            #   result = client.generate_retrieval_url request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::GenerateRetrievalUrlResponse.
            #   p result
            #
            def generate_retrieval_url request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GenerateRetrievalUrlRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_retrieval_url.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_retrieval_url.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_retrieval_url.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :generate_retrieval_url, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyze asset to power search capability.
            #
            # @overload analyze_asset(request, options = nil)
            #   Pass arguments to `analyze_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_asset(name: nil)
            #   Pass arguments to `analyze_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to analyze.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::AnalyzeAssetRequest.new
            #
            #   # Call the analyze_asset method.
            #   result = client.analyze_asset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def analyze_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::AnalyzeAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :analyze_asset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Index one asset for search.
            # Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
            #
            # @overload index_asset(request, options = nil)
            #   Pass arguments to `index_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::IndexAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::IndexAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload index_asset(name: nil, index: nil)
            #   Pass arguments to `index_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to index.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param index [::String]
            #     Optional. The name of the index.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::IndexAssetRequest.new
            #
            #   # Call the index_asset method.
            #   result = client.index_asset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def index_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::IndexAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.index_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.index_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.index_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :index_asset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Remove one asset's index data for search.
            # Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
            #
            # @overload remove_index_asset(request, options = nil)
            #   Pass arguments to `remove_index_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_index_asset(name: nil, index: nil)
            #   Pass arguments to `remove_index_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to index.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param index [::String]
            #     Optional. The name of the index.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest.new
            #
            #   # Call the remove_index_asset method.
            #   result = client.remove_index_asset request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def remove_index_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::RemoveIndexAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_index_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_index_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_index_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :remove_index_asset, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists assets inside an index.
            #
            # @overload view_indexed_assets(request, options = nil)
            #   Pass arguments to `view_indexed_assets` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload view_indexed_assets(index: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `view_indexed_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param index [::String]
            #     Required. The index that owns this collection of assets.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
            #   @param page_size [::Integer]
            #     The maximum number of assets to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 50 assets will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ViewIndexedAssets` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ViewIndexedAssets` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     The filter applied to the returned list.
            #     Only the following filterings are supported:
            #     "asset_id = xxxx", which returns asset with specified id.
            #     "asset_id = xxxx, yyyy, zzzz", which returns assets with specified ids.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::IndexedAsset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::IndexedAsset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest.new
            #
            #   # Call the view_indexed_assets method.
            #   result = client.view_indexed_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::IndexedAsset.
            #     p item
            #   end
            #
            def view_indexed_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ViewIndexedAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.view_indexed_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index
                header_params["index"] = request.index
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.view_indexed_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.view_indexed_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :view_indexed_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :view_indexed_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Index under the corpus.
            #
            # @overload create_index(request, options = nil)
            #   Pass arguments to `create_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_index(parent: nil, index_id: nil, index: nil)
            #   Pass arguments to `create_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for the parent. The resource name of the Corpus under which
            #     this index is created. Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #   @param index_id [::String]
            #     Optional. The ID for the index. This will become the final resource name
            #     for the index. If the user does not specify this value, it will be
            #     generated by system.
            #
            #     This value should be up to 63 characters, and valid characters
            #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
            #     a letter or a number.
            #   @param index [::Google::Cloud::VisionAI::V1::Index, ::Hash]
            #     Required. The index being created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateIndexRequest.new
            #
            #   # Call the create_index method.
            #   result = client.create_index request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_index, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an Index under the corpus.
            # Users can perform a metadata-only update or trigger a full index rebuild
            # with different update_mask values.
            #
            # @overload update_index(request, options = nil)
            #   Pass arguments to `update_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_index(index: nil, update_mask: nil)
            #   Pass arguments to `update_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param index [::Google::Cloud::VisionAI::V1::Index, ::Hash]
            #     Required. The resource being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Index resource by the update. The fields specified in the update_mask are
            #     relative to the resource, not the full request. A field of the resource
            #     will be overwritten if it is in the mask. Empty field mask is not allowed.
            #     If the mask is "*", it triggers a full update of the index, and also a
            #     whole rebuild of index data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateIndexRequest.new
            #
            #   # Call the update_index method.
            #   result = client.update_index request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index&.name
                header_params["index.name"] = request.index.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_index, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a single Index under a Corpus.
            #
            # @overload get_index(request, options = nil)
            #   Pass arguments to `get_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_index(name: nil)
            #   Pass arguments to `get_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the Index resource.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Index]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Index]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetIndexRequest.new
            #
            #   # Call the get_index method.
            #   result = client.get_index request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Index.
            #   p result
            #
            def get_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_index, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List all Indexes in a given Corpus.
            #
            # @overload list_indexes(request, options = nil)
            #   Pass arguments to `list_indexes` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListIndexesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListIndexesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_indexes(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_indexes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent corpus that owns this collection of indexes.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param page_size [::Integer]
            #     The maximum number of indexes to return. The service may return fewer than
            #     this value.
            #     If unspecified, at most 50 indexes will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListIndexes` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListIndexes` must match
            #     the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Index>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Index>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListIndexesRequest.new
            #
            #   # Call the list_indexes method.
            #   result = client.list_indexes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::Index.
            #     p item
            #   end
            #
            def list_indexes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListIndexesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_indexes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_indexes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_indexes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_indexes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_indexes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single Index. In order to delete an index, the caller must
            # make sure that it is not deployed to any index endpoint.
            #
            # @overload delete_index(request, options = nil)
            #   Pass arguments to `delete_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_index(name: nil)
            #   Pass arguments to `delete_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the index to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteIndexRequest.new
            #
            #   # Call the delete_index method.
            #   result = client.delete_index request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_index, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a corpus inside a project.
            #
            # @overload create_corpus(request, options = nil)
            #   Pass arguments to `create_corpus` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateCorpusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateCorpusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_corpus(parent: nil, corpus: nil)
            #   Pass arguments to `create_corpus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Form: `projects/{project_number}/locations/{location_id}`
            #   @param corpus [::Google::Cloud::VisionAI::V1::Corpus, ::Hash]
            #     Required. The corpus to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateCorpusRequest.new
            #
            #   # Call the create_corpus method.
            #   result = client.create_corpus request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_corpus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateCorpusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_corpus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_corpus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_corpus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_corpus, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets corpus details inside a project.
            #
            # @overload get_corpus(request, options = nil)
            #   Pass arguments to `get_corpus` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetCorpusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetCorpusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_corpus(name: nil)
            #   Pass arguments to `get_corpus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the corpus to retrieve.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Corpus]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Corpus]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetCorpusRequest.new
            #
            #   # Call the get_corpus method.
            #   result = client.get_corpus request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Corpus.
            #   p result
            #
            def get_corpus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetCorpusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_corpus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_corpus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_corpus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_corpus, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a corpus in a project.
            #
            # @overload update_corpus(request, options = nil)
            #   Pass arguments to `update_corpus` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateCorpusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateCorpusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_corpus(corpus: nil, update_mask: nil)
            #   Pass arguments to `update_corpus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param corpus [::Google::Cloud::VisionAI::V1::Corpus, ::Hash]
            #     Required. The corpus which replaces the resource on the server.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Corpus]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Corpus]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateCorpusRequest.new
            #
            #   # Call the update_corpus method.
            #   result = client.update_corpus request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Corpus.
            #   p result
            #
            def update_corpus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateCorpusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_corpus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.corpus&.name
                header_params["corpus.name"] = request.corpus.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_corpus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_corpus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_corpus, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all corpora in a project.
            #
            # @overload list_corpora(request, options = nil)
            #   Pass arguments to `list_corpora` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListCorporaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListCorporaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_corpora(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_corpora` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the project from which to list corpora.
            #   @param page_size [::Integer]
            #     Requested page size. API may return fewer results than requested.
            #     If negative, INVALID_ARGUMENT error will be returned.
            #     If unspecified or 0, API will pick a default size, which is 10.
            #     If the requested page size is larger than the maximum size, API will pick
            #     use the maximum size, which is 20.
            #   @param page_token [::String]
            #     A token identifying a page of results for the server to return.
            #     Typically obtained via
            #     {::Google::Cloud::VisionAI::V1::ListCorporaResponse#next_page_token ListCorporaResponse.next_page_token}
            #     of the previous
            #     {::Google::Cloud::VisionAI::V1::Warehouse::Client#list_corpora Warehouse.ListCorpora}
            #     call.
            #   @param filter [::String]
            #     The filter applied to the returned corpora list.
            #     Only the following restrictions are supported:
            #     `type=<Corpus.Type>`,
            #     `type!=<Corpus.Type>`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Corpus>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Corpus>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListCorporaRequest.new
            #
            #   # Call the list_corpora method.
            #   result = client.list_corpora request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::Corpus.
            #     p item
            #   end
            #
            def list_corpora request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListCorporaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_corpora.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_corpora.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_corpora.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_corpora, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_corpora, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a corpus only if its empty.
            # Returns empty response.
            #
            # @overload delete_corpus(request, options = nil)
            #   Pass arguments to `delete_corpus` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteCorpusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteCorpusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_corpus(name: nil)
            #   Pass arguments to `delete_corpus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the corpus to delete.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteCorpusRequest.new
            #
            #   # Call the delete_corpus method.
            #   result = client.delete_corpus request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_corpus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteCorpusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_corpus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_corpus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_corpus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_corpus, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Analyzes a corpus.
            #
            # @overload analyze_corpus(request, options = nil)
            #   Pass arguments to `analyze_corpus` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload analyze_corpus(name: nil)
            #   Pass arguments to `analyze_corpus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The parent corpus resource where the assets will be analyzed.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest.new
            #
            #   # Call the analyze_corpus method.
            #   result = client.analyze_corpus request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def analyze_corpus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::AnalyzeCorpusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.analyze_corpus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.analyze_corpus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.analyze_corpus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :analyze_corpus, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates data schema inside corpus.
            #
            # @overload create_data_schema(request, options = nil)
            #   Pass arguments to `create_data_schema` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_schema(parent: nil, data_schema: nil)
            #   Pass arguments to `create_data_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this data schema will be created.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #   @param data_schema [::Google::Cloud::VisionAI::V1::DataSchema, ::Hash]
            #     Required. The data schema to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::DataSchema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::DataSchema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateDataSchemaRequest.new
            #
            #   # Call the create_data_schema method.
            #   result = client.create_data_schema request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::DataSchema.
            #   p result
            #
            def create_data_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateDataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_data_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates data schema inside corpus.
            #
            # @overload update_data_schema(request, options = nil)
            #   Pass arguments to `update_data_schema` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_schema(data_schema: nil, update_mask: nil)
            #   Pass arguments to `update_data_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param data_schema [::Google::Cloud::VisionAI::V1::DataSchema, ::Hash]
            #     Required. The data schema's `name` field is used to identify the data
            #     schema to be updated. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::DataSchema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::DataSchema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest.new
            #
            #   # Call the update_data_schema method.
            #   result = client.update_data_schema request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::DataSchema.
            #   p result
            #
            def update_data_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateDataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_schema&.name
                header_params["data_schema.name"] = request.data_schema.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_data_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets data schema inside corpus.
            #
            # @overload get_data_schema(request, options = nil)
            #   Pass arguments to `get_data_schema` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetDataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetDataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_schema(name: nil)
            #   Pass arguments to `get_data_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the data schema to retrieve.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::DataSchema]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::DataSchema]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetDataSchemaRequest.new
            #
            #   # Call the get_data_schema method.
            #   result = client.get_data_schema request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::DataSchema.
            #   p result
            #
            def get_data_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetDataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_data_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes data schema inside corpus.
            #
            # @overload delete_data_schema(request, options = nil)
            #   Pass arguments to `delete_data_schema` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_schema(name: nil)
            #   Pass arguments to `delete_data_schema` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the data schema to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest.new
            #
            #   # Call the delete_data_schema method.
            #   result = client.delete_data_schema request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_data_schema request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteDataSchemaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_schema.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_schema.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_schema.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_data_schema, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists a list of data schemas inside corpus.
            #
            # @overload list_data_schemas(request, options = nil)
            #   Pass arguments to `list_data_schemas` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListDataSchemasRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListDataSchemasRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_schemas(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_data_schemas` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of data schemas.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #   @param page_size [::Integer]
            #     The maximum number of data schemas to return. The service may return fewer
            #     than this value. If unspecified, at most 50 data schemas will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListDataSchemas` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListDataSchemas` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::DataSchema>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::DataSchema>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListDataSchemasRequest.new
            #
            #   # Call the list_data_schemas method.
            #   result = client.list_data_schemas request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::DataSchema.
            #     p item
            #   end
            #
            def list_data_schemas request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListDataSchemasRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_schemas.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_schemas.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_schemas.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_data_schemas, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_data_schemas, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates annotation inside asset.
            #
            # @overload create_annotation(request, options = nil)
            #   Pass arguments to `create_annotation` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateAnnotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateAnnotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_annotation(parent: nil, annotation: nil, annotation_id: nil)
            #   Pass arguments to `create_annotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this annotation will be created.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param annotation [::Google::Cloud::VisionAI::V1::Annotation, ::Hash]
            #     Required. The annotation to create.
            #   @param annotation_id [::String]
            #     Optional. The ID to use for the annotation, which will become the final
            #     component of the annotation's resource name if user choose to specify.
            #     Otherwise, annotation id will be generated by system.
            #
            #     This value should be up to 63 characters, and valid characters
            #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
            #     a letter or a number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Annotation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Annotation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateAnnotationRequest.new
            #
            #   # Call the create_annotation method.
            #   result = client.create_annotation request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Annotation.
            #   p result
            #
            def create_annotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateAnnotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_annotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_annotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_annotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_annotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Reads annotation inside asset.
            #
            # @overload get_annotation(request, options = nil)
            #   Pass arguments to `get_annotation` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetAnnotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetAnnotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_annotation(name: nil)
            #   Pass arguments to `get_annotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the annotation to retrieve.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Annotation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Annotation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetAnnotationRequest.new
            #
            #   # Call the get_annotation method.
            #   result = client.get_annotation request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Annotation.
            #   p result
            #
            def get_annotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetAnnotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_annotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_annotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_annotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_annotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists a list of annotations inside asset.
            #
            # @overload list_annotations(request, options = nil)
            #   Pass arguments to `list_annotations` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListAnnotationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListAnnotationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_annotations(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_annotations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     The parent, which owns this collection of annotations.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
            #   @param page_size [::Integer]
            #     The maximum number of annotations to return. The service may return fewer
            #     than this value. If unspecified, at most 50 annotations will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListAnnotations` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListAnnotations` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     The filter applied to the returned list.
            #     We only support filtering for the following fields:
            #     For corpus of STREAM_VIDEO type:
            #     `partition.temporal_partition.start_time`,
            #     `partition.temporal_partition.end_time`, and `key`.
            #     For corpus of VIDEO_ON_DEMAND type,
            #     `partition.relative_temporal_partition.start_offset`,
            #     `partition.relative_temporal_partition.end_offset`, and `key`.
            #     For corpus of IMAGE type, only `key` is supported.
            #     Timestamps are specified in the RFC-3339 format, and only one restriction
            #     may be applied per field, joined by conjunctions.
            #     Format:
            #     "partition.temporal_partition.start_time > "2012-04-21T11:30:00-04:00" AND
            #     partition.temporal_partition.end_time < "2012-04-22T11:30:00-04:00" AND
            #     key = "example_key""
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Annotation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Annotation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListAnnotationsRequest.new
            #
            #   # Call the list_annotations method.
            #   result = client.list_annotations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::Annotation.
            #     p item
            #   end
            #
            def list_annotations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListAnnotationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_annotations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_annotations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_annotations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_annotations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_annotations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates annotation inside asset.
            #
            # @overload update_annotation(request, options = nil)
            #   Pass arguments to `update_annotation` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_annotation(annotation: nil, update_mask: nil)
            #   Pass arguments to `update_annotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param annotation [::Google::Cloud::VisionAI::V1::Annotation, ::Hash]
            #     Required. The annotation to update.
            #     The annotation's `name` field is used to identify the annotation to be
            #     updated. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Annotation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Annotation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateAnnotationRequest.new
            #
            #   # Call the update_annotation method.
            #   result = client.update_annotation request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Annotation.
            #   p result
            #
            def update_annotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateAnnotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_annotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.annotation&.name
                header_params["annotation.name"] = request.annotation.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_annotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_annotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_annotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes annotation inside asset.
            #
            # @overload delete_annotation(request, options = nil)
            #   Pass arguments to `delete_annotation` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_annotation(name: nil)
            #   Pass arguments to `delete_annotation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the annotation to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteAnnotationRequest.new
            #
            #   # Call the delete_annotation method.
            #   result = client.delete_annotation request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_annotation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteAnnotationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_annotation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_annotation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_annotation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_annotation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Ingests data for the asset. It is not allowed to ingest a data chunk which
            # is already expired according to TTL.
            # This method is only available via the gRPC API (not HTTP since
            # bi-directional streaming is not supported via HTTP).
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::VisionAI::V1::IngestAssetRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::VisionAI::V1::IngestAssetRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::VisionAI::V1::IngestAssetResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::VisionAI::V1::IngestAssetResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the ingest_asset method to start streaming.
            #   output = client.ingest_asset input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::VisionAI::V1::IngestAssetRequest.new
            #   input << Google::Cloud::VisionAI::V1::IngestAssetRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::VisionAI::V1::IngestAssetResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def ingest_asset request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::VisionAI::V1::IngestAssetRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.ingest_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.ingest_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.ingest_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :ingest_asset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Supported by STREAM_VIDEO corpus type.
            # Generates clips for downloading. The api takes in a time range, and
            # generates a clip of the first content available after start_time and
            # before end_time, which may overflow beyond these bounds.
            # Returned clips are truncated if the total size of the clips are larger
            # than 100MB.
            #
            # @overload clip_asset(request, options = nil)
            #   Pass arguments to `clip_asset` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ClipAssetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ClipAssetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload clip_asset(name: nil, temporal_partition: nil)
            #   Pass arguments to `clip_asset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to request clips for.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param temporal_partition [::Google::Cloud::VisionAI::V1::Partition::TemporalPartition, ::Hash]
            #     Required. The time range to request clips for.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::ClipAssetResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::ClipAssetResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ClipAssetRequest.new
            #
            #   # Call the clip_asset method.
            #   result = client.clip_asset request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::ClipAssetResponse.
            #   p result
            #
            def clip_asset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ClipAssetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.clip_asset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.clip_asset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.clip_asset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :clip_asset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates a uri for an HLS manifest. The api takes in a collection of time
            # ranges, and generates a URI for an HLS manifest that covers all the
            # requested time ranges.
            #
            # @overload generate_hls_uri(request, options = nil)
            #   Pass arguments to `generate_hls_uri` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_hls_uri(name: nil, temporal_partitions: nil, live_view_enabled: nil)
            #   Pass arguments to `generate_hls_uri` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the asset to request clips for.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
            #   @param temporal_partitions [::Array<::Google::Cloud::VisionAI::V1::Partition::TemporalPartition, ::Hash>]
            #     The time range to request clips for. Will be ignored if `get_live_view` is
            #     set to True. The total time range requested should be smaller than 24h.
            #   @param live_view_enabled [::Boolean]
            #     Option to exclusively show a livestream of the asset with up to 3 minutes
            #     of backlog data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::GenerateHlsUriResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::GenerateHlsUriResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GenerateHlsUriRequest.new
            #
            #   # Call the generate_hls_uri method.
            #   result = client.generate_hls_uri request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::GenerateHlsUriResponse.
            #   p result
            #
            def generate_hls_uri request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GenerateHlsUriRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_hls_uri.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_hls_uri.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_hls_uri.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :generate_hls_uri, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports assets (images plus annotations) from a meta file on cloud storage.
            # Each row in the meta file is corresponding to an image (specified by a
            # cloud storage uri) and its annotations.
            #
            # @overload import_assets(request, options = nil)
            #   Pass arguments to `import_assets` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ImportAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ImportAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_assets(assets_gcs_uri: nil, parent: nil)
            #   Pass arguments to `import_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param assets_gcs_uri [::String]
            #     The file contains all assets information to be imported.
            #     * The file is in JSONL format.
            #     * Each line corresponding to one asset.
            #     * Each line will be converted into InputImageAsset proto.
            #   @param parent [::String]
            #     Required. The parent corpus resource where the assets will be imported.
            #     Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ImportAssetsRequest.new
            #
            #   # Call the import_assets method.
            #   result = client.import_assets request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ImportAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :import_assets, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a search configuration inside a corpus.
            #
            # Please follow the rules below to create a valid CreateSearchConfigRequest.
            # --- General Rules ---
            # 1. Request.search_config_id must not be associated with an existing
            #    SearchConfig.
            # 2. Request must contain at least one non-empty search_criteria_property or
            #    facet_property.
            # 3. mapped_fields must not be empty, and must map to existing UGA keys.
            # 4. All mapped_fields must be of the same type.
            # 5. All mapped_fields must share the same granularity.
            # 6. All mapped_fields must share the same semantic SearchConfig match
            #    options.
            # For property-specific rules, please reference the comments for
            # FacetProperty and SearchCriteriaProperty.
            #
            # @overload create_search_config(request, options = nil)
            #   Pass arguments to `create_search_config` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_search_config(parent: nil, search_config: nil, search_config_id: nil)
            #   Pass arguments to `create_search_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this search configuration will be
            #     created. Format:
            #     `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
            #   @param search_config [::Google::Cloud::VisionAI::V1::SearchConfig, ::Hash]
            #     Required. The search config to create.
            #   @param search_config_id [::String]
            #     Required. ID to use for the new search config. Will become the final
            #     component of the SearchConfig's resource name. This value should be up to
            #     63 characters, and valid characters are /[a-z][0-9]-_/. The first character
            #     must be a letter, the last could be a letter or a number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateSearchConfigRequest.new
            #
            #   # Call the create_search_config method.
            #   result = client.create_search_config request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchConfig.
            #   p result
            #
            def create_search_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateSearchConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_search_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_search_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_search_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_search_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a search configuration inside a corpus.
            #
            # Please follow the rules below to create a valid UpdateSearchConfigRequest.
            # --- General Rules ---
            # 1. Request.search_configuration.name must already exist.
            # 2. Request must contain at least one non-empty search_criteria_property or
            # facet_property.
            # 3. mapped_fields must not be empty, and must map to existing UGA keys.
            # 4. All mapped_fields must be of the same type.
            # 5. All mapped_fields must share the same granularity.
            # 6. All mapped_fields must share the same semantic SearchConfig match
            #    options.
            # For property-specific rules, please reference the comments for
            # FacetProperty and SearchCriteriaProperty.
            #
            # @overload update_search_config(request, options = nil)
            #   Pass arguments to `update_search_config` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_search_config(search_config: nil, update_mask: nil)
            #   Pass arguments to `update_search_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param search_config [::Google::Cloud::VisionAI::V1::SearchConfig, ::Hash]
            #     Required. The search configuration to update.
            #
            #     The search configuration's `name` field is used to identify the resource to
            #     be updated. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated. If left unset, all field paths will be
            #     updated/overwritten.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest.new
            #
            #   # Call the update_search_config method.
            #   result = client.update_search_config request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchConfig.
            #   p result
            #
            def update_search_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateSearchConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_search_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.search_config&.name
                header_params["search_config.name"] = request.search_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_search_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_search_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_search_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a search configuration inside a corpus.
            #
            # @overload get_search_config(request, options = nil)
            #   Pass arguments to `get_search_config` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetSearchConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetSearchConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_search_config(name: nil)
            #   Pass arguments to `get_search_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the search configuration to retrieve.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetSearchConfigRequest.new
            #
            #   # Call the get_search_config method.
            #   result = client.get_search_config request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchConfig.
            #   p result
            #
            def get_search_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetSearchConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_search_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_search_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_search_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_search_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a search configuration inside a corpus.
            #
            # For a DeleteSearchConfigRequest to be valid,
            # Request.search_configuration.name must already exist.
            #
            # @overload delete_search_config(request, options = nil)
            #   Pass arguments to `delete_search_config` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_search_config(name: nil)
            #   Pass arguments to `delete_search_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the search configuration to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest.new
            #
            #   # Call the delete_search_config method.
            #   result = client.delete_search_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_search_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteSearchConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_search_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_search_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_search_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_search_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all search configurations inside a corpus.
            #
            # @overload list_search_configs(request, options = nil)
            #   Pass arguments to `list_search_configs` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_search_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_search_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of search configurations.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param page_size [::Integer]
            #     The maximum number of search configurations to return. The service may
            #     return fewer than this value. If unspecified, a page size of 50 will be
            #     used. The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListSearchConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListSearchConfigs` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListSearchConfigsRequest.new
            #
            #   # Call the list_search_configs method.
            #   result = client.list_search_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::SearchConfig.
            #     p item
            #   end
            #
            def list_search_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListSearchConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_search_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_search_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_search_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_search_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_search_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a SearchHypernym inside a corpus.
            #
            # @overload create_search_hypernym(request, options = nil)
            #   Pass arguments to `create_search_hypernym` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_search_hypernym(parent: nil, search_hypernym: nil, search_hypernym_id: nil)
            #   Pass arguments to `create_search_hypernym` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this SearchHypernym will be created.
            #     Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param search_hypernym [::Google::Cloud::VisionAI::V1::SearchHypernym, ::Hash]
            #     Required. The SearchHypernym to create.
            #   @param search_hypernym_id [::String]
            #     Optional. The search hypernym id.
            #     If omitted, a random UUID will be generated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchHypernym]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchHypernym]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest.new
            #
            #   # Call the create_search_hypernym method.
            #   result = client.create_search_hypernym request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchHypernym.
            #   p result
            #
            def create_search_hypernym request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateSearchHypernymRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_search_hypernym.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_search_hypernym.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_search_hypernym.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_search_hypernym, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a SearchHypernym inside a corpus.
            #
            # @overload update_search_hypernym(request, options = nil)
            #   Pass arguments to `update_search_hypernym` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_search_hypernym(search_hypernym: nil, update_mask: nil)
            #   Pass arguments to `update_search_hypernym` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param search_hypernym [::Google::Cloud::VisionAI::V1::SearchHypernym, ::Hash]
            #     Required. The SearchHypernym to update.
            #     The search hypernym's `name` field is used to identify the search hypernym
            #     to be updated. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated. If left unset, all field paths will be
            #     updated/overwritten.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchHypernym]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchHypernym]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest.new
            #
            #   # Call the update_search_hypernym method.
            #   result = client.update_search_hypernym request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchHypernym.
            #   p result
            #
            def update_search_hypernym request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateSearchHypernymRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_search_hypernym.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.search_hypernym&.name
                header_params["search_hypernym.name"] = request.search_hypernym.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_search_hypernym.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_search_hypernym.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_search_hypernym, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a SearchHypernym inside a corpus.
            #
            # @overload get_search_hypernym(request, options = nil)
            #   Pass arguments to `get_search_hypernym` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_search_hypernym(name: nil)
            #   Pass arguments to `get_search_hypernym` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the SearchHypernym to retrieve.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::SearchHypernym]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::SearchHypernym]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetSearchHypernymRequest.new
            #
            #   # Call the get_search_hypernym method.
            #   result = client.get_search_hypernym request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::SearchHypernym.
            #   p result
            #
            def get_search_hypernym request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetSearchHypernymRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_search_hypernym.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_search_hypernym.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_search_hypernym.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_search_hypernym, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a SearchHypernym inside a corpus.
            #
            # @overload delete_search_hypernym(request, options = nil)
            #   Pass arguments to `delete_search_hypernym` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_search_hypernym(name: nil)
            #   Pass arguments to `delete_search_hypernym` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the SearchHypernym to delete.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest.new
            #
            #   # Call the delete_search_hypernym method.
            #   result = client.delete_search_hypernym request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_search_hypernym request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteSearchHypernymRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_search_hypernym.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_search_hypernym.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_search_hypernym.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_search_hypernym, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists SearchHypernyms inside a corpus.
            #
            # @overload list_search_hypernyms(request, options = nil)
            #   Pass arguments to `list_search_hypernyms` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_search_hypernyms(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_search_hypernyms` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of SearchHypernyms.
            #     Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param page_size [::Integer]
            #     The maximum number of SearchHypernyms returned. The service may
            #     return fewer than this value. If unspecified, a page size of 50 will be
            #     used. The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `SearchHypernym` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `SearchHypernym` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchHypernym>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchHypernym>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest.new
            #
            #   # Call the list_search_hypernyms method.
            #   result = client.list_search_hypernyms request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::SearchHypernym.
            #     p item
            #   end
            #
            def list_search_hypernyms request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListSearchHypernymsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_search_hypernyms.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_search_hypernyms.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_search_hypernyms.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_search_hypernyms, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_search_hypernyms, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Search media asset.
            #
            # @overload search_assets(request, options = nil)
            #   Pass arguments to `search_assets` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::SearchAssetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::SearchAssetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_assets(schema_key_sorting_strategy: nil, corpus: nil, page_size: nil, page_token: nil, content_time_ranges: nil, criteria: nil, facet_selections: nil, result_annotation_keys: nil, search_query: nil)
            #   Pass arguments to `search_assets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param schema_key_sorting_strategy [::Google::Cloud::VisionAI::V1::SchemaKeySortingStrategy, ::Hash]
            #     Sort by the value under the data schema key.
            #   @param corpus [::String]
            #     Required. The parent corpus to search.
            #     Format: `projects/{project_id}/locations/{location_id}/corpora/{corpus_id}`
            #   @param page_size [::Integer]
            #     The number of results to be returned in this page. If it's 0, the server
            #     will decide the appropriate page_size.
            #   @param page_token [::String]
            #     The continuation token to fetch the next page. If empty, it means it is
            #     fetching the first page.
            #   @param content_time_ranges [::Google::Cloud::VisionAI::V1::DateTimeRangeArray, ::Hash]
            #     Time ranges that matching video content must fall within. If no ranges are
            #     provided, there will be no time restriction. This field is treated just
            #     like the criteria below, but defined separately for convenience as it is
            #     used frequently. Note that if the end_time is in the future, it will be
            #     clamped to the time the request was received.
            #   @param criteria [::Array<::Google::Cloud::VisionAI::V1::Criteria, ::Hash>]
            #     Criteria applied to search results.
            #   @param facet_selections [::Array<::Google::Cloud::VisionAI::V1::FacetGroup, ::Hash>]
            #     Stores most recent facet selection state. Only facet groups with user's
            #     selection will be presented here. Selection state is either selected or
            #     unselected. Only selected facet buckets will be used as search criteria.
            #   @param result_annotation_keys [::Array<::String>]
            #     A list of annotation keys to specify the annotations to be retrieved and
            #     returned with each search result.
            #     Annotation granularity must be GRANULARITY_ASSET_LEVEL and its search
            #     strategy must not be NO_SEARCH.
            #   @param search_query [::String]
            #     Global search query. Allows user to search assets without needing to
            #     specify which field the value belongs to.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchResultItem>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchResultItem>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::SearchAssetsRequest.new
            #
            #   # Call the search_assets method.
            #   result = client.search_assets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::SearchResultItem.
            #     p item
            #   end
            #
            def search_assets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::SearchAssetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_assets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.corpus
                header_params["corpus"] = request.corpus
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_assets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_assets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :search_assets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :search_assets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Search a deployed index endpoint (IMAGE corpus type only).
            #
            # @overload search_index_endpoint(request, options = nil)
            #   Pass arguments to `search_index_endpoint` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_index_endpoint(image_query: nil, text_query: nil, index_endpoint: nil, criteria: nil, exclusion_criteria: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_index_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param image_query [::Google::Cloud::VisionAI::V1::ImageQuery, ::Hash]
            #     An image-only query.
            #
            #     Note: The following parameters are mutually exclusive: `image_query`, `text_query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param text_query [::String]
            #     A text-only query.
            #
            #     Note: The following parameters are mutually exclusive: `text_query`, `image_query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param index_endpoint [::String]
            #     Required. The index endpoint to search.
            #     Format:
            #     `projects/{project_id}/locations/{location_id}/indexEndpoints/{index_endpoint_id}`
            #   @param criteria [::Array<::Google::Cloud::VisionAI::V1::Criteria, ::Hash>]
            #     Criteria applied to search results.
            #   @param exclusion_criteria [::Array<::Google::Cloud::VisionAI::V1::Criteria, ::Hash>]
            #     Criteria to exclude from search results.
            #     Note that `fetch_matched_annotations` will be ignored.
            #   @param page_size [::Integer]
            #     Requested page size. API may return fewer results than requested.
            #     If negative, INVALID_ARGUMENT error will be returned.
            #     If unspecified or 0, API will pick a default size, which is 10.
            #     If the requested page size is larger than the maximum size, API will pick
            #     the maximum size, which is 100.
            #   @param page_token [::String]
            #     The continuation token to fetch the next page. If empty, it means it is
            #     fetching the first page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchResultItem>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::SearchResultItem>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest.new
            #
            #   # Call the search_index_endpoint method.
            #   result = client.search_index_endpoint request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::SearchResultItem.
            #     p item
            #   end
            #
            def search_index_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::SearchIndexEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_index_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index_endpoint
                header_params["index_endpoint"] = request.index_endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_index_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_index_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :search_index_endpoint, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :search_index_endpoint, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an IndexEndpoint.
            #
            # @overload create_index_endpoint(request, options = nil)
            #   Pass arguments to `create_index_endpoint` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_index_endpoint(parent: nil, index_endpoint_id: nil, index_endpoint: nil)
            #   Pass arguments to `create_index_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `projects/{project}/locations/{location}`
            #   @param index_endpoint_id [::String]
            #     Optional. The ID to use for the IndexEndpoint, which will become the final
            #     component of the IndexEndpoint's resource name if the user specifies it.
            #     Otherwise, IndexEndpoint id will be autogenerated.
            #
            #     This value should be up to 63 characters, and valid characters
            #     are a-z, 0-9 and dash (-). The first character must be a letter, the last
            #     must be a letter or a number.
            #   @param index_endpoint [::Google::Cloud::VisionAI::V1::IndexEndpoint, ::Hash]
            #     Required. The resource being created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest.new
            #
            #   # Call the create_index_endpoint method.
            #   result = client.create_index_endpoint request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_index_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateIndexEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_index_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_index_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_index_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_index_endpoint, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an IndexEndpoint.
            #
            # @overload get_index_endpoint(request, options = nil)
            #   Pass arguments to `get_index_endpoint` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_index_endpoint(name: nil)
            #   Pass arguments to `get_index_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the IndexEndpoint resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::IndexEndpoint]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::IndexEndpoint]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetIndexEndpointRequest.new
            #
            #   # Call the get_index_endpoint method.
            #   result = client.get_index_endpoint request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::IndexEndpoint.
            #   p result
            #
            def get_index_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetIndexEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_index_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_index_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_index_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_index_endpoint, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all IndexEndpoints in a project.
            #
            # @overload list_index_endpoints(request, options = nil)
            #   Pass arguments to `list_index_endpoints` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_index_endpoints(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_index_endpoints` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Format: `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. The service may return fewer than this value. If unspecified, a
            #     page size of 50 will be used. The maximum value is 1000; values above 1000
            #     will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. The filter applied to the returned list.
            #     We only support filtering for the `deployed_image_index.image_index` field.
            #     However, to filter by a corpus instead of an image index, simply use
            #     `deployed_image_index.corpus`, which will return all endpoints with
            #     `deployed_image_index.image_index` inside of the given corpus.
            #     A basic filter on image index would look like:
            #       deployed_image_index.image_index =
            #         "projects/123/locations/us-central1/corpora/my_corpus/imageIndexes/my_image_index"
            #     A basic filter on corpus would look like:
            #       deployed_image_index.corpus =
            #         "projects/123/locations/us-central1/corpora/my_corpus"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::IndexEndpoint>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::IndexEndpoint>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest.new
            #
            #   # Call the list_index_endpoints method.
            #   result = client.list_index_endpoints request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::IndexEndpoint.
            #     p item
            #   end
            #
            def list_index_endpoints request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListIndexEndpointsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_index_endpoints.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_index_endpoints.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_index_endpoints.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_index_endpoints, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_index_endpoints, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an IndexEndpoint.
            #
            # @overload update_index_endpoint(request, options = nil)
            #   Pass arguments to `update_index_endpoint` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_index_endpoint(index_endpoint: nil, update_mask: nil)
            #   Pass arguments to `update_index_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param index_endpoint [::Google::Cloud::VisionAI::V1::IndexEndpoint, ::Hash]
            #     Required. The resource being updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     IndexEndpoint resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request.
            #     A field of the resource will be overwritten if it is in the mask.
            #     Empty field mask is not allowed.
            #     If the mask is "*", then this is a full replacement of the resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest.new
            #
            #   # Call the update_index_endpoint method.
            #   result = client.update_index_endpoint request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_index_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateIndexEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_index_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index_endpoint&.name
                header_params["index_endpoint.name"] = request.index_endpoint.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_index_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_index_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_index_endpoint, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an IndexEndpoint.
            #
            # @overload delete_index_endpoint(request, options = nil)
            #   Pass arguments to `delete_index_endpoint` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_index_endpoint(name: nil)
            #   Pass arguments to `delete_index_endpoint` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest.new
            #
            #   # Call the delete_index_endpoint method.
            #   result = client.delete_index_endpoint request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_index_endpoint request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteIndexEndpointRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_index_endpoint.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_index_endpoint.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_index_endpoint.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_index_endpoint, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deploys an Index to IndexEndpoint.
            #
            # @overload deploy_index(request, options = nil)
            #   Pass arguments to `deploy_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeployIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeployIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload deploy_index(index_endpoint: nil, deployed_index: nil)
            #   Pass arguments to `deploy_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param index_endpoint [::String]
            #     Required. IndexEndpoint the index is deployed to.
            #     Format:
            #     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
            #   @param deployed_index [::Google::Cloud::VisionAI::V1::DeployedIndex, ::Hash]
            #     Required. Index to deploy.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeployIndexRequest.new
            #
            #   # Call the deploy_index method.
            #   result = client.deploy_index request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def deploy_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeployIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.deploy_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index_endpoint
                header_params["index_endpoint"] = request.index_endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.deploy_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.deploy_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :deploy_index, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeploys an Index from IndexEndpoint.
            #
            # @overload undeploy_index(request, options = nil)
            #   Pass arguments to `undeploy_index` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UndeployIndexRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UndeployIndexRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undeploy_index(index_endpoint: nil)
            #   Pass arguments to `undeploy_index` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param index_endpoint [::String]
            #     Required. Resource name of the IndexEndpoint resource on which the
            #     undeployment will act. Format:
            #     `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UndeployIndexRequest.new
            #
            #   # Call the undeploy_index method.
            #   result = client.undeploy_index request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undeploy_index request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UndeployIndexRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undeploy_index.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.index_endpoint
                header_params["index_endpoint"] = request.index_endpoint
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undeploy_index.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undeploy_index.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :undeploy_index, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a collection.
            #
            # @overload create_collection(request, options = nil)
            #   Pass arguments to `create_collection` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::CreateCollectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::CreateCollectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_collection(parent: nil, collection: nil, collection_id: nil)
            #   Pass arguments to `create_collection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this collection will be created.
            #     Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param collection [::Google::Cloud::VisionAI::V1::Collection, ::Hash]
            #     Required. The collection resource to be created.
            #   @param collection_id [::String]
            #     Optional. The ID to use for the collection, which will become the final
            #     component of the resource name if user choose to specify. Otherwise,
            #     collection id will be generated by system.
            #
            #     This value should be up to 55 characters, and valid characters
            #     are /[a-z][0-9]-/. The first character must be a letter, the last could be
            #     a letter or a number.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::CreateCollectionRequest.new
            #
            #   # Call the create_collection method.
            #   result = client.create_collection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_collection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateCollectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_collection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_collection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_collection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :create_collection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a collection.
            #
            # @overload delete_collection(request, options = nil)
            #   Pass arguments to `delete_collection` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::DeleteCollectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::DeleteCollectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_collection(name: nil)
            #   Pass arguments to `delete_collection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the collection to delete. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::DeleteCollectionRequest.new
            #
            #   # Call the delete_collection method.
            #   result = client.delete_collection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_collection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteCollectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_collection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_collection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_collection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :delete_collection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a collection.
            #
            # @overload get_collection(request, options = nil)
            #   Pass arguments to `get_collection` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::GetCollectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::GetCollectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_collection(name: nil)
            #   Pass arguments to `get_collection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the collection to retrieve. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Collection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Collection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::GetCollectionRequest.new
            #
            #   # Call the get_collection method.
            #   result = client.get_collection request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Collection.
            #   p result
            #
            def get_collection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetCollectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_collection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_collection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_collection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :get_collection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a collection.
            #
            # @overload update_collection(request, options = nil)
            #   Pass arguments to `update_collection` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::UpdateCollectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::UpdateCollectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_collection(collection: nil, update_mask: nil)
            #   Pass arguments to `update_collection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param collection [::Google::Cloud::VisionAI::V1::Collection, ::Hash]
            #     Required. The collection to update.
            #
            #     The collection's `name` field is used to identify the collection to be
            #     updated. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #     - Unset `update_mask` or set `update_mask` to be a single "*" only will
            #       update all updatable fields with the value provided in `collection`.
            #     - To update `display_name` value to empty string, set it in the
            #     `collection`
            #       to empty string, and set `update_mask` with "display_name". Same applies
            #       to other updatable string fields in the `collection`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Collection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Collection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::UpdateCollectionRequest.new
            #
            #   # Call the update_collection method.
            #   result = client.update_collection request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Collection.
            #   p result
            #
            def update_collection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateCollectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_collection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.collection&.name
                header_params["collection.name"] = request.collection.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_collection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_collection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :update_collection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists collections inside a corpus.
            #
            # @overload list_collections(request, options = nil)
            #   Pass arguments to `list_collections` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ListCollectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ListCollectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_collections(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_collections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent corpus. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}`
            #   @param page_size [::Integer]
            #     The maximum number of collections to return. The service may return fewer
            #     than this value. If unspecified, at most 50 collections will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListCollectionsRequest` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListCollectionsRequest`
            #     must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Collection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::Collection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ListCollectionsRequest.new
            #
            #   # Call the list_collections method.
            #   result = client.list_collections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::Collection.
            #     p item
            #   end
            #
            def list_collections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListCollectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_collections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_collections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_collections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :list_collections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :list_collections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Adds an item into a Collection.
            #
            # @overload add_collection_item(request, options = nil)
            #   Pass arguments to `add_collection_item` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::AddCollectionItemRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::AddCollectionItemRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload add_collection_item(item: nil)
            #   Pass arguments to `add_collection_item` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param item [::Google::Cloud::VisionAI::V1::CollectionItem, ::Hash]
            #     Required. The item to be added.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::AddCollectionItemResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::AddCollectionItemResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::AddCollectionItemRequest.new
            #
            #   # Call the add_collection_item method.
            #   result = client.add_collection_item request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::AddCollectionItemResponse.
            #   p result
            #
            def add_collection_item request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::AddCollectionItemRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.add_collection_item.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.item&.collection
                header_params["item.collection"] = request.item.collection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.add_collection_item.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.add_collection_item.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :add_collection_item, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Removes an item from a collection.
            #
            # @overload remove_collection_item(request, options = nil)
            #   Pass arguments to `remove_collection_item` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_collection_item(item: nil)
            #   Pass arguments to `remove_collection_item` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param item [::Google::Cloud::VisionAI::V1::CollectionItem, ::Hash]
            #     Required. The item to be removed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest.new
            #
            #   # Call the remove_collection_item method.
            #   result = client.remove_collection_item request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::RemoveCollectionItemResponse.
            #   p result
            #
            def remove_collection_item request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::RemoveCollectionItemRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_collection_item.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.item&.collection
                header_params["item.collection"] = request.item.collection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_collection_item.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_collection_item.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :remove_collection_item, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # View items inside a collection.
            #
            # @overload view_collection_items(request, options = nil)
            #   Pass arguments to `view_collection_items` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload view_collection_items(collection: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `view_collection_items` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param collection [::String]
            #     Required. The collection to view. Format:
            #     `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
            #   @param page_size [::Integer]
            #     The maximum number of collections to return. The service may return fewer
            #     than this value. If unspecified, at most 50 collections will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ViewCollectionItemsRequest` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ViewCollectionItemsRequest` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::CollectionItem>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VisionAI::V1::CollectionItem>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::Warehouse::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest.new
            #
            #   # Call the view_collection_items method.
            #   result = client.view_collection_items request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VisionAI::V1::CollectionItem.
            #     p item
            #   end
            #
            def view_collection_items request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ViewCollectionItemsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.view_collection_items.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.collection
                header_params["collection"] = request.collection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.view_collection_items.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.view_collection_items.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @warehouse_stub.call_rpc :view_collection_items, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @warehouse_stub, :view_collection_items, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Warehouse API.
            #
            # This class represents the configuration for Warehouse,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::VisionAI::V1::Warehouse::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_asset to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::VisionAI::V1::Warehouse::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_asset.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_asset.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::VisionAI::V1::Warehouse::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "visionai.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Warehouse API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_asset
                ##
                # RPC-specific configuration for `update_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_asset
                ##
                # RPC-specific configuration for `get_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_asset
                ##
                # RPC-specific configuration for `list_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_assets
                ##
                # RPC-specific configuration for `delete_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_asset
                ##
                # RPC-specific configuration for `upload_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upload_asset
                ##
                # RPC-specific configuration for `generate_retrieval_url`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_retrieval_url
                ##
                # RPC-specific configuration for `analyze_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_asset
                ##
                # RPC-specific configuration for `index_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :index_asset
                ##
                # RPC-specific configuration for `remove_index_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_index_asset
                ##
                # RPC-specific configuration for `view_indexed_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :view_indexed_assets
                ##
                # RPC-specific configuration for `create_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_index
                ##
                # RPC-specific configuration for `update_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_index
                ##
                # RPC-specific configuration for `get_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_index
                ##
                # RPC-specific configuration for `list_indexes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_indexes
                ##
                # RPC-specific configuration for `delete_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_index
                ##
                # RPC-specific configuration for `create_corpus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_corpus
                ##
                # RPC-specific configuration for `get_corpus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_corpus
                ##
                # RPC-specific configuration for `update_corpus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_corpus
                ##
                # RPC-specific configuration for `list_corpora`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_corpora
                ##
                # RPC-specific configuration for `delete_corpus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_corpus
                ##
                # RPC-specific configuration for `analyze_corpus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :analyze_corpus
                ##
                # RPC-specific configuration for `create_data_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_schema
                ##
                # RPC-specific configuration for `update_data_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_schema
                ##
                # RPC-specific configuration for `get_data_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_schema
                ##
                # RPC-specific configuration for `delete_data_schema`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_schema
                ##
                # RPC-specific configuration for `list_data_schemas`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_schemas
                ##
                # RPC-specific configuration for `create_annotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_annotation
                ##
                # RPC-specific configuration for `get_annotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_annotation
                ##
                # RPC-specific configuration for `list_annotations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_annotations
                ##
                # RPC-specific configuration for `update_annotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_annotation
                ##
                # RPC-specific configuration for `delete_annotation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_annotation
                ##
                # RPC-specific configuration for `ingest_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :ingest_asset
                ##
                # RPC-specific configuration for `clip_asset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :clip_asset
                ##
                # RPC-specific configuration for `generate_hls_uri`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_hls_uri
                ##
                # RPC-specific configuration for `import_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_assets
                ##
                # RPC-specific configuration for `create_search_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_search_config
                ##
                # RPC-specific configuration for `update_search_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_search_config
                ##
                # RPC-specific configuration for `get_search_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_search_config
                ##
                # RPC-specific configuration for `delete_search_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_search_config
                ##
                # RPC-specific configuration for `list_search_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_search_configs
                ##
                # RPC-specific configuration for `create_search_hypernym`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_search_hypernym
                ##
                # RPC-specific configuration for `update_search_hypernym`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_search_hypernym
                ##
                # RPC-specific configuration for `get_search_hypernym`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_search_hypernym
                ##
                # RPC-specific configuration for `delete_search_hypernym`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_search_hypernym
                ##
                # RPC-specific configuration for `list_search_hypernyms`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_search_hypernyms
                ##
                # RPC-specific configuration for `search_assets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_assets
                ##
                # RPC-specific configuration for `search_index_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_index_endpoint
                ##
                # RPC-specific configuration for `create_index_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_index_endpoint
                ##
                # RPC-specific configuration for `get_index_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_index_endpoint
                ##
                # RPC-specific configuration for `list_index_endpoints`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_index_endpoints
                ##
                # RPC-specific configuration for `update_index_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_index_endpoint
                ##
                # RPC-specific configuration for `delete_index_endpoint`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_index_endpoint
                ##
                # RPC-specific configuration for `deploy_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :deploy_index
                ##
                # RPC-specific configuration for `undeploy_index`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undeploy_index
                ##
                # RPC-specific configuration for `create_collection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_collection
                ##
                # RPC-specific configuration for `delete_collection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_collection
                ##
                # RPC-specific configuration for `get_collection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_collection
                ##
                # RPC-specific configuration for `update_collection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_collection
                ##
                # RPC-specific configuration for `list_collections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_collections
                ##
                # RPC-specific configuration for `add_collection_item`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :add_collection_item
                ##
                # RPC-specific configuration for `remove_collection_item`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_collection_item
                ##
                # RPC-specific configuration for `view_collection_items`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :view_collection_items

                # @private
                def initialize parent_rpcs = nil
                  create_asset_config = parent_rpcs.create_asset if parent_rpcs.respond_to? :create_asset
                  @create_asset = ::Gapic::Config::Method.new create_asset_config
                  update_asset_config = parent_rpcs.update_asset if parent_rpcs.respond_to? :update_asset
                  @update_asset = ::Gapic::Config::Method.new update_asset_config
                  get_asset_config = parent_rpcs.get_asset if parent_rpcs.respond_to? :get_asset
                  @get_asset = ::Gapic::Config::Method.new get_asset_config
                  list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                  @list_assets = ::Gapic::Config::Method.new list_assets_config
                  delete_asset_config = parent_rpcs.delete_asset if parent_rpcs.respond_to? :delete_asset
                  @delete_asset = ::Gapic::Config::Method.new delete_asset_config
                  upload_asset_config = parent_rpcs.upload_asset if parent_rpcs.respond_to? :upload_asset
                  @upload_asset = ::Gapic::Config::Method.new upload_asset_config
                  generate_retrieval_url_config = parent_rpcs.generate_retrieval_url if parent_rpcs.respond_to? :generate_retrieval_url
                  @generate_retrieval_url = ::Gapic::Config::Method.new generate_retrieval_url_config
                  analyze_asset_config = parent_rpcs.analyze_asset if parent_rpcs.respond_to? :analyze_asset
                  @analyze_asset = ::Gapic::Config::Method.new analyze_asset_config
                  index_asset_config = parent_rpcs.index_asset if parent_rpcs.respond_to? :index_asset
                  @index_asset = ::Gapic::Config::Method.new index_asset_config
                  remove_index_asset_config = parent_rpcs.remove_index_asset if parent_rpcs.respond_to? :remove_index_asset
                  @remove_index_asset = ::Gapic::Config::Method.new remove_index_asset_config
                  view_indexed_assets_config = parent_rpcs.view_indexed_assets if parent_rpcs.respond_to? :view_indexed_assets
                  @view_indexed_assets = ::Gapic::Config::Method.new view_indexed_assets_config
                  create_index_config = parent_rpcs.create_index if parent_rpcs.respond_to? :create_index
                  @create_index = ::Gapic::Config::Method.new create_index_config
                  update_index_config = parent_rpcs.update_index if parent_rpcs.respond_to? :update_index
                  @update_index = ::Gapic::Config::Method.new update_index_config
                  get_index_config = parent_rpcs.get_index if parent_rpcs.respond_to? :get_index
                  @get_index = ::Gapic::Config::Method.new get_index_config
                  list_indexes_config = parent_rpcs.list_indexes if parent_rpcs.respond_to? :list_indexes
                  @list_indexes = ::Gapic::Config::Method.new list_indexes_config
                  delete_index_config = parent_rpcs.delete_index if parent_rpcs.respond_to? :delete_index
                  @delete_index = ::Gapic::Config::Method.new delete_index_config
                  create_corpus_config = parent_rpcs.create_corpus if parent_rpcs.respond_to? :create_corpus
                  @create_corpus = ::Gapic::Config::Method.new create_corpus_config
                  get_corpus_config = parent_rpcs.get_corpus if parent_rpcs.respond_to? :get_corpus
                  @get_corpus = ::Gapic::Config::Method.new get_corpus_config
                  update_corpus_config = parent_rpcs.update_corpus if parent_rpcs.respond_to? :update_corpus
                  @update_corpus = ::Gapic::Config::Method.new update_corpus_config
                  list_corpora_config = parent_rpcs.list_corpora if parent_rpcs.respond_to? :list_corpora
                  @list_corpora = ::Gapic::Config::Method.new list_corpora_config
                  delete_corpus_config = parent_rpcs.delete_corpus if parent_rpcs.respond_to? :delete_corpus
                  @delete_corpus = ::Gapic::Config::Method.new delete_corpus_config
                  analyze_corpus_config = parent_rpcs.analyze_corpus if parent_rpcs.respond_to? :analyze_corpus
                  @analyze_corpus = ::Gapic::Config::Method.new analyze_corpus_config
                  create_data_schema_config = parent_rpcs.create_data_schema if parent_rpcs.respond_to? :create_data_schema
                  @create_data_schema = ::Gapic::Config::Method.new create_data_schema_config
                  update_data_schema_config = parent_rpcs.update_data_schema if parent_rpcs.respond_to? :update_data_schema
                  @update_data_schema = ::Gapic::Config::Method.new update_data_schema_config
                  get_data_schema_config = parent_rpcs.get_data_schema if parent_rpcs.respond_to? :get_data_schema
                  @get_data_schema = ::Gapic::Config::Method.new get_data_schema_config
                  delete_data_schema_config = parent_rpcs.delete_data_schema if parent_rpcs.respond_to? :delete_data_schema
                  @delete_data_schema = ::Gapic::Config::Method.new delete_data_schema_config
                  list_data_schemas_config = parent_rpcs.list_data_schemas if parent_rpcs.respond_to? :list_data_schemas
                  @list_data_schemas = ::Gapic::Config::Method.new list_data_schemas_config
                  create_annotation_config = parent_rpcs.create_annotation if parent_rpcs.respond_to? :create_annotation
                  @create_annotation = ::Gapic::Config::Method.new create_annotation_config
                  get_annotation_config = parent_rpcs.get_annotation if parent_rpcs.respond_to? :get_annotation
                  @get_annotation = ::Gapic::Config::Method.new get_annotation_config
                  list_annotations_config = parent_rpcs.list_annotations if parent_rpcs.respond_to? :list_annotations
                  @list_annotations = ::Gapic::Config::Method.new list_annotations_config
                  update_annotation_config = parent_rpcs.update_annotation if parent_rpcs.respond_to? :update_annotation
                  @update_annotation = ::Gapic::Config::Method.new update_annotation_config
                  delete_annotation_config = parent_rpcs.delete_annotation if parent_rpcs.respond_to? :delete_annotation
                  @delete_annotation = ::Gapic::Config::Method.new delete_annotation_config
                  ingest_asset_config = parent_rpcs.ingest_asset if parent_rpcs.respond_to? :ingest_asset
                  @ingest_asset = ::Gapic::Config::Method.new ingest_asset_config
                  clip_asset_config = parent_rpcs.clip_asset if parent_rpcs.respond_to? :clip_asset
                  @clip_asset = ::Gapic::Config::Method.new clip_asset_config
                  generate_hls_uri_config = parent_rpcs.generate_hls_uri if parent_rpcs.respond_to? :generate_hls_uri
                  @generate_hls_uri = ::Gapic::Config::Method.new generate_hls_uri_config
                  import_assets_config = parent_rpcs.import_assets if parent_rpcs.respond_to? :import_assets
                  @import_assets = ::Gapic::Config::Method.new import_assets_config
                  create_search_config_config = parent_rpcs.create_search_config if parent_rpcs.respond_to? :create_search_config
                  @create_search_config = ::Gapic::Config::Method.new create_search_config_config
                  update_search_config_config = parent_rpcs.update_search_config if parent_rpcs.respond_to? :update_search_config
                  @update_search_config = ::Gapic::Config::Method.new update_search_config_config
                  get_search_config_config = parent_rpcs.get_search_config if parent_rpcs.respond_to? :get_search_config
                  @get_search_config = ::Gapic::Config::Method.new get_search_config_config
                  delete_search_config_config = parent_rpcs.delete_search_config if parent_rpcs.respond_to? :delete_search_config
                  @delete_search_config = ::Gapic::Config::Method.new delete_search_config_config
                  list_search_configs_config = parent_rpcs.list_search_configs if parent_rpcs.respond_to? :list_search_configs
                  @list_search_configs = ::Gapic::Config::Method.new list_search_configs_config
                  create_search_hypernym_config = parent_rpcs.create_search_hypernym if parent_rpcs.respond_to? :create_search_hypernym
                  @create_search_hypernym = ::Gapic::Config::Method.new create_search_hypernym_config
                  update_search_hypernym_config = parent_rpcs.update_search_hypernym if parent_rpcs.respond_to? :update_search_hypernym
                  @update_search_hypernym = ::Gapic::Config::Method.new update_search_hypernym_config
                  get_search_hypernym_config = parent_rpcs.get_search_hypernym if parent_rpcs.respond_to? :get_search_hypernym
                  @get_search_hypernym = ::Gapic::Config::Method.new get_search_hypernym_config
                  delete_search_hypernym_config = parent_rpcs.delete_search_hypernym if parent_rpcs.respond_to? :delete_search_hypernym
                  @delete_search_hypernym = ::Gapic::Config::Method.new delete_search_hypernym_config
                  list_search_hypernyms_config = parent_rpcs.list_search_hypernyms if parent_rpcs.respond_to? :list_search_hypernyms
                  @list_search_hypernyms = ::Gapic::Config::Method.new list_search_hypernyms_config
                  search_assets_config = parent_rpcs.search_assets if parent_rpcs.respond_to? :search_assets
                  @search_assets = ::Gapic::Config::Method.new search_assets_config
                  search_index_endpoint_config = parent_rpcs.search_index_endpoint if parent_rpcs.respond_to? :search_index_endpoint
                  @search_index_endpoint = ::Gapic::Config::Method.new search_index_endpoint_config
                  create_index_endpoint_config = parent_rpcs.create_index_endpoint if parent_rpcs.respond_to? :create_index_endpoint
                  @create_index_endpoint = ::Gapic::Config::Method.new create_index_endpoint_config
                  get_index_endpoint_config = parent_rpcs.get_index_endpoint if parent_rpcs.respond_to? :get_index_endpoint
                  @get_index_endpoint = ::Gapic::Config::Method.new get_index_endpoint_config
                  list_index_endpoints_config = parent_rpcs.list_index_endpoints if parent_rpcs.respond_to? :list_index_endpoints
                  @list_index_endpoints = ::Gapic::Config::Method.new list_index_endpoints_config
                  update_index_endpoint_config = parent_rpcs.update_index_endpoint if parent_rpcs.respond_to? :update_index_endpoint
                  @update_index_endpoint = ::Gapic::Config::Method.new update_index_endpoint_config
                  delete_index_endpoint_config = parent_rpcs.delete_index_endpoint if parent_rpcs.respond_to? :delete_index_endpoint
                  @delete_index_endpoint = ::Gapic::Config::Method.new delete_index_endpoint_config
                  deploy_index_config = parent_rpcs.deploy_index if parent_rpcs.respond_to? :deploy_index
                  @deploy_index = ::Gapic::Config::Method.new deploy_index_config
                  undeploy_index_config = parent_rpcs.undeploy_index if parent_rpcs.respond_to? :undeploy_index
                  @undeploy_index = ::Gapic::Config::Method.new undeploy_index_config
                  create_collection_config = parent_rpcs.create_collection if parent_rpcs.respond_to? :create_collection
                  @create_collection = ::Gapic::Config::Method.new create_collection_config
                  delete_collection_config = parent_rpcs.delete_collection if parent_rpcs.respond_to? :delete_collection
                  @delete_collection = ::Gapic::Config::Method.new delete_collection_config
                  get_collection_config = parent_rpcs.get_collection if parent_rpcs.respond_to? :get_collection
                  @get_collection = ::Gapic::Config::Method.new get_collection_config
                  update_collection_config = parent_rpcs.update_collection if parent_rpcs.respond_to? :update_collection
                  @update_collection = ::Gapic::Config::Method.new update_collection_config
                  list_collections_config = parent_rpcs.list_collections if parent_rpcs.respond_to? :list_collections
                  @list_collections = ::Gapic::Config::Method.new list_collections_config
                  add_collection_item_config = parent_rpcs.add_collection_item if parent_rpcs.respond_to? :add_collection_item
                  @add_collection_item = ::Gapic::Config::Method.new add_collection_item_config
                  remove_collection_item_config = parent_rpcs.remove_collection_item if parent_rpcs.respond_to? :remove_collection_item
                  @remove_collection_item = ::Gapic::Config::Method.new remove_collection_item_config
                  view_collection_items_config = parent_rpcs.view_collection_items if parent_rpcs.respond_to? :view_collection_items
                  @view_collection_items = ::Gapic::Config::Method.new view_collection_items_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
