# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/visionai/v1/streams_service_pb"
require "google/cloud/vision_ai/v1/streams_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module VisionAI
      module V1
        module StreamsService
          module Rest
            ##
            # REST client for the StreamsService service.
            #
            # Service describing handlers for resources.
            # Vision API and Vision AI API are two independent APIs developed by the same
            # team. Vision API is for people to annotate their image while Vision AI is an
            # e2e solution for customer to build their own computer vision application.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "visionai.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :streams_service_stub

              ##
              # Configure the StreamsService Client class.
              #
              # See {::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all StreamsService clients
              #   ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "VisionAI", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the StreamsService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @streams_service_stub.universe_domain
              end

              ##
              # Create a new StreamsService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the StreamsService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @streams_service_stub = ::Google::Cloud::VisionAI::V1::StreamsService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @streams_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @streams_service_stub.endpoint
                  config.universe_domain = @streams_service_stub.universe_domain
                  config.logger = @streams_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @streams_service_stub.endpoint
                  config.universe_domain = @streams_service_stub.universe_domain
                  config.logger = @streams_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::VisionAI::V1::StreamsService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @streams_service_stub.logger
              end

              # Service calls

              ##
              # Lists Clusters in a given project and location.
              #
              # @overload list_clusters(request, options = nil)
              #   Pass arguments to `list_clusters` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::ListClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::ListClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListClustersRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Cluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Cluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::ListClustersRequest.new
              #
              #   # Call the list_clusters method.
              #   result = client.list_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VisionAI::V1::Cluster.
              #     p item
              #   end
              #
              def list_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.list_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @streams_service_stub, :list_clusters, "clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Cluster.
              #
              # @overload get_cluster(request, options = nil)
              #   Pass arguments to `get_cluster` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GetClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GetClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cluster(name: nil)
              #   Pass arguments to `get_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VisionAI::V1::Cluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VisionAI::V1::Cluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GetClusterRequest.new
              #
              #   # Call the get_cluster method.
              #   result = client.get_cluster request
              #
              #   # The returned object is of type Google::Cloud::VisionAI::V1::Cluster.
              #   p result
              #
              def get_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.get_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Cluster in a given project and location.
              #
              # @overload create_cluster(request, options = nil)
              #   Pass arguments to `create_cluster` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::CreateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::CreateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil)
              #   Pass arguments to `create_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param cluster_id [::String]
              #     Required. Id of the requesting object.
              #   @param cluster [::Google::Cloud::VisionAI::V1::Cluster, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::CreateClusterRequest.new
              #
              #   # Call the create_cluster method.
              #   result = client.create_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.create_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Cluster.
              #
              # @overload update_cluster(request, options = nil)
              #   Pass arguments to `update_cluster` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::UpdateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::UpdateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_cluster(update_mask: nil, cluster: nil, request_id: nil)
              #   Pass arguments to `update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Cluster resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param cluster [::Google::Cloud::VisionAI::V1::Cluster, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::UpdateClusterRequest.new
              #
              #   # Call the update_cluster method.
              #   result = client.update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.update_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Cluster.
              #
              # @overload delete_cluster(request, options = nil)
              #   Pass arguments to `delete_cluster` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::DeleteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::DeleteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cluster(name: nil, request_id: nil)
              #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::DeleteClusterRequest.new
              #
              #   # Call the delete_cluster method.
              #   result = client.delete_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.delete_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Streams in a given project and location.
              #
              # @overload list_streams(request, options = nil)
              #   Pass arguments to `list_streams` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::ListStreamsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::ListStreamsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_streams(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_streams` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListStreamsRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Stream>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Stream>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::ListStreamsRequest.new
              #
              #   # Call the list_streams method.
              #   result = client.list_streams request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VisionAI::V1::Stream.
              #     p item
              #   end
              #
              def list_streams request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListStreamsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_streams.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_streams.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_streams.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.list_streams request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @streams_service_stub, :list_streams, "streams", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Stream.
              #
              # @overload get_stream(request, options = nil)
              #   Pass arguments to `get_stream` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GetStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GetStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_stream(name: nil)
              #   Pass arguments to `get_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VisionAI::V1::Stream]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VisionAI::V1::Stream]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GetStreamRequest.new
              #
              #   # Call the get_stream method.
              #   result = client.get_stream request
              #
              #   # The returned object is of type Google::Cloud::VisionAI::V1::Stream.
              #   p result
              #
              def get_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.get_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Stream in a given project and location.
              #
              # @overload create_stream(request, options = nil)
              #   Pass arguments to `create_stream` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::CreateStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::CreateStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_stream(parent: nil, stream_id: nil, stream: nil, request_id: nil)
              #   Pass arguments to `create_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param stream_id [::String]
              #     Required. Id of the requesting object.
              #   @param stream [::Google::Cloud::VisionAI::V1::Stream, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::CreateStreamRequest.new
              #
              #   # Call the create_stream method.
              #   result = client.create_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.create_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Stream.
              #
              # @overload update_stream(request, options = nil)
              #   Pass arguments to `update_stream` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::UpdateStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::UpdateStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_stream(update_mask: nil, stream: nil, request_id: nil)
              #   Pass arguments to `update_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Stream resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param stream [::Google::Cloud::VisionAI::V1::Stream, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::UpdateStreamRequest.new
              #
              #   # Call the update_stream method.
              #   result = client.update_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.update_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Stream.
              #
              # @overload delete_stream(request, options = nil)
              #   Pass arguments to `delete_stream` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::DeleteStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::DeleteStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_stream(name: nil, request_id: nil)
              #   Pass arguments to `delete_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::DeleteStreamRequest.new
              #
              #   # Call the delete_stream method.
              #   result = client.delete_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.delete_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the thumbnail (image snapshot) of a single Stream.
              #
              # @overload get_stream_thumbnail(request, options = nil)
              #   Pass arguments to `get_stream_thumbnail` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GetStreamThumbnailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GetStreamThumbnailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_stream_thumbnail(stream: nil, gcs_object_name: nil, event: nil, request_id: nil)
              #   Pass arguments to `get_stream_thumbnail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param stream [::String]
              #     Required. The name of the stream for to get the thumbnail from.
              #   @param gcs_object_name [::String]
              #     Required. The name of the GCS object to store the thumbnail image.
              #   @param event [::String]
              #     Optional. The name of the event. If unspecified, the thumbnail will be
              #     retrieved from the latest event.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify the requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GetStreamThumbnailRequest.new
              #
              #   # Call the get_stream_thumbnail method.
              #   result = client.get_stream_thumbnail request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def get_stream_thumbnail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetStreamThumbnailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_stream_thumbnail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_stream_thumbnail.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_stream_thumbnail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.get_stream_thumbnail request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generate the JWT auth token required to get the stream HLS contents.
              #
              # @overload generate_stream_hls_token(request, options = nil)
              #   Pass arguments to `generate_stream_hls_token` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_stream_hls_token(stream: nil)
              #   Pass arguments to `generate_stream_hls_token` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param stream [::String]
              #     Required. The name of the stream.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenRequest.new
              #
              #   # Call the generate_stream_hls_token method.
              #   result = client.generate_stream_hls_token request
              #
              #   # The returned object is of type Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenResponse.
              #   p result
              #
              def generate_stream_hls_token request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GenerateStreamHlsTokenRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_stream_hls_token.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_stream_hls_token.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_stream_hls_token.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.generate_stream_hls_token request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Events in a given project and location.
              #
              # @overload list_events(request, options = nil)
              #   Pass arguments to `list_events` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::ListEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::ListEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_events(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListEventsRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Event>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Event>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::ListEventsRequest.new
              #
              #   # Call the list_events method.
              #   result = client.list_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VisionAI::V1::Event.
              #     p item
              #   end
              #
              def list_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_events.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.list_events request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @streams_service_stub, :list_events, "events", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Event.
              #
              # @overload get_event(request, options = nil)
              #   Pass arguments to `get_event` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GetEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GetEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_event(name: nil)
              #   Pass arguments to `get_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VisionAI::V1::Event]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VisionAI::V1::Event]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GetEventRequest.new
              #
              #   # Call the get_event method.
              #   result = client.get_event request
              #
              #   # The returned object is of type Google::Cloud::VisionAI::V1::Event.
              #   p result
              #
              def get_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.get_event request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Event in a given project and location.
              #
              # @overload create_event(request, options = nil)
              #   Pass arguments to `create_event` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::CreateEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::CreateEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_event(parent: nil, event_id: nil, event: nil, request_id: nil)
              #   Pass arguments to `create_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param event_id [::String]
              #     Required. Id of the requesting object.
              #   @param event [::Google::Cloud::VisionAI::V1::Event, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::CreateEventRequest.new
              #
              #   # Call the create_event method.
              #   result = client.create_event request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.create_event request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Event.
              #
              # @overload update_event(request, options = nil)
              #   Pass arguments to `update_event` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::UpdateEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::UpdateEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_event(update_mask: nil, event: nil, request_id: nil)
              #   Pass arguments to `update_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Event resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param event [::Google::Cloud::VisionAI::V1::Event, ::Hash]
              #     Required. The resource being updated.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::UpdateEventRequest.new
              #
              #   # Call the update_event method.
              #   result = client.update_event request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.update_event request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Event.
              #
              # @overload delete_event(request, options = nil)
              #   Pass arguments to `delete_event` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::DeleteEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::DeleteEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_event(name: nil, request_id: nil)
              #   Pass arguments to `delete_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::DeleteEventRequest.new
              #
              #   # Call the delete_event method.
              #   result = client.delete_event request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_event.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.delete_event request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Series in a given project and location.
              #
              # @overload list_series(request, options = nil)
              #   Pass arguments to `list_series` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::ListSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::ListSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_series(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListSeriesRequest.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results.
              #   @param order_by [::String]
              #     Hint for how to order the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Series>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::VisionAI::V1::Series>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::ListSeriesRequest.new
              #
              #   # Call the list_series method.
              #   result = client.list_series request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::VisionAI::V1::Series.
              #     p item
              #   end
              #
              def list_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ListSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.list_series request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @streams_service_stub, :list_series, "series", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Series.
              #
              # @overload get_series(request, options = nil)
              #   Pass arguments to `get_series` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::GetSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::GetSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_series(name: nil)
              #   Pass arguments to `get_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::VisionAI::V1::Series]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::VisionAI::V1::Series]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::GetSeriesRequest.new
              #
              #   # Call the get_series method.
              #   result = client.get_series request
              #
              #   # The returned object is of type Google::Cloud::VisionAI::V1::Series.
              #   p result
              #
              def get_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::GetSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.get_series request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Series in a given project and location.
              #
              # @overload create_series(request, options = nil)
              #   Pass arguments to `create_series` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::CreateSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::CreateSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_series(parent: nil, series_id: nil, series: nil, request_id: nil)
              #   Pass arguments to `create_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param series_id [::String]
              #     Required. Id of the requesting object.
              #   @param series [::Google::Cloud::VisionAI::V1::Series, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::CreateSeriesRequest.new
              #
              #   # Call the create_series method.
              #   result = client.create_series request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::CreateSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.create_series request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Event.
              #
              # @overload update_series(request, options = nil)
              #   Pass arguments to `update_series` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::UpdateSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::UpdateSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_series(update_mask: nil, series: nil, request_id: nil)
              #   Pass arguments to `update_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Series resource by the update. The fields specified in the update_mask are
              #     relative to the resource, not the full request. A field will be overwritten
              #     if it is in the mask. If the user does not provide a mask then all fields
              #     will be overwritten.
              #   @param series [::Google::Cloud::VisionAI::V1::Series, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::UpdateSeriesRequest.new
              #
              #   # Call the update_series method.
              #   result = client.update_series request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::UpdateSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.update_series request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Series.
              #
              # @overload delete_series(request, options = nil)
              #   Pass arguments to `delete_series` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::DeleteSeriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::DeleteSeriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_series(name: nil, request_id: nil)
              #   Pass arguments to `delete_series` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::DeleteSeriesRequest.new
              #
              #   # Call the delete_series method.
              #   result = client.delete_series request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_series request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::DeleteSeriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_series.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_series.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_series.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.delete_series request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Materialize a channel.
              #
              # @overload materialize_channel(request, options = nil)
              #   Pass arguments to `materialize_channel` via a request object, either of type
              #   {::Google::Cloud::VisionAI::V1::MaterializeChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::VisionAI::V1::MaterializeChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload materialize_channel(parent: nil, channel_id: nil, channel: nil, request_id: nil)
              #   Pass arguments to `materialize_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param channel_id [::String]
              #     Required. Id of the channel.
              #   @param channel [::Google::Cloud::VisionAI::V1::Channel, ::Hash]
              #     Required. The resource being created.
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision_ai/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::VisionAI::V1::MaterializeChannelRequest.new
              #
              #   # Call the materialize_channel method.
              #   result = client.materialize_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def materialize_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::MaterializeChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.materialize_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::VisionAI::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.materialize_channel.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.materialize_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @streams_service_stub.materialize_channel request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the StreamsService REST API.
              #
              # This class represents the configuration for StreamsService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_clusters to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::VisionAI::V1::StreamsService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_clusters.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "visionai.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the StreamsService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clusters
                  ##
                  # RPC-specific configuration for `get_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster
                  ##
                  # RPC-specific configuration for `create_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cluster
                  ##
                  # RPC-specific configuration for `update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cluster
                  ##
                  # RPC-specific configuration for `delete_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cluster
                  ##
                  # RPC-specific configuration for `list_streams`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_streams
                  ##
                  # RPC-specific configuration for `get_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_stream
                  ##
                  # RPC-specific configuration for `create_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_stream
                  ##
                  # RPC-specific configuration for `update_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_stream
                  ##
                  # RPC-specific configuration for `delete_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_stream
                  ##
                  # RPC-specific configuration for `get_stream_thumbnail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_stream_thumbnail
                  ##
                  # RPC-specific configuration for `generate_stream_hls_token`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_stream_hls_token
                  ##
                  # RPC-specific configuration for `list_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_events
                  ##
                  # RPC-specific configuration for `get_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_event
                  ##
                  # RPC-specific configuration for `create_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_event
                  ##
                  # RPC-specific configuration for `update_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_event
                  ##
                  # RPC-specific configuration for `delete_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_event
                  ##
                  # RPC-specific configuration for `list_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_series
                  ##
                  # RPC-specific configuration for `get_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_series
                  ##
                  # RPC-specific configuration for `create_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_series
                  ##
                  # RPC-specific configuration for `update_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_series
                  ##
                  # RPC-specific configuration for `delete_series`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_series
                  ##
                  # RPC-specific configuration for `materialize_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :materialize_channel

                  # @private
                  def initialize parent_rpcs = nil
                    list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                    @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                    get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                    @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                    create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                    @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                    update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                    @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                    delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                    @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                    list_streams_config = parent_rpcs.list_streams if parent_rpcs.respond_to? :list_streams
                    @list_streams = ::Gapic::Config::Method.new list_streams_config
                    get_stream_config = parent_rpcs.get_stream if parent_rpcs.respond_to? :get_stream
                    @get_stream = ::Gapic::Config::Method.new get_stream_config
                    create_stream_config = parent_rpcs.create_stream if parent_rpcs.respond_to? :create_stream
                    @create_stream = ::Gapic::Config::Method.new create_stream_config
                    update_stream_config = parent_rpcs.update_stream if parent_rpcs.respond_to? :update_stream
                    @update_stream = ::Gapic::Config::Method.new update_stream_config
                    delete_stream_config = parent_rpcs.delete_stream if parent_rpcs.respond_to? :delete_stream
                    @delete_stream = ::Gapic::Config::Method.new delete_stream_config
                    get_stream_thumbnail_config = parent_rpcs.get_stream_thumbnail if parent_rpcs.respond_to? :get_stream_thumbnail
                    @get_stream_thumbnail = ::Gapic::Config::Method.new get_stream_thumbnail_config
                    generate_stream_hls_token_config = parent_rpcs.generate_stream_hls_token if parent_rpcs.respond_to? :generate_stream_hls_token
                    @generate_stream_hls_token = ::Gapic::Config::Method.new generate_stream_hls_token_config
                    list_events_config = parent_rpcs.list_events if parent_rpcs.respond_to? :list_events
                    @list_events = ::Gapic::Config::Method.new list_events_config
                    get_event_config = parent_rpcs.get_event if parent_rpcs.respond_to? :get_event
                    @get_event = ::Gapic::Config::Method.new get_event_config
                    create_event_config = parent_rpcs.create_event if parent_rpcs.respond_to? :create_event
                    @create_event = ::Gapic::Config::Method.new create_event_config
                    update_event_config = parent_rpcs.update_event if parent_rpcs.respond_to? :update_event
                    @update_event = ::Gapic::Config::Method.new update_event_config
                    delete_event_config = parent_rpcs.delete_event if parent_rpcs.respond_to? :delete_event
                    @delete_event = ::Gapic::Config::Method.new delete_event_config
                    list_series_config = parent_rpcs.list_series if parent_rpcs.respond_to? :list_series
                    @list_series = ::Gapic::Config::Method.new list_series_config
                    get_series_config = parent_rpcs.get_series if parent_rpcs.respond_to? :get_series
                    @get_series = ::Gapic::Config::Method.new get_series_config
                    create_series_config = parent_rpcs.create_series if parent_rpcs.respond_to? :create_series
                    @create_series = ::Gapic::Config::Method.new create_series_config
                    update_series_config = parent_rpcs.update_series if parent_rpcs.respond_to? :update_series
                    @update_series = ::Gapic::Config::Method.new update_series_config
                    delete_series_config = parent_rpcs.delete_series if parent_rpcs.respond_to? :delete_series
                    @delete_series = ::Gapic::Config::Method.new delete_series_config
                    materialize_channel_config = parent_rpcs.materialize_channel if parent_rpcs.respond_to? :materialize_channel
                    @materialize_channel = ::Gapic::Config::Method.new materialize_channel_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
