# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        module StreamsService
          # Path helper methods for the StreamsService API.
          module Paths
            ##
            # Create a fully-qualified Channel resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/channels/{channel}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param channel [String]
            #
            # @return [::String]
            def channel_path project:, location:, cluster:, channel:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/channels/#{channel}"
            end

            ##
            # Create a fully-qualified Cluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_path project:, location:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified Event resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/events/{event}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param event [String]
            #
            # @return [::String]
            def event_path project:, location:, cluster:, event:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/events/#{event}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Series resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/series/{series}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param series [String]
            #
            # @return [::String]
            def series_path project:, location:, cluster:, series:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/series/#{series}"
            end

            ##
            # Create a fully-qualified Stream resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param stream [String]
            #
            # @return [::String]
            def stream_path project:, location:, cluster:, stream:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/streams/#{stream}"
            end

            extend self
          end
        end
      end
    end
  end
end
