# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/visionai/v1/streaming_service_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module VisionAI
      module V1
        module StreamingService
          ##
          # Client for the StreamingService service.
          #
          # Streaming service for receiving and sending packets.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "visionai.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :streaming_service_stub

            ##
            # Configure the StreamingService Client class.
            #
            # See {::Google::Cloud::VisionAI::V1::StreamingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all StreamingService clients
            #   ::Google::Cloud::VisionAI::V1::StreamingService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "VisionAI", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the StreamingService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::VisionAI::V1::StreamingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @streaming_service_stub.universe_domain
            end

            ##
            # Create a new StreamingService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the StreamingService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/visionai/v1/streaming_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @streaming_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::VisionAI::V1::StreamingService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @streaming_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @streaming_service_stub.endpoint
                config.universe_domain = @streaming_service_stub.universe_domain
                config.logger = @streaming_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @streaming_service_stub.endpoint
                config.universe_domain = @streaming_service_stub.universe_domain
                config.logger = @streaming_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @streaming_service_stub.logger
            end

            # Service calls

            ##
            # Send packets to the series.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::VisionAI::V1::SendPacketsRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::VisionAI::V1::SendPacketsRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::VisionAI::V1::SendPacketsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::VisionAI::V1::SendPacketsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the send_packets method to start streaming.
            #   output = client.send_packets input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::VisionAI::V1::SendPacketsRequest.new
            #   input << Google::Cloud::VisionAI::V1::SendPacketsRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::VisionAI::V1::SendPacketsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def send_packets request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::VisionAI::V1::SendPacketsRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.send_packets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.send_packets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.send_packets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :send_packets, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Receive packets from the series.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::VisionAI::V1::ReceivePacketsRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::VisionAI::V1::ReceivePacketsRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::VisionAI::V1::ReceivePacketsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::VisionAI::V1::ReceivePacketsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the receive_packets method to start streaming.
            #   output = client.receive_packets input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new
            #   input << Google::Cloud::VisionAI::V1::ReceivePacketsRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::VisionAI::V1::ReceivePacketsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def receive_packets request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::VisionAI::V1::ReceivePacketsRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.receive_packets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.receive_packets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.receive_packets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :receive_packets, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Receive events given the stream name.
            #
            # @param request [::Gapic::StreamInput, ::Enumerable<::Google::Cloud::VisionAI::V1::ReceiveEventsRequest, ::Hash>]
            #   An enumerable of {::Google::Cloud::VisionAI::V1::ReceiveEventsRequest} instances.
            # @param options [::Gapic::CallOptions, ::Hash]
            #   Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::VisionAI::V1::ReceiveEventsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::VisionAI::V1::ReceiveEventsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create an input stream.
            #   input = Gapic::StreamInput.new
            #
            #   # Call the receive_events method to start streaming.
            #   output = client.receive_events input
            #
            #   # Send requests on the stream. For each request object, set fields by
            #   # passing keyword arguments. Be sure to close the stream when done.
            #   input << Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new
            #   input << Google::Cloud::VisionAI::V1::ReceiveEventsRequest.new
            #   input.close
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::VisionAI::V1::ReceiveEventsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def receive_events request, options = nil
              unless request.is_a? ::Enumerable
                raise ::ArgumentError, "request must be an Enumerable" unless request.respond_to? :to_enum
                request = request.to_enum
              end

              request = request.lazy.map do |req|
                ::Gapic::Protobuf.coerce req, to: ::Google::Cloud::VisionAI::V1::ReceiveEventsRequest
              end

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.receive_events.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.receive_events.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.receive_events.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :receive_events, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # AcquireLease acquires a lease.
            #
            # @overload acquire_lease(request, options = nil)
            #   Pass arguments to `acquire_lease` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::AcquireLeaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::AcquireLeaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload acquire_lease(series: nil, owner: nil, term: nil, lease_type: nil)
            #   Pass arguments to `acquire_lease` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param series [::String]
            #     The series name.
            #   @param owner [::String]
            #     The owner name.
            #   @param term [::Google::Protobuf::Duration, ::Hash]
            #     The lease term.
            #   @param lease_type [::Google::Cloud::VisionAI::V1::LeaseType]
            #     The lease type.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Lease]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Lease]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::AcquireLeaseRequest.new
            #
            #   # Call the acquire_lease method.
            #   result = client.acquire_lease request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Lease.
            #   p result
            #
            def acquire_lease request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::AcquireLeaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.acquire_lease.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.series
                header_params["series"] = request.series
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.acquire_lease.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.acquire_lease.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :acquire_lease, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # RenewLease renews a lease.
            #
            # @overload renew_lease(request, options = nil)
            #   Pass arguments to `renew_lease` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::RenewLeaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::RenewLeaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload renew_lease(id: nil, series: nil, owner: nil, term: nil)
            #   Pass arguments to `renew_lease` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param id [::String]
            #     Lease id.
            #   @param series [::String]
            #     Series name.
            #   @param owner [::String]
            #     Lease owner.
            #   @param term [::Google::Protobuf::Duration, ::Hash]
            #     Lease term.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::Lease]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::Lease]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::RenewLeaseRequest.new
            #
            #   # Call the renew_lease method.
            #   result = client.renew_lease request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::Lease.
            #   p result
            #
            def renew_lease request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::RenewLeaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.renew_lease.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.series
                header_params["series"] = request.series
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.renew_lease.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.renew_lease.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :renew_lease, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # RleaseLease releases a lease.
            #
            # @overload release_lease(request, options = nil)
            #   Pass arguments to `release_lease` via a request object, either of type
            #   {::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload release_lease(id: nil, series: nil, owner: nil)
            #   Pass arguments to `release_lease` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param id [::String]
            #     Lease id.
            #   @param series [::String]
            #     Series name.
            #   @param owner [::String]
            #     Lease owner.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VisionAI::V1::ReleaseLeaseResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VisionAI::V1::ReleaseLeaseResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vision_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VisionAI::V1::StreamingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VisionAI::V1::ReleaseLeaseRequest.new
            #
            #   # Call the release_lease method.
            #   result = client.release_lease request
            #
            #   # The returned object is of type Google::Cloud::VisionAI::V1::ReleaseLeaseResponse.
            #   p result
            #
            def release_lease request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VisionAI::V1::ReleaseLeaseRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.release_lease.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VisionAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.series
                header_params["series"] = request.series
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.release_lease.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.release_lease.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @streaming_service_stub.call_rpc :release_lease, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the StreamingService API.
            #
            # This class represents the configuration for StreamingService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::VisionAI::V1::StreamingService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # send_packets to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::VisionAI::V1::StreamingService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.send_packets.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.send_packets.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::VisionAI::V1::StreamingService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "visionai.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the StreamingService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `send_packets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :send_packets
                ##
                # RPC-specific configuration for `receive_packets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :receive_packets
                ##
                # RPC-specific configuration for `receive_events`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :receive_events
                ##
                # RPC-specific configuration for `acquire_lease`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :acquire_lease
                ##
                # RPC-specific configuration for `renew_lease`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :renew_lease
                ##
                # RPC-specific configuration for `release_lease`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :release_lease

                # @private
                def initialize parent_rpcs = nil
                  send_packets_config = parent_rpcs.send_packets if parent_rpcs.respond_to? :send_packets
                  @send_packets = ::Gapic::Config::Method.new send_packets_config
                  receive_packets_config = parent_rpcs.receive_packets if parent_rpcs.respond_to? :receive_packets
                  @receive_packets = ::Gapic::Config::Method.new receive_packets_config
                  receive_events_config = parent_rpcs.receive_events if parent_rpcs.respond_to? :receive_events
                  @receive_events = ::Gapic::Config::Method.new receive_events_config
                  acquire_lease_config = parent_rpcs.acquire_lease if parent_rpcs.respond_to? :acquire_lease
                  @acquire_lease = ::Gapic::Config::Method.new acquire_lease_config
                  renew_lease_config = parent_rpcs.renew_lease if parent_rpcs.respond_to? :renew_lease
                  @renew_lease = ::Gapic::Config::Method.new renew_lease_config
                  release_lease_config = parent_rpcs.release_lease if parent_rpcs.respond_to? :release_lease
                  @release_lease = ::Gapic::Config::Method.new release_lease_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
