# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        module LiveVideoAnalytics
          # Path helper methods for the LiveVideoAnalytics API.
          module Paths
            ##
            # Create a fully-qualified Analysis resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/analyses/{analysis}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param analysis [String]
            #
            # @return [::String]
            def analysis_path project:, location:, cluster:, analysis:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/analyses/#{analysis}"
            end

            ##
            # Create a fully-qualified Cluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_path project:, location:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Operator resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/operators/{operator}`
            #
            # @param project [String]
            # @param location [String]
            # @param operator [String]
            #
            # @return [::String]
            def operator_path project:, location:, operator:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/operators/#{operator}"
            end

            ##
            # Create a fully-qualified Process resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/processes/{process}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param process [String]
            #
            # @return [::String]
            def process_path project:, location:, cluster:, process:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/processes/#{process}"
            end

            extend self
          end
        end
      end
    end
  end
end
