# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VisionAI
      module V1
        module AppPlatform
          # Path helper methods for the AppPlatform API.
          module Paths
            ##
            # Create a fully-qualified Application resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/applications/{application}`
            #
            # @param project [String]
            # @param location [String]
            # @param application [String]
            #
            # @return [::String]
            def application_path project:, location:, application:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/applications/#{application}"
            end

            ##
            # Create a fully-qualified Draft resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/applications/{application}/drafts/{draft}`
            #
            # @param project [String]
            # @param location [String]
            # @param application [String]
            # @param draft [String]
            #
            # @return [::String]
            def draft_path project:, location:, application:, draft:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "application cannot contain /" if application.to_s.include? "/"

              "projects/#{project}/locations/#{location}/applications/#{application}/drafts/#{draft}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/applications/{application}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param application [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, application:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "application cannot contain /" if application.to_s.include? "/"

              "projects/#{project}/locations/#{location}/applications/#{application}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Processor resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/processors/{processor}`
            #
            # @param project [String]
            # @param location [String]
            # @param processor [String]
            #
            # @return [::String]
            def processor_path project:, location:, processor:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/processors/#{processor}"
            end

            ##
            # Create a fully-qualified Stream resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            # @param stream [String]
            #
            # @return [::String]
            def stream_path project:, location:, cluster:, stream:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}/streams/#{stream}"
            end

            extend self
          end
        end
      end
    end
  end
end
