# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/vision/v1p4beta1/product_search_service_pb"
require "google/cloud/vision/v1p4beta1/product_search/rest"


class ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_product_set
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ProductSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    product_set = {}
    product_set_id = "hello world"

    create_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_create_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_product_set({ parent: parent, product_set: product_set, product_set_id: product_set_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_product_set parent: parent, product_set: product_set, product_set_id: product_set_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_product_set ::Google::Cloud::Vision::V1p4beta1::CreateProductSetRequest.new(parent: parent, product_set: product_set, product_set_id: product_set_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_product_set({ parent: parent, product_set: product_set, product_set_id: product_set_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_product_set(::Google::Cloud::Vision::V1p4beta1::CreateProductSetRequest.new(parent: parent, product_set: product_set, product_set_id: product_set_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_product_set_client_stub.call_count
      end
    end
  end

  def test_list_product_sets
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ListProductSetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_product_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_list_product_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_product_sets_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_product_sets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_product_sets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_product_sets ::Google::Cloud::Vision::V1p4beta1::ListProductSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_product_sets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_product_sets(::Google::Cloud::Vision::V1p4beta1::ListProductSetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_product_sets_client_stub.call_count
      end
    end
  end

  def test_get_product_set
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ProductSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_get_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_product_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_product_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_product_set ::Google::Cloud::Vision::V1p4beta1::GetProductSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_product_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_product_set(::Google::Cloud::Vision::V1p4beta1::GetProductSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_product_set_client_stub.call_count
      end
    end
  end

  def test_update_product_set
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ProductSet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product_set = {}
    update_mask = {}

    update_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_update_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_product_set({ product_set: product_set, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_product_set product_set: product_set, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_product_set ::Google::Cloud::Vision::V1p4beta1::UpdateProductSetRequest.new(product_set: product_set, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_product_set({ product_set: product_set, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_product_set(::Google::Cloud::Vision::V1p4beta1::UpdateProductSetRequest.new(product_set: product_set, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_product_set_client_stub.call_count
      end
    end
  end

  def test_delete_product_set
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_delete_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_product_set({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_product_set name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_product_set ::Google::Cloud::Vision::V1p4beta1::DeleteProductSetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_product_set({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_product_set(::Google::Cloud::Vision::V1p4beta1::DeleteProductSetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_product_set_client_stub.call_count
      end
    end
  end

  def test_create_product
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    product = {}
    product_id = "hello world"

    create_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_create_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_product_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_product({ parent: parent, product: product, product_id: product_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_product parent: parent, product: product, product_id: product_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_product ::Google::Cloud::Vision::V1p4beta1::CreateProductRequest.new(parent: parent, product: product, product_id: product_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_product({ parent: parent, product: product, product_id: product_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_product(::Google::Cloud::Vision::V1p4beta1::CreateProductRequest.new(parent: parent, product: product, product_id: product_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_product_client_stub.call_count
      end
    end
  end

  def test_list_products
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ListProductsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_list_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_products_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_products parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_products ::Google::Cloud::Vision::V1p4beta1::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_products({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_products(::Google::Cloud::Vision::V1p4beta1::ListProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_products_client_stub.call_count
      end
    end
  end

  def test_get_product
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_get_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_product_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_product({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_product name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_product ::Google::Cloud::Vision::V1p4beta1::GetProductRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_product({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_product(::Google::Cloud::Vision::V1p4beta1::GetProductRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_product_client_stub.call_count
      end
    end
  end

  def test_update_product
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::Product.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product = {}
    update_mask = {}

    update_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_update_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_product_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_product({ product: product, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_product product: product, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_product ::Google::Cloud::Vision::V1p4beta1::UpdateProductRequest.new(product: product, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_product({ product: product, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_product(::Google::Cloud::Vision::V1p4beta1::UpdateProductRequest.new(product: product, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_product_client_stub.call_count
      end
    end
  end

  def test_delete_product
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_product_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_delete_product_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_product_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_product({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_product name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_product ::Google::Cloud::Vision::V1p4beta1::DeleteProductRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_product({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_product(::Google::Cloud::Vision::V1p4beta1::DeleteProductRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_product_client_stub.call_count
      end
    end
  end

  def test_create_reference_image
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ReferenceImage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    reference_image = {}
    reference_image_id = "hello world"

    create_reference_image_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_create_reference_image_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_reference_image_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_reference_image({ parent: parent, reference_image: reference_image, reference_image_id: reference_image_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_reference_image parent: parent, reference_image: reference_image, reference_image_id: reference_image_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_reference_image ::Google::Cloud::Vision::V1p4beta1::CreateReferenceImageRequest.new(parent: parent, reference_image: reference_image, reference_image_id: reference_image_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_reference_image({ parent: parent, reference_image: reference_image, reference_image_id: reference_image_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_reference_image(::Google::Cloud::Vision::V1p4beta1::CreateReferenceImageRequest.new(parent: parent, reference_image: reference_image, reference_image_id: reference_image_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_reference_image_client_stub.call_count
      end
    end
  end

  def test_delete_reference_image
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_reference_image_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_delete_reference_image_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_reference_image_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_reference_image({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_reference_image name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_reference_image ::Google::Cloud::Vision::V1p4beta1::DeleteReferenceImageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_reference_image({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_reference_image(::Google::Cloud::Vision::V1p4beta1::DeleteReferenceImageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_reference_image_client_stub.call_count
      end
    end
  end

  def test_list_reference_images
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ListReferenceImagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_reference_images_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_list_reference_images_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_reference_images_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_reference_images({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_reference_images parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_reference_images ::Google::Cloud::Vision::V1p4beta1::ListReferenceImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_reference_images({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_reference_images(::Google::Cloud::Vision::V1p4beta1::ListReferenceImagesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_reference_images_client_stub.call_count
      end
    end
  end

  def test_get_reference_image
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ReferenceImage.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_reference_image_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_get_reference_image_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_reference_image_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_reference_image({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_reference_image name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_reference_image ::Google::Cloud::Vision::V1p4beta1::GetReferenceImageRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_reference_image({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_reference_image(::Google::Cloud::Vision::V1p4beta1::GetReferenceImageRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_reference_image_client_stub.call_count
      end
    end
  end

  def test_add_product_to_product_set
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    product = "hello world"

    add_product_to_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_add_product_to_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_product_to_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_product_to_product_set({ name: name, product: product }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_product_to_product_set name: name, product: product do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_product_to_product_set ::Google::Cloud::Vision::V1p4beta1::AddProductToProductSetRequest.new(name: name, product: product) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_product_to_product_set({ name: name, product: product }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_product_to_product_set(::Google::Cloud::Vision::V1p4beta1::AddProductToProductSetRequest.new(name: name, product: product), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_product_to_product_set_client_stub.call_count
      end
    end
  end

  def test_remove_product_from_product_set
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    product = "hello world"

    remove_product_from_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_remove_product_from_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_product_from_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_product_from_product_set({ name: name, product: product }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_product_from_product_set name: name, product: product do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_product_from_product_set ::Google::Cloud::Vision::V1p4beta1::RemoveProductFromProductSetRequest.new(name: name, product: product) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_product_from_product_set({ name: name, product: product }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_product_from_product_set(::Google::Cloud::Vision::V1p4beta1::RemoveProductFromProductSetRequest.new(name: name, product: product), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_product_from_product_set_client_stub.call_count
      end
    end
  end

  def test_list_products_in_product_set
    # Create test objects.
    client_result = ::Google::Cloud::Vision::V1p4beta1::ListProductsInProductSetResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_products_in_product_set_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_list_products_in_product_set_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_products_in_product_set_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_products_in_product_set({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_products_in_product_set name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_products_in_product_set ::Google::Cloud::Vision::V1p4beta1::ListProductsInProductSetRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_products_in_product_set({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_products_in_product_set(::Google::Cloud::Vision::V1p4beta1::ListProductsInProductSetRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_products_in_product_set_client_stub.call_count
      end
    end
  end

  def test_import_product_sets
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    input_config = {}

    import_product_sets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_import_product_sets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_product_sets_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_product_sets({ parent: parent, input_config: input_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_product_sets parent: parent, input_config: input_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_product_sets ::Google::Cloud::Vision::V1p4beta1::ImportProductSetsRequest.new(parent: parent, input_config: input_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_product_sets({ parent: parent, input_config: input_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_product_sets(::Google::Cloud::Vision::V1p4beta1::ImportProductSetsRequest.new(parent: parent, input_config: input_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_product_sets_client_stub.call_count
      end
    end
  end

  def test_purge_products
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    product_set_purge_config = {}
    parent = "hello world"
    force = true

    purge_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::ServiceStub.stub :transcode_purge_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_products_client_stub do
        # Create client
        client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_products({ product_set_purge_config: product_set_purge_config, parent: parent, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_products product_set_purge_config: product_set_purge_config, parent: parent, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_products ::Google::Cloud::Vision::V1p4beta1::PurgeProductsRequest.new(product_set_purge_config: product_set_purge_config, parent: parent, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_products({ product_set_purge_config: product_set_purge_config, parent: parent, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_products(::Google::Cloud::Vision::V1p4beta1::PurgeProductsRequest.new(product_set_purge_config: product_set_purge_config, parent: parent, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_products_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Vision::V1p4beta1::ProductSearch::Rest::Client::Configuration, config
  end
end
