# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/vision/v1/product_search_service_pb"
require "google/cloud/vision/v1/product_search/rest/service_stub"

module Google
  module Cloud
    module Vision
      module V1
        module ProductSearch
          module Rest
            ##
            # REST client for the ProductSearch service.
            #
            # Manages Products and ProductSets of reference images for use in product
            # search. It uses the following resource model:
            #
            # - The API has a collection of {::Google::Cloud::Vision::V1::ProductSet ProductSet}
            # resources, named `projects/*/locations/*/productSets/*`, which acts as a way
            # to put different products into groups to limit identification.
            #
            # In parallel,
            #
            # - The API has a collection of {::Google::Cloud::Vision::V1::Product Product}
            # resources, named
            #   `projects/*/locations/*/products/*`
            #
            # - Each {::Google::Cloud::Vision::V1::Product Product} has a collection of
            # {::Google::Cloud::Vision::V1::ReferenceImage ReferenceImage} resources, named
            #   `projects/*/locations/*/products/*/referenceImages/*`
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "vision.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :product_search_stub

              ##
              # Configure the ProductSearch Client class.
              #
              # See {::Google::Cloud::Vision::V1::ProductSearch::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ProductSearch clients
              #   ::Google::Cloud::Vision::V1::ProductSearch::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Vision", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_product_set.timeout = 600.0
                  default_config.rpcs.create_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: []
                  }

                  default_config.rpcs.list_product_sets.timeout = 600.0
                  default_config.rpcs.list_product_sets.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_product_set.timeout = 600.0
                  default_config.rpcs.get_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_product_set.timeout = 600.0
                  default_config.rpcs.update_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_product_set.timeout = 600.0
                  default_config.rpcs.delete_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_product.timeout = 600.0
                  default_config.rpcs.create_product.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: []
                  }

                  default_config.rpcs.list_products.timeout = 600.0
                  default_config.rpcs.list_products.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_product.timeout = 600.0
                  default_config.rpcs.get_product.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_product.timeout = 600.0
                  default_config.rpcs.update_product.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.delete_product.timeout = 600.0
                  default_config.rpcs.delete_product.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_reference_image.timeout = 600.0
                  default_config.rpcs.create_reference_image.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: []
                  }

                  default_config.rpcs.delete_reference_image.timeout = 600.0
                  default_config.rpcs.delete_reference_image.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_reference_images.timeout = 600.0
                  default_config.rpcs.list_reference_images.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_reference_image.timeout = 600.0
                  default_config.rpcs.get_reference_image.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.add_product_to_product_set.timeout = 600.0
                  default_config.rpcs.add_product_to_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.remove_product_from_product_set.timeout = 600.0
                  default_config.rpcs.remove_product_from_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_products_in_product_set.timeout = 600.0
                  default_config.rpcs.list_products_in_product_set.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.import_product_sets.timeout = 600.0
                  default_config.rpcs.import_product_sets.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: []
                  }

                  default_config.rpcs.purge_products.timeout = 600.0
                  default_config.rpcs.purge_products.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: []
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ProductSearch Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Vision::V1::ProductSearch::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @product_search_stub.universe_domain
              end

              ##
              # Create a new ProductSearch REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ProductSearch client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Vision::V1::ProductSearch::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @product_search_stub = ::Google::Cloud::Vision::V1::ProductSearch::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @product_search_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Vision::V1::ProductSearch::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @product_search_stub.logger
              end

              # Service calls

              ##
              # Creates and returns a new ProductSet resource.
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
              #   4096 characters.
              #
              # @overload create_product_set(request, options = nil)
              #   Pass arguments to `create_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::CreateProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::CreateProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_product_set(parent: nil, product_set: nil, product_set_id: nil)
              #   Pass arguments to `create_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the ProductSet should be created.
              #
              #     Format is `projects/PROJECT_ID/locations/LOC_ID`.
              #   @param product_set [::Google::Cloud::Vision::V1::ProductSet, ::Hash]
              #     Required. The ProductSet to create.
              #   @param product_set_id [::String]
              #     A user-supplied resource id for this ProductSet. If set, the server will
              #     attempt to use this value as the resource id. If it is already in use, an
              #     error is returned with code ALREADY_EXISTS. Must be at most 128 characters
              #     long. It cannot contain the character `/`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::ProductSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::ProductSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::CreateProductSetRequest.new
              #
              #   # Call the create_product_set method.
              #   result = client.create_product_set request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::ProductSet.
              #   p result
              #
              def create_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::CreateProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.create_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ProductSets in an unspecified order.
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
              #   than 1.
              #
              # @overload list_product_sets(request, options = nil)
              #   Pass arguments to `list_product_sets` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::ListProductSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::ListProductSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_product_sets(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_product_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project from which ProductSets should be listed.
              #
              #     Format is `projects/PROJECT_ID/locations/LOC_ID`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. Default 10, maximum 100.
              #   @param page_token [::String]
              #     The next_page_token returned from a previous List request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::ProductSet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::ProductSet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::ListProductSetsRequest.new
              #
              #   # Call the list_product_sets method.
              #   result = client.list_product_sets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Vision::V1::ProductSet.
              #     p item
              #   end
              #
              def list_product_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::ListProductSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_product_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_product_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_product_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.list_product_sets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @product_search_stub, :list_product_sets, "product_sets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information associated with a ProductSet.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the ProductSet does not exist.
              #
              # @overload get_product_set(request, options = nil)
              #   Pass arguments to `get_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::GetProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::GetProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_product_set(name: nil)
              #   Pass arguments to `get_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the ProductSet to get.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::ProductSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::ProductSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::GetProductSetRequest.new
              #
              #   # Call the get_product_set method.
              #   result = client.get_product_set request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::ProductSet.
              #   p result
              #
              def get_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::GetProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.get_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Makes changes to a ProductSet resource.
              # Only display_name can be updated currently.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the ProductSet does not exist.
              # * Returns INVALID_ARGUMENT if display_name is present in update_mask but
              #   missing from the request or longer than 4096 characters.
              #
              # @overload update_product_set(request, options = nil)
              #   Pass arguments to `update_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::UpdateProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::UpdateProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_product_set(product_set: nil, update_mask: nil)
              #   Pass arguments to `update_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param product_set [::Google::Cloud::Vision::V1::ProductSet, ::Hash]
              #     Required. The ProductSet resource which replaces the one on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The {::Google::Protobuf::FieldMask FieldMask} that specifies which fields to
              #     update.
              #     If update_mask isn't specified, all mutable fields are to be updated.
              #     Valid mask path is `display_name`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::ProductSet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::ProductSet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::UpdateProductSetRequest.new
              #
              #   # Call the update_product_set method.
              #   result = client.update_product_set request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::ProductSet.
              #   p result
              #
              def update_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::UpdateProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.update_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes a ProductSet. Products and ReferenceImages in the
              # ProductSet are not deleted.
              #
              # The actual image files are not deleted from Google Cloud Storage.
              #
              # @overload delete_product_set(request, options = nil)
              #   Pass arguments to `delete_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::DeleteProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::DeleteProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_product_set(name: nil)
              #   Pass arguments to `delete_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the ProductSet to delete.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::DeleteProductSetRequest.new
              #
              #   # Call the delete_product_set method.
              #   result = client.delete_product_set request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::DeleteProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.delete_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates and returns a new product resource.
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
              #   characters.
              # * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
              # * Returns INVALID_ARGUMENT if product_category is missing or invalid.
              #
              # @overload create_product(request, options = nil)
              #   Pass arguments to `create_product` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::CreateProductRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::CreateProductRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_product(parent: nil, product: nil, product_id: nil)
              #   Pass arguments to `create_product` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the Product should be created.
              #
              #     Format is
              #     `projects/PROJECT_ID/locations/LOC_ID`.
              #   @param product [::Google::Cloud::Vision::V1::Product, ::Hash]
              #     Required. The product to create.
              #   @param product_id [::String]
              #     A user-supplied resource id for this Product. If set, the server will
              #     attempt to use this value as the resource id. If it is already in use, an
              #     error is returned with code ALREADY_EXISTS. Must be at most 128 characters
              #     long. It cannot contain the character `/`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::Product]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::Product]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::CreateProductRequest.new
              #
              #   # Call the create_product method.
              #   result = client.create_product request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::Product.
              #   p result
              #
              def create_product request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::CreateProductRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_product.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_product.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_product.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.create_product request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists products in an unspecified order.
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
              #
              # @overload list_products(request, options = nil)
              #   Pass arguments to `list_products` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::ListProductsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::ListProductsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_products(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_products` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project OR ProductSet from which Products should be listed.
              #
              #     Format:
              #     `projects/PROJECT_ID/locations/LOC_ID`
              #   @param page_size [::Integer]
              #     The maximum number of items to return. Default 10, maximum 100.
              #   @param page_token [::String]
              #     The next_page_token returned from a previous List request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::Product>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::Product>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::ListProductsRequest.new
              #
              #   # Call the list_products method.
              #   result = client.list_products request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Vision::V1::Product.
              #     p item
              #   end
              #
              def list_products request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::ListProductsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_products.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_products.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_products.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.list_products request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @product_search_stub, :list_products, "products", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information associated with a Product.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the Product does not exist.
              #
              # @overload get_product(request, options = nil)
              #   Pass arguments to `get_product` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::GetProductRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::GetProductRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_product(name: nil)
              #   Pass arguments to `get_product` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the Product to get.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::Product]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::Product]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::GetProductRequest.new
              #
              #   # Call the get_product method.
              #   result = client.get_product request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::Product.
              #   p result
              #
              def get_product request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::GetProductRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_product.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_product.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_product.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.get_product request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Makes changes to a Product resource.
              # Only the `display_name`, `description`, and `labels` fields can be updated
              # right now.
              #
              # If labels are updated, the change will not be reflected in queries until
              # the next index time.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the Product does not exist.
              # * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
              #   missing from the request or longer than 4096 characters.
              # * Returns INVALID_ARGUMENT if description is present in update_mask but is
              #   longer than 4096 characters.
              # * Returns INVALID_ARGUMENT if product_category is present in update_mask.
              #
              # @overload update_product(request, options = nil)
              #   Pass arguments to `update_product` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::UpdateProductRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::UpdateProductRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_product(product: nil, update_mask: nil)
              #   Pass arguments to `update_product` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param product [::Google::Cloud::Vision::V1::Product, ::Hash]
              #     Required. The Product resource which replaces the one on the server.
              #     product.name is immutable.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The {::Google::Protobuf::FieldMask FieldMask} that specifies which fields
              #     to update.
              #     If update_mask isn't specified, all mutable fields are to be updated.
              #     Valid mask paths include `product_labels`, `display_name`, and
              #     `description`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::Product]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::Product]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::UpdateProductRequest.new
              #
              #   # Call the update_product method.
              #   result = client.update_product request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::Product.
              #   p result
              #
              def update_product request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::UpdateProductRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_product.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_product.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_product.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.update_product request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes a product and its reference images.
              #
              # Metadata of the product and all its images will be deleted right away, but
              # search queries against ProductSets containing the product may still work
              # until all related caches are refreshed.
              #
              # @overload delete_product(request, options = nil)
              #   Pass arguments to `delete_product` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::DeleteProductRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::DeleteProductRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_product(name: nil)
              #   Pass arguments to `delete_product` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of product to delete.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::DeleteProductRequest.new
              #
              #   # Call the delete_product method.
              #   result = client.delete_product request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_product request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::DeleteProductRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_product.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_product.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_product.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.delete_product request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates and returns a new ReferenceImage resource.
              #
              # The `bounding_poly` field is optional. If `bounding_poly` is not specified,
              # the system will try to detect regions of interest in the image that are
              # compatible with the product_category on the parent product. If it is
              # specified, detection is ALWAYS skipped. The system converts polygons into
              # non-rotated rectangles.
              #
              # Note that the pipeline will resize the image if the image resolution is too
              # large to process (above 50MP).
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
              #   characters.
              # * Returns INVALID_ARGUMENT if the product does not exist.
              # * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
              #   compatible with the parent product's product_category is detected.
              # * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
              #
              # @overload create_reference_image(request, options = nil)
              #   Pass arguments to `create_reference_image` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::CreateReferenceImageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::CreateReferenceImageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_reference_image(parent: nil, reference_image: nil, reference_image_id: nil)
              #   Pass arguments to `create_reference_image` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the product in which to create the reference
              #     image.
              #
              #     Format is
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
              #   @param reference_image [::Google::Cloud::Vision::V1::ReferenceImage, ::Hash]
              #     Required. The reference image to create.
              #     If an image ID is specified, it is ignored.
              #   @param reference_image_id [::String]
              #     A user-supplied resource id for the ReferenceImage to be added. If set,
              #     the server will attempt to use this value as the resource id. If it is
              #     already in use, an error is returned with code ALREADY_EXISTS. Must be at
              #     most 128 characters long. It cannot contain the character `/`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::ReferenceImage]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::ReferenceImage]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::CreateReferenceImageRequest.new
              #
              #   # Call the create_reference_image method.
              #   result = client.create_reference_image request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::ReferenceImage.
              #   p result
              #
              def create_reference_image request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::CreateReferenceImageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_reference_image.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_reference_image.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_reference_image.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.create_reference_image request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Permanently deletes a reference image.
              #
              # The image metadata will be deleted right away, but search queries
              # against ProductSets containing the image may still work until all related
              # caches are refreshed.
              #
              # The actual image files are not deleted from Google Cloud Storage.
              #
              # @overload delete_reference_image(request, options = nil)
              #   Pass arguments to `delete_reference_image` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::DeleteReferenceImageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::DeleteReferenceImageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_reference_image(name: nil)
              #   Pass arguments to `delete_reference_image` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the reference image to delete.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::DeleteReferenceImageRequest.new
              #
              #   # Call the delete_reference_image method.
              #   result = client.delete_reference_image request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_reference_image request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::DeleteReferenceImageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_reference_image.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_reference_image.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_reference_image.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.delete_reference_image request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists reference images.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the parent product does not exist.
              # * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
              #   than 1.
              #
              # @overload list_reference_images(request, options = nil)
              #   Pass arguments to `list_reference_images` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::ListReferenceImagesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::ListReferenceImagesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_reference_images(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_reference_images` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the product containing the reference images.
              #
              #     Format is
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. Default 10, maximum 100.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This is the value
              #     of `nextPageToken` returned in a previous reference image list request.
              #
              #     Defaults to the first page if not specified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::ReferenceImage>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::ReferenceImage>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::ListReferenceImagesRequest.new
              #
              #   # Call the list_reference_images method.
              #   result = client.list_reference_images request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Vision::V1::ReferenceImage.
              #     p item
              #   end
              #
              def list_reference_images request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::ListReferenceImagesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_reference_images.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_reference_images.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_reference_images.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.list_reference_images request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @product_search_stub, :list_reference_images, "reference_images", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information associated with a ReferenceImage.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the specified image does not exist.
              #
              # @overload get_reference_image(request, options = nil)
              #   Pass arguments to `get_reference_image` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::GetReferenceImageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::GetReferenceImageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_reference_image(name: nil)
              #   Pass arguments to `get_reference_image` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ReferenceImage to get.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Vision::V1::ReferenceImage]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Vision::V1::ReferenceImage]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::GetReferenceImageRequest.new
              #
              #   # Call the get_reference_image method.
              #   result = client.get_reference_image request
              #
              #   # The returned object is of type Google::Cloud::Vision::V1::ReferenceImage.
              #   p result
              #
              def get_reference_image request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::GetReferenceImageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_reference_image.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_reference_image.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_reference_image.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.get_reference_image request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Adds a Product to the specified ProductSet. If the Product is already
              # present, no change is made.
              #
              # One Product can be added to at most 100 ProductSets.
              #
              # Possible errors:
              #
              # * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
              #
              # @overload add_product_to_product_set(request, options = nil)
              #   Pass arguments to `add_product_to_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::AddProductToProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::AddProductToProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload add_product_to_product_set(name: nil, product: nil)
              #   Pass arguments to `add_product_to_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for the ProductSet to modify.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
              #   @param product [::String]
              #     Required. The resource name for the Product to be added to this ProductSet.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::AddProductToProductSetRequest.new
              #
              #   # Call the add_product_to_product_set method.
              #   result = client.add_product_to_product_set request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def add_product_to_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::AddProductToProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.add_product_to_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.add_product_to_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.add_product_to_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.add_product_to_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Removes a Product from the specified ProductSet.
              #
              # @overload remove_product_from_product_set(request, options = nil)
              #   Pass arguments to `remove_product_from_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::RemoveProductFromProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::RemoveProductFromProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload remove_product_from_product_set(name: nil, product: nil)
              #   Pass arguments to `remove_product_from_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name for the ProductSet to modify.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
              #   @param product [::String]
              #     Required. The resource name for the Product to be removed from this
              #     ProductSet.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::RemoveProductFromProductSetRequest.new
              #
              #   # Call the remove_product_from_product_set method.
              #   result = client.remove_product_from_product_set request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def remove_product_from_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::RemoveProductFromProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.remove_product_from_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.remove_product_from_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.remove_product_from_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.remove_product_from_product_set request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Products in a ProductSet, in an unspecified order. If the
              # ProductSet does not exist, the products field of the response will be
              # empty.
              #
              # Possible errors:
              #
              # * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
              #
              # @overload list_products_in_product_set(request, options = nil)
              #   Pass arguments to `list_products_in_product_set` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::ListProductsInProductSetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::ListProductsInProductSetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_products_in_product_set(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_products_in_product_set` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The ProductSet resource for which to retrieve Products.
              #
              #     Format is:
              #     `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
              #   @param page_size [::Integer]
              #     The maximum number of items to return. Default 10, maximum 100.
              #   @param page_token [::String]
              #     The next_page_token returned from a previous List request, if any.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::Product>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Vision::V1::Product>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::ListProductsInProductSetRequest.new
              #
              #   # Call the list_products_in_product_set method.
              #   result = client.list_products_in_product_set request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Vision::V1::Product.
              #     p item
              #   end
              #
              def list_products_in_product_set request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::ListProductsInProductSetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_products_in_product_set.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_products_in_product_set.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_products_in_product_set.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.list_products_in_product_set request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @product_search_stub, :list_products_in_product_set, "products", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Asynchronous API that imports a list of reference images to specified
              # product sets based on a list of image information.
              #
              # The {::Google::Longrunning::Operation google.longrunning.Operation} API can be
              # used to keep track of the progress and results of the request.
              # `Operation.metadata` contains `BatchOperationMetadata`. (progress)
              # `Operation.response` contains `ImportProductSetsResponse`. (results)
              #
              # The input source of this method is a csv file on Google Cloud Storage.
              # For the format of the csv file please see
              # {::Google::Cloud::Vision::V1::ImportProductSetsGcsSource#csv_file_uri ImportProductSetsGcsSource.csv_file_uri}.
              #
              # @overload import_product_sets(request, options = nil)
              #   Pass arguments to `import_product_sets` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::ImportProductSetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::ImportProductSetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_product_sets(parent: nil, input_config: nil)
              #   Pass arguments to `import_product_sets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the ProductSets should be imported.
              #
              #     Format is `projects/PROJECT_ID/locations/LOC_ID`.
              #   @param input_config [::Google::Cloud::Vision::V1::ImportProductSetsInputConfig, ::Hash]
              #     Required. The input content for the list of requests.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::ImportProductSetsRequest.new
              #
              #   # Call the import_product_sets method.
              #   result = client.import_product_sets request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_product_sets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::ImportProductSetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_product_sets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_product_sets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_product_sets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.import_product_sets request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Asynchronous API to delete all Products in a ProductSet or all Products
              # that are in no ProductSet.
              #
              # If a Product is a member of the specified ProductSet in addition to other
              # ProductSets, the Product will still be deleted.
              #
              # It is recommended to not delete the specified ProductSet until after this
              # operation has completed. It is also recommended to not add any of the
              # Products involved in the batch delete to a new ProductSet while this
              # operation is running because those Products may still end up deleted.
              #
              # It's not possible to undo the PurgeProducts operation. Therefore, it is
              # recommended to keep the csv files used in ImportProductSets (if that was
              # how you originally built the Product Set) before starting PurgeProducts, in
              # case you need to re-import the data after deletion.
              #
              # If the plan is to purge all of the Products from a ProductSet and then
              # re-use the empty ProductSet to re-import new Products into the empty
              # ProductSet, you must wait until the PurgeProducts operation has finished
              # for that ProductSet.
              #
              # The {::Google::Longrunning::Operation google.longrunning.Operation} API can be
              # used to keep track of the progress and results of the request.
              # `Operation.metadata` contains `BatchOperationMetadata`. (progress)
              #
              # @overload purge_products(request, options = nil)
              #   Pass arguments to `purge_products` via a request object, either of type
              #   {::Google::Cloud::Vision::V1::PurgeProductsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Vision::V1::PurgeProductsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload purge_products(product_set_purge_config: nil, delete_orphan_products: nil, parent: nil, force: nil)
              #   Pass arguments to `purge_products` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param product_set_purge_config [::Google::Cloud::Vision::V1::ProductSetPurgeConfig, ::Hash]
              #     Specify which ProductSet contains the Products to be deleted.
              #
              #     Note: The following parameters are mutually exclusive: `product_set_purge_config`, `delete_orphan_products`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param delete_orphan_products [::Boolean]
              #     If delete_orphan_products is true, all Products that are not in any
              #     ProductSet will be deleted.
              #
              #     Note: The following parameters are mutually exclusive: `delete_orphan_products`, `product_set_purge_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The project and location in which the Products should be deleted.
              #
              #     Format is `projects/PROJECT_ID/locations/LOC_ID`.
              #   @param force [::Boolean]
              #     The default value is false. Override this value to true to actually perform
              #     the purge.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/vision/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Vision::V1::PurgeProductsRequest.new
              #
              #   # Call the purge_products method.
              #   result = client.purge_products request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def purge_products request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Vision::V1::PurgeProductsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.purge_products.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Vision::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.purge_products.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.purge_products.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @product_search_stub.purge_products request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ProductSearch REST API.
              #
              # This class represents the configuration for ProductSearch REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Vision::V1::ProductSearch::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_product_set to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Vision::V1::ProductSearch::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_product_set.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Vision::V1::ProductSearch::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_product_set.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "vision.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ProductSearch API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_product_set
                  ##
                  # RPC-specific configuration for `list_product_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_product_sets
                  ##
                  # RPC-specific configuration for `get_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_product_set
                  ##
                  # RPC-specific configuration for `update_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_product_set
                  ##
                  # RPC-specific configuration for `delete_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_product_set
                  ##
                  # RPC-specific configuration for `create_product`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_product
                  ##
                  # RPC-specific configuration for `list_products`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_products
                  ##
                  # RPC-specific configuration for `get_product`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_product
                  ##
                  # RPC-specific configuration for `update_product`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_product
                  ##
                  # RPC-specific configuration for `delete_product`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_product
                  ##
                  # RPC-specific configuration for `create_reference_image`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_reference_image
                  ##
                  # RPC-specific configuration for `delete_reference_image`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_reference_image
                  ##
                  # RPC-specific configuration for `list_reference_images`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reference_images
                  ##
                  # RPC-specific configuration for `get_reference_image`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reference_image
                  ##
                  # RPC-specific configuration for `add_product_to_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :add_product_to_product_set
                  ##
                  # RPC-specific configuration for `remove_product_from_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :remove_product_from_product_set
                  ##
                  # RPC-specific configuration for `list_products_in_product_set`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_products_in_product_set
                  ##
                  # RPC-specific configuration for `import_product_sets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_product_sets
                  ##
                  # RPC-specific configuration for `purge_products`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :purge_products

                  # @private
                  def initialize parent_rpcs = nil
                    create_product_set_config = parent_rpcs.create_product_set if parent_rpcs.respond_to? :create_product_set
                    @create_product_set = ::Gapic::Config::Method.new create_product_set_config
                    list_product_sets_config = parent_rpcs.list_product_sets if parent_rpcs.respond_to? :list_product_sets
                    @list_product_sets = ::Gapic::Config::Method.new list_product_sets_config
                    get_product_set_config = parent_rpcs.get_product_set if parent_rpcs.respond_to? :get_product_set
                    @get_product_set = ::Gapic::Config::Method.new get_product_set_config
                    update_product_set_config = parent_rpcs.update_product_set if parent_rpcs.respond_to? :update_product_set
                    @update_product_set = ::Gapic::Config::Method.new update_product_set_config
                    delete_product_set_config = parent_rpcs.delete_product_set if parent_rpcs.respond_to? :delete_product_set
                    @delete_product_set = ::Gapic::Config::Method.new delete_product_set_config
                    create_product_config = parent_rpcs.create_product if parent_rpcs.respond_to? :create_product
                    @create_product = ::Gapic::Config::Method.new create_product_config
                    list_products_config = parent_rpcs.list_products if parent_rpcs.respond_to? :list_products
                    @list_products = ::Gapic::Config::Method.new list_products_config
                    get_product_config = parent_rpcs.get_product if parent_rpcs.respond_to? :get_product
                    @get_product = ::Gapic::Config::Method.new get_product_config
                    update_product_config = parent_rpcs.update_product if parent_rpcs.respond_to? :update_product
                    @update_product = ::Gapic::Config::Method.new update_product_config
                    delete_product_config = parent_rpcs.delete_product if parent_rpcs.respond_to? :delete_product
                    @delete_product = ::Gapic::Config::Method.new delete_product_config
                    create_reference_image_config = parent_rpcs.create_reference_image if parent_rpcs.respond_to? :create_reference_image
                    @create_reference_image = ::Gapic::Config::Method.new create_reference_image_config
                    delete_reference_image_config = parent_rpcs.delete_reference_image if parent_rpcs.respond_to? :delete_reference_image
                    @delete_reference_image = ::Gapic::Config::Method.new delete_reference_image_config
                    list_reference_images_config = parent_rpcs.list_reference_images if parent_rpcs.respond_to? :list_reference_images
                    @list_reference_images = ::Gapic::Config::Method.new list_reference_images_config
                    get_reference_image_config = parent_rpcs.get_reference_image if parent_rpcs.respond_to? :get_reference_image
                    @get_reference_image = ::Gapic::Config::Method.new get_reference_image_config
                    add_product_to_product_set_config = parent_rpcs.add_product_to_product_set if parent_rpcs.respond_to? :add_product_to_product_set
                    @add_product_to_product_set = ::Gapic::Config::Method.new add_product_to_product_set_config
                    remove_product_from_product_set_config = parent_rpcs.remove_product_from_product_set if parent_rpcs.respond_to? :remove_product_from_product_set
                    @remove_product_from_product_set = ::Gapic::Config::Method.new remove_product_from_product_set_config
                    list_products_in_product_set_config = parent_rpcs.list_products_in_product_set if parent_rpcs.respond_to? :list_products_in_product_set
                    @list_products_in_product_set = ::Gapic::Config::Method.new list_products_in_product_set_config
                    import_product_sets_config = parent_rpcs.import_product_sets if parent_rpcs.respond_to? :import_product_sets
                    @import_product_sets = ::Gapic::Config::Method.new import_product_sets_config
                    purge_products_config = parent_rpcs.purge_products if parent_rpcs.respond_to? :purge_products
                    @purge_products = ::Gapic::Config::Method.new purge_products_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
