# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Transcoder
        module V1
          # Transcoding job resource.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the job.
          #     Format: `projects/{project_number}/locations/{location}/jobs/{job}`
          # @!attribute [rw] input_uri
          #   @return [::String]
          #     Input only. Specify the `input_uri` to populate empty `uri` fields in each
          #     element of `Job.config.inputs` or `JobTemplate.config.inputs` when using
          #     template. URI of the media. Input files must be at least 5 seconds in
          #     duration and stored in Cloud Storage (for example,
          #     `gs://bucket/inputs/file.mp4`). See [Supported input and output
          #     formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
          # @!attribute [rw] output_uri
          #   @return [::String]
          #     Input only. Specify the `output_uri` to populate an empty
          #     `Job.config.output.uri` or `JobTemplate.config.output.uri` when using
          #     template. URI for the output file(s). For example,
          #     `gs://my-bucket/outputs/`. See [Supported input and output
          #     formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
          # @!attribute [rw] template_id
          #   @return [::String]
          #     Input only. Specify the `template_id` to use for populating `Job.config`.
          #     The default is `preset/web-hd`, which is the only supported preset.
          #
          #     User defined JobTemplate: `{job_template_id}`
          #
          #     Note: The following fields are mutually exclusive: `template_id`, `config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Video::Transcoder::V1::JobConfig]
          #     The configuration for this job.
          #
          #     Note: The following fields are mutually exclusive: `config`, `template_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::Transcoder::V1::Job::ProcessingState]
          #     Output only. The current state of the job.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the job was created.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the transcoding started.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the transcoding finished.
          # @!attribute [rw] ttl_after_completion_days
          #   @return [::Integer]
          #     Job time to live value in days, which will be effective after job
          #     completion. Job should be deleted automatically after the given TTL. Enter
          #     a value between 1 and 90. The default is 30.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The labels associated with this job. You can use these to organize and
          #     group your jobs.
          # @!attribute [r] error
          #   @return [::Google::Rpc::Status]
          #     Output only. An error object that describes the reason for the failure.
          #     This property is always present when
          #     {::Google::Cloud::Video::Transcoder::V1::Job::ProcessingState ProcessingState} is
          #     `FAILED`.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::Video::Transcoder::V1::Job::ProcessingMode]
          #     The processing mode of the job.
          #     The default is `PROCESSING_MODE_INTERACTIVE`.
          # @!attribute [rw] batch_mode_priority
          #   @return [::Integer]
          #     The processing priority of a batch job.
          #     This field can only be set for batch mode jobs. The default value is 0.
          #     This value cannot be negative. Higher values correspond to higher
          #     priorities for the job.
          # @!attribute [rw] optimization
          #   @return [::Google::Cloud::Video::Transcoder::V1::Job::OptimizationStrategy]
          #     Optional. The optimization strategy of the job. The default is
          #     `AUTODETECT`.
          # @!attribute [rw] fill_content_gaps
          #   @return [::Boolean]
          #     Optional. Insert silence and duplicate frames when timestamp gaps are
          #     detected in a given stream.
          class Job
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The current state of the job.
            module ProcessingState
              # The processing state is not specified.
              PROCESSING_STATE_UNSPECIFIED = 0

              # The job is enqueued and will be picked up for processing soon.
              PENDING = 1

              # The job is being processed.
              RUNNING = 2

              # The job has been completed successfully.
              SUCCEEDED = 3

              # The job has failed. For additional information, see
              # [Troubleshooting](https://cloud.google.com/transcoder/docs/troubleshooting).
              FAILED = 4
            end

            # The processing mode of the job.
            module ProcessingMode
              # The job processing mode is not specified.
              PROCESSING_MODE_UNSPECIFIED = 0

              # The job processing mode is interactive mode.
              # Interactive job will either be ran or rejected if quota does not allow
              # for it.
              PROCESSING_MODE_INTERACTIVE = 1

              # The job processing mode is batch mode.
              # Batch mode allows queuing of jobs.
              PROCESSING_MODE_BATCH = 2
            end

            # The optimization strategy of the job. The default is `AUTODETECT`.
            module OptimizationStrategy
              # The optimization strategy is not specified.
              OPTIMIZATION_STRATEGY_UNSPECIFIED = 0

              # Prioritize job processing speed.
              AUTODETECT = 1

              # Disable all optimizations.
              DISABLED = 2
            end
          end

          # Transcoding job template resource.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the job template.
          #     Format:
          #     `projects/{project_number}/locations/{location}/jobTemplates/{job_template}`
          # @!attribute [rw] config
          #   @return [::Google::Cloud::Video::Transcoder::V1::JobConfig]
          #     The configuration for this template.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The labels associated with this job template. You can use these to organize
          #     and group your job templates.
          class JobTemplate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Job configuration
          # @!attribute [rw] inputs
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::Input>]
          #     List of input assets stored in Cloud Storage.
          # @!attribute [rw] edit_list
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::EditAtom>]
          #     List of edit atoms. Defines the ultimate timeline of the resulting
          #     file or manifest.
          # @!attribute [rw] elementary_streams
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::ElementaryStream>]
          #     List of elementary streams.
          # @!attribute [rw] mux_streams
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::MuxStream>]
          #     List of multiplexing settings for output streams.
          # @!attribute [rw] manifests
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::Manifest>]
          #     List of output manifests.
          # @!attribute [rw] output
          #   @return [::Google::Cloud::Video::Transcoder::V1::Output]
          #     Output configuration.
          # @!attribute [rw] ad_breaks
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::AdBreak>]
          #     List of ad breaks. Specifies where to insert ad break tags in the output
          #     manifests.
          # @!attribute [rw] pubsub_destination
          #   @return [::Google::Cloud::Video::Transcoder::V1::PubsubDestination]
          #     Destination on Pub/Sub.
          # @!attribute [rw] sprite_sheets
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::SpriteSheet>]
          #     List of output sprite sheets.
          #     Spritesheets require at least one VideoStream in the Jobconfig.
          # @!attribute [rw] overlays
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::Overlay>]
          #     List of overlays on the output video, in descending Z-order.
          # @!attribute [rw] encryptions
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::Encryption>]
          #     List of encryption configurations for the content.
          #     Each configuration has an ID. Specify this ID in the
          #     {::Google::Cloud::Video::Transcoder::V1::MuxStream#encryption_id MuxStream.encryption_id}
          #     field to indicate the configuration to use for that `MuxStream` output.
          class JobConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input asset.
          # @!attribute [rw] key
          #   @return [::String]
          #     A unique key for this input. Must be specified when using advanced
          #     mapping and edit lists.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI of the media. Input files must be at least 5 seconds in duration and
          #     stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`).
          #     If empty, the value is populated from
          #     {::Google::Cloud::Video::Transcoder::V1::Job#input_uri Job.input_uri}. See
          #     [Supported input and output
          #     formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
          # @!attribute [rw] preprocessing_config
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig]
          #     Preprocessing configurations.
          # @!attribute [rw] attributes
          #   @return [::Google::Cloud::Video::Transcoder::V1::InputAttributes]
          #     Optional. Input Attributes.
          class Input
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Location of output file(s) in a Cloud Storage bucket.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI for the output file(s). For example, `gs://my-bucket/outputs/`. Must be
          #     a directory and not a top-level bucket. If empty, the value is populated
          #     from {::Google::Cloud::Video::Transcoder::V1::Job#output_uri Job.output_uri}. See
          #     [Supported input and output
          #     formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
          class Output
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Edit atom.
          # @!attribute [rw] key
          #   @return [::String]
          #     A unique key for this atom. Must be specified when using advanced
          #     mapping.
          # @!attribute [rw] inputs
          #   @return [::Array<::String>]
          #     List of {::Google::Cloud::Video::Transcoder::V1::Input#key Input.key} values
          #     identifying files that should be used in this atom. The listed `inputs`
          #     must have the same timeline.
          # @!attribute [rw] end_time_offset
          #   @return [::Google::Protobuf::Duration]
          #     End time in seconds for the atom, relative to the input file timeline.
          #     When `end_time_offset` is not specified, the `inputs` are used until
          #     the end of the atom.
          # @!attribute [rw] start_time_offset
          #   @return [::Google::Protobuf::Duration]
          #     Start time in seconds for the atom, relative to the input file timeline.
          #     The default is `0s`.
          class EditAtom
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Ad break.
          # @!attribute [rw] start_time_offset
          #   @return [::Google::Protobuf::Duration]
          #     Start time in seconds for the ad break, relative to the output file
          #     timeline. The default is `0s`.
          class AdBreak
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Encoding of an input file such as an audio, video, or text track.
          # Elementary streams must be packaged before
          # mapping and sharing between different output formats.
          # @!attribute [rw] key
          #   @return [::String]
          #     A unique key for this elementary stream.
          # @!attribute [rw] video_stream
          #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream]
          #     Encoding of a video stream.
          #
          #     Note: The following fields are mutually exclusive: `video_stream`, `audio_stream`, `text_stream`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] audio_stream
          #   @return [::Google::Cloud::Video::Transcoder::V1::AudioStream]
          #     Encoding of an audio stream.
          #
          #     Note: The following fields are mutually exclusive: `audio_stream`, `video_stream`, `text_stream`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] text_stream
          #   @return [::Google::Cloud::Video::Transcoder::V1::TextStream]
          #     Encoding of a text stream. For example, closed captions or subtitles.
          #
          #     Note: The following fields are mutually exclusive: `text_stream`, `video_stream`, `audio_stream`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ElementaryStream
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Multiplexing settings for output stream.
          # @!attribute [rw] key
          #   @return [::String]
          #     A unique key for this multiplexed stream.
          # @!attribute [rw] file_name
          #   @return [::String]
          #     The name of the generated file. The default is
          #     {::Google::Cloud::Video::Transcoder::V1::MuxStream#key MuxStream.key} with the
          #     extension suffix corresponding to the
          #     {::Google::Cloud::Video::Transcoder::V1::MuxStream#container MuxStream.container}.
          #
          #     Individual segments also have an incremental 10-digit zero-padded suffix
          #     starting from 0 before the extension, such as `mux_stream0000000123.ts`.
          # @!attribute [rw] container
          #   @return [::String]
          #     The container format. The default is `mp4`
          #
          #     Supported streaming formats:
          #
          #     - `ts`
          #     - `fmp4`- the corresponding file extension is `.m4s`
          #
          #     Supported standalone file formats:
          #
          #     - `mp4`
          #     - `mp3`
          #     - `ogg`
          #     - `vtt`
          #
          #     See also:
          #     [Supported input and output
          #     formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
          # @!attribute [rw] elementary_streams
          #   @return [::Array<::String>]
          #     List of
          #     {::Google::Cloud::Video::Transcoder::V1::ElementaryStream#key ElementaryStream.key}
          #     values multiplexed in this stream.
          # @!attribute [rw] segment_settings
          #   @return [::Google::Cloud::Video::Transcoder::V1::SegmentSettings]
          #     Segment settings for `ts`, `fmp4` and `vtt`.
          # @!attribute [rw] encryption_id
          #   @return [::String]
          #     Identifier of the encryption configuration to use. If omitted, output will
          #     be unencrypted.
          # @!attribute [rw] fmp4
          #   @return [::Google::Cloud::Video::Transcoder::V1::MuxStream::Fmp4Config]
          #     Optional. `fmp4` container configuration.
          class MuxStream
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # `fmp4` container configuration.
            # @!attribute [rw] codec_tag
            #   @return [::String]
            #     Optional. Specify the codec tag string that will be used in the media
            #     bitstream. When not specified, the codec appropriate value is used.
            #
            #     Supported H265 codec tags:
            #
            #     - `hvc1` (default)
            #     - `hev1`
            class Fmp4Config
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Manifest configuration.
          # @!attribute [rw] file_name
          #   @return [::String]
          #     The name of the generated file. The default is `manifest` with the
          #     extension suffix corresponding to the
          #     {::Google::Cloud::Video::Transcoder::V1::Manifest#type Manifest.type}.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Video::Transcoder::V1::Manifest::ManifestType]
          #     Required. Type of the manifest.
          # @!attribute [rw] mux_streams
          #   @return [::Array<::String>]
          #     Required. List of user supplied
          #     {::Google::Cloud::Video::Transcoder::V1::MuxStream#key MuxStream.key} values that
          #     should appear in this manifest.
          #
          #     When {::Google::Cloud::Video::Transcoder::V1::Manifest#type Manifest.type} is
          #     `HLS`, a media manifest with name
          #     {::Google::Cloud::Video::Transcoder::V1::MuxStream#key MuxStream.key} and `.m3u8`
          #     extension is generated for each element in this list.
          # @!attribute [rw] dash
          #   @return [::Google::Cloud::Video::Transcoder::V1::Manifest::DashConfig]
          #     `DASH` manifest configuration.
          class Manifest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # `DASH` manifest configuration.
            # @!attribute [rw] segment_reference_scheme
            #   @return [::Google::Cloud::Video::Transcoder::V1::Manifest::DashConfig::SegmentReferenceScheme]
            #     The segment reference scheme for a `DASH` manifest. The default is
            #     `SEGMENT_LIST`.
            class DashConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The segment reference scheme for a `DASH` manifest.
              module SegmentReferenceScheme
                # The segment reference scheme is not specified.
                SEGMENT_REFERENCE_SCHEME_UNSPECIFIED = 0

                # Explicitly lists the URLs of media files for each segment. For example,
                # if
                # {::Google::Cloud::Video::Transcoder::V1::SegmentSettings#individual_segments SegmentSettings.individual_segments}
                # is `true`, then the manifest contains fields similar to the following:
                # ```xml
                # <Initialization sourceURL="my-hd-stream-init.m4s"/>
                #   <SegmentList presentationTimeOffset="0" duration="1000"
                #   timescale="10000">
                #     <SegmentURL media="hd-stream0000000000.m4s"/>
                #     <SegmentURL media="hd-stream0000000001.m4s"/>
                #     ...
                # ```
                SEGMENT_LIST = 1

                # {::Google::Cloud::Video::Transcoder::V1::SegmentSettings#individual_segments SegmentSettings.individual_segments}
                # must be set to `true` to use this segment reference scheme. Uses the
                # DASH specification
                # `<SegmentTemplate>` tag to determine the URLs of media files for each
                # segment. For example:
                # ```xml
                # <SegmentTemplate presentationTimeOffset="0" timescale="10000"
                #       initialization="my-hd-stream-init.m4s"
                #       media="hd-stream$Number%010d$.m4s" startNumber="0">
                #   ...
                # ```
                SEGMENT_TEMPLATE_NUMBER = 2
              end
            end

            # The manifest type, which corresponds to the adaptive streaming format used.
            module ManifestType
              # The manifest type is not specified.
              MANIFEST_TYPE_UNSPECIFIED = 0

              # Create an HLS manifest. The corresponding file extension is `.m3u8`.
              HLS = 1

              # Create an MPEG-DASH manifest. The corresponding file extension is `.mpd`.
              DASH = 2
            end
          end

          # A Pub/Sub destination.
          # @!attribute [rw] topic
          #   @return [::String]
          #     The name of the Pub/Sub topic to publish job completion notification
          #     to. For example: `projects/{project}/topics/{topic}`.
          class PubsubDestination
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sprite sheet configuration.
          # @!attribute [rw] format
          #   @return [::String]
          #     Format type. The default is `jpeg`.
          #
          #     Supported formats:
          #
          #     - `jpeg`
          # @!attribute [rw] file_prefix
          #   @return [::String]
          #     Required. File name prefix for the generated sprite sheets.
          #
          #     Each sprite sheet has an incremental 10-digit zero-padded suffix starting
          #     from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
          # @!attribute [rw] sprite_width_pixels
          #   @return [::Integer]
          #     Required. The width of sprite in pixels. Must be an even integer. To
          #     preserve the source aspect ratio, set the
          #     {::Google::Cloud::Video::Transcoder::V1::SpriteSheet#sprite_width_pixels SpriteSheet.sprite_width_pixels}
          #     field or the
          #     {::Google::Cloud::Video::Transcoder::V1::SpriteSheet#sprite_height_pixels SpriteSheet.sprite_height_pixels}
          #     field, but not both (the API will automatically calculate the missing
          #     field).
          #
          #     For portrait videos that contain horizontal ASR and rotation metadata,
          #     provide the width, in pixels, per the horizontal ASR. The API calculates
          #     the height per the horizontal ASR. The API detects any rotation metadata
          #     and swaps the requested height and width for the output.
          # @!attribute [rw] sprite_height_pixels
          #   @return [::Integer]
          #     Required. The height of sprite in pixels. Must be an even integer. To
          #     preserve the source aspect ratio, set the
          #     {::Google::Cloud::Video::Transcoder::V1::SpriteSheet#sprite_height_pixels SpriteSheet.sprite_height_pixels}
          #     field or the
          #     {::Google::Cloud::Video::Transcoder::V1::SpriteSheet#sprite_width_pixels SpriteSheet.sprite_width_pixels}
          #     field, but not both (the API will automatically calculate the missing
          #     field).
          #
          #     For portrait videos that contain horizontal ASR and rotation metadata,
          #     provide the height, in pixels, per the horizontal ASR. The API calculates
          #     the width per the horizontal ASR. The API detects any rotation metadata
          #     and swaps the requested height and width for the output.
          # @!attribute [rw] column_count
          #   @return [::Integer]
          #     The maximum number of sprites per row in a sprite sheet. The default is 0,
          #     which indicates no maximum limit.
          # @!attribute [rw] row_count
          #   @return [::Integer]
          #     The maximum number of rows per sprite sheet. When the sprite sheet is full,
          #     a new sprite sheet is created. The default is 0, which indicates no maximum
          #     limit.
          # @!attribute [rw] start_time_offset
          #   @return [::Google::Protobuf::Duration]
          #     Start time in seconds, relative to the output file timeline. Determines the
          #     first sprite to pick. The default is `0s`.
          # @!attribute [rw] end_time_offset
          #   @return [::Google::Protobuf::Duration]
          #     End time in seconds, relative to the output file timeline. When
          #     `end_time_offset` is not specified, the sprites are generated until the end
          #     of the output file.
          # @!attribute [rw] total_count
          #   @return [::Integer]
          #     Total number of sprites. Create the specified number of sprites
          #     distributed evenly across the timeline of the output media. The default
          #     is 100.
          #
          #     Note: The following fields are mutually exclusive: `total_count`, `interval`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] interval
          #   @return [::Google::Protobuf::Duration]
          #     Starting from `0s`, create sprites at regular intervals. Specify the
          #     interval value in seconds.
          #
          #     Note: The following fields are mutually exclusive: `interval`, `total_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] quality
          #   @return [::Integer]
          #     The quality of the generated sprite sheet. Enter a value between 1
          #     and 100, where 1 is the lowest quality and 100 is the highest quality.
          #     The default is 100. A high quality value corresponds to a low image data
          #     compression ratio.
          class SpriteSheet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Overlay configuration.
          # @!attribute [rw] image
          #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::Image]
          #     Image overlay.
          # @!attribute [rw] animations
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::Overlay::Animation>]
          #     List of animations. The list should be chronological, without any time
          #     overlap.
          class Overlay
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # 2D normalized coordinates. Default: `{0.0, 0.0}`
            # @!attribute [rw] x
            #   @return [::Float]
            #     Normalized x coordinate.
            # @!attribute [rw] y
            #   @return [::Float]
            #     Normalized y coordinate.
            class NormalizedCoordinate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Overlaid image.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Required. URI of the image in Cloud Storage. For example,
            #     `gs://bucket/inputs/image.png`. Only PNG and JPEG images are supported.
            # @!attribute [rw] resolution
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::NormalizedCoordinate]
            #     Normalized image resolution, based on output video resolution. Valid
            #     values: `0.0`–`1.0`. To respect the original image aspect ratio, set
            #     either `x` or `y` to `0.0`. To use the original image resolution, set
            #     both `x` and `y` to `0.0`.
            # @!attribute [rw] alpha
            #   @return [::Float]
            #     Target image opacity. Valid values are from  `1.0` (solid, default) to
            #     `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
            class Image
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Display static overlay object.
            # @!attribute [rw] xy
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::NormalizedCoordinate]
            #     Normalized coordinates based on output video resolution. Valid
            #     values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
            #     object. For example, use the x and y coordinates \\{0,0} to position the
            #     top-left corner of the overlay animation in the top-left corner of the
            #     output video.
            # @!attribute [rw] start_time_offset
            #   @return [::Google::Protobuf::Duration]
            #     The time to start displaying the overlay object, in seconds. Default: 0
            class AnimationStatic
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Display overlay object with fade animation.
            # @!attribute [rw] fade_type
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::FadeType]
            #     Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
            # @!attribute [rw] xy
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::NormalizedCoordinate]
            #     Normalized coordinates based on output video resolution. Valid
            #     values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
            #     object. For example, use the x and y coordinates \\{0,0} to position the
            #     top-left corner of the overlay animation in the top-left corner of the
            #     output video.
            # @!attribute [rw] start_time_offset
            #   @return [::Google::Protobuf::Duration]
            #     The time to start the fade animation, in seconds. Default: 0
            # @!attribute [rw] end_time_offset
            #   @return [::Google::Protobuf::Duration]
            #     The time to end the fade animation, in seconds. Default:
            #     `start_time_offset` + 1s
            class AnimationFade
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # End previous overlay animation from the video. Without `AnimationEnd`, the
            # overlay object will keep the state of previous animation until the end of
            # the video.
            # @!attribute [rw] start_time_offset
            #   @return [::Google::Protobuf::Duration]
            #     The time to end overlay object, in seconds. Default: 0
            class AnimationEnd
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Animation types.
            # @!attribute [rw] animation_static
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::AnimationStatic]
            #     Display static overlay object.
            #
            #     Note: The following fields are mutually exclusive: `animation_static`, `animation_fade`, `animation_end`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] animation_fade
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::AnimationFade]
            #     Display overlay object with fade animation.
            #
            #     Note: The following fields are mutually exclusive: `animation_fade`, `animation_static`, `animation_end`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] animation_end
            #   @return [::Google::Cloud::Video::Transcoder::V1::Overlay::AnimationEnd]
            #     End previous animation.
            #
            #     Note: The following fields are mutually exclusive: `animation_end`, `animation_static`, `animation_fade`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class Animation
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Fade type for the overlay: `FADE_IN` or `FADE_OUT`.
            module FadeType
              # The fade type is not specified.
              FADE_TYPE_UNSPECIFIED = 0

              # Fade the overlay object into view.
              FADE_IN = 1

              # Fade the overlay object out of view.
              FADE_OUT = 2
            end
          end

          # Preprocessing configurations.
          # @!attribute [rw] color
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Color]
          #     Color preprocessing configuration.
          # @!attribute [rw] denoise
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Denoise]
          #     Denoise preprocessing configuration.
          # @!attribute [rw] deblock
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Deblock]
          #     Deblock preprocessing configuration.
          # @!attribute [rw] audio
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Audio]
          #     Audio preprocessing configuration.
          # @!attribute [rw] crop
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Crop]
          #     Specify the video cropping configuration.
          # @!attribute [rw] pad
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Pad]
          #     Specify the video pad filter configuration.
          # @!attribute [rw] deinterlace
          #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Deinterlace]
          #     Specify the video deinterlace configuration.
          class PreprocessingConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Color preprocessing configuration.
            #
            # **Note:** This configuration is not supported.
            # @!attribute [rw] saturation
            #   @return [::Float]
            #     Control color saturation of the video. Enter a value between -1 and 1,
            #     where -1 is fully desaturated and 1 is maximum saturation. 0 is no
            #     change. The default is 0.
            # @!attribute [rw] contrast
            #   @return [::Float]
            #     Control black and white contrast of the video. Enter a value between -1
            #     and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
            #     change. The default is 0.
            # @!attribute [rw] brightness
            #   @return [::Float]
            #     Control brightness of the video. Enter a value between -1 and 1, where -1
            #     is minimum brightness and 1 is maximum brightness. 0 is no change. The
            #     default is 0.
            class Color
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Denoise preprocessing configuration.
            #
            # **Note:** This configuration is not supported.
            # @!attribute [rw] strength
            #   @return [::Float]
            #     Set strength of the denoise. Enter a value between 0 and 1. The higher
            #     the value, the smoother the image. 0 is no denoising. The default is 0.
            # @!attribute [rw] tune
            #   @return [::String]
            #     Set the denoiser mode. The default is `standard`.
            #
            #     Supported denoiser modes:
            #
            #     - `standard`
            #     - `grain`
            class Denoise
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Deblock preprocessing configuration.
            #
            # **Note:** This configuration is not supported.
            # @!attribute [rw] strength
            #   @return [::Float]
            #     Set strength of the deblocker. Enter a value between 0 and 1. The higher
            #     the value, the stronger the block removal. 0 is no deblocking. The
            #     default is 0.
            # @!attribute [rw] enabled
            #   @return [::Boolean]
            #     Enable deblocker. The default is `false`.
            class Deblock
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Audio preprocessing configuration.
            # @!attribute [rw] lufs
            #   @return [::Float]
            #     Specify audio loudness normalization in loudness units relative to full
            #     scale (LUFS). Enter a value between -24 and 0 (the default), where:
            #
            #     *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
            #     *   -23 is the EU R128 broadcast standard
            #     *   -19 is the prior standard for online mono audio
            #     *   -18 is the ReplayGain standard
            #     *   -16 is the prior standard for stereo audio
            #     *   -14 is the new online audio standard recommended by Spotify, as well
            #         as Amazon Echo
            #     *   0 disables normalization
            # @!attribute [rw] high_boost
            #   @return [::Boolean]
            #     Enable boosting high frequency components. The default is `false`.
            #
            #     **Note:** This field is not supported.
            # @!attribute [rw] low_boost
            #   @return [::Boolean]
            #     Enable boosting low frequency components. The default is `false`.
            #
            #     **Note:** This field is not supported.
            class Audio
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Video cropping configuration for the input video. The cropped input video
            # is scaled to match the output resolution.
            # @!attribute [rw] top_pixels
            #   @return [::Integer]
            #     The number of pixels to crop from the top. The default is 0.
            # @!attribute [rw] bottom_pixels
            #   @return [::Integer]
            #     The number of pixels to crop from the bottom. The default is 0.
            # @!attribute [rw] left_pixels
            #   @return [::Integer]
            #     The number of pixels to crop from the left. The default is 0.
            # @!attribute [rw] right_pixels
            #   @return [::Integer]
            #     The number of pixels to crop from the right. The default is 0.
            class Crop
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Pad filter configuration for the input video. The padded input video
            # is scaled after padding with black to match the output resolution.
            # @!attribute [rw] top_pixels
            #   @return [::Integer]
            #     The number of pixels to add to the top. The default is 0.
            # @!attribute [rw] bottom_pixels
            #   @return [::Integer]
            #     The number of pixels to add to the bottom. The default is 0.
            # @!attribute [rw] left_pixels
            #   @return [::Integer]
            #     The number of pixels to add to the left. The default is 0.
            # @!attribute [rw] right_pixels
            #   @return [::Integer]
            #     The number of pixels to add to the right. The default is 0.
            class Pad
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Deinterlace configuration for input video.
            # @!attribute [rw] yadif
            #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Deinterlace::YadifConfig]
            #     Specifies the Yet Another Deinterlacing Filter Configuration.
            #
            #     Note: The following fields are mutually exclusive: `yadif`, `bwdif`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] bwdif
            #   @return [::Google::Cloud::Video::Transcoder::V1::PreprocessingConfig::Deinterlace::BwdifConfig]
            #     Specifies the Bob Weaver Deinterlacing Filter Configuration.
            #
            #     Note: The following fields are mutually exclusive: `bwdif`, `yadif`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class Deinterlace
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Yet Another Deinterlacing Filter Configuration.
              # @!attribute [rw] mode
              #   @return [::String]
              #     Specifies the deinterlacing mode to adopt.
              #     The default is `send_frame`.
              #     Supported values:
              #
              #     - `send_frame`: Output one frame for each frame
              #     - `send_field`: Output one frame for each field
              # @!attribute [rw] disable_spatial_interlacing
              #   @return [::Boolean]
              #     Disable spacial interlacing.
              #     The default is `false`.
              # @!attribute [rw] parity
              #   @return [::String]
              #     The picture field parity assumed for the input interlaced video.
              #     The default is `auto`.
              #     Supported values:
              #
              #     - `tff`: Assume the top field is first
              #     - `bff`: Assume the bottom field is first
              #     - `auto`: Enable automatic detection of field parity
              # @!attribute [rw] deinterlace_all_frames
              #   @return [::Boolean]
              #     Deinterlace all frames rather than just the frames identified as
              #     interlaced. The default is `false`.
              class YadifConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # Bob Weaver Deinterlacing Filter Configuration.
              # @!attribute [rw] mode
              #   @return [::String]
              #     Specifies the deinterlacing mode to adopt.
              #     The default is `send_frame`.
              #     Supported values:
              #
              #     - `send_frame`: Output one frame for each frame
              #     - `send_field`: Output one frame for each field
              # @!attribute [rw] parity
              #   @return [::String]
              #     The picture field parity assumed for the input interlaced video.
              #     The default is `auto`.
              #     Supported values:
              #
              #     - `tff`: Assume the top field is first
              #     - `bff`: Assume the bottom field is first
              #     - `auto`: Enable automatic detection of field parity
              # @!attribute [rw] deinterlace_all_frames
              #   @return [::Boolean]
              #     Deinterlace all frames rather than just the frames identified as
              #     interlaced. The default is `false`.
              class BwdifConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # Track definition for the input asset.
          # @!attribute [rw] input_track
          #   @return [::Integer]
          #     The input track.
          # @!attribute [rw] languages
          #   @return [::Array<::String>]
          #     Optional. A list of languages spoken in the input asset, represented by a
          #     BCP 47 language code, such as "en-US" or "sr-Latn". For more information,
          #     see https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
          # @!attribute [rw] detect_languages
          #   @return [::Boolean]
          #     Optional. Whether to automatically detect the languages present in the
          #     track. If true, the system will attempt to identify all the languages
          #     present in the track and populate the languages field.
          # @!attribute [r] detected_languages
          #   @return [::Array<::String>]
          #     Output only. A list of languages detected in the input asset, represented
          #     by a BCP 47 language code, such as "en-US" or "sr-Latn". For more
          #     information, see
          #     https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
          #     This field is only populated if the detect_languages field is set to true.
          class TrackDefinition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Input attributes that provide additional information about the input asset.
          # @!attribute [rw] track_definitions
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::TrackDefinition>]
          #     Optional. A list of track definitions for the input asset.
          class InputAttributes
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Video stream resource.
          # @!attribute [rw] h264
          #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H264CodecSettings]
          #     H264 codec settings.
          #
          #     Note: The following fields are mutually exclusive: `h264`, `h265`, `vp9`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] h265
          #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H265CodecSettings]
          #     H265 codec settings.
          #
          #     Note: The following fields are mutually exclusive: `h265`, `h264`, `vp9`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] vp9
          #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::Vp9CodecSettings]
          #     VP9 codec settings.
          #
          #     Note: The following fields are mutually exclusive: `vp9`, `h264`, `h265`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class VideoStream
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Convert the input video to a Standard Dynamic Range (SDR) video.
            class H264ColorFormatSDR
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a Hybrid Log Gamma (HLG) video.
            class H264ColorFormatHLG
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # H264 codec settings.
            # @!attribute [rw] width_pixels
            #   @return [::Integer]
            #     The width of the video in pixels. Must be an even integer.
            #     When not specified, the width is adjusted to match the specified height
            #     and input aspect ratio. If both are omitted, the input width is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the width, in pixels, per the horizontal ASR. The API calculates
            #     the height per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] height_pixels
            #   @return [::Integer]
            #     The height of the video in pixels. Must be an even integer.
            #     When not specified, the height is adjusted to match the specified width
            #     and input aspect ratio. If both are omitted, the input height is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the height, in pixels, per the horizontal ASR. The API calculates
            #     the width per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] frame_rate
            #   @return [::Float]
            #     Required. The target video frame rate in frames per second (FPS). Must be
            #     less than or equal to 120.
            # @!attribute [rw] frame_rate_conversion_strategy
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::FrameRateConversionStrategy]
            #     Optional. Frame rate conversion strategy for desired frame rate. The
            #     default is `DOWNSAMPLE`.
            # @!attribute [rw] bitrate_bps
            #   @return [::Integer]
            #     Required. The video bitrate in bits per second. The minimum value is
            #     1,000. The maximum value is 800,000,000.
            # @!attribute [rw] pixel_format
            #   @return [::String]
            #     Pixel format to use. The default is `yuv420p`.
            #
            #     Supported pixel formats:
            #
            #     - `yuv420p` pixel format
            #     - `yuv422p` pixel format
            #     - `yuv444p` pixel format
            #     - `yuv420p10` 10-bit HDR pixel format
            #     - `yuv422p10` 10-bit HDR pixel format
            #     - `yuv444p10` 10-bit HDR pixel format
            #     - `yuv420p12` 12-bit HDR pixel format
            #     - `yuv422p12` 12-bit HDR pixel format
            #     - `yuv444p12` 12-bit HDR pixel format
            # @!attribute [rw] rate_control_mode
            #   @return [::String]
            #     Specify the mode. The default is `vbr`.
            #
            #     Supported rate control modes:
            #
            #     - `vbr` - variable bitrate
            #     - `crf` - constant rate factor
            # @!attribute [rw] crf_level
            #   @return [::Integer]
            #     Target CRF level. Must be between 10 and 36, where 10 is the highest
            #     quality and 36 is the most efficient compression. The default is 21.
            # @!attribute [rw] allow_open_gop
            #   @return [::Boolean]
            #     Specifies whether an open Group of Pictures (GOP) structure should be
            #     allowed or not. The default is `false`.
            # @!attribute [rw] gop_frame_count
            #   @return [::Integer]
            #     Select the GOP size based on the specified frame count. Must be greater
            #     than zero.
            #
            #     Note: The following fields are mutually exclusive: `gop_frame_count`, `gop_duration`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] gop_duration
            #   @return [::Google::Protobuf::Duration]
            #     Select the GOP size based on the specified duration. The default is
            #     `3s`. Note that `gopDuration` must be less than or equal to
            #     [`segmentDuration`](#SegmentSettings), and
            #     [`segmentDuration`](#SegmentSettings) must be divisible by
            #     `gopDuration`.
            #
            #     Note: The following fields are mutually exclusive: `gop_duration`, `gop_frame_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] enable_two_pass
            #   @return [::Boolean]
            #     Use two-pass encoding strategy to achieve better video quality.
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H264CodecSettings#rate_control_mode H264CodecSettings.rate_control_mode}
            #     must be `vbr`. The default is `false`.
            # @!attribute [rw] vbv_size_bits
            #   @return [::Integer]
            #     Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
            #     greater than zero. The default is equal to
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H264CodecSettings#bitrate_bps H264CodecSettings.bitrate_bps}.
            # @!attribute [rw] vbv_fullness_bits
            #   @return [::Integer]
            #     Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
            #     Must be greater than zero. The default is equal to 90% of
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H264CodecSettings#vbv_size_bits H264CodecSettings.vbv_size_bits}.
            # @!attribute [rw] entropy_coder
            #   @return [::String]
            #     The entropy coder to use. The default is `cabac`.
            #
            #     Supported entropy coders:
            #
            #     - `cavlc`
            #     - `cabac`
            # @!attribute [rw] b_pyramid
            #   @return [::Boolean]
            #     Allow B-pyramid for reference frame selection. This may not be supported
            #     on all decoders. The default is `false`.
            # @!attribute [rw] b_frame_count
            #   @return [::Integer]
            #     The number of consecutive B-frames. Must be greater than or equal to
            #     zero. Must be less than
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H264CodecSettings#gop_frame_count H264CodecSettings.gop_frame_count}
            #     if set. The default is 0.
            # @!attribute [rw] aq_strength
            #   @return [::Float]
            #     Specify the intensity of the adaptive quantizer (AQ). Must be between 0
            #     and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
            #     higher value equals a lower bitrate but smoother image. The default is 0.
            # @!attribute [rw] profile
            #   @return [::String]
            #     Enforces the specified codec profile. The following profiles are
            #     supported:
            #
            #     *   `baseline`
            #     *   `main`
            #     *   `high` (default)
            #
            #     The available options are
            #     [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H264CodecSettings`
            #     message.
            # @!attribute [rw] tune
            #   @return [::String]
            #     Enforces the specified codec tune. The available options are
            #     [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H264CodecSettings`
            #     message.
            # @!attribute [rw] preset
            #   @return [::String]
            #     Enforces the specified codec preset. The default is `veryfast`. The
            #     available options are
            #     [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H264CodecSettings`
            #     message.
            # @!attribute [rw] sdr
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H264ColorFormatSDR]
            #     Optional. SDR color format setting for H264.
            #
            #     Note: The following fields are mutually exclusive: `sdr`, `hlg`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] hlg
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H264ColorFormatHLG]
            #     Optional. HLG color format setting for H264.
            #
            #     Note: The following fields are mutually exclusive: `hlg`, `sdr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class H264CodecSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a Standard Dynamic Range (SDR) video.
            class H265ColorFormatSDR
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a Hybrid Log Gamma (HLG) video.
            class H265ColorFormatHLG
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a High Dynamic Range 10 (HDR10) video.
            class H265ColorFormatHDR10
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # H265 codec settings.
            # @!attribute [rw] width_pixels
            #   @return [::Integer]
            #     The width of the video in pixels. Must be an even integer.
            #     When not specified, the width is adjusted to match the specified height
            #     and input aspect ratio. If both are omitted, the input width is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the width, in pixels, per the horizontal ASR. The API calculates
            #     the height per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] height_pixels
            #   @return [::Integer]
            #     The height of the video in pixels. Must be an even integer.
            #     When not specified, the height is adjusted to match the specified width
            #     and input aspect ratio. If both are omitted, the input height is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the height, in pixels, per the horizontal ASR. The API calculates
            #     the width per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] frame_rate
            #   @return [::Float]
            #     Required. The target video frame rate in frames per second (FPS). Must be
            #     less than or equal to 120.
            # @!attribute [rw] frame_rate_conversion_strategy
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::FrameRateConversionStrategy]
            #     Optional. Frame rate conversion strategy for desired frame rate. The
            #     default is `DOWNSAMPLE`.
            # @!attribute [rw] bitrate_bps
            #   @return [::Integer]
            #     Required. The video bitrate in bits per second. The minimum value is
            #     1,000. The maximum value is 800,000,000.
            # @!attribute [rw] pixel_format
            #   @return [::String]
            #     Pixel format to use. The default is `yuv420p`.
            #
            #     Supported pixel formats:
            #
            #     - `yuv420p` pixel format
            #     - `yuv422p` pixel format
            #     - `yuv444p` pixel format
            #     - `yuv420p10` 10-bit HDR pixel format
            #     - `yuv422p10` 10-bit HDR pixel format
            #     - `yuv444p10` 10-bit HDR pixel format
            #     - `yuv420p12` 12-bit HDR pixel format
            #     - `yuv422p12` 12-bit HDR pixel format
            #     - `yuv444p12` 12-bit HDR pixel format
            # @!attribute [rw] rate_control_mode
            #   @return [::String]
            #     Specify the mode. The default is `vbr`.
            #
            #     Supported rate control modes:
            #
            #     - `vbr` - variable bitrate
            #     - `crf` - constant rate factor
            # @!attribute [rw] crf_level
            #   @return [::Integer]
            #     Target CRF level. Must be between 10 and 36, where 10 is the highest
            #     quality and 36 is the most efficient compression. The default is 21.
            # @!attribute [rw] allow_open_gop
            #   @return [::Boolean]
            #     Specifies whether an open Group of Pictures (GOP) structure should be
            #     allowed or not. The default is `false`.
            # @!attribute [rw] gop_frame_count
            #   @return [::Integer]
            #     Select the GOP size based on the specified frame count. Must be greater
            #     than zero.
            #
            #     Note: The following fields are mutually exclusive: `gop_frame_count`, `gop_duration`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] gop_duration
            #   @return [::Google::Protobuf::Duration]
            #     Select the GOP size based on the specified duration. The default is
            #     `3s`. Note that `gopDuration` must be less than or equal to
            #     [`segmentDuration`](#SegmentSettings), and
            #     [`segmentDuration`](#SegmentSettings) must be divisible by
            #     `gopDuration`.
            #
            #     Note: The following fields are mutually exclusive: `gop_duration`, `gop_frame_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] enable_two_pass
            #   @return [::Boolean]
            #     Use two-pass encoding strategy to achieve better video quality.
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H265CodecSettings#rate_control_mode H265CodecSettings.rate_control_mode}
            #     must be `vbr`. The default is `false`.
            # @!attribute [rw] vbv_size_bits
            #   @return [::Integer]
            #     Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
            #     greater than zero. The default is equal to `VideoStream.bitrate_bps`.
            # @!attribute [rw] vbv_fullness_bits
            #   @return [::Integer]
            #     Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
            #     Must be greater than zero. The default is equal to 90% of
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H265CodecSettings#vbv_size_bits H265CodecSettings.vbv_size_bits}.
            # @!attribute [rw] b_pyramid
            #   @return [::Boolean]
            #     Allow B-pyramid for reference frame selection. This may not be supported
            #     on all decoders. The default is `false`.
            # @!attribute [rw] b_frame_count
            #   @return [::Integer]
            #     The number of consecutive B-frames. Must be greater than or equal to
            #     zero. Must be less than
            #     {::Google::Cloud::Video::Transcoder::V1::VideoStream::H265CodecSettings#gop_frame_count H265CodecSettings.gop_frame_count}
            #     if set. The default is 0.
            # @!attribute [rw] aq_strength
            #   @return [::Float]
            #     Specify the intensity of the adaptive quantizer (AQ). Must be between 0
            #     and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
            #     higher value equals a lower bitrate but smoother image. The default is 0.
            # @!attribute [rw] profile
            #   @return [::String]
            #     Enforces the specified codec profile. The following profiles are
            #     supported:
            #
            #     *   8-bit profiles
            #         *   `main` (default)
            #         *   `main-intra`
            #         *   `mainstillpicture`
            #     *   10-bit profiles
            #         *   `main10` (default)
            #         *   `main10-intra`
            #         *   `main422-10`
            #         *   `main422-10-intra`
            #         *   `main444-10`
            #         *   `main444-10-intra`
            #     *   12-bit profiles
            #         *   `main12` (default)
            #         *   `main12-intra`
            #         *   `main422-12`
            #         *   `main422-12-intra`
            #         *   `main444-12`
            #         *   `main444-12-intra`
            #
            #     The available options are
            #     [FFmpeg-compatible](https://x265.readthedocs.io/).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H265CodecSettings`
            #     message.
            # @!attribute [rw] tune
            #   @return [::String]
            #     Enforces the specified codec tune. The available options are
            #     [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H265CodecSettings`
            #     message.
            # @!attribute [rw] preset
            #   @return [::String]
            #     Enforces the specified codec preset. The default is `veryfast`. The
            #     available options are
            #     [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `H265CodecSettings`
            #     message.
            # @!attribute [rw] sdr
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H265ColorFormatSDR]
            #     Optional. SDR color format setting for H265.
            #
            #     Note: The following fields are mutually exclusive: `sdr`, `hlg`, `hdr10`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] hlg
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H265ColorFormatHLG]
            #     Optional. HLG color format setting for H265.
            #
            #     Note: The following fields are mutually exclusive: `hlg`, `sdr`, `hdr10`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] hdr10
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::H265ColorFormatHDR10]
            #     Optional. HDR10 color format setting for H265.
            #
            #     Note: The following fields are mutually exclusive: `hdr10`, `sdr`, `hlg`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class H265CodecSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a Standard Dynamic Range (SDR) video.
            class Vp9ColorFormatSDR
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Convert the input video to a Hybrid Log Gamma (HLG) video.
            class Vp9ColorFormatHLG
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # VP9 codec settings.
            # @!attribute [rw] width_pixels
            #   @return [::Integer]
            #     The width of the video in pixels. Must be an even integer.
            #     When not specified, the width is adjusted to match the specified height
            #     and input aspect ratio. If both are omitted, the input width is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the width, in pixels, per the horizontal ASR. The API calculates
            #     the height per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] height_pixels
            #   @return [::Integer]
            #     The height of the video in pixels. Must be an even integer.
            #     When not specified, the height is adjusted to match the specified width
            #     and input aspect ratio. If both are omitted, the input height is used.
            #
            #     For portrait videos that contain horizontal ASR and rotation metadata,
            #     provide the height, in pixels, per the horizontal ASR. The API calculates
            #     the width per the horizontal ASR. The API detects any rotation metadata
            #     and swaps the requested height and width for the output.
            # @!attribute [rw] frame_rate
            #   @return [::Float]
            #     Required. The target video frame rate in frames per second (FPS). Must be
            #     less than or equal to 120.
            # @!attribute [rw] frame_rate_conversion_strategy
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::FrameRateConversionStrategy]
            #     Optional. Frame rate conversion strategy for desired frame rate. The
            #     default is `DOWNSAMPLE`.
            # @!attribute [rw] bitrate_bps
            #   @return [::Integer]
            #     Required. The video bitrate in bits per second. The minimum value is
            #     1,000. The maximum value is 480,000,000.
            # @!attribute [rw] pixel_format
            #   @return [::String]
            #     Pixel format to use. The default is `yuv420p`.
            #
            #     Supported pixel formats:
            #
            #     - `yuv420p` pixel format
            #     - `yuv422p` pixel format
            #     - `yuv444p` pixel format
            #     - `yuv420p10` 10-bit HDR pixel format
            #     - `yuv422p10` 10-bit HDR pixel format
            #     - `yuv444p10` 10-bit HDR pixel format
            #     - `yuv420p12` 12-bit HDR pixel format
            #     - `yuv422p12` 12-bit HDR pixel format
            #     - `yuv444p12` 12-bit HDR pixel format
            # @!attribute [rw] rate_control_mode
            #   @return [::String]
            #     Specify the mode. The default is `vbr`.
            #
            #     Supported rate control modes:
            #
            #     - `vbr` - variable bitrate
            # @!attribute [rw] crf_level
            #   @return [::Integer]
            #     Target CRF level. Must be between 10 and 36, where 10 is the highest
            #     quality and 36 is the most efficient compression. The default is 21.
            #
            #     **Note:** This field is not supported.
            # @!attribute [rw] gop_frame_count
            #   @return [::Integer]
            #     Select the GOP size based on the specified frame count. Must be greater
            #     than zero.
            #
            #     Note: The following fields are mutually exclusive: `gop_frame_count`, `gop_duration`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] gop_duration
            #   @return [::Google::Protobuf::Duration]
            #     Select the GOP size based on the specified duration. The default is
            #     `3s`. Note that `gopDuration` must be less than or equal to
            #     [`segmentDuration`](#SegmentSettings), and
            #     [`segmentDuration`](#SegmentSettings) must be divisible by
            #     `gopDuration`.
            #
            #     Note: The following fields are mutually exclusive: `gop_duration`, `gop_frame_count`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] profile
            #   @return [::String]
            #     Enforces the specified codec profile. The following profiles are
            #     supported:
            #
            #     *   `profile0` (default)
            #     *   `profile1`
            #     *   `profile2`
            #     *   `profile3`
            #
            #     The available options are
            #     [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
            #     Note that certain values for this field may cause the
            #     transcoder to override other fields you set in the `Vp9CodecSettings`
            #     message.
            # @!attribute [rw] sdr
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::Vp9ColorFormatSDR]
            #     Optional. SDR color format setting for VP9.
            #
            #     Note: The following fields are mutually exclusive: `sdr`, `hlg`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] hlg
            #   @return [::Google::Cloud::Video::Transcoder::V1::VideoStream::Vp9ColorFormatHLG]
            #     Optional. HLG color format setting for VP9.
            #
            #     Note: The following fields are mutually exclusive: `hlg`, `sdr`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class Vp9CodecSettings
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The conversion strategy for desired frame rate.
            module FrameRateConversionStrategy
              # Unspecified frame rate conversion strategy.
              FRAME_RATE_CONVERSION_STRATEGY_UNSPECIFIED = 0

              # Selectively retain frames to reduce the output frame rate.
              # Every _n_ th frame is kept, where `n = ceil(input frame rate / target
              # frame rate)`. When _n_ = 1 (that is, the target frame rate is greater
              # than the input frame rate), the output frame rate matches the input frame
              # rate. When _n_ > 1, frames are dropped and the output frame rate is
              # equal to `(input frame rate / n)`. For more information, see
              # [Calculate frame
              # rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate).
              DOWNSAMPLE = 1

              # Drop or duplicate frames to match the specified frame rate.
              DROP_DUPLICATE = 2
            end
          end

          # Audio stream resource.
          # @!attribute [rw] codec
          #   @return [::String]
          #     The codec for this audio stream. The default is `aac`.
          #
          #     Supported audio codecs:
          #
          #     - `aac`
          #     - `aac-he`
          #     - `aac-he-v2`
          #     - `mp3`
          #     - `ac3`
          #     - `eac3`
          #     - `vorbis`
          # @!attribute [rw] bitrate_bps
          #   @return [::Integer]
          #     Required. Audio bitrate in bits per second. Must be between 1 and
          #     10,000,000.
          # @!attribute [rw] channel_count
          #   @return [::Integer]
          #     Number of audio channels. Must be between 1 and 6. The default is 2.
          # @!attribute [rw] channel_layout
          #   @return [::Array<::String>]
          #     A list of channel names specifying layout of the audio channels.
          #     This only affects the metadata embedded in the container headers, if
          #     supported by the specified format. The default is `["fl", "fr"]`.
          #
          #     Supported channel names:
          #
          #     - `fl` - Front left channel
          #     - `fr` - Front right channel
          #     - `sl` - Side left channel
          #     - `sr` - Side right channel
          #     - `fc` - Front center channel
          #     - `lfe` - Low frequency
          # @!attribute [rw] mapping
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::AudioStream::AudioMapping>]
          #     The mapping for the
          #     {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}
          #     atoms with audio
          #     {::Google::Cloud::Video::Transcoder::V1::EditAtom#inputs EditAtom.inputs}.
          # @!attribute [rw] sample_rate_hertz
          #   @return [::Integer]
          #     The audio sample rate in Hertz. The default is 48000 Hertz.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The BCP-47 language code, such as `en-US` or `sr-Latn`. For more
          #     information, see
          #     https://www.unicode.org/reports/tr35/#Unicode_locale_identifier. Not
          #     supported in MP4 files.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The name for this particular audio stream that
          #     will be added to the HLS/DASH manifest. Not supported in MP4 files.
          class AudioStream
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The mapping for the
            # {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}
            # atoms with audio
            # {::Google::Cloud::Video::Transcoder::V1::EditAtom#inputs EditAtom.inputs}.
            # @!attribute [rw] atom_key
            #   @return [::String]
            #     Required. The
            #     {::Google::Cloud::Video::Transcoder::V1::EditAtom#key EditAtom.key} that
            #     references the atom with audio inputs in the
            #     {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}.
            # @!attribute [rw] input_key
            #   @return [::String]
            #     Required. The {::Google::Cloud::Video::Transcoder::V1::Input#key Input.key}
            #     that identifies the input file.
            # @!attribute [rw] input_track
            #   @return [::Integer]
            #     Required. The zero-based index of the track in the input file.
            # @!attribute [rw] input_channel
            #   @return [::Integer]
            #     Required. The zero-based index of the channel in the input audio stream.
            # @!attribute [rw] output_channel
            #   @return [::Integer]
            #     Required. The zero-based index of the channel in the output audio stream.
            # @!attribute [rw] gain_db
            #   @return [::Float]
            #     Audio volume control in dB. Negative values decrease volume,
            #     positive values increase. The default is 0.
            class AudioMapping
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Encoding of a text stream. For example, closed captions or subtitles.
          # @!attribute [rw] codec
          #   @return [::String]
          #     The codec for this text stream. The default is `webvtt`.
          #
          #     Supported text codecs:
          #
          #     - `srt`
          #     - `ttml`
          #     - `cea608`
          #     - `cea708`
          #     - `webvtt`
          # @!attribute [rw] language_code
          #   @return [::String]
          #     The BCP-47 language code, such as `en-US` or `sr-Latn`. For more
          #     information, see
          #     https://www.unicode.org/reports/tr35/#Unicode_locale_identifier. Not
          #     supported in MP4 files.
          # @!attribute [rw] mapping
          #   @return [::Array<::Google::Cloud::Video::Transcoder::V1::TextStream::TextMapping>]
          #     The mapping for the
          #     {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}
          #     atoms with text
          #     {::Google::Cloud::Video::Transcoder::V1::EditAtom#inputs EditAtom.inputs}.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The name for this particular text stream that
          #     will be added to the HLS/DASH manifest. Not supported in MP4 files.
          class TextStream
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The mapping for the
            # {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}
            # atoms with text
            # {::Google::Cloud::Video::Transcoder::V1::EditAtom#inputs EditAtom.inputs}.
            # @!attribute [rw] atom_key
            #   @return [::String]
            #     Required. The
            #     {::Google::Cloud::Video::Transcoder::V1::EditAtom#key EditAtom.key} that
            #     references atom with text inputs in the
            #     {::Google::Cloud::Video::Transcoder::V1::JobConfig#edit_list JobConfig.edit_list}.
            # @!attribute [rw] input_key
            #   @return [::String]
            #     Required. The {::Google::Cloud::Video::Transcoder::V1::Input#key Input.key}
            #     that identifies the input file.
            # @!attribute [rw] input_track
            #   @return [::Integer]
            #     Required. The zero-based index of the track in the input file.
            class TextMapping
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Segment settings for `ts`, `fmp4` and `vtt`.
          # @!attribute [rw] segment_duration
          #   @return [::Google::Protobuf::Duration]
          #     Duration of the segments in seconds. The default is `6.0s`. Note that
          #     `segmentDuration` must be greater than or equal to
          #     [`gopDuration`](#videostream), and `segmentDuration` must be divisible by
          #     [`gopDuration`](#videostream).
          # @!attribute [rw] individual_segments
          #   @return [::Boolean]
          #     Required. Create an individual segment file. The default is `false`.
          class SegmentSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Encryption settings.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. Identifier for this set of encryption options.
          # @!attribute [rw] aes_128
          #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::Aes128Encryption]
          #     Configuration for AES-128 encryption.
          #
          #     Note: The following fields are mutually exclusive: `aes_128`, `sample_aes`, `mpeg_cenc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sample_aes
          #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::SampleAesEncryption]
          #     Configuration for SAMPLE-AES encryption.
          #
          #     Note: The following fields are mutually exclusive: `sample_aes`, `aes_128`, `mpeg_cenc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mpeg_cenc
          #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::MpegCommonEncryption]
          #     Configuration for MPEG Common Encryption (MPEG-CENC).
          #
          #     Note: The following fields are mutually exclusive: `mpeg_cenc`, `aes_128`, `sample_aes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] secret_manager_key_source
          #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::SecretManagerSource]
          #     Keys are stored in Google Secret Manager.
          # @!attribute [rw] drm_systems
          #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::DrmSystems]
          #     Required. DRM system(s) to use; at least one must be specified. If a
          #     DRM system is omitted, it is considered disabled.
          class Encryption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for AES-128 encryption.
            class Aes128Encryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for SAMPLE-AES encryption.
            class SampleAesEncryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for MPEG Common Encryption (MPEG-CENC).
            # @!attribute [rw] scheme
            #   @return [::String]
            #     Required. Specify the encryption scheme.
            #
            #     Supported encryption schemes:
            #
            #     - `cenc`
            #     - `cbcs`
            class MpegCommonEncryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for secrets stored in Google Secret Manager.
            # @!attribute [rw] secret_version
            #   @return [::String]
            #     Required. The name of the Secret Version containing the encryption key in
            #     the following format:
            #     `projects/{project}/secrets/{secret_id}/versions/{version_number}`
            #
            #     Note that only numbered versions are supported. Aliases like "latest" are
            #     not supported.
            class SecretManagerSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Widevine configuration.
            class Widevine
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Fairplay configuration.
            class Fairplay
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Playready configuration.
            class Playready
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Clearkey configuration.
            class Clearkey
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Defines configuration for DRM systems in use.
            # @!attribute [rw] widevine
            #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::Widevine]
            #     Widevine configuration.
            # @!attribute [rw] fairplay
            #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::Fairplay]
            #     Fairplay configuration.
            # @!attribute [rw] playready
            #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::Playready]
            #     Playready configuration.
            # @!attribute [rw] clearkey
            #   @return [::Google::Cloud::Video::Transcoder::V1::Encryption::Clearkey]
            #     Clearkey configuration.
            class DrmSystems
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
