# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/video/stitcher/v1/video_stitcher_service_pb"
require "google/cloud/video/stitcher/v1/video_stitcher_service"

class ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_cdn_key
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cdn_key = {}
    cdn_key_id = "hello world"

    create_cdn_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_cdn_key, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::CdnKey), request["cdn_key"]
      assert_equal "hello world", request["cdn_key_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_cdn_key_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_cdn_key({ parent: parent, cdn_key: cdn_key, cdn_key_id: cdn_key_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_cdn_key parent: parent, cdn_key: cdn_key, cdn_key_id: cdn_key_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_cdn_key ::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest.new(parent: parent, cdn_key: cdn_key, cdn_key_id: cdn_key_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_cdn_key({ parent: parent, cdn_key: cdn_key, cdn_key_id: cdn_key_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_cdn_key(::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest.new(parent: parent, cdn_key: cdn_key, cdn_key_id: cdn_key_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_cdn_key_client_stub.call_rpc_count
    end
  end

  def test_list_cdn_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListCdnKeysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_cdn_keys_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_cdn_keys, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_cdn_keys_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_cdn_keys({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_cdn_keys parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_cdn_keys ::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_cdn_keys({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_cdn_keys(::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_cdn_keys_client_stub.call_rpc_count
    end
  end

  def test_get_cdn_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::CdnKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cdn_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cdn_key, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cdn_key_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cdn_key({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cdn_key name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cdn_key ::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cdn_key({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cdn_key(::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cdn_key_client_stub.call_rpc_count
    end
  end

  def test_delete_cdn_key
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_cdn_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_cdn_key, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_cdn_key_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_cdn_key({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_cdn_key name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_cdn_key ::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_cdn_key({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_cdn_key(::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_cdn_key_client_stub.call_rpc_count
    end
  end

  def test_update_cdn_key
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    cdn_key = {}
    update_mask = {}

    update_cdn_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_cdn_key, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::CdnKey), request["cdn_key"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_cdn_key_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_cdn_key({ cdn_key: cdn_key, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_cdn_key cdn_key: cdn_key, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_cdn_key ::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest.new(cdn_key: cdn_key, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_cdn_key({ cdn_key: cdn_key, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_cdn_key(::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest.new(cdn_key: cdn_key, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_cdn_key_client_stub.call_rpc_count
    end
  end

  def test_create_vod_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::VodSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vod_session = {}

    create_vod_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_vod_session, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::VodSession), request["vod_session"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_vod_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_vod_session({ parent: parent, vod_session: vod_session }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_vod_session parent: parent, vod_session: vod_session do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_vod_session ::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest.new(parent: parent, vod_session: vod_session) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_vod_session({ parent: parent, vod_session: vod_session }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_vod_session(::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest.new(parent: parent, vod_session: vod_session), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_vod_session_client_stub.call_rpc_count
    end
  end

  def test_get_vod_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::VodSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vod_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vod_session, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vod_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vod_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vod_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vod_session ::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vod_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vod_session(::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vod_session_client_stub.call_rpc_count
    end
  end

  def test_list_vod_stitch_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_vod_stitch_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vod_stitch_details, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vod_stitch_details_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vod_stitch_details({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vod_stitch_details parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vod_stitch_details ::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vod_stitch_details({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vod_stitch_details(::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vod_stitch_details_client_stub.call_rpc_count
    end
  end

  def test_get_vod_stitch_detail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::VodStitchDetail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vod_stitch_detail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vod_stitch_detail, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vod_stitch_detail_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vod_stitch_detail({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vod_stitch_detail name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vod_stitch_detail ::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vod_stitch_detail({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vod_stitch_detail(::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vod_stitch_detail_client_stub.call_rpc_count
    end
  end

  def test_list_vod_ad_tag_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_vod_ad_tag_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vod_ad_tag_details, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vod_ad_tag_details_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vod_ad_tag_details({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vod_ad_tag_details parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vod_ad_tag_details ::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vod_ad_tag_details({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vod_ad_tag_details(::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vod_ad_tag_details_client_stub.call_rpc_count
    end
  end

  def test_get_vod_ad_tag_detail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vod_ad_tag_detail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vod_ad_tag_detail, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vod_ad_tag_detail_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vod_ad_tag_detail({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vod_ad_tag_detail name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vod_ad_tag_detail ::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vod_ad_tag_detail({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vod_ad_tag_detail(::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vod_ad_tag_detail_client_stub.call_rpc_count
    end
  end

  def test_list_live_ad_tag_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_live_ad_tag_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_live_ad_tag_details, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_live_ad_tag_details_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_live_ad_tag_details({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_live_ad_tag_details parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_live_ad_tag_details ::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_live_ad_tag_details({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_live_ad_tag_details(::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_live_ad_tag_details_client_stub.call_rpc_count
    end
  end

  def test_get_live_ad_tag_detail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_live_ad_tag_detail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_live_ad_tag_detail, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_live_ad_tag_detail_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_live_ad_tag_detail({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_live_ad_tag_detail name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_live_ad_tag_detail ::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_live_ad_tag_detail({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_live_ad_tag_detail(::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_live_ad_tag_detail_client_stub.call_rpc_count
    end
  end

  def test_create_slate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    slate_id = "hello world"
    slate = {}
    request_id = "hello world"

    create_slate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_slate, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["slate_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::Slate), request["slate"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_slate_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_slate({ parent: parent, slate_id: slate_id, slate: slate, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_slate parent: parent, slate_id: slate_id, slate: slate, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_slate ::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest.new(parent: parent, slate_id: slate_id, slate: slate, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_slate({ parent: parent, slate_id: slate_id, slate: slate, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_slate(::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest.new(parent: parent, slate_id: slate_id, slate: slate, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_slate_client_stub.call_rpc_count
    end
  end

  def test_list_slates
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListSlatesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_slates_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_slates, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_slates_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_slates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_slates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_slates ::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_slates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_slates(::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_slates_client_stub.call_rpc_count
    end
  end

  def test_get_slate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::Slate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_slate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_slate, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetSlateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_slate_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_slate({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_slate name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_slate ::Google::Cloud::Video::Stitcher::V1::GetSlateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_slate({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_slate(::Google::Cloud::Video::Stitcher::V1::GetSlateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_slate_client_stub.call_rpc_count
    end
  end

  def test_update_slate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    slate = {}
    update_mask = {}

    update_slate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_slate, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::Slate), request["slate"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_slate_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_slate({ slate: slate, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_slate slate: slate, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_slate ::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest.new(slate: slate, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_slate({ slate: slate, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_slate(::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest.new(slate: slate, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_slate_client_stub.call_rpc_count
    end
  end

  def test_delete_slate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_slate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_slate, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_slate_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_slate({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_slate name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_slate ::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_slate({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_slate(::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_slate_client_stub.call_rpc_count
    end
  end

  def test_create_live_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::LiveSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    live_session = {}

    create_live_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_live_session, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::LiveSession), request["live_session"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_live_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_live_session({ parent: parent, live_session: live_session }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_live_session parent: parent, live_session: live_session do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_live_session ::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest.new(parent: parent, live_session: live_session) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_live_session({ parent: parent, live_session: live_session }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_live_session(::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest.new(parent: parent, live_session: live_session), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_live_session_client_stub.call_rpc_count
    end
  end

  def test_get_live_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::LiveSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_live_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_live_session, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_live_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_live_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_live_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_live_session ::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_live_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_live_session(::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_live_session_client_stub.call_rpc_count
    end
  end

  def test_create_live_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    live_config_id = "hello world"
    live_config = {}
    request_id = "hello world"

    create_live_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_live_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["live_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::LiveConfig), request["live_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_live_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_live_config({ parent: parent, live_config_id: live_config_id, live_config: live_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_live_config parent: parent, live_config_id: live_config_id, live_config: live_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_live_config ::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest.new(parent: parent, live_config_id: live_config_id, live_config: live_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_live_config({ parent: parent, live_config_id: live_config_id, live_config: live_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_live_config(::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest.new(parent: parent, live_config_id: live_config_id, live_config: live_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_live_config_client_stub.call_rpc_count
    end
  end

  def test_list_live_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_live_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_live_configs, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_live_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_live_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_live_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_live_configs ::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_live_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_live_configs(::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_live_configs_client_stub.call_rpc_count
    end
  end

  def test_get_live_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::LiveConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_live_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_live_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_live_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_live_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_live_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_live_config ::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_live_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_live_config(::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_live_config_client_stub.call_rpc_count
    end
  end

  def test_delete_live_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_live_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_live_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_live_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_live_config({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_live_config name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_live_config ::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_live_config({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_live_config(::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_live_config_client_stub.call_rpc_count
    end
  end

  def test_update_live_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    live_config = {}
    update_mask = {}

    update_live_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_live_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::LiveConfig), request["live_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_live_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_live_config({ live_config: live_config, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_live_config live_config: live_config, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_live_config ::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest.new(live_config: live_config, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_live_config({ live_config: live_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_live_config(::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest.new(live_config: live_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_live_config_client_stub.call_rpc_count
    end
  end

  def test_create_vod_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vod_config_id = "hello world"
    vod_config = {}
    request_id = "hello world"

    create_vod_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_vod_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["vod_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::VodConfig), request["vod_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_vod_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_vod_config({ parent: parent, vod_config_id: vod_config_id, vod_config: vod_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_vod_config parent: parent, vod_config_id: vod_config_id, vod_config: vod_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_vod_config ::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest.new(parent: parent, vod_config_id: vod_config_id, vod_config: vod_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_vod_config({ parent: parent, vod_config_id: vod_config_id, vod_config: vod_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_vod_config(::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest.new(parent: parent, vod_config_id: vod_config_id, vod_config: vod_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_vod_config_client_stub.call_rpc_count
    end
  end

  def test_list_vod_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::ListVodConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vod_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vod_configs, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vod_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vod_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vod_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vod_configs ::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vod_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vod_configs(::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vod_configs_client_stub.call_rpc_count
    end
  end

  def test_get_vod_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::Stitcher::V1::VodConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vod_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vod_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vod_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vod_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vod_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vod_config ::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vod_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vod_config(::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vod_config_client_stub.call_rpc_count
    end
  end

  def test_delete_vod_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_vod_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_vod_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_vod_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_vod_config({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_vod_config name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_vod_config ::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_vod_config({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_vod_config(::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_vod_config_client_stub.call_rpc_count
    end
  end

  def test_update_vod_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    vod_config = {}
    update_mask = {}

    update_vod_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_vod_config, name
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::Stitcher::V1::VodConfig), request["vod_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_vod_config_client_stub do
      # Create client
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_vod_config({ vod_config: vod_config, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_vod_config vod_config: vod_config, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_vod_config ::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest.new(vod_config: vod_config, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_vod_config({ vod_config: vod_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_vod_config(::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest.new(vod_config: vod_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_vod_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Operations, client.operations_client
  end
end
