# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/video/stitcher/v1/video_stitcher_service"

class ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_cdn_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cdn_key_path project: "value0", location: "value1", cdn_key: "value2"
      assert_equal "projects/value0/locations/value1/cdnKeys/value2", path
    end
  end

  def test_live_ad_tag_detail_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.live_ad_tag_detail_path project: "value0", location: "value1", live_session: "value2", live_ad_tag_detail: "value3"
      assert_equal "projects/value0/locations/value1/liveSessions/value2/liveAdTagDetails/value3", path
    end
  end

  def test_live_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.live_config_path project: "value0", location: "value1", live_config: "value2"
      assert_equal "projects/value0/locations/value1/liveConfigs/value2", path
    end
  end

  def test_live_session_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.live_session_path project: "value0", location: "value1", live_session: "value2"
      assert_equal "projects/value0/locations/value1/liveSessions/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_slate_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.slate_path project: "value0", location: "value1", slate: "value2"
      assert_equal "projects/value0/locations/value1/slates/value2", path
    end
  end

  def test_vod_ad_tag_detail_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.vod_ad_tag_detail_path project: "value0", location: "value1", vod_session: "value2", vod_ad_tag_detail: "value3"
      assert_equal "projects/value0/locations/value1/vodSessions/value2/vodAdTagDetails/value3", path
    end
  end

  def test_vod_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.vod_config_path project: "value0", location: "value1", vod_config: "value2"
      assert_equal "projects/value0/locations/value1/vodConfigs/value2", path
    end
  end

  def test_vod_session_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.vod_session_path project: "value0", location: "value1", vod_session: "value2"
      assert_equal "projects/value0/locations/value1/vodSessions/value2", path
    end
  end

  def test_vod_stitch_detail_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.vod_stitch_detail_path project: "value0", location: "value1", vod_session: "value2", vod_stitch_detail: "value3"
      assert_equal "projects/value0/locations/value1/vodSessions/value2/vodStitchDetails/value3", path
    end
  end
end
