# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Metadata used to register VOD configs.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the VOD config, in the form of
          #     `projects/{project}/locations/{location}/vodConfigs/{id}`.
          # @!attribute [rw] source_uri
          #   @return [::String]
          #     Required. Source URI for the VOD stream manifest.
          # @!attribute [rw] ad_tag_uri
          #   @return [::String]
          #     Required. The default ad tag associated with this VOD config.
          # @!attribute [rw] gam_vod_config
          #   @return [::Google::Cloud::Video::Stitcher::V1::GamVodConfig]
          #     Optional. Google Ad Manager (GAM) metadata.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::Stitcher::V1::VodConfig::State]
          #     Output only. State of the VOD config.
          # @!attribute [rw] source_fetch_options
          #   @return [::Google::Cloud::Video::Stitcher::V1::FetchOptions]
          #     Options for fetching source manifests and segments.
          class VodConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # State of the VOD config.
            module State
              # State is not specified.
              STATE_UNSPECIFIED = 0

              # VOD config is being created.
              CREATING = 1

              # VOD config is ready for use.
              READY = 2

              # VOD config is queued up for deletion.
              DELETING = 3
            end
          end

          # Metadata used for GAM ad decisioning.
          # @!attribute [rw] network_code
          #   @return [::String]
          #     Required. Ad Manager network code to associate with the VOD config.
          class GamVodConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
