# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Metadata for used to register live configs.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The resource name of the live config, in the form of
          #     `projects/{project}/locations/{location}/liveConfigs/{id}`.
          # @!attribute [rw] source_uri
          #   @return [::String]
          #     Required. Source URI for the live stream manifest.
          # @!attribute [rw] ad_tag_uri
          #   @return [::String]
          #     The default ad tag associated with this live stream config.
          # @!attribute [rw] gam_live_config
          #   @return [::Google::Cloud::Video::Stitcher::V1::GamLiveConfig]
          #     Additional metadata used to register a live stream with Google Ad Manager
          #     (GAM)
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::Stitcher::V1::LiveConfig::State]
          #     Output only. State of the live config.
          # @!attribute [rw] ad_tracking
          #   @return [::Google::Cloud::Video::Stitcher::V1::AdTracking]
          #     Required. Determines how the ads are tracked.
          # @!attribute [rw] default_slate
          #   @return [::String]
          #     This must refer to a slate in the same
          #     project. If Google Ad Manager (GAM) is used for ads, this string sets the
          #     value of `slateCreativeId` in
          #     https://developers.google.com/ad-manager/api/reference/v202211/LiveStreamEventService.LiveStreamEvent#slateCreativeId
          # @!attribute [rw] stitching_policy
          #   @return [::Google::Cloud::Video::Stitcher::V1::LiveConfig::StitchingPolicy]
          #     Defines the stitcher behavior in case an ad does not align exactly with
          #     the ad break boundaries. If not specified, the default is `CUT_CURRENT`.
          # @!attribute [rw] prefetch_config
          #   @return [::Google::Cloud::Video::Stitcher::V1::PrefetchConfig]
          #     The configuration for prefetching ads.
          # @!attribute [rw] source_fetch_options
          #   @return [::Google::Cloud::Video::Stitcher::V1::FetchOptions]
          #     Options for fetching source manifests and segments.
          class LiveConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # State of the live config.
            module State
              # State is not specified.
              STATE_UNSPECIFIED = 0

              # Live config is being created.
              CREATING = 1

              # Live config is ready for use.
              READY = 2

              # Live config is queued up for deletion.
              DELETING = 3
            end

            # Defines the ad stitching behavior in case the ad duration does not align
            # exactly with the ad break boundaries. If not specified, the default is
            # `CUT_CURRENT`.
            module StitchingPolicy
              # Stitching policy is not specified.
              STITCHING_POLICY_UNSPECIFIED = 0

              # Cuts an ad short and returns to content in the middle of the ad.
              CUT_CURRENT = 1

              # Finishes stitching the current ad before returning to content.
              COMPLETE_AD = 2
            end
          end

          # The configuration for prefetch ads.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Required. Indicates whether the option to prefetch ad requests is enabled.
          # @!attribute [rw] initial_ad_request_duration
          #   @return [::Google::Protobuf::Duration]
          #     The duration in seconds of the part of the break to be prefetched.
          #     This field is only relevant if prefetch is enabled.
          #     You should set this duration to as long as possible to increase the
          #     benefits of prefetching, but not longer than the shortest ad break
          #     expected. For example, for a live event with 30s and 60s ad breaks, the
          #     initial duration should be set to 30s.
          class PrefetchConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata used to register a live stream with Google Ad Manager (GAM)
          # @!attribute [rw] network_code
          #   @return [::String]
          #     Required. Ad Manager network code to associate with the live config.
          # @!attribute [r] asset_key
          #   @return [::String]
          #     Output only. The asset key identifier generated for the live config.
          # @!attribute [r] custom_asset_key
          #   @return [::String]
          #     Output only. The custom asset key identifier generated for the live config.
          class GamLiveConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Determines the ad tracking policy.
          module AdTracking
            # The ad tracking policy is not specified.
            AD_TRACKING_UNSPECIFIED = 0

            # Client-side ad tracking is specified. The client player is expected to
            # trigger playback and activity events itself.
            CLIENT = 1

            # The Video Stitcher API will trigger playback events on behalf of
            # the client player.
            SERVER = 2
          end
        end
      end
    end
  end
end
