# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Describes an event and a trigger URI.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Video::Stitcher::V1::Event::EventType]
          #     Describes the event that occurred.
          # @!attribute [rw] uri
          #   @return [::String]
          #     The URI to trigger for this event.
          # @!attribute [rw] id
          #   @return [::String]
          #     The ID of the event.
          # @!attribute [rw] offset
          #   @return [::Google::Protobuf::Duration]
          #     The offset in seconds if the event type is `PROGRESS`.
          class Event
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes the event that occurred.
            module EventType
              # The event type is unspecified.
              EVENT_TYPE_UNSPECIFIED = 0

              # First frame of creative ad viewed.
              CREATIVE_VIEW = 1

              # Creative ad started.
              START = 2

              # Start of an ad break.
              BREAK_START = 3

              # End of an ad break.
              BREAK_END = 4

              # Impression.
              IMPRESSION = 5

              # First quartile progress.
              FIRST_QUARTILE = 6

              # Midpoint progress.
              MIDPOINT = 7

              # Third quartile progress.
              THIRD_QUARTILE = 8

              # Ad progress completed.
              COMPLETE = 9

              # Specific progress event with an offset.
              PROGRESS = 10

              # Player muted.
              MUTE = 11

              # Player unmuted.
              UNMUTE = 12

              # Player paused.
              PAUSE = 13

              # Click event.
              CLICK = 14

              # Click-through event.
              CLICK_THROUGH = 15

              # Player rewinding.
              REWIND = 16

              # Player resumed.
              RESUME = 17

              # Error event.
              ERROR = 18

              # Ad expanded to a larger size.
              EXPAND = 21

              # Ad collapsed to a smaller size.
              COLLAPSE = 22

              # Non-linear ad closed.
              CLOSE = 24

              # Linear ad closed.
              CLOSE_LINEAR = 25

              # Ad skipped.
              SKIP = 26

              # Accept invitation event.
              ACCEPT_INVITATION = 27
            end
          end

          # Indicates a time in which a list of events should be triggered
          # during media playback.
          # @!attribute [rw] time_offset
          #   @return [::Google::Protobuf::Duration]
          #     The time when the following tracking events occurs. The time is in
          #     seconds relative to the start of the VOD asset.
          # @!attribute [rw] events
          #   @return [::Array<::Google::Cloud::Video::Stitcher::V1::Event>]
          #     The list of progress tracking events for the ad break. These can be of
          #     the following IAB types: `BREAK_START`, `BREAK_END`, `IMPRESSION`,
          #     `CREATIVE_VIEW`, `START`, `FIRST_QUARTILE`, `MIDPOINT`, `THIRD_QUARTILE`,
          #     `COMPLETE`, `PROGRESS`.
          class ProgressEvent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
