# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Metadata for companion ads.
          # @!attribute [rw] display_requirement
          #   @return [::Google::Cloud::Video::Stitcher::V1::CompanionAds::DisplayRequirement]
          #     Indicates how many of the companions should be displayed with the ad.
          # @!attribute [rw] companions
          #   @return [::Array<::Google::Cloud::Video::Stitcher::V1::Companion>]
          #     List of companion ads.
          class CompanionAds
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Indicates how many of the companions should be displayed with the ad.
            module DisplayRequirement
              # Required companions are not specified. The default is ALL.
              DISPLAY_REQUIREMENT_UNSPECIFIED = 0

              # All companions are required to be displayed.
              ALL = 1

              # At least one of companions needs to be displayed.
              ANY = 2

              # All companions are optional for display.
              NONE = 3
            end
          end

          # Metadata for a companion.
          # @!attribute [rw] iframe_ad_resource
          #   @return [::Google::Cloud::Video::Stitcher::V1::IframeAdResource]
          #     The IFrame ad resource associated with the companion ad.
          #
          #     Note: The following fields are mutually exclusive: `iframe_ad_resource`, `static_ad_resource`, `html_ad_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] static_ad_resource
          #   @return [::Google::Cloud::Video::Stitcher::V1::StaticAdResource]
          #     The static ad resource associated with the companion ad.
          #
          #     Note: The following fields are mutually exclusive: `static_ad_resource`, `iframe_ad_resource`, `html_ad_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] html_ad_resource
          #   @return [::Google::Cloud::Video::Stitcher::V1::HtmlAdResource]
          #     The HTML ad resource associated with the companion ad.
          #
          #     Note: The following fields are mutually exclusive: `html_ad_resource`, `iframe_ad_resource`, `static_ad_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] api_framework
          #   @return [::String]
          #     The API necessary to communicate with the creative if available.
          # @!attribute [rw] height_px
          #   @return [::Integer]
          #     The pixel height of the placement slot for the intended creative.
          # @!attribute [rw] width_px
          #   @return [::Integer]
          #     The pixel width of the placement slot for the intended creative.
          # @!attribute [rw] asset_height_px
          #   @return [::Integer]
          #     The pixel height of the creative.
          # @!attribute [rw] expanded_height_px
          #   @return [::Integer]
          #     The maximum pixel height of the creative in its expanded state.
          # @!attribute [rw] asset_width_px
          #   @return [::Integer]
          #     The pixel width of the creative.
          # @!attribute [rw] expanded_width_px
          #   @return [::Integer]
          #     The maximum pixel width of the creative in its expanded state.
          # @!attribute [rw] ad_slot_id
          #   @return [::String]
          #     The ID used to identify the desired placement on a publisher's page.
          #     Values to be used should be discussed between publishers and
          #     advertisers.
          # @!attribute [rw] events
          #   @return [::Array<::Google::Cloud::Video::Stitcher::V1::Event>]
          #     The list of tracking events for the companion.
          class Companion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for an HTML ad resource.
          # @!attribute [rw] html_source
          #   @return [::String]
          #     The HTML to display for the ad resource.
          class HtmlAdResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for an IFrame ad resource.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI source for an IFrame to display for the ad resource.
          class IframeAdResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for a static ad resource.
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI to the static file for the ad resource.
          # @!attribute [rw] creative_type
          #   @return [::String]
          #     Describes the MIME type of the ad resource.
          class StaticAdResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
