# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Configuration for a CDN key. Used by the Video Stitcher
          # to sign URIs for fetching video manifests and signing
          # media segments for playback.
          # @!attribute [rw] google_cdn_key
          #   @return [::Google::Cloud::Video::Stitcher::V1::GoogleCdnKey]
          #     The configuration for a Google Cloud CDN key.
          #
          #     Note: The following fields are mutually exclusive: `google_cdn_key`, `akamai_cdn_key`, `media_cdn_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] akamai_cdn_key
          #   @return [::Google::Cloud::Video::Stitcher::V1::AkamaiCdnKey]
          #     The configuration for an Akamai CDN key.
          #
          #     Note: The following fields are mutually exclusive: `akamai_cdn_key`, `google_cdn_key`, `media_cdn_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] media_cdn_key
          #   @return [::Google::Cloud::Video::Stitcher::V1::MediaCdnKey]
          #     The configuration for a Media CDN key.
          #
          #     Note: The following fields are mutually exclusive: `media_cdn_key`, `google_cdn_key`, `akamai_cdn_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the CDN key, in the form of
          #     `projects/{project}/locations/{location}/cdnKeys/{id}`.
          #     The name is ignored when creating a CDN key.
          # @!attribute [rw] hostname
          #   @return [::String]
          #     The hostname this key applies to.
          class CdnKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a Google Cloud CDN key.
          # @!attribute [rw] private_key
          #   @return [::String]
          #     Input only. Secret for this Google Cloud CDN key.
          # @!attribute [rw] key_name
          #   @return [::String]
          #     The public name of the Google Cloud CDN key.
          class GoogleCdnKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for an Akamai CDN key.
          # @!attribute [rw] token_key
          #   @return [::String]
          #     Input only. Token key for the Akamai CDN edge configuration.
          class AkamaiCdnKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for a Media CDN key.
          # @!attribute [rw] private_key
          #   @return [::String]
          #     Input only. 64-byte ed25519 private key for this Media CDN key.
          # @!attribute [rw] key_name
          #   @return [::String]
          #     The keyset name of the Media CDN key.
          # @!attribute [rw] token_config
          #   @return [::Google::Cloud::Video::Stitcher::V1::MediaCdnKey::TokenConfig]
          #     Optional. If set, the URL will be signed using the Media CDN token.
          #     Otherwise, the URL would be signed using the standard Media CDN signature.
          class MediaCdnKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for a Media CDN token.
            # @!attribute [rw] query_parameter
            #   @return [::String]
            #     Optional. The query parameter in which to find the token.
            #
            #     The name must be 1-64 characters long and match
            #     the regular expression `[a-zA-Z]([a-zA-Z0-9_-])*` which means the
            #     first character must be a letter, and all following characters
            #     must be a dash, underscore, letter or digit.
            #
            #     Defaults to `edge-cache-token`.
            class TokenConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
