# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          # Information related to the details for one ad tag. This resource is only
          # available for live sessions that do not implement Google Ad Manager ad
          # insertion.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name in the form of
          #     `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{id}`.
          # @!attribute [rw] ad_requests
          #   @return [::Array<::Google::Cloud::Video::Stitcher::V1::AdRequest>]
          #     A list of ad requests.
          class LiveAdTagDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information related to the details for one ad tag. This resource is only
          # available for VOD sessions that do not implement Google Ad Manager ad
          # insertion.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the ad tag detail for the specified VOD session, in the form of
          #     `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{id}`.
          # @!attribute [rw] ad_requests
          #   @return [::Array<::Google::Cloud::Video::Stitcher::V1::AdRequest>]
          #     A list of ad requests for one ad tag.
          class VodAdTagDetail
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details of an ad request to an ad server.
          # @!attribute [rw] uri
          #   @return [::String]
          #     The ad tag URI processed with integrated macros.
          # @!attribute [rw] request_metadata
          #   @return [::Google::Cloud::Video::Stitcher::V1::RequestMetadata]
          #     The request metadata used to make the ad request.
          # @!attribute [rw] response_metadata
          #   @return [::Google::Cloud::Video::Stitcher::V1::ResponseMetadata]
          #     The response metadata received from the ad request.
          class AdRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for an ad request.
          # @!attribute [rw] headers
          #   @return [::Google::Protobuf::Struct]
          #     The HTTP headers of the ad request.
          class RequestMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for the response of an ad request.
          # @!attribute [rw] error
          #   @return [::String]
          #     Error message received when making the ad request.
          # @!attribute [rw] headers
          #   @return [::Google::Protobuf::Struct]
          #     Headers from the response.
          # @!attribute [rw] status_code
          #   @return [::String]
          #     Status code for the response.
          # @!attribute [rw] size_bytes
          #   @return [::Integer]
          #     Size in bytes of the response.
          # @!attribute [rw] duration
          #   @return [::Google::Protobuf::Duration]
          #     Total time elapsed for the response.
          # @!attribute [rw] body
          #   @return [::String]
          #     The body of the response.
          class ResponseMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
