# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/video/stitcher/v1/video_stitcher_service_pb"

module Google
  module Cloud
    module Video
      module Stitcher
        module V1
          module VideoStitcherService
            ##
            # Client for the VideoStitcherService service.
            #
            # Video-On-Demand content stitching API allows you to insert ads
            # into (VoD) video on demand files. You will be able to render custom
            # scrubber bars with highlighted ads, enforce ad policies, allow
            # seamless playback and tracking on native players and monetize
            # content with any standard VMAP compliant ad server.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "videostitcher.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :video_stitcher_service_stub

              ##
              # Configure the VideoStitcherService Client class.
              #
              # See {::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all VideoStitcherService clients
              #   ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Video", "Stitcher", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_cdn_key.timeout = 60.0

                  default_config.rpcs.list_cdn_keys.timeout = 60.0

                  default_config.rpcs.get_cdn_key.timeout = 60.0

                  default_config.rpcs.delete_cdn_key.timeout = 60.0

                  default_config.rpcs.update_cdn_key.timeout = 60.0

                  default_config.rpcs.create_vod_session.timeout = 60.0

                  default_config.rpcs.get_vod_session.timeout = 60.0

                  default_config.rpcs.list_vod_stitch_details.timeout = 60.0

                  default_config.rpcs.get_vod_stitch_detail.timeout = 60.0

                  default_config.rpcs.list_vod_ad_tag_details.timeout = 60.0

                  default_config.rpcs.get_vod_ad_tag_detail.timeout = 60.0

                  default_config.rpcs.list_live_ad_tag_details.timeout = 60.0

                  default_config.rpcs.get_live_ad_tag_detail.timeout = 60.0

                  default_config.rpcs.create_slate.timeout = 60.0

                  default_config.rpcs.list_slates.timeout = 60.0

                  default_config.rpcs.get_slate.timeout = 60.0

                  default_config.rpcs.update_slate.timeout = 60.0

                  default_config.rpcs.delete_slate.timeout = 60.0

                  default_config.rpcs.create_live_session.timeout = 60.0

                  default_config.rpcs.get_live_session.timeout = 60.0

                  default_config.rpcs.create_live_config.timeout = 60.0

                  default_config.rpcs.list_live_configs.timeout = 60.0

                  default_config.rpcs.get_live_config.timeout = 60.0

                  default_config.rpcs.delete_live_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the VideoStitcherService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @video_stitcher_service_stub.universe_domain
              end

              ##
              # Create a new VideoStitcherService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the VideoStitcherService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/video/stitcher/v1/video_stitcher_service_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @video_stitcher_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @video_stitcher_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @video_stitcher_service_stub.logger
              end

              # Service calls

              ##
              # Creates a new CDN key.
              #
              # @overload create_cdn_key(request, options = nil)
              #   Pass arguments to `create_cdn_key` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_cdn_key(parent: nil, cdn_key: nil, cdn_key_id: nil)
              #   Pass arguments to `create_cdn_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the CDN key should be created, in the form
              #     of `projects/{project_number}/locations/{location}`.
              #   @param cdn_key [::Google::Cloud::Video::Stitcher::V1::CdnKey, ::Hash]
              #     Required. The CDN key resource to create.
              #   @param cdn_key_id [::String]
              #     Required. The ID to use for the CDN key, which will become the final
              #     component of the CDN key's resource name.
              #
              #     This value should conform to RFC-1034, which restricts to
              #     lower-case letters, numbers, and hyphen, with the first character a
              #     letter, the last a letter or a number, and a 63 character maximum.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest.new
              #
              #   # Call the create_cdn_key method.
              #   result = client.create_cdn_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cdn_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateCdnKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_cdn_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_cdn_key.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_cdn_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_cdn_key, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all CDN keys in the specified project and location.
              #
              # @overload list_cdn_keys(request, options = nil)
              #   Pass arguments to `list_cdn_keys` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_cdn_keys(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_cdn_keys` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project that contains the list of CDN keys, in the form of
              #     `projects/{project_number}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::CdnKey>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::CdnKey>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest.new
              #
              #   # Call the list_cdn_keys method.
              #   result = client.list_cdn_keys request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::CdnKey.
              #     p item
              #   end
              #
              def list_cdn_keys request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListCdnKeysRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_cdn_keys.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_cdn_keys.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_cdn_keys.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_cdn_keys, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_cdn_keys, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified CDN key.
              #
              # @overload get_cdn_key(request, options = nil)
              #   Pass arguments to `get_cdn_key` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_cdn_key(name: nil)
              #   Pass arguments to `get_cdn_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CDN key to be retrieved, in the form of
              #     `projects/{project}/locations/{location}/cdnKeys/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::CdnKey]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::CdnKey]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest.new
              #
              #   # Call the get_cdn_key method.
              #   result = client.get_cdn_key request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::CdnKey.
              #   p result
              #
              def get_cdn_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetCdnKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_cdn_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_cdn_key.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_cdn_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_cdn_key, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified CDN key.
              #
              # @overload delete_cdn_key(request, options = nil)
              #   Pass arguments to `delete_cdn_key` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_cdn_key(name: nil)
              #   Pass arguments to `delete_cdn_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the CDN key to be deleted, in the form of
              #     `projects/{project_number}/locations/{location}/cdnKeys/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest.new
              #
              #   # Call the delete_cdn_key method.
              #   result = client.delete_cdn_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cdn_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::DeleteCdnKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_cdn_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_cdn_key.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_cdn_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :delete_cdn_key, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified CDN key. Only update fields specified
              # in the call method body.
              #
              # @overload update_cdn_key(request, options = nil)
              #   Pass arguments to `update_cdn_key` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_cdn_key(cdn_key: nil, update_mask: nil)
              #   Pass arguments to `update_cdn_key` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param cdn_key [::Google::Cloud::Video::Stitcher::V1::CdnKey, ::Hash]
              #     Required. The CDN key resource which replaces the resource on the server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest.new
              #
              #   # Call the update_cdn_key method.
              #   result = client.update_cdn_key request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cdn_key request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::UpdateCdnKeyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_cdn_key.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.cdn_key&.name
                  header_params["cdn_key.name"] = request.cdn_key.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_cdn_key.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_cdn_key.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :update_cdn_key, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a client side playback VOD session and returns the full
              # tracking and playback metadata of the session.
              #
              # @overload create_vod_session(request, options = nil)
              #   Pass arguments to `create_vod_session` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_vod_session(parent: nil, vod_session: nil)
              #   Pass arguments to `create_vod_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location in which the VOD session should be
              #     created, in the form of `projects/{project_number}/locations/{location}`.
              #   @param vod_session [::Google::Cloud::Video::Stitcher::V1::VodSession, ::Hash]
              #     Required. Parameters for creating a session.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::VodSession]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VodSession]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest.new
              #
              #   # Call the create_vod_session method.
              #   result = client.create_vod_session request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::VodSession.
              #   p result
              #
              def create_vod_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateVodSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_vod_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_vod_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_vod_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_vod_session, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the full tracking, playback metadata, and relevant ad-ops
              # logs for the specified VOD session.
              #
              # @overload get_vod_session(request, options = nil)
              #   Pass arguments to `get_vod_session` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_vod_session(name: nil)
              #   Pass arguments to `get_vod_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the VOD session to be retrieved, in the form of
              #     `projects/{project_number}/locations/{location}/vodSessions/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::VodSession]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VodSession]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest.new
              #
              #   # Call the get_vod_session method.
              #   result = client.get_vod_session request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::VodSession.
              #   p result
              #
              def get_vod_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetVodSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_vod_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_vod_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_vod_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_vod_session, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of detailed stitching information of the specified VOD
              # session.
              #
              # @overload list_vod_stitch_details(request, options = nil)
              #   Pass arguments to `list_vod_stitch_details` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_vod_stitch_details(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_vod_stitch_details` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The VOD session where the stitch details belong to, in the form
              #     of `projects/{project}/locations/{location}/vodSessions/{id}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodStitchDetail>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodStitchDetail>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest.new
              #
              #   # Call the list_vod_stitch_details method.
              #   result = client.list_vod_stitch_details request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::VodStitchDetail.
              #     p item
              #   end
              #
              def list_vod_stitch_details request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListVodStitchDetailsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_vod_stitch_details.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_vod_stitch_details.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_vod_stitch_details.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_vod_stitch_details, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_vod_stitch_details, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified stitching information for the specified VOD session.
              #
              # @overload get_vod_stitch_detail(request, options = nil)
              #   Pass arguments to `get_vod_stitch_detail` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_vod_stitch_detail(name: nil)
              #   Pass arguments to `get_vod_stitch_detail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the stitch detail in the specified VOD session, in
              #     the form of
              #     `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodStitchDetails/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::VodStitchDetail]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VodStitchDetail]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest.new
              #
              #   # Call the get_vod_stitch_detail method.
              #   result = client.get_vod_stitch_detail request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::VodStitchDetail.
              #   p result
              #
              def get_vod_stitch_detail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetVodStitchDetailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_vod_stitch_detail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_vod_stitch_detail.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_vod_stitch_detail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_vod_stitch_detail, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Return the list of ad tag details for the specified VOD session.
              #
              # @overload list_vod_ad_tag_details(request, options = nil)
              #   Pass arguments to `list_vod_ad_tag_details` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_vod_ad_tag_details(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_vod_ad_tag_details` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The VOD session which the ad tag details belong to, in the form
              #     of `projects/{project}/locations/{location}/vodSessions/{vod_session_id}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest.new
              #
              #   # Call the list_vod_ad_tag_details method.
              #   result = client.list_vod_ad_tag_details request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail.
              #     p item
              #   end
              #
              def list_vod_ad_tag_details request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListVodAdTagDetailsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_vod_ad_tag_details.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_vod_ad_tag_details.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_vod_ad_tag_details.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_vod_ad_tag_details, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_vod_ad_tag_details, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified ad tag detail for the specified VOD session.
              #
              # @overload get_vod_ad_tag_detail(request, options = nil)
              #   Pass arguments to `get_vod_ad_tag_detail` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_vod_ad_tag_detail(name: nil)
              #   Pass arguments to `get_vod_ad_tag_detail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the ad tag detail for the specified VOD session, in
              #     the form of
              #     `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{vod_ad_tag_detail}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VodAdTagDetail]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest.new
              #
              #   # Call the get_vod_ad_tag_detail method.
              #   result = client.get_vod_ad_tag_detail request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::VodAdTagDetail.
              #   p result
              #
              def get_vod_ad_tag_detail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetVodAdTagDetailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_vod_ad_tag_detail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_vod_ad_tag_detail.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_vod_ad_tag_detail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_vod_ad_tag_detail, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Return the list of ad tag details for the specified live session.
              #
              # @overload list_live_ad_tag_details(request, options = nil)
              #   Pass arguments to `list_live_ad_tag_details` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_live_ad_tag_details(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_live_ad_tag_details` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource parent in the form of
              #     `projects/{project}/locations/{location}/liveSessions/{live_session}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The pagination token returned from a previous List request.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest.new
              #
              #   # Call the list_live_ad_tag_details method.
              #   result = client.list_live_ad_tag_details request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail.
              #     p item
              #   end
              #
              def list_live_ad_tag_details request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListLiveAdTagDetailsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_live_ad_tag_details.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_live_ad_tag_details.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_live_ad_tag_details.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_live_ad_tag_details, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_live_ad_tag_details, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified ad tag detail for the specified live session.
              #
              # @overload get_live_ad_tag_detail(request, options = nil)
              #   Pass arguments to `get_live_ad_tag_detail` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_live_ad_tag_detail(name: nil)
              #   Pass arguments to `get_live_ad_tag_detail` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name in the form of
              #     `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest.new
              #
              #   # Call the get_live_ad_tag_detail method.
              #   result = client.get_live_ad_tag_detail request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::LiveAdTagDetail.
              #   p result
              #
              def get_live_ad_tag_detail request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetLiveAdTagDetailRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_live_ad_tag_detail.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_live_ad_tag_detail.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_live_ad_tag_detail.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_live_ad_tag_detail, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a slate.
              #
              # @overload create_slate(request, options = nil)
              #   Pass arguments to `create_slate` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_slate(parent: nil, slate_id: nil, slate: nil, request_id: nil)
              #   Pass arguments to `create_slate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the slate should be created, in the form of
              #     `projects/{project_number}/locations/{location}`.
              #   @param slate_id [::String]
              #     Required. The unique identifier for the slate.
              #     This value should conform to RFC-1034, which restricts to
              #     lower-case letters, numbers, and hyphen, with the first character a
              #     letter, the last a letter or a number, and a 63 character maximum.
              #   @param slate [::Google::Cloud::Video::Stitcher::V1::Slate, ::Hash]
              #     Required. The slate to create.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateSlateRequest.new
              #
              #   # Call the create_slate method.
              #   result = client.create_slate request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_slate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateSlateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_slate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_slate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_slate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_slate, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all slates in the specified project and location.
              #
              # @overload list_slates(request, options = nil)
              #   Pass arguments to `list_slates` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_slates(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_slates` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project to list slates, in the form of
              #     `projects/{project_number}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::Slate>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::Slate>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListSlatesRequest.new
              #
              #   # Call the list_slates method.
              #   result = client.list_slates request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::Slate.
              #     p item
              #   end
              #
              def list_slates request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListSlatesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_slates.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_slates.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_slates.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_slates, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_slates, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified slate.
              #
              # @overload get_slate(request, options = nil)
              #   Pass arguments to `get_slate` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetSlateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetSlateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_slate(name: nil)
              #   Pass arguments to `get_slate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the slate to be retrieved, of the slate, in the form
              #     of `projects/{project_number}/locations/{location}/slates/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::Slate]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::Slate]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetSlateRequest.new
              #
              #   # Call the get_slate method.
              #   result = client.get_slate request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::Slate.
              #   p result
              #
              def get_slate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetSlateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_slate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_slate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_slate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_slate, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified slate.
              #
              # @overload update_slate(request, options = nil)
              #   Pass arguments to `update_slate` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_slate(slate: nil, update_mask: nil)
              #   Pass arguments to `update_slate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param slate [::Google::Cloud::Video::Stitcher::V1::Slate, ::Hash]
              #     Required. The resource with updated fields.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask which specifies fields which should be updated.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest.new
              #
              #   # Call the update_slate method.
              #   result = client.update_slate request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_slate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::UpdateSlateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_slate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.slate&.name
                  header_params["slate.name"] = request.slate.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_slate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_slate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :update_slate, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified slate.
              #
              # @overload delete_slate(request, options = nil)
              #   Pass arguments to `delete_slate` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_slate(name: nil)
              #   Pass arguments to `delete_slate` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the slate to be deleted, in the form of
              #     `projects/{project_number}/locations/{location}/slates/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest.new
              #
              #   # Call the delete_slate method.
              #   result = client.delete_slate request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_slate request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::DeleteSlateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_slate.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_slate.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_slate.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :delete_slate, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new live session.
              #
              # @overload create_live_session(request, options = nil)
              #   Pass arguments to `create_live_session` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_live_session(parent: nil, live_session: nil)
              #   Pass arguments to `create_live_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location in which the live session should be
              #     created, in the form of `projects/{project_number}/locations/{location}`.
              #   @param live_session [::Google::Cloud::Video::Stitcher::V1::LiveSession, ::Hash]
              #     Required. Parameters for creating a live session.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::LiveSession]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::LiveSession]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest.new
              #
              #   # Call the create_live_session method.
              #   result = client.create_live_session request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::LiveSession.
              #   p result
              #
              def create_live_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateLiveSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_live_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_live_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_live_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_live_session, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the details for the specified live session.
              #
              # @overload get_live_session(request, options = nil)
              #   Pass arguments to `get_live_session` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_live_session(name: nil)
              #   Pass arguments to `get_live_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the live session, in the form of
              #     `projects/{project_number}/locations/{location}/liveSessions/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::LiveSession]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::LiveSession]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest.new
              #
              #   # Call the get_live_session method.
              #   result = client.get_live_session request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::LiveSession.
              #   p result
              #
              def get_live_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetLiveSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_live_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_live_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_live_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_live_session, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers the live config with the provided unique ID in
              # the specified region.
              #
              # @overload create_live_config(request, options = nil)
              #   Pass arguments to `create_live_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_live_config(parent: nil, live_config_id: nil, live_config: nil, request_id: nil)
              #   Pass arguments to `create_live_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the live config should be created, in
              #     the form of `projects/{project_number}/locations/{location}`.
              #   @param live_config_id [::String]
              #     Required. The unique identifier ID to use for the live config.
              #   @param live_config [::Google::Cloud::Video::Stitcher::V1::LiveConfig, ::Hash]
              #     Required. The live config resource to create.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest.new
              #
              #   # Call the create_live_config method.
              #   result = client.create_live_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_live_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateLiveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_live_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_live_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_live_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_live_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all live configs managed by the Video Stitcher that
              # belong to the specified project and region.
              #
              # @overload list_live_configs(request, options = nil)
              #   Pass arguments to `list_live_configs` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_live_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_live_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project that contains the list of live configs, in the
              #     form of `projects/{project_number}/locations/{location}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #   @param filter [::String]
              #     Optional. The filter to apply to list results (see
              #     [Filtering](https://google.aip.dev/160)).
              #   @param order_by [::String]
              #     Optional. Specifies the ordering of results following
              #     [Cloud API
              #     syntax](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::LiveConfig>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::LiveConfig>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest.new
              #
              #   # Call the list_live_configs method.
              #   result = client.list_live_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::LiveConfig.
              #     p item
              #   end
              #
              def list_live_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListLiveConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_live_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_live_configs.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_live_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_live_configs, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_live_configs, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified live config managed by the Video
              # Stitcher service.
              #
              # @overload get_live_config(request, options = nil)
              #   Pass arguments to `get_live_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_live_config(name: nil)
              #   Pass arguments to `get_live_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the live config to be retrieved, in the form
              #     of
              #     `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::LiveConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::LiveConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest.new
              #
              #   # Call the get_live_config method.
              #   result = client.get_live_config request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::LiveConfig.
              #   p result
              #
              def get_live_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetLiveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_live_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_live_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_live_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_live_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified live config.
              #
              # @overload delete_live_config(request, options = nil)
              #   Pass arguments to `delete_live_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_live_config(name: nil)
              #   Pass arguments to `delete_live_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the live config to be deleted, in the form of
              #     `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest.new
              #
              #   # Call the delete_live_config method.
              #   result = client.delete_live_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_live_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::DeleteLiveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_live_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_live_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_live_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :delete_live_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified LiveConfig. Only update fields specified
              # in the call method body.
              #
              # @overload update_live_config(request, options = nil)
              #   Pass arguments to `update_live_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_live_config(live_config: nil, update_mask: nil)
              #   Pass arguments to `update_live_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param live_config [::Google::Cloud::Video::Stitcher::V1::LiveConfig, ::Hash]
              #     Required. The LiveConfig resource which replaces the resource on the
              #     server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest.new
              #
              #   # Call the update_live_config method.
              #   result = client.update_live_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_live_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::UpdateLiveConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_live_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.live_config&.name
                  header_params["live_config.name"] = request.live_config.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_live_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_live_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :update_live_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers the VOD config with the provided unique ID in
              # the specified region.
              #
              # @overload create_vod_config(request, options = nil)
              #   Pass arguments to `create_vod_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_vod_config(parent: nil, vod_config_id: nil, vod_config: nil, request_id: nil)
              #   Pass arguments to `create_vod_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project in which the VOD config should be created, in
              #     the form of `projects/{project_number}/locations/{location}`.
              #   @param vod_config_id [::String]
              #     Required. The unique identifier ID to use for the VOD config.
              #   @param vod_config [::Google::Cloud::Video::Stitcher::V1::VodConfig, ::Hash]
              #     Required. The VOD config resource to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest.new
              #
              #   # Call the create_vod_config method.
              #   result = client.create_vod_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_vod_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::CreateVodConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_vod_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_vod_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_vod_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :create_vod_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all VOD configs managed by the Video Stitcher API that
              # belong to the specified project and region.
              #
              # @overload list_vod_configs(request, options = nil)
              #   Pass arguments to `list_vod_configs` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_vod_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_vod_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project that contains the list of VOD configs, in the
              #     form of `projects/{project_number}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #   @param page_token [::String]
              #     Optional. The next_page_token value returned from a previous List request,
              #     if any.
              #   @param filter [::String]
              #     Optional. The filter to apply to list results (see
              #     [Filtering](https://google.aip.dev/160)).
              #   @param order_by [::String]
              #     Optional. Specifies the ordering of results following
              #     [Cloud API
              #     syntax](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodConfig>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::Stitcher::V1::VodConfig>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest.new
              #
              #   # Call the list_vod_configs method.
              #   result = client.list_vod_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::Stitcher::V1::VodConfig.
              #     p item
              #   end
              #
              def list_vod_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::ListVodConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_vod_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_vod_configs.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_vod_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :list_vod_configs, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @video_stitcher_service_stub, :list_vod_configs, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified VOD config managed by the Video
              # Stitcher API service.
              #
              # @overload get_vod_config(request, options = nil)
              #   Pass arguments to `get_vod_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_vod_config(name: nil)
              #   Pass arguments to `get_vod_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the VOD config to be retrieved, in the form
              #     of `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::Stitcher::V1::VodConfig]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::Stitcher::V1::VodConfig]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest.new
              #
              #   # Call the get_vod_config method.
              #   result = client.get_vod_config request
              #
              #   # The returned object is of type Google::Cloud::Video::Stitcher::V1::VodConfig.
              #   p result
              #
              def get_vod_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::GetVodConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_vod_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_vod_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_vod_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :get_vod_config, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified VOD config.
              #
              # @overload delete_vod_config(request, options = nil)
              #   Pass arguments to `delete_vod_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_vod_config(name: nil)
              #   Pass arguments to `delete_vod_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the VOD config to be deleted, in the form of
              #     `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest.new
              #
              #   # Call the delete_vod_config method.
              #   result = client.delete_vod_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_vod_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::DeleteVodConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_vod_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_vod_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_vod_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :delete_vod_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified VOD config. Only update fields specified
              # in the call method body.
              #
              # @overload update_vod_config(request, options = nil)
              #   Pass arguments to `update_vod_config` via a request object, either of type
              #   {::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_vod_config(vod_config: nil, update_mask: nil)
              #   Pass arguments to `update_vod_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param vod_config [::Google::Cloud::Video::Stitcher::V1::VodConfig, ::Hash]
              #     Required. The VOD config resource which replaces the resource on the
              #     server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource.
              #     For the `FieldMask` definition, see
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/stitcher/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest.new
              #
              #   # Call the update_vod_config method.
              #   result = client.update_vod_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_vod_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::Stitcher::V1::UpdateVodConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_vod_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::Stitcher::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.vod_config&.name
                  header_params["vod_config.name"] = request.vod_config.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_vod_config.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_vod_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @video_stitcher_service_stub.call_rpc :update_vod_config, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the VideoStitcherService API.
              #
              # This class represents the configuration for VideoStitcherService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_cdn_key to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_cdn_key.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_cdn_key.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Video::Stitcher::V1::VideoStitcherService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "videostitcher.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the VideoStitcherService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_cdn_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cdn_key
                  ##
                  # RPC-specific configuration for `list_cdn_keys`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_cdn_keys
                  ##
                  # RPC-specific configuration for `get_cdn_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cdn_key
                  ##
                  # RPC-specific configuration for `delete_cdn_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cdn_key
                  ##
                  # RPC-specific configuration for `update_cdn_key`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cdn_key
                  ##
                  # RPC-specific configuration for `create_vod_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_vod_session
                  ##
                  # RPC-specific configuration for `get_vod_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_vod_session
                  ##
                  # RPC-specific configuration for `list_vod_stitch_details`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_vod_stitch_details
                  ##
                  # RPC-specific configuration for `get_vod_stitch_detail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_vod_stitch_detail
                  ##
                  # RPC-specific configuration for `list_vod_ad_tag_details`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_vod_ad_tag_details
                  ##
                  # RPC-specific configuration for `get_vod_ad_tag_detail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_vod_ad_tag_detail
                  ##
                  # RPC-specific configuration for `list_live_ad_tag_details`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_live_ad_tag_details
                  ##
                  # RPC-specific configuration for `get_live_ad_tag_detail`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_live_ad_tag_detail
                  ##
                  # RPC-specific configuration for `create_slate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_slate
                  ##
                  # RPC-specific configuration for `list_slates`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_slates
                  ##
                  # RPC-specific configuration for `get_slate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_slate
                  ##
                  # RPC-specific configuration for `update_slate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_slate
                  ##
                  # RPC-specific configuration for `delete_slate`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_slate
                  ##
                  # RPC-specific configuration for `create_live_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_live_session
                  ##
                  # RPC-specific configuration for `get_live_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_live_session
                  ##
                  # RPC-specific configuration for `create_live_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_live_config
                  ##
                  # RPC-specific configuration for `list_live_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_live_configs
                  ##
                  # RPC-specific configuration for `get_live_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_live_config
                  ##
                  # RPC-specific configuration for `delete_live_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_live_config
                  ##
                  # RPC-specific configuration for `update_live_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_live_config
                  ##
                  # RPC-specific configuration for `create_vod_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_vod_config
                  ##
                  # RPC-specific configuration for `list_vod_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_vod_configs
                  ##
                  # RPC-specific configuration for `get_vod_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_vod_config
                  ##
                  # RPC-specific configuration for `delete_vod_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_vod_config
                  ##
                  # RPC-specific configuration for `update_vod_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_vod_config

                  # @private
                  def initialize parent_rpcs = nil
                    create_cdn_key_config = parent_rpcs.create_cdn_key if parent_rpcs.respond_to? :create_cdn_key
                    @create_cdn_key = ::Gapic::Config::Method.new create_cdn_key_config
                    list_cdn_keys_config = parent_rpcs.list_cdn_keys if parent_rpcs.respond_to? :list_cdn_keys
                    @list_cdn_keys = ::Gapic::Config::Method.new list_cdn_keys_config
                    get_cdn_key_config = parent_rpcs.get_cdn_key if parent_rpcs.respond_to? :get_cdn_key
                    @get_cdn_key = ::Gapic::Config::Method.new get_cdn_key_config
                    delete_cdn_key_config = parent_rpcs.delete_cdn_key if parent_rpcs.respond_to? :delete_cdn_key
                    @delete_cdn_key = ::Gapic::Config::Method.new delete_cdn_key_config
                    update_cdn_key_config = parent_rpcs.update_cdn_key if parent_rpcs.respond_to? :update_cdn_key
                    @update_cdn_key = ::Gapic::Config::Method.new update_cdn_key_config
                    create_vod_session_config = parent_rpcs.create_vod_session if parent_rpcs.respond_to? :create_vod_session
                    @create_vod_session = ::Gapic::Config::Method.new create_vod_session_config
                    get_vod_session_config = parent_rpcs.get_vod_session if parent_rpcs.respond_to? :get_vod_session
                    @get_vod_session = ::Gapic::Config::Method.new get_vod_session_config
                    list_vod_stitch_details_config = parent_rpcs.list_vod_stitch_details if parent_rpcs.respond_to? :list_vod_stitch_details
                    @list_vod_stitch_details = ::Gapic::Config::Method.new list_vod_stitch_details_config
                    get_vod_stitch_detail_config = parent_rpcs.get_vod_stitch_detail if parent_rpcs.respond_to? :get_vod_stitch_detail
                    @get_vod_stitch_detail = ::Gapic::Config::Method.new get_vod_stitch_detail_config
                    list_vod_ad_tag_details_config = parent_rpcs.list_vod_ad_tag_details if parent_rpcs.respond_to? :list_vod_ad_tag_details
                    @list_vod_ad_tag_details = ::Gapic::Config::Method.new list_vod_ad_tag_details_config
                    get_vod_ad_tag_detail_config = parent_rpcs.get_vod_ad_tag_detail if parent_rpcs.respond_to? :get_vod_ad_tag_detail
                    @get_vod_ad_tag_detail = ::Gapic::Config::Method.new get_vod_ad_tag_detail_config
                    list_live_ad_tag_details_config = parent_rpcs.list_live_ad_tag_details if parent_rpcs.respond_to? :list_live_ad_tag_details
                    @list_live_ad_tag_details = ::Gapic::Config::Method.new list_live_ad_tag_details_config
                    get_live_ad_tag_detail_config = parent_rpcs.get_live_ad_tag_detail if parent_rpcs.respond_to? :get_live_ad_tag_detail
                    @get_live_ad_tag_detail = ::Gapic::Config::Method.new get_live_ad_tag_detail_config
                    create_slate_config = parent_rpcs.create_slate if parent_rpcs.respond_to? :create_slate
                    @create_slate = ::Gapic::Config::Method.new create_slate_config
                    list_slates_config = parent_rpcs.list_slates if parent_rpcs.respond_to? :list_slates
                    @list_slates = ::Gapic::Config::Method.new list_slates_config
                    get_slate_config = parent_rpcs.get_slate if parent_rpcs.respond_to? :get_slate
                    @get_slate = ::Gapic::Config::Method.new get_slate_config
                    update_slate_config = parent_rpcs.update_slate if parent_rpcs.respond_to? :update_slate
                    @update_slate = ::Gapic::Config::Method.new update_slate_config
                    delete_slate_config = parent_rpcs.delete_slate if parent_rpcs.respond_to? :delete_slate
                    @delete_slate = ::Gapic::Config::Method.new delete_slate_config
                    create_live_session_config = parent_rpcs.create_live_session if parent_rpcs.respond_to? :create_live_session
                    @create_live_session = ::Gapic::Config::Method.new create_live_session_config
                    get_live_session_config = parent_rpcs.get_live_session if parent_rpcs.respond_to? :get_live_session
                    @get_live_session = ::Gapic::Config::Method.new get_live_session_config
                    create_live_config_config = parent_rpcs.create_live_config if parent_rpcs.respond_to? :create_live_config
                    @create_live_config = ::Gapic::Config::Method.new create_live_config_config
                    list_live_configs_config = parent_rpcs.list_live_configs if parent_rpcs.respond_to? :list_live_configs
                    @list_live_configs = ::Gapic::Config::Method.new list_live_configs_config
                    get_live_config_config = parent_rpcs.get_live_config if parent_rpcs.respond_to? :get_live_config
                    @get_live_config = ::Gapic::Config::Method.new get_live_config_config
                    delete_live_config_config = parent_rpcs.delete_live_config if parent_rpcs.respond_to? :delete_live_config
                    @delete_live_config = ::Gapic::Config::Method.new delete_live_config_config
                    update_live_config_config = parent_rpcs.update_live_config if parent_rpcs.respond_to? :update_live_config
                    @update_live_config = ::Gapic::Config::Method.new update_live_config_config
                    create_vod_config_config = parent_rpcs.create_vod_config if parent_rpcs.respond_to? :create_vod_config
                    @create_vod_config = ::Gapic::Config::Method.new create_vod_config_config
                    list_vod_configs_config = parent_rpcs.list_vod_configs if parent_rpcs.respond_to? :list_vod_configs
                    @list_vod_configs = ::Gapic::Config::Method.new list_vod_configs_config
                    get_vod_config_config = parent_rpcs.get_vod_config if parent_rpcs.respond_to? :get_vod_config
                    @get_vod_config = ::Gapic::Config::Method.new get_vod_config_config
                    delete_vod_config_config = parent_rpcs.delete_vod_config if parent_rpcs.respond_to? :delete_vod_config
                    @delete_vod_config = ::Gapic::Config::Method.new delete_vod_config_config
                    update_vod_config_config = parent_rpcs.update_vod_config if parent_rpcs.respond_to? :update_vod_config
                    @update_vod_config = ::Gapic::Config::Method.new update_vod_config_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
