# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/video/livestream/v1/service_pb"
require "google/cloud/video/live_stream/v1/livestream_service"

class ::Google::Cloud::Video::LiveStream::V1::LivestreamService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel = {}
    channel_id = "hello world"
    request_id = "hello world"

    create_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Channel), request["channel"]
      assert_equal "hello world", request["channel_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel parent: parent, channel: channel, channel_id: channel_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel ::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel(::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_client_stub.call_rpc_count
    end
  end

  def test_list_channels
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListChannelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_channels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channels, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channels_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channels parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channels ::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channels(::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channels_client_stub.call_rpc_count
    end
  end

  def test_get_channel
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Channel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetChannelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel ::Google::Cloud::Video::LiveStream::V1::GetChannelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel(::Google::Cloud::Video::LiveStream::V1::GetChannelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_client_stub.call_rpc_count
    end
  end

  def test_delete_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_channel({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_channel name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_channel ::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_channel({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_channel(::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_channel_client_stub.call_rpc_count
    end
  end

  def test_update_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    channel = {}
    request_id = "hello world"

    update_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Channel), request["channel"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_channel({ update_mask: update_mask, channel: channel, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_channel update_mask: update_mask, channel: channel, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_channel ::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest.new(update_mask: update_mask, channel: channel, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_channel({ update_mask: update_mask, channel: channel, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_channel(::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest.new(update_mask: update_mask, channel: channel, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_channel_client_stub.call_rpc_count
    end
  end

  def test_start_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    start_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::StartChannelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_channel({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_channel name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_channel ::Google::Cloud::Video::LiveStream::V1::StartChannelRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_channel({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_channel(::Google::Cloud::Video::LiveStream::V1::StartChannelRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_channel_client_stub.call_rpc_count
    end
  end

  def test_stop_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    stop_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_channel, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::StopChannelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_channel({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_channel name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_channel ::Google::Cloud::Video::LiveStream::V1::StopChannelRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_channel({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_channel(::Google::Cloud::Video::LiveStream::V1::StopChannelRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_channel_client_stub.call_rpc_count
    end
  end

  def test_start_distribution
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    distribution_keys = ["hello world"]
    request_id = "hello world"

    start_distribution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_distribution, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["distribution_keys"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_distribution_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_distribution name: name, distribution_keys: distribution_keys, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_distribution ::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_distribution(::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_distribution_client_stub.call_rpc_count
    end
  end

  def test_stop_distribution
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    distribution_keys = ["hello world"]
    request_id = "hello world"

    stop_distribution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_distribution, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["distribution_keys"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_distribution_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_distribution name: name, distribution_keys: distribution_keys, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_distribution ::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_distribution(::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_distribution_client_stub.call_rpc_count
    end
  end

  def test_create_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    input = {}
    input_id = "hello world"
    request_id = "hello world"

    create_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_input, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateInputRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Input), request["input"]
      assert_equal "hello world", request["input_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_input_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_input({ parent: parent, input: input, input_id: input_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_input parent: parent, input: input, input_id: input_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_input ::Google::Cloud::Video::LiveStream::V1::CreateInputRequest.new(parent: parent, input: input, input_id: input_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_input({ parent: parent, input: input, input_id: input_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_input(::Google::Cloud::Video::LiveStream::V1::CreateInputRequest.new(parent: parent, input: input, input_id: input_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_input_client_stub.call_rpc_count
    end
  end

  def test_list_inputs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListInputsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_inputs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_inputs, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListInputsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_inputs_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_inputs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_inputs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_inputs ::Google::Cloud::Video::LiveStream::V1::ListInputsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_inputs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_inputs(::Google::Cloud::Video::LiveStream::V1::ListInputsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_inputs_client_stub.call_rpc_count
    end
  end

  def test_get_input
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Input.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_input, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetInputRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_input_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_input({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_input name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_input ::Google::Cloud::Video::LiveStream::V1::GetInputRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_input({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_input(::Google::Cloud::Video::LiveStream::V1::GetInputRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_input_client_stub.call_rpc_count
    end
  end

  def test_delete_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_input, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_input_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_input({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_input name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_input ::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_input({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_input(::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_input_client_stub.call_rpc_count
    end
  end

  def test_update_input
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    input = {}
    request_id = "hello world"

    update_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_input, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Input), request["input"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_input_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_input({ update_mask: update_mask, input: input, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_input update_mask: update_mask, input: input, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_input ::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest.new(update_mask: update_mask, input: input, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_input({ update_mask: update_mask, input: input, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_input(::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest.new(update_mask: update_mask, input: input, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_input_client_stub.call_rpc_count
    end
  end

  def test_preview_input
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::PreviewInputResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    preview_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :preview_input, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, preview_input_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.preview_input({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.preview_input name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.preview_input ::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.preview_input({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.preview_input(::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, preview_input_client_stub.call_rpc_count
    end
  end

  def test_create_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Event.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event = {}
    event_id = "hello world"
    request_id = "hello world"

    create_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_event, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateEventRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Event), request["event"]
      assert_equal "hello world", request["event_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_event_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_event({ parent: parent, event: event, event_id: event_id, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_event parent: parent, event: event, event_id: event_id, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_event ::Google::Cloud::Video::LiveStream::V1::CreateEventRequest.new(parent: parent, event: event, event_id: event_id, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_event({ parent: parent, event: event, event_id: event_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_event(::Google::Cloud::Video::LiveStream::V1::CreateEventRequest.new(parent: parent, event: event, event_id: event_id, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_event_client_stub.call_rpc_count
    end
  end

  def test_list_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_events, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListEventsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_events_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_events parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_events ::Google::Cloud::Video::LiveStream::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_events(::Google::Cloud::Video::LiveStream::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_events_client_stub.call_rpc_count
    end
  end

  def test_get_event
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Event.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_event, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetEventRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_event_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_event({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_event name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_event ::Google::Cloud::Video::LiveStream::V1::GetEventRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_event({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_event(::Google::Cloud::Video::LiveStream::V1::GetEventRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_event_client_stub.call_rpc_count
    end
  end

  def test_delete_event
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_event_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_event, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_event_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_event({ name: name, request_id: request_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_event name: name, request_id: request_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_event ::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_event({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_event(::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_event_client_stub.call_rpc_count
    end
  end

  def test_list_clips
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListClipsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clips_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_clips, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListClipsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_clips_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_clips({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_clips parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_clips ::Google::Cloud::Video::LiveStream::V1::ListClipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_clips({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_clips(::Google::Cloud::Video::LiveStream::V1::ListClipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_clips_client_stub.call_rpc_count
    end
  end

  def test_get_clip
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Clip.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_clip_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_clip, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetClipRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_clip_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_clip({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_clip name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_clip ::Google::Cloud::Video::LiveStream::V1::GetClipRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_clip({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_clip(::Google::Cloud::Video::LiveStream::V1::GetClipRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_clip_client_stub.call_rpc_count
    end
  end

  def test_create_clip
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    clip_id = "hello world"
    clip = {}
    request_id = "hello world"

    create_clip_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_clip, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateClipRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["clip_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Clip), request["clip"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_clip_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_clip({ parent: parent, clip_id: clip_id, clip: clip, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_clip parent: parent, clip_id: clip_id, clip: clip, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_clip ::Google::Cloud::Video::LiveStream::V1::CreateClipRequest.new(parent: parent, clip_id: clip_id, clip: clip, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_clip({ parent: parent, clip_id: clip_id, clip: clip, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_clip(::Google::Cloud::Video::LiveStream::V1::CreateClipRequest.new(parent: parent, clip_id: clip_id, clip: clip, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_clip_client_stub.call_rpc_count
    end
  end

  def test_delete_clip
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_clip_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_clip, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_clip_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_clip({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_clip name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_clip ::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_clip({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_clip(::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_clip_client_stub.call_rpc_count
    end
  end

  def test_create_dvr_session
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dvr_session_id = "hello world"
    dvr_session = {}
    request_id = "hello world"

    create_dvr_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_dvr_session, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["dvr_session_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::DvrSession), request["dvr_session"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_dvr_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_dvr_session({ parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_dvr_session parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_dvr_session ::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest.new(parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_dvr_session({ parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_dvr_session(::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest.new(parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_dvr_session_client_stub.call_rpc_count
    end
  end

  def test_list_dvr_sessions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_dvr_sessions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_dvr_sessions, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_dvr_sessions_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_dvr_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_dvr_sessions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_dvr_sessions ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_dvr_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_dvr_sessions(::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_dvr_sessions_client_stub.call_rpc_count
    end
  end

  def test_get_dvr_session
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::DvrSession.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dvr_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dvr_session, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dvr_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dvr_session({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dvr_session name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dvr_session ::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dvr_session({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dvr_session(::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dvr_session_client_stub.call_rpc_count
    end
  end

  def test_delete_dvr_session
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_dvr_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_dvr_session, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_dvr_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_dvr_session({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_dvr_session name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_dvr_session ::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_dvr_session({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_dvr_session(::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_dvr_session_client_stub.call_rpc_count
    end
  end

  def test_update_dvr_session
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    dvr_session = {}
    request_id = "hello world"

    update_dvr_session_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_dvr_session, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::DvrSession), request["dvr_session"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_dvr_session_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_dvr_session({ update_mask: update_mask, dvr_session: dvr_session, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_dvr_session update_mask: update_mask, dvr_session: dvr_session, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_dvr_session ::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest.new(update_mask: update_mask, dvr_session: dvr_session, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_dvr_session({ update_mask: update_mask, dvr_session: dvr_session, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_dvr_session(::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest.new(update_mask: update_mask, dvr_session: dvr_session, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_dvr_session_client_stub.call_rpc_count
    end
  end

  def test_create_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    asset = {}
    asset_id = "hello world"
    request_id = "hello world"

    create_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_asset, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Asset), request["asset"]
      assert_equal "hello world", request["asset_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_asset_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_asset({ parent: parent, asset: asset, asset_id: asset_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_asset parent: parent, asset: asset, asset_id: asset_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_asset ::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_asset({ parent: parent, asset: asset, asset_id: asset_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_asset(::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_asset_client_stub.call_rpc_count
    end
  end

  def test_delete_asset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_asset, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_asset_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_asset({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_asset name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_asset ::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_asset({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_asset(::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_asset_client_stub.call_rpc_count
    end
  end

  def test_get_asset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Asset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_asset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_asset, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetAssetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_asset_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_asset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_asset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_asset ::Google::Cloud::Video::LiveStream::V1::GetAssetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_asset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_asset(::Google::Cloud::Video::LiveStream::V1::GetAssetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_asset_client_stub.call_rpc_count
    end
  end

  def test_list_assets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::ListAssetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_assets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_assets, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_assets_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_assets ::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_assets(::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_assets_client_stub.call_rpc_count
    end
  end

  def test_get_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Video::LiveStream::V1::Pool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_pool, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::GetPoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_pool ::Google::Cloud::Video::LiveStream::V1::GetPoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_pool(::Google::Cloud::Video::LiveStream::V1::GetPoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_pool_client_stub.call_rpc_count
    end
  end

  def test_update_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    pool = {}
    request_id = "hello world"

    update_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_pool, name
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Video::LiveStream::V1::Pool), request["pool"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_pool({ update_mask: update_mask, pool: pool, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_pool update_mask: update_mask, pool: pool, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_pool ::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest.new(update_mask: update_mask, pool: pool, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_pool({ update_mask: update_mask, pool: pool, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_pool(::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest.new(update_mask: update_mask, pool: pool, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_pool_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Operations, client.operations_client
  end
end
