# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/video/livestream/v1/service_pb"
require "google/cloud/video/live_stream/v1/livestream_service/rest"


class ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel = {}
    channel_id = "hello world"
    request_id = "hello world"

    create_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel parent: parent, channel: channel, channel_id: channel_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel ::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel(::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_client_stub.call_count
      end
    end
  end

  def test_list_channels
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListChannelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_channels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_channels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channels_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channels parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channels ::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channels(::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channels_client_stub.call_count
      end
    end
  end

  def test_get_channel
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Channel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel ::Google::Cloud::Video::LiveStream::V1::GetChannelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel(::Google::Cloud::Video::LiveStream::V1::GetChannelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_client_stub.call_count
      end
    end
  end

  def test_delete_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_channel({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_channel name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_channel ::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_channel({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_channel(::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_channel_client_stub.call_count
      end
    end
  end

  def test_update_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    channel = {}
    request_id = "hello world"

    update_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_update_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_channel({ update_mask: update_mask, channel: channel, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_channel update_mask: update_mask, channel: channel, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_channel ::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest.new(update_mask: update_mask, channel: channel, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_channel({ update_mask: update_mask, channel: channel, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_channel(::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest.new(update_mask: update_mask, channel: channel, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_channel_client_stub.call_count
      end
    end
  end

  def test_start_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    start_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_start_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_channel({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_channel name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_channel ::Google::Cloud::Video::LiveStream::V1::StartChannelRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_channel({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_channel(::Google::Cloud::Video::LiveStream::V1::StartChannelRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_channel_client_stub.call_count
      end
    end
  end

  def test_stop_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    stop_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_stop_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_channel({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_channel name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_channel ::Google::Cloud::Video::LiveStream::V1::StopChannelRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_channel({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_channel(::Google::Cloud::Video::LiveStream::V1::StopChannelRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_channel_client_stub.call_count
      end
    end
  end

  def test_start_distribution
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    distribution_keys = ["hello world"]
    request_id = "hello world"

    start_distribution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_start_distribution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_distribution_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_distribution name: name, distribution_keys: distribution_keys, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_distribution ::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_distribution(::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_distribution_client_stub.call_count
      end
    end
  end

  def test_stop_distribution
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    distribution_keys = ["hello world"]
    request_id = "hello world"

    stop_distribution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_stop_distribution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_distribution_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_distribution name: name, distribution_keys: distribution_keys, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_distribution ::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_distribution({ name: name, distribution_keys: distribution_keys, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_distribution(::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest.new(name: name, distribution_keys: distribution_keys, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_distribution_client_stub.call_count
      end
    end
  end

  def test_create_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    input = {}
    input_id = "hello world"
    request_id = "hello world"

    create_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_input_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_input({ parent: parent, input: input, input_id: input_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_input parent: parent, input: input, input_id: input_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_input ::Google::Cloud::Video::LiveStream::V1::CreateInputRequest.new(parent: parent, input: input, input_id: input_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_input({ parent: parent, input: input, input_id: input_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_input(::Google::Cloud::Video::LiveStream::V1::CreateInputRequest.new(parent: parent, input: input, input_id: input_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_input_client_stub.call_count
      end
    end
  end

  def test_list_inputs
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListInputsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_inputs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_inputs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_inputs_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_inputs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_inputs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_inputs ::Google::Cloud::Video::LiveStream::V1::ListInputsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_inputs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_inputs(::Google::Cloud::Video::LiveStream::V1::ListInputsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_inputs_client_stub.call_count
      end
    end
  end

  def test_get_input
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Input.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_input_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_input({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_input name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_input ::Google::Cloud::Video::LiveStream::V1::GetInputRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_input({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_input(::Google::Cloud::Video::LiveStream::V1::GetInputRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_input_client_stub.call_count
      end
    end
  end

  def test_delete_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_input_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_input({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_input name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_input ::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_input({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_input(::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_input_client_stub.call_count
      end
    end
  end

  def test_update_input
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    input = {}
    request_id = "hello world"

    update_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_update_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_input_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_input({ update_mask: update_mask, input: input, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_input update_mask: update_mask, input: input, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_input ::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest.new(update_mask: update_mask, input: input, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_input({ update_mask: update_mask, input: input, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_input(::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest.new(update_mask: update_mask, input: input, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_input_client_stub.call_count
      end
    end
  end

  def test_preview_input
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::PreviewInputResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    preview_input_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_preview_input_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, preview_input_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.preview_input({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.preview_input name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.preview_input ::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.preview_input({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.preview_input(::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, preview_input_client_stub.call_count
      end
    end
  end

  def test_create_event
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Event.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    event = {}
    event_id = "hello world"
    request_id = "hello world"

    create_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_event_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_event({ parent: parent, event: event, event_id: event_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_event parent: parent, event: event, event_id: event_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_event ::Google::Cloud::Video::LiveStream::V1::CreateEventRequest.new(parent: parent, event: event, event_id: event_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_event({ parent: parent, event: event, event_id: event_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_event(::Google::Cloud::Video::LiveStream::V1::CreateEventRequest.new(parent: parent, event: event, event_id: event_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_event_client_stub.call_count
      end
    end
  end

  def test_list_events
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_events_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_events parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_events ::Google::Cloud::Video::LiveStream::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_events({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_events(::Google::Cloud::Video::LiveStream::V1::ListEventsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_events_client_stub.call_count
      end
    end
  end

  def test_get_event
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Event.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_event_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_event({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_event name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_event ::Google::Cloud::Video::LiveStream::V1::GetEventRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_event({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_event(::Google::Cloud::Video::LiveStream::V1::GetEventRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_event_client_stub.call_count
      end
    end
  end

  def test_delete_event
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_event_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_event_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_event_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_event({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_event name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_event ::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_event({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_event(::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_event_client_stub.call_count
      end
    end
  end

  def test_list_clips
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListClipsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clips_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_clips_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clips_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clips({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clips parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clips ::Google::Cloud::Video::LiveStream::V1::ListClipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clips({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clips(::Google::Cloud::Video::LiveStream::V1::ListClipsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clips_client_stub.call_count
      end
    end
  end

  def test_get_clip
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Clip.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_clip_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_clip_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_clip_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_clip({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_clip name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_clip ::Google::Cloud::Video::LiveStream::V1::GetClipRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_clip({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_clip(::Google::Cloud::Video::LiveStream::V1::GetClipRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_clip_client_stub.call_count
      end
    end
  end

  def test_create_clip
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    clip_id = "hello world"
    clip = {}
    request_id = "hello world"

    create_clip_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_clip_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_clip_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_clip({ parent: parent, clip_id: clip_id, clip: clip, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_clip parent: parent, clip_id: clip_id, clip: clip, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_clip ::Google::Cloud::Video::LiveStream::V1::CreateClipRequest.new(parent: parent, clip_id: clip_id, clip: clip, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_clip({ parent: parent, clip_id: clip_id, clip: clip, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_clip(::Google::Cloud::Video::LiveStream::V1::CreateClipRequest.new(parent: parent, clip_id: clip_id, clip: clip, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_clip_client_stub.call_count
      end
    end
  end

  def test_delete_clip
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_clip_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_clip_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_clip_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_clip({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_clip name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_clip ::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_clip({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_clip(::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_clip_client_stub.call_count
      end
    end
  end

  def test_create_dvr_session
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dvr_session_id = "hello world"
    dvr_session = {}
    request_id = "hello world"

    create_dvr_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_dvr_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dvr_session_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dvr_session({ parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dvr_session parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dvr_session ::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest.new(parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dvr_session({ parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dvr_session(::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest.new(parent: parent, dvr_session_id: dvr_session_id, dvr_session: dvr_session, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dvr_session_client_stub.call_count
      end
    end
  end

  def test_list_dvr_sessions
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_dvr_sessions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_dvr_sessions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_dvr_sessions_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_dvr_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_dvr_sessions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_dvr_sessions ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_dvr_sessions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_dvr_sessions(::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_dvr_sessions_client_stub.call_count
      end
    end
  end

  def test_get_dvr_session
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::DvrSession.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dvr_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_dvr_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dvr_session_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dvr_session({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dvr_session name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dvr_session ::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dvr_session({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dvr_session(::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dvr_session_client_stub.call_count
      end
    end
  end

  def test_delete_dvr_session
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_dvr_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_dvr_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dvr_session_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dvr_session({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dvr_session name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dvr_session ::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dvr_session({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dvr_session(::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dvr_session_client_stub.call_count
      end
    end
  end

  def test_update_dvr_session
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    dvr_session = {}
    request_id = "hello world"

    update_dvr_session_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_update_dvr_session_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dvr_session_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dvr_session({ update_mask: update_mask, dvr_session: dvr_session, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dvr_session update_mask: update_mask, dvr_session: dvr_session, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dvr_session ::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest.new(update_mask: update_mask, dvr_session: dvr_session, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dvr_session({ update_mask: update_mask, dvr_session: dvr_session, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dvr_session(::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest.new(update_mask: update_mask, dvr_session: dvr_session, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dvr_session_client_stub.call_count
      end
    end
  end

  def test_create_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    asset = {}
    asset_id = "hello world"
    request_id = "hello world"

    create_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_create_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_asset_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_asset({ parent: parent, asset: asset, asset_id: asset_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_asset parent: parent, asset: asset, asset_id: asset_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_asset ::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_asset({ parent: parent, asset: asset, asset_id: asset_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_asset(::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest.new(parent: parent, asset: asset, asset_id: asset_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_asset_client_stub.call_count
      end
    end
  end

  def test_delete_asset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_delete_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_asset_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_asset({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_asset name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_asset ::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_asset({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_asset(::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_asset_client_stub.call_count
      end
    end
  end

  def test_get_asset
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Asset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_asset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_asset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_asset_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_asset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_asset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_asset ::Google::Cloud::Video::LiveStream::V1::GetAssetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_asset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_asset(::Google::Cloud::Video::LiveStream::V1::GetAssetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_asset_client_stub.call_count
      end
    end
  end

  def test_list_assets
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::ListAssetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_assets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_list_assets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_assets_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_assets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_assets ::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_assets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_assets(::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_assets_client_stub.call_count
      end
    end
  end

  def test_get_pool
    # Create test objects.
    client_result = ::Google::Cloud::Video::LiveStream::V1::Pool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_get_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pool ::Google::Cloud::Video::LiveStream::V1::GetPoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pool(::Google::Cloud::Video::LiveStream::V1::GetPoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pool_client_stub.call_count
      end
    end
  end

  def test_update_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    pool = {}
    request_id = "hello world"

    update_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::ServiceStub.stub :transcode_update_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_pool({ update_mask: update_mask, pool: pool, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_pool update_mask: update_mask, pool: pool, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_pool ::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest.new(update_mask: update_mask, pool: pool, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_pool({ update_mask: update_mask, pool: pool, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_pool(::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest.new(update_mask: update_mask, pool: pool, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_pool_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client::Configuration, config
  end
end
