# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module LiveStream
        module V1
          # Request message for "LivestreamService.CreateAsset".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] asset
          #   @return [::Google::Cloud::Video::LiveStream::V1::Asset]
          #     Required. The asset resource to be created.
          # @!attribute [rw] asset_id
          #   @return [::String]
          #     Required. The ID of the asset resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class CreateAssetRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteAsset".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the asset resource, in the form of:
          #     `projects/{project}/locations/{location}/assets/{assetId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes after the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class DeleteAssetRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListAssets".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Requested page size. Server may return fewer items than requested.
          #     If unspecified, server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A token identifying a page of results the server should return.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filtering results
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Hint for how to order the results
          class ListAssetsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListAssets".
          # @!attribute [rw] assets
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Asset>]
          #     The list of Assets
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListAssetsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetAsset".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource, in the following form:
          #     `projects/{project}/locations/{location}/assets/{asset}`.
          class GetAssetRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.CreateChannel".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] channel
          #   @return [::Google::Cloud::Video::LiveStream::V1::Channel]
          #     Required. The channel resource to be created.
          # @!attribute [rw] channel_id
          #   @return [::String]
          #     Required. The ID of the channel resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class CreateChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListChannels".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return. If unspecified, server
          #     will pick an appropriate default. Server may return fewer items than
          #     requested. A caller should only rely on response's
          #     {::Google::Cloud::Video::LiveStream::V1::ListChannelsResponse#next_page_token next_page_token}
          #     to determine if there are more items left to be queried.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter to apply to list results.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Specifies the ordering of results following syntax at
          #     https://cloud.google.com/apis/design/design_patterns#sorting_order.
          class ListChannelsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListChannels".
          # @!attribute [rw] channels
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Channel>]
          #     A list of channels.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListChannelsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetChannel".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          class GetChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteChannel".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes after the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     If the `force` field is set to the default value of `false`, you must
          #     delete all of a channel's events before you can delete the channel itself.
          #     If the field is set to `true`, requests to delete a channel also delete
          #     associated channel events.
          class DeleteChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.UpdateChannel".
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the Channel
          #     resource by the update. You can only update the following fields:
          #
          #     * [`inputAttachments`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputattachment)
          #     * [`inputConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputconfig)
          #     * [`output`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#output)
          #     * [`elementaryStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#elementarystream)
          #     * [`muxStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#muxstream)
          #     * [`manifests`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#manifest)
          #     * [`spriteSheets`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#spritesheet)
          #     * [`logConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#logconfig)
          #     * [`timecodeConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#timecodeconfig)
          #     * [`encryptions`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#encryption)
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the mask is not present, then each field from the list above is updated
          #     if the field appears in the request payload. To unset a field, add the
          #     field to the update mask and remove it from the request payload.
          # @!attribute [rw] channel
          #   @return [::Google::Cloud::Video::LiveStream::V1::Channel]
          #     Required. The channel resource to be updated.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class UpdateChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.StartChannel".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class StartChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.StopChannel".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class StopChannelRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.StartDistribution".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] distribution_keys
          #   @return [::Array<::String>]
          #     Optional. A list of keys to identify the distribution configuration in the
          #     channel resource. If left empty, all the distributions in the channel
          #     specification will be started.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class StartDistributionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.StopDistribution".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the channel resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] distribution_keys
          #   @return [::Array<::String>]
          #     Optional. A list of key to identify the distribution configuration in the
          #     channel resource. If left empty, all the distributions in the channel
          #     specification will be stopped.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class StopDistributionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.CreateInput".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] input
          #   @return [::Google::Cloud::Video::LiveStream::V1::Input]
          #     Required. The input resource to be created.
          # @!attribute [rw] input_id
          #   @return [::String]
          #     Required. The ID of the input resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class CreateInputRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListInputs".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent location for the resource, in the form of:
          #     `projects/{project}/locations/{location}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return. If unspecified, server
          #     will pick an appropriate default. Server may return fewer items than
          #     requested. A caller should only rely on response's
          #     {::Google::Cloud::Video::LiveStream::V1::ListInputsResponse#next_page_token next_page_token}
          #     to determine if there are more items left to be queried.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter to apply to list results.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Specifies the ordering of results following syntax at [Sorting
          #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
          class ListInputsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListInputs".
          # @!attribute [rw] inputs
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Input>]
          #     A list of inputs.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListInputsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetInput".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the input resource, in the form of:
          #     `projects/{project}/locations/{location}/inputs/{inputId}`.
          class GetInputRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteInput".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the input resource, in the form of:
          #     `projects/{project}/locations/{location}/inputs/{inputId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class DeleteInputRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.UpdateInput".
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the Input
          #     resource by the update. You can only update the following fields:
          #
          #     * [`tier`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#Tier)
          #     * [`preprocessingConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#PreprocessingConfig)
          #     * [`securityRules`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#SecurityRule)
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          #
          #     If the mask is not present, then each field from the list above is updated
          #     if the field appears in the request payload. To unset a field, add the
          #     field to the update mask and remove it from the request payload.
          # @!attribute [rw] input
          #   @return [::Google::Cloud::Video::LiveStream::V1::Input]
          #     Required. The input resource to be updated.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class UpdateInputRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.CreateEvent".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent channel for the resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] event
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event]
          #     Required. The event resource to be created.
          # @!attribute [rw] event_id
          #   @return [::String]
          #     Required. The ID of the event resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class CreateEventRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListEvents".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent channel for the resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of items to return. If unspecified, server
          #     will pick an appropriate default. Server may return fewer items than
          #     requested. A caller should only rely on response's
          #     {::Google::Cloud::Video::LiveStream::V1::ListEventsResponse#next_page_token next_page_token}
          #     to determine if there are more items left to be queried.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The next_page_token value returned from a previous List request, if any.
          # @!attribute [rw] filter
          #   @return [::String]
          #     The filter to apply to list results.
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Specifies the ordering of results following syntax at
          #     https://cloud.google.com/apis/design/design_patterns#sorting_order.
          class ListEventsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListEvents".
          # @!attribute [rw] events
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Event>]
          #     A list of events.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Token to retrieve the next page of results, or empty if there are no more
          #     results in the list.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListEventsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetEvent".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the event resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
          class GetEventRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteEvent".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the event resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class DeleteEventRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for Start/Stop Channel long-running operations.
          class ChannelOperationResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListClips".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Parent value for ListClipsRequest
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Requested page size. Server may return fewer items than requested.
          #     If unspecified, server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A token identifying a page of results the server should return.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Filtering results
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Hint for how to order the results
          class ListClipsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListClips".
          # @!attribute [rw] clips
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Clip>]
          #     The list of Clip
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token identifying a page of results the server should return.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListClipsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetClip".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource, in the following form:
          #     `projects/{project}/locations/{location}/channels/{channel}/clips/{clip}`.
          class GetClipRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.CreateClip".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name, in the following form:
          #     `projects/{project}/locations/{location}/channels/{channel}`.
          # @!attribute [rw] clip_id
          #   @return [::String]
          #     Required. The ID of the clip resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] clip
          #   @return [::Google::Cloud::Video::LiveStream::V1::Clip]
          #     Required. The resource being created
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateClipRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteClip".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the clip resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class DeleteClipRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.ListDvrSessions".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. Parent value for ListDvrSessionsRequest
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Requested page size. Server may return fewer items than
          #     requested. If unspecified, server will pick an appropriate default.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A token identifying a page of results the server should return.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Filtering results
          # @!attribute [rw] order_by
          #   @return [::String]
          #     Optional. Hint for how to order the results
          class ListDvrSessionsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.ListDvrSessions".
          # @!attribute [rw] dvr_sessions
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::DvrSession>]
          #     The list of DVR sessions
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token identifying a page of results the server should return.
          # @!attribute [rw] unreachable
          #   @return [::Array<::String>]
          #     Locations that could not be reached.
          class ListDvrSessionsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetDvrSession".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the resource, in the following form:
          #     `projects/{project}/locations/{location}/channels/{channelId}/dvrSessions/{dvrSessionId}`.
          class GetDvrSessionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.CreateDvrSession".
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource name, in the following form:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [rw] dvr_session_id
          #   @return [::String]
          #     Required. The ID of the DVR session resource to be created.
          #
          #     This value must be 1-63 characters, begin and end with a lower-case letter
          #     or a number, and consist of only lower-case letters, numbers, and hyphens.
          #     In other words, it must match the following regex:
          #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] dvr_session
          #   @return [::Google::Cloud::Video::LiveStream::V1::DvrSession]
          #     Required. The resource being created
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. An optional request ID to identify requests. Specify a unique
          #     request ID so that if you must retry your request, the server will know to
          #     ignore the request if it has already been completed. The server will
          #     guarantee that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and
          #     the request times out. If you make the request again with the same request
          #     ID, the server can check if original operation with the same request ID
          #     was received, and if so, will ignore the second request. This prevents
          #     clients from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported (00000000-0000-0000-0000-000000000000).
          class CreateDvrSessionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.DeleteDvrSession".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the event resource, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}/dvrSessions/{dvrSessionId}`.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class DeleteDvrSessionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.UpdateDvrSession".
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. Field mask is used to specify the fields to be overwritten in the
          #     DvrSession resource by the update. You can only update the following
          #     fields:
          #
          #     * `dvrWindows`
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          # @!attribute [rw] dvr_session
          #   @return [::Google::Cloud::Video::LiveStream::V1::DvrSession]
          #     Required. The DVR session resource to be updated.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     Optional. A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class UpdateDvrSessionRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents the metadata of the long-running operation.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation was created.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time the operation finished running.
          # @!attribute [r] target
          #   @return [::String]
          #     Output only. Server-defined resource path for the target of the operation.
          # @!attribute [r] verb
          #   @return [::String]
          #     Output only. Name of the verb executed by the operation.
          # @!attribute [r] requested_cancellation
          #   @return [::Boolean]
          #     Output only. Identifies whether the user has requested cancellation
          #     of the operation. Operations that have successfully been cancelled
          #     have
          #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
          #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
          #     corresponding to `Code.CANCELLED`.
          # @!attribute [r] api_version
          #   @return [::String]
          #     Output only. API version used to start the operation.
          class OperationMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.GetPool".
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the pool resource, in the form of:
          #     `projects/{project}/locations/{location}/pools/{poolId}`.
          class GetPoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.UpdatePool".
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Field mask is used to specify the fields to be overwritten in the Pool
          #     resource by the update. You can only update the following fields:
          #
          #     * `networkConfig`
          #
          #     The fields specified in the update_mask are relative to the resource, not
          #     the full request. A field will be overwritten if it is in the mask.
          # @!attribute [rw] pool
          #   @return [::Google::Cloud::Video::LiveStream::V1::Pool]
          #     Required. The pool resource to be updated.
          # @!attribute [rw] request_id
          #   @return [::String]
          #     A request ID to identify requests. Specify a unique request ID
          #     so that if you must retry your request, the server will know to ignore
          #     the request if it has already been completed. The server will guarantee
          #     that for at least 60 minutes since the first request.
          #
          #     For example, consider a situation where you make an initial request and the
          #     request times out. If you make the request again with the same request ID,
          #     the server can check if original operation with the same request ID was
          #     received, and if so, will ignore the second request. This prevents clients
          #     from accidentally creating duplicate commitments.
          #
          #     The request ID must be a valid UUID with the exception that zero UUID is
          #     not supported `(00000000-0000-0000-0000-000000000000)`.
          class UpdatePoolRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for "LivestreamService.PreviewInput"
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the input resource, in the form of:
          #     `projects/{project}/locations/{location}/inputs/{inputId}`.
          class PreviewInputRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for "LivestreamService.PreviewInput"
          # @!attribute [rw] uri
          #   @return [::String]
          #     URI to display the preview content.
          # @!attribute [rw] bearer_token
          #   @return [::String]
          #     A bearer token used to authenticate connections that display the preview
          #     content. The token expires after one hour. For HTTP connections, this token
          #     should be included as a bearer token inside the Authorization header.
          class PreviewInputResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
