# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module LiveStream
        module V1
          # Input resource represents the endpoint from which the channel ingests
          # the input stream.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the input, in the form of:
          #     `projects/{project}/locations/{location}/inputs/{inputId}`.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     User-defined key/value metadata.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Video::LiveStream::V1::Input::Type]
          #     Source type.
          # @!attribute [rw] tier
          #   @return [::Google::Cloud::Video::LiveStream::V1::Input::Tier]
          #     Tier defines the maximum input specification that is accepted by the
          #     video pipeline. The billing is charged based on the tier specified here.
          #     See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
          #     The default is `HD`.
          # @!attribute [r] uri
          #   @return [::String]
          #     Output only. URI to push the input stream to.
          #     Its format depends on the input
          #     {::Google::Cloud::Video::LiveStream::V1::Input#type type}, for example:
          #
          #     *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
          #     *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
          # @!attribute [rw] preprocessing_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::PreprocessingConfig]
          #     Preprocessing configurations.
          # @!attribute [rw] security_rules
          #   @return [::Google::Cloud::Video::LiveStream::V1::Input::SecurityRule]
          #     Security rule for access control.
          # @!attribute [r] input_stream_property
          #   @return [::Google::Cloud::Video::LiveStream::V1::InputStreamProperty]
          #     Output only. The information for the input stream. This field will be
          #     present only when this input receives the input stream.
          class Input
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Security rules for access control. Each field represents one security rule.
            # Only when the source of the input stream satisfies all the fields, this
            # input stream can be accepted.
            # @!attribute [rw] ip_ranges
            #   @return [::Array<::String>]
            #     At least one ip range must match unless none specified. The IP range is
            #     defined by CIDR block: for example, `192.0.1.0/24` for a range and
            #     `192.0.1.0/32` for a single IP address.
            class SecurityRule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The type of the input.
            module Type
              # Input type is not specified.
              TYPE_UNSPECIFIED = 0

              # Input will take an rtmp input stream.
              RTMP_PUSH = 1

              # Input will take an srt (Secure Reliable Transport) input stream.
              SRT_PUSH = 2
            end

            # Tier of the input specification.
            module Tier
              # Tier is not specified.
              TIER_UNSPECIFIED = 0

              # Resolution < 1280x720. Bitrate <= 6 Mbps. FPS <= 60.
              SD = 1

              # Resolution <= 1920x1080. Bitrate <= 25 Mbps. FPS <= 60.
              HD = 2

              # Resolution <= 4096x2160. Bitrate <= 50 Mbps. FPS <= 60.
              UHD = 3

              # Resolution <= 1280x720. Bitrate <= 6 Mbps. FPS <= 60. H265 codec.
              SD_H265 = 4

              # Resolution <= 1920x1080. Bitrate <= 25 Mbps. FPS <= 60. H265 codec.
              HD_H265 = 5

              # Resolution <= 4096x2160. Bitrate <= 50 Mbps. FPS <= 60. H265 codec.
              UHD_H265 = 6
            end
          end

          # Channel resource represents the processor that does a user-defined
          # "streaming" operation, which includes getting an input stream through an
          # input, transcoding it to multiple renditions, and publishing output live
          # streams in certain formats (for example, HLS or DASH) to the specified
          # location.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the channel, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}`.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     User-defined key/value metadata.
          # @!attribute [rw] input_attachments
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::InputAttachment>]
          #     A list of input attachments that this channel uses.
          #     One channel can have multiple inputs as the input sources. Only one
          #     input can be selected as the input source at one time.
          # @!attribute [r] active_input
          #   @return [::String]
          #     Output only. The
          #     {::Google::Cloud::Video::LiveStream::V1::InputAttachment#key InputAttachment.key}
          #     that serves as the current input source. The first input in the
          #     {::Google::Cloud::Video::LiveStream::V1::Channel#input_attachments input_attachments}
          #     is the initial input source.
          # @!attribute [rw] output
          #   @return [::Google::Cloud::Video::LiveStream::V1::Channel::Output]
          #     Required. Information about the output (that is, the Cloud Storage bucket
          #     to store the generated live stream).
          # @!attribute [rw] elementary_streams
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::ElementaryStream>]
          #     List of elementary streams.
          # @!attribute [rw] mux_streams
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::MuxStream>]
          #     List of multiplexing settings for output streams.
          # @!attribute [rw] manifests
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Manifest>]
          #     List of output manifests.
          # @!attribute [rw] distribution_streams
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::DistributionStream>]
          #     Optional. List of multiplexing settings of streams for distributions.
          # @!attribute [rw] distributions
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Distribution>]
          #     Optional. List of distributions.
          # @!attribute [rw] sprite_sheets
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::SpriteSheet>]
          #     List of output sprite sheets.
          # @!attribute [r] streaming_state
          #   @return [::Google::Cloud::Video::LiveStream::V1::Channel::StreamingState]
          #     Output only. State of the streaming operation.
          # @!attribute [r] streaming_error
          #   @return [::Google::Rpc::Status]
          #     Output only. A description of the reason for the streaming error. This
          #     property is always present when
          #     {::Google::Cloud::Video::LiveStream::V1::Channel#streaming_state streaming_state}
          #     is
          #     {::Google::Cloud::Video::LiveStream::V1::Channel::StreamingState::STREAMING_ERROR STREAMING_ERROR}.
          # @!attribute [rw] log_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::LogConfig]
          #     Configuration of platform logs for this channel.
          # @!attribute [rw] timecode_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::TimecodeConfig]
          #     Configuration of timecode for this channel.
          # @!attribute [rw] encryptions
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Encryption>]
          #     Optional. Encryption configurations for this channel. Each configuration
          #     has an ID which is referred to by each MuxStream to indicate which
          #     configuration is used for that output.
          # @!attribute [rw] input_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::InputConfig]
          #     The configuration for input sources defined in
          #     {::Google::Cloud::Video::LiveStream::V1::Channel#input_attachments input_attachments}.
          # @!attribute [rw] retention_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::RetentionConfig]
          #     Optional. Configuration for retention of output files for this channel.
          # @!attribute [rw] static_overlays
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::StaticOverlay>]
          #     Optional. List of static overlay images. Those images display over the
          #     output content for the whole duration of the live stream.
          # @!attribute [rw] auto_transcription_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::AutoTranscriptionConfig]
          #     Optional. Advanced configurations for auto-generated text streams.
          class Channel
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Location of output file(s) in a Google Cloud Storage bucket.
            # @!attribute [rw] uri
            #   @return [::String]
            #     URI for the output file(s). For example, `gs://my-bucket/outputs/`.
            class Output
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of streaming operation that the channel is running.
            module StreamingState
              # Streaming state is not specified.
              STREAMING_STATE_UNSPECIFIED = 0

              # Channel is getting the input stream, generating the live streams to the
              # specified output location.
              STREAMING = 1

              # Channel is waiting for the input stream through the input.
              AWAITING_INPUT = 2

              # Channel is running, but has trouble publishing the live streams onto the
              # specified output location (for example, the specified Cloud Storage
              # bucket is not writable).
              STREAMING_ERROR = 4

              # Channel is generating live streams with no input stream. Live streams are
              # filled out with black screen, while input stream is missing.
              # Not supported yet.
              STREAMING_NO_INPUT = 5

              # Channel is stopped, finishing live streams.
              STOPPED = 6

              # Channel is starting.
              STARTING = 7

              # Channel is stopping.
              STOPPING = 8
            end
          end

          # 2D normalized coordinates.
          # @!attribute [rw] x
          #   @return [::Float]
          #     Optional. Normalized x coordinate. Valid range is [0.0, 1.0]. Default is 0.
          # @!attribute [rw] y
          #   @return [::Float]
          #     Optional. Normalized y coordinate. Valid range is [0.0, 1.0]. Default is 0.
          class NormalizedCoordinate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Normalized resolution.
          # @!attribute [rw] w
          #   @return [::Float]
          #     Optional. Normalized width. Valid range is [0.0, 1.0]. Default is 0.
          # @!attribute [rw] h
          #   @return [::Float]
          #     Optional. Normalized height. Valid range is [0.0, 1.0]. Default is 0.
          class NormalizedResolution
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for the static overlay.
          # @!attribute [rw] asset
          #   @return [::String]
          #     Required. Asset to use for the overlaid image.
          #     The asset must be represented in the form of:
          #     `projects/{project}/locations/{location}/assets/{assetId}`.
          #     The asset's resource type must be image.
          # @!attribute [rw] resolution
          #   @return [::Google::Cloud::Video::LiveStream::V1::NormalizedResolution]
          #     Optional. Normalized image resolution, based on output video resolution.
          #     Valid values are [0.0, 1.0]. To respect the original image aspect ratio,
          #     set either `w` or `h` to 0. To use the original image resolution, set both
          #     `w` and `h` to 0. The default is \\{0, 0}.
          # @!attribute [rw] position
          #   @return [::Google::Cloud::Video::LiveStream::V1::NormalizedCoordinate]
          #     Optional. Position of the image in terms of normalized coordinates of the
          #     upper-left corner of the image, based on output video resolution. For
          #     example, use the x and y coordinates \\{0, 0} to position the top-left corner
          #     of the overlay animation in the top-left corner of the output video.
          # @!attribute [rw] opacity
          #   @return [::Float]
          #     Optional. Target image opacity. Valid values are from `1.0` (solid,
          #     default) to `0.0` (transparent), exclusive. Set this to a value greater
          #     than `0.0`.
          class StaticOverlay
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for the input sources of a channel.
          # @!attribute [rw] input_switch_mode
          #   @return [::Google::Cloud::Video::LiveStream::V1::InputConfig::InputSwitchMode]
          #     Input switch mode. Default mode is `FAILOVER_PREFER_PRIMARY`.
          class InputConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Input switch mode.
            module InputSwitchMode
              # The input switch mode is not specified.
              INPUT_SWITCH_MODE_UNSPECIFIED = 0

              # Automatic failover is enabled. The primary input stream is always
              # preferred over its backup input streams configured using the
              # {::Google::Cloud::Video::LiveStream::V1::InputAttachment::AutomaticFailover AutomaticFailover}
              # field.
              FAILOVER_PREFER_PRIMARY = 1

              # Automatic failover is disabled. You must use the
              # {::Google::Cloud::Video::LiveStream::V1::Event#input_switch inputSwitch} event
              # to switch the active input source for the channel to stream from. When
              # this mode is chosen, the
              # {::Google::Cloud::Video::LiveStream::V1::InputAttachment::AutomaticFailover AutomaticFailover}
              # field is ignored.
              MANUAL = 3
            end
          end

          # Configuration of platform logs.
          # See [Using and managing platform
          # logs](https://cloud.google.com/logging/docs/api/platform-logs#managing-logs)
          # for more information about how to view platform logs through Cloud Logging.
          # @!attribute [rw] log_severity
          #   @return [::Google::Cloud::Video::LiveStream::V1::LogConfig::LogSeverity]
          #     The severity level of platform logging for this resource.
          class LogConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The severity level of platform logging for this channel. Logs with a
            # severity level higher than or equal to the chosen severity level will be
            # logged and can be viewed through Cloud Logging.
            # The severity level of a log is ranked as followed from low to high: DEBUG <
            # INFO < NOTICE < WARNING < ERROR < CRITICAL < ALERT < EMERGENCY.
            # See
            # [LogSeverity](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry#logseverity)
            # for more information.
            module LogSeverity
              # Log severity is not specified. This is the same as log severity is OFF.
              LOG_SEVERITY_UNSPECIFIED = 0

              # Log is turned off.
              OFF = 1

              # Log with severity higher than or equal to DEBUG are logged.
              DEBUG = 100

              # Logs with severity higher than or equal to INFO are logged.
              INFO = 200

              # Logs with severity higher than or equal to WARNING are logged.
              WARNING = 400

              # Logs with severity higher than or equal to ERROR are logged.
              ERROR = 500
            end
          end

          # Configuration for retention of output files.
          # @!attribute [rw] retention_window_duration
          #   @return [::Google::Protobuf::Duration]
          #     The minimum duration for which the output files from the channel will
          #     remain in the output bucket. After this duration, output files are
          #     deleted asynchronously.
          #
          #     When the channel is deleted, all output files are deleted from the output
          #     bucket asynchronously.
          #
          #     If omitted or set to zero, output files will remain in the output bucket
          #     based on
          #     {::Google::Cloud::Video::LiveStream::V1::Manifest#segment_keep_duration Manifest.segment_keep_duration},
          #     which defaults to 60s.
          #
          #     If both retention_window_duration and
          #     {::Google::Cloud::Video::LiveStream::V1::Manifest#segment_keep_duration Manifest.segment_keep_duration}
          #     are set, retention_window_duration is used and
          #     {::Google::Cloud::Video::LiveStream::V1::Manifest#segment_keep_duration Manifest.segment_keep_duration}
          #     is ignored.
          class RetentionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Properties of the input stream.
          # @!attribute [rw] last_establish_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time that the current input stream is accepted and the connection is
          #     established.
          # @!attribute [rw] video_streams
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::VideoStreamProperty>]
          #     Properties of the video streams.
          # @!attribute [rw] audio_streams
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::AudioStreamProperty>]
          #     Properties of the audio streams.
          class InputStreamProperty
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Properties of the video stream.
          # @!attribute [rw] index
          #   @return [::Integer]
          #     Index of this video stream.
          # @!attribute [rw] video_format
          #   @return [::Google::Cloud::Video::LiveStream::V1::VideoFormat]
          #     Properties of the video format.
          class VideoStreamProperty
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Properties of the video format.
          # @!attribute [rw] codec
          #   @return [::String]
          #     Video codec used in this video stream.
          # @!attribute [rw] width_pixels
          #   @return [::Integer]
          #     The width of the video stream in pixels.
          # @!attribute [rw] height_pixels
          #   @return [::Integer]
          #     The height of the video stream in pixels.
          # @!attribute [rw] frame_rate
          #   @return [::Float]
          #     The frame rate of the input video stream.
          class VideoFormat
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Properties of the audio stream.
          # @!attribute [rw] index
          #   @return [::Integer]
          #     Index of this audio stream.
          # @!attribute [rw] audio_format
          #   @return [::Google::Cloud::Video::LiveStream::V1::AudioFormat]
          #     Properties of the audio format.
          class AudioStreamProperty
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Properties of the audio format.
          # @!attribute [rw] codec
          #   @return [::String]
          #     Audio codec used in this audio stream.
          # @!attribute [rw] channel_count
          #   @return [::Integer]
          #     The number of audio channels.
          # @!attribute [rw] channel_layout
          #   @return [::Array<::String>]
          #     A list of channel names specifying the layout of the audio channels.
          class AudioFormat
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A group of information for attaching an input resource to this channel.
          # @!attribute [rw] key
          #   @return [::String]
          #     A unique key for this input attachment. The key must be 1-63
          #     characters in length. The key must begin and end with a letter (regardless
          #     of case) or a number, but can contain dashes or underscores in between.
          # @!attribute [rw] input
          #   @return [::String]
          #     The resource name of an existing input, in the form of:
          #     `projects/{project}/locations/{location}/inputs/{inputId}`.
          # @!attribute [rw] automatic_failover
          #   @return [::Google::Cloud::Video::LiveStream::V1::InputAttachment::AutomaticFailover]
          #     Automatic failover configurations.
          class InputAttachment
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configurations to follow when automatic failover happens.
            # @!attribute [rw] input_keys
            #   @return [::Array<::String>]
            #     The
            #     {::Google::Cloud::Video::LiveStream::V1::InputAttachment#key InputAttachment.key}s
            #     of inputs to failover to when this input is disconnected. Currently, only
            #     up to one backup input is supported.
            class AutomaticFailover
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Advanced configurations for auto-generated text streams.
          # @!attribute [rw] display_timing
          #   @return [::Google::Cloud::Video::LiveStream::V1::AutoTranscriptionConfig::DisplayTiming]
          #     Optional. Whether auto-generated text streams are displayed synchronously
          #     or asynchronously with the original audio.
          # @!attribute [rw] quality_preset
          #   @return [::Google::Cloud::Video::LiveStream::V1::AutoTranscriptionConfig::QualityPreset]
          #     Optional. Tunes the latency and quality of auto-generated captions.
          class AutoTranscriptionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Whether auto-generated text streams are displayed synchronously or
            # asynchronously with the original audio.
            module DisplayTiming
              # Display timing is not specified. Caption display will be asynchronous by
              # default.
              DISPLAY_TIMING_UNSPECIFIED = 0

              # Caption will be displayed asynchronous with audio.
              ASYNC = 1

              # Caption will be displayed synchronous with audio. This option increases
              # overall media output latency, and reduces viewing latency between audio
              # and auto-generated captions.
              SYNC = 2
            end

            # Presets to tune the latency and quality of auto-generated captions.
            module QualityPreset
              # Quality Preset is not specified. By default, BALANCED_QUALITY will be
              # used.
              QUALITY_PRESET_UNSPECIFIED = 0

              # Reduce the latency of auto-generated captions. This may reduce the
              # quality of the captions.
              LOW_LATENCY = 1

              # Default behavior when QualityPreset is not specified.
              BALANCED_QUALITY = 2

              # Increases the quality of the auto-generated captions at the cost of
              # higher latency.
              IMPROVED_QUALITY = 3
            end
          end

          # Event is a sub-resource of a channel, which can be scheduled by the user to
          # execute operations on a channel resource without having to stop the channel.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the event, in the form of:
          #     `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     User-defined key/value metadata.
          # @!attribute [rw] input_switch
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::InputSwitchTask]
          #     Switches to another input stream.
          #
          #     Note: The following fields are mutually exclusive: `input_switch`, `ad_break`, `return_to_program`, `slate`, `mute`, `unmute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] ad_break
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::AdBreakTask]
          #     Inserts a new ad opportunity.
          #
          #     Note: The following fields are mutually exclusive: `ad_break`, `input_switch`, `return_to_program`, `slate`, `mute`, `unmute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] return_to_program
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::ReturnToProgramTask]
          #     Stops any running ad break.
          #
          #     Note: The following fields are mutually exclusive: `return_to_program`, `input_switch`, `ad_break`, `slate`, `mute`, `unmute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] slate
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::SlateTask]
          #     Inserts a slate.
          #
          #     Note: The following fields are mutually exclusive: `slate`, `input_switch`, `ad_break`, `return_to_program`, `mute`, `unmute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mute
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::MuteTask]
          #     Mutes the stream.
          #
          #     Note: The following fields are mutually exclusive: `mute`, `input_switch`, `ad_break`, `return_to_program`, `slate`, `unmute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] unmute
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::UnmuteTask]
          #     Unmutes the stream.
          #
          #     Note: The following fields are mutually exclusive: `unmute`, `input_switch`, `ad_break`, `return_to_program`, `slate`, `mute`, `update_encryptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] update_encryptions
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::UpdateEncryptionsTask]
          #     Updates encryption settings.
          #
          #     Note: The following fields are mutually exclusive: `update_encryptions`, `input_switch`, `ad_break`, `return_to_program`, `slate`, `mute`, `unmute`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] execute_now
          #   @return [::Boolean]
          #     When this field is set to true, the event will be executed at the earliest
          #     time that the server can schedule the event and
          #     {::Google::Cloud::Video::LiveStream::V1::Event#execution_time execution_time}
          #     will be populated with the time that the server actually schedules the
          #     event.
          # @!attribute [rw] execution_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time to execute the event. If you set
          #     {::Google::Cloud::Video::LiveStream::V1::Event#execute_now execute_now} to
          #     `true`, then do not set this field in the `CreateEvent` request. In
          #     this case, the server schedules the event and populates this field. If you
          #     set {::Google::Cloud::Video::LiveStream::V1::Event#execute_now execute_now} to
          #     `false`, then you must set this field to at least 10 seconds in the future
          #     or else the event can't be created.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::LiveStream::V1::Event::State]
          #     Output only. The state of the event.
          # @!attribute [r] error
          #   @return [::Google::Rpc::Status]
          #     Output only. An error object that describes the reason for the failure.
          #     This property is always present when `state` is `FAILED`.
          class Event
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Switches to another input stream. Automatic failover is then disabled.
            # @!attribute [rw] input_key
            #   @return [::String]
            #     The
            #     {::Google::Cloud::Video::LiveStream::V1::InputAttachment#key InputAttachment.key}
            #     of the input to switch to.
            class InputSwitchTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Inserts a new ad opportunity.
            # @!attribute [rw] duration
            #   @return [::Google::Protobuf::Duration]
            #     Duration of an ad opportunity. Must be greater than 0.
            class AdBreakTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Inserts a slate.
            # @!attribute [rw] duration
            #   @return [::Google::Protobuf::Duration]
            #     Optional. Duration of the slate. Must be greater than 0 if specified.
            #     Omit this field for a long running slate.
            # @!attribute [rw] asset
            #   @return [::String]
            #     Slate asset to use for the duration. If its duration is less than the
            #     duration of the SlateTask, then the slate loops. The slate must be
            #     represented in the form of:
            #     `projects/{project}/locations/{location}/assets/{assetId}`.
            class SlateTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Stops any events which are currently running. This only applies to events
            # with a duration.
            class ReturnToProgramTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Mutes the stream.
            # @!attribute [rw] duration
            #   @return [::Google::Protobuf::Duration]
            #     Duration for which the stream should be muted. If omitted, the stream
            #     will be muted until an UnmuteTask event is sent.
            class MuteTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Unmutes the stream. The task fails if the stream is not currently muted.
            class UnmuteTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Update encryption settings.
            # @!attribute [rw] encryptions
            #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::EncryptionUpdate>]
            #     Required. A list of
            #     {::Google::Cloud::Video::LiveStream::V1::EncryptionUpdate EncryptionUpdate}s
            #     that updates the existing encryption settings.
            class UpdateEncryptionsTask
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of the event
            module State
              # Event state is not specified.
              STATE_UNSPECIFIED = 0

              # Event is scheduled but not executed yet.
              SCHEDULED = 1

              # Event is being executed.
              RUNNING = 2

              # Event has been successfully executed.
              SUCCEEDED = 3

              # Event fails to be executed.
              FAILED = 4

              # Event has been created but not scheduled yet.
              PENDING = 5

              # Event was stopped before running for its full duration.
              STOPPED = 6
            end
          end

          # Clip is a sub-resource under channel. Each clip represents a clipping
          # operation that generates a VOD playlist from its channel given a set of
          # timestamp ranges.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the clip, in the following format:
          #     `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
          #     `{clipId}` is a user-specified resource id that conforms to the following
          #     criteria:
          #
          #     1. 1 character minimum, 63 characters maximum
          #     2. Only contains letters, digits, underscores, and hyphens
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation timestamp of the clip resource.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp when the clip request starts to be processed.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update timestamp of the clip resource.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     The labels associated with this resource. Each label is a key-value pair.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::LiveStream::V1::Clip::State]
          #     Output only. The state of the clip.
          # @!attribute [rw] output_uri
          #   @return [::String]
          #     Specify the `output_uri` to determine where to place the clip segments and
          #     clip manifest files in Cloud Storage. The manifests specified in
          #     `clip_manifests` fields will be placed under this URI. The exact URI of the
          #     generated manifests will be provided in `clip_manifests.output_uri` for
          #     each manifest.
          #     Example:
          #     "output_uri": "gs://my-bucket/clip-outputs"
          #     "clip_manifests.output_uri": "gs://my-bucket/clip-outputs/main.m3u8"
          # @!attribute [r] error
          #   @return [::Google::Rpc::Status]
          #     Output only. An error object that describes the reason for the failure.
          #     This property only presents when `state` is `FAILED`.
          # @!attribute [rw] slices
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Clip::Slice>]
          #     The specified ranges of segments to generate a clip.
          # @!attribute [rw] clip_manifests
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::Clip::ClipManifest>]
          #     Required. A list of clip manifests. Currently only one clip manifest is
          #     allowed.
          # @!attribute [rw] output_type
          #   @return [::Google::Cloud::Video::LiveStream::V1::Clip::OutputType]
          #     Optional. OutputType of the clip. If not specified, the default value is
          #     MANIFEST.
          class Clip
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # TimeSlice represents a tuple of Unix epoch timestamps that specifies a time
            # range.
            # @!attribute [rw] markin_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The mark-in Unix epoch time in the original live stream manifest.
            # @!attribute [rw] markout_time
            #   @return [::Google::Protobuf::Timestamp]
            #     The mark-out Unix epoch time in the original live stream manifest.
            class TimeSlice
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Slice represents a slice of the requested clip.
            # @!attribute [rw] time_slice
            #   @return [::Google::Cloud::Video::LiveStream::V1::Clip::TimeSlice]
            #     A slice in form of a tuple of Unix epoch time.
            class Slice
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # ClipManifest identifies a source manifest for the generated clip manifest.
            # @!attribute [rw] manifest_key
            #   @return [::String]
            #     Required. A unique key that identifies a manifest config in the parent
            #     channel. This key is the same as `channel.manifests.key` for the selected
            #     manifest.
            # @!attribute [r] output_uri
            #   @return [::String]
            #     Output only. The output URI of the generated clip manifest. This field
            #     will be populated when the CreateClip request is accepted. Current output
            #     format is provided below but may change in the future. Please read this
            #     field to get the uri to the generated clip manifest. Format:
            #     \\{clip.output_uri}/\\{channel.manifest.fileName} Example:
            #     gs://my-bucket/clip-outputs/main.m3u8
            class ClipManifest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of clipping operation.
            module State
              # State is not specified.
              STATE_UNSPECIFIED = 0

              # The operation is pending to be picked up by the server.
              PENDING = 1

              # The server admitted this create clip request, and
              # outputs are under processing.
              CREATING = 2

              # Outputs are available in the specified Cloud Storage bucket. For
              # additional information, see the `outputs` field.
              SUCCEEDED = 3

              # The operation has failed. For additional information, see the `error`
              # field.
              FAILED = 4
            end

            # OutputType represents the output type of the clip.
            module OutputType
              # OutputType is not specified.
              OUTPUT_TYPE_UNSPECIFIED = 0

              # OutputType is a VOD manifest. This is the default value.
              MANIFEST = 1

              # OutputType is an MP4 file.
              MP4 = 2
            end
          end

          # TimeInterval represents a time interval.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The start time of the interval.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The end time of the interval.
          class TimeInterval
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # DvrSession is a sub-resource under channel. Each DvrSession represents a DVR
          # recording of the live stream for a specific time range.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the DVR session, in the following format:
          #     `projects/{project}/locations/{location}/channels/{channelId}/dvrSessions/{dvrSessionId}`.
          #     `{dvrSessionId}` is a user-specified resource id that conforms to the
          #     following criteria:
          #
          #     1. 1 character minimum, 63 characters maximum
          #     2. Only contains letters, digits, underscores, and hyphens
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. User-defined key/value metadata.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::LiveStream::V1::DvrSession::State]
          #     Output only. The state of the clip.
          # @!attribute [r] error
          #   @return [::Google::Rpc::Status]
          #     Output only. An error object that describes the reason for the failure.
          #     This property only presents when `state` is `FAILED`.
          # @!attribute [rw] dvr_manifests
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::DvrSession::DvrManifest>]
          #     Required. A list of DVR manifests. Currently only one DVR manifest is
          #     allowed.
          # @!attribute [rw] dvr_windows
          #   @return [::Array<::Google::Cloud::Video::LiveStream::V1::DvrSession::DvrWindow>]
          #     Required. The specified ranges of segments to generate a DVR recording.
          class DvrSession
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # DvrManifest identifies a source manifest and specifies a file name for the
            # generated DVR manifest.
            # @!attribute [rw] manifest_key
            #   @return [::String]
            #     Required. A unique key that identifies a manifest config in the parent
            #     channel. This key is the same as `channel.manifests.key` for the selected
            #     manifest.
            # @!attribute [r] output_uri
            #   @return [::String]
            #     Output only. The output URI of the DVR manifest. The DVR output will be
            #     placed in a directory named `dvr/dvrSessionId/` under the parent
            #     channel's output uri. Format:
            #     \\{channel.output.uri}/dvr/\\{dvrSessionId}/\\{channel.manifests.fileName}
            #     Example: gs://my-bucket/outputs/dvr/my-dvr-session/main.m3u8
            class DvrManifest
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # DvrWindow represents a DVR window.
            # @!attribute [rw] time_interval
            #   @return [::Google::Cloud::Video::LiveStream::V1::TimeInterval]
            #     A time interval in the form of a tuple of Unix epoch time.
            class DvrWindow
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of the DVR session.
            module State
              # State is not specified.
              STATE_UNSPECIFIED = 0

              # The operation is pending to be picked up by the server.
              PENDING = 1

              # The session is being updated.
              UPDATING = 2

              # The session is scheduled and waiting for the start time.
              SCHEDULED = 3

              # The session is currently in progress and the outputs are available in the
              # specified Cloud Storage bucket. For additional information, see the
              # `dvr_manifests.output_uri` field.
              LIVE = 4

              # Outputs are available in the specified Cloud Storage bucket. For
              # additional information, see the `dvr_manifests.output_uri` field.
              FINISHED = 5

              # The operation has failed. For additional information, see the `error`
              # field.
              FAILED = 6

              # The session is being deleted.
              DELETING = 7

              # The session is being post processed.
              POST_PROCESSING = 8

              # The session is in cooldown. The cooldown period lasts for 60 seconds.
              # When the DVR session is updated by the user to have a new end time that
              # is likely already in the past, the DVR manifest will end as soon as
              # possible and the DVR session will move to this state. This is done to
              # prevent the players to receive a manifest update that removes a segment
              # that has already been played. After the cooldown period ends, a new
              # manifest is generated that honors the new end time.
              COOLDOWN = 9

              # The session is being stopped. The session will move to STOPPING state, if
              # the parent channel is updated.
              STOPPING = 10
            end
          end

          # An asset represents a video or an image.
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the asset, in the form of:
          #     `projects/{project}/locations/{location}/assets/{assetId}`.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     User-defined key/value metadata.
          # @!attribute [rw] video
          #   @return [::Google::Cloud::Video::LiveStream::V1::Asset::VideoAsset]
          #     VideoAsset represents a video.
          #
          #     Note: The following fields are mutually exclusive: `video`, `image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] image
          #   @return [::Google::Cloud::Video::LiveStream::V1::Asset::ImageAsset]
          #     ImageAsset represents an image.
          #
          #     Note: The following fields are mutually exclusive: `image`, `video`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] crc32c
          #   @return [::String]
          #     Based64-encoded CRC32c checksum of the asset file. For more information,
          #     see the crc32c checksum of the [Cloud Storage Objects
          #     resource](https://cloud.google.com/storage/docs/json_api/v1/objects).
          #     If crc32c is omitted or left empty when the asset is created, this field is
          #     filled by the crc32c checksum of the Cloud Storage object indicated by
          #     {::Google::Cloud::Video::LiveStream::V1::Asset::VideoAsset#uri VideoAsset.uri} or
          #     {::Google::Cloud::Video::LiveStream::V1::Asset::ImageAsset#uri ImageAsset.uri}. If
          #     crc32c is set, the asset can't be created if the crc32c value does not
          #     match with the crc32c checksum of the Cloud Storage object indicated by
          #     {::Google::Cloud::Video::LiveStream::V1::Asset::VideoAsset#uri VideoAsset.uri} or
          #     {::Google::Cloud::Video::LiveStream::V1::Asset::ImageAsset#uri ImageAsset.uri}.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Video::LiveStream::V1::Asset::State]
          #     Output only. The state of the asset resource.
          # @!attribute [r] error
          #   @return [::Google::Rpc::Status]
          #     Output only. Only present when `state` is `ERROR`. The reason for the error
          #     state of the asset.
          class Asset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # VideoAsset represents a video. The supported formats are MP4, MPEG-TS, and
            # FLV. The supported video codec is H264. The supported audio codecs are
            # AAC, AC3, MP2, and MP3.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Cloud Storage URI of the video. The format is `gs://my-bucket/my-object`.
            class VideoAsset
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Image represents an image. The supported formats are JPEG, PNG.
            # @!attribute [rw] uri
            #   @return [::String]
            #     Cloud Storage URI of the image. The format is `gs://my-bucket/my-object`.
            class ImageAsset
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # State of the asset resource.
            module State
              # State is not specified.
              STATE_UNSPECIFIED = 0

              # The asset is being created.
              CREATING = 1

              # The asset is ready for use.
              ACTIVE = 2

              # The asset is being deleted.
              DELETING = 3

              # The asset has an error.
              ERROR = 4
            end
          end

          # Encryption settings.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. Identifier for this set of encryption options. The ID must be
          #     1-63 characters in length. The ID must begin and end with a letter
          #     (regardless of case) or a number, but can contain dashes or underscores in
          #     between.
          # @!attribute [rw] secret_manager_key_source
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::SecretManagerSource]
          #     For keys stored in Google Secret Manager.
          # @!attribute [rw] drm_systems
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::DrmSystems]
          #     Required. Configuration for DRM systems.
          # @!attribute [rw] aes128
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::Aes128Encryption]
          #     Configuration for HLS AES-128 encryption.
          #
          #     Note: The following fields are mutually exclusive: `aes128`, `sample_aes`, `mpeg_cenc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sample_aes
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::SampleAesEncryption]
          #     Configuration for HLS SAMPLE-AES encryption.
          #
          #     Note: The following fields are mutually exclusive: `sample_aes`, `aes128`, `mpeg_cenc`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mpeg_cenc
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::MpegCommonEncryption]
          #     Configuration for MPEG-Dash Common Encryption (MPEG-CENC).
          #
          #     Note: The following fields are mutually exclusive: `mpeg_cenc`, `aes128`, `sample_aes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Encryption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration for secrets stored in Google Secret Manager.
            # @!attribute [rw] secret_version
            #   @return [::String]
            #     Required. The name of the Secret Version containing the encryption key.
            #     `projects/{project}/secrets/{secret_id}/versions/{version_number}`
            class SecretManagerSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Widevine configuration.
            class Widevine
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Fairplay configuration.
            class Fairplay
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Playready configuration.
            class Playready
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Clearkey configuration.
            class Clearkey
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Defines configuration for DRM systems in use. If a field is omitted,
            # that DRM system will be considered to be disabled.
            # @!attribute [rw] widevine
            #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::Widevine]
            #     Optional. Widevine configuration.
            # @!attribute [rw] fairplay
            #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::Fairplay]
            #     Optional. Fairplay configuration.
            # @!attribute [rw] playready
            #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::Playready]
            #     Optional. Playready configuration.
            # @!attribute [rw] clearkey
            #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::Clearkey]
            #     Optional. Clearkey configuration.
            class DrmSystems
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for HLS AES-128 encryption.
            class Aes128Encryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for HLS SAMPLE-AES encryption.
            class SampleAesEncryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for MPEG-Dash Common Encryption (MPEG-CENC).
            # @!attribute [rw] scheme
            #   @return [::String]
            #     Required. Specify the encryption scheme, supported schemes:
            #     - `cenc` - AES-CTR subsample
            #     - `cbcs`- AES-CBC subsample pattern
            class MpegCommonEncryption
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Encryption setting when updating encryption.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. Identifier for the encryption option to be updated.
          # @!attribute [rw] secret_manager_key_source
          #   @return [::Google::Cloud::Video::LiveStream::V1::Encryption::SecretManagerSource]
          #     For keys stored in Google Secret Manager.
          class EncryptionUpdate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Pool resource defines the configuration of Live Stream pools for a specific
          # location. Currently we support only one pool resource per project per
          # location. After the creation of the first input, a default pool is created
          # automatically at "projects/\\{project}/locations/\\{location}/pools/default".
          # @!attribute [rw] name
          #   @return [::String]
          #     The resource name of the pool, in the form of:
          #     `projects/{project}/locations/{location}/pools/{poolId}`.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The creation time.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The update time.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     User-defined key/value metadata.
          # @!attribute [rw] network_config
          #   @return [::Google::Cloud::Video::LiveStream::V1::Pool::NetworkConfig]
          #     Network configuration for the pool.
          class Pool
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the network configuration for the pool.
            # @!attribute [rw] peered_network
            #   @return [::String]
            #     peered_network is the network resource URL of the network that is peered
            #     to the service provider network. Must be of the format
            #     projects/NETWORK_PROJECT_NUMBER/global/networks/NETWORK_NAME, where
            #     NETWORK_PROJECT_NUMBER is the project number of the Cloud project that
            #     holds your VPC network and NETWORK_NAME is the name of your VPC network.
            #     If peered_network is omitted or empty, the pool will use endpoints that
            #     are publicly available.
            class NetworkConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
