# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/video/live_stream/v1/version"
require "google/cloud/video/live_stream/v1/bindings_override"

require "google/cloud/video/live_stream/v1/livestream_service/credentials"
require "google/cloud/video/live_stream/v1/livestream_service/paths"
require "google/cloud/video/live_stream/v1/livestream_service/rest/operations"
require "google/cloud/video/live_stream/v1/livestream_service/rest/client"

module Google
  module Cloud
    module Video
      module LiveStream
        module V1
          ##
          # Using Live Stream API, you can generate live streams in the various
          # renditions and streaming formats. The streaming format include HTTP Live
          # Streaming (HLS) and Dynamic Adaptive Streaming over HTTP (DASH). You can send
          # a source stream in the various ways, including Real-Time Messaging
          # Protocol (RTMP) and Secure Reliable Transport (SRT).
          #
          # To load this service and instantiate a REST client:
          #
          #     require "google/cloud/video/live_stream/v1/livestream_service/rest"
          #     client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Rest::Client.new
          #
          module LivestreamService
            # Client for the REST transport
            module Rest
            end
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/video/live_stream/v1/livestream_service/rest/helpers" if ::File.file? helper_path
