# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Video
      module LiveStream
        module V1
          module LivestreamService
            # Path helper methods for the LivestreamService API.
            module Paths
              ##
              # Create a fully-qualified Asset resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/assets/{asset}`
              #
              # @param project [String]
              # @param location [String]
              # @param asset [String]
              #
              # @return [::String]
              def asset_path project:, location:, asset:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/assets/#{asset}"
              end

              ##
              # Create a fully-qualified Channel resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/channels/{channel}`
              #
              # @param project [String]
              # @param location [String]
              # @param channel [String]
              #
              # @return [::String]
              def channel_path project:, location:, channel:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/channels/#{channel}"
              end

              ##
              # Create a fully-qualified Clip resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/channels/{channel}/clips/{clip}`
              #
              # @param project [String]
              # @param location [String]
              # @param channel [String]
              # @param clip [String]
              #
              # @return [::String]
              def clip_path project:, location:, channel:, clip:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "channel cannot contain /" if channel.to_s.include? "/"

                "projects/#{project}/locations/#{location}/channels/#{channel}/clips/#{clip}"
              end

              ##
              # Create a fully-qualified DvrSession resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/channels/{channel}/dvrSessions/{dvr_session}`
              #
              # @param project [String]
              # @param location [String]
              # @param channel [String]
              # @param dvr_session [String]
              #
              # @return [::String]
              def dvr_session_path project:, location:, channel:, dvr_session:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "channel cannot contain /" if channel.to_s.include? "/"

                "projects/#{project}/locations/#{location}/channels/#{channel}/dvrSessions/#{dvr_session}"
              end

              ##
              # Create a fully-qualified Event resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/channels/{channel}/events/{event}`
              #
              # @param project [String]
              # @param location [String]
              # @param channel [String]
              # @param event [String]
              #
              # @return [::String]
              def event_path project:, location:, channel:, event:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
                raise ::ArgumentError, "channel cannot contain /" if channel.to_s.include? "/"

                "projects/#{project}/locations/#{location}/channels/#{channel}/events/#{event}"
              end

              ##
              # Create a fully-qualified Input resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/inputs/{input}`
              #
              # @param project [String]
              # @param location [String]
              # @param input [String]
              #
              # @return [::String]
              def input_path project:, location:, input:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/inputs/#{input}"
              end

              ##
              # Create a fully-qualified Location resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}`
              #
              # @param project [String]
              # @param location [String]
              #
              # @return [::String]
              def location_path project:, location:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/locations/#{location}"
              end

              ##
              # Create a fully-qualified Network resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/global/networks/{network}`
              #
              # @param project [String]
              # @param network [String]
              #
              # @return [::String]
              def network_path project:, network:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                "projects/#{project}/global/networks/#{network}"
              end

              ##
              # Create a fully-qualified Pool resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/locations/{location}/pools/{pool}`
              #
              # @param project [String]
              # @param location [String]
              # @param pool [String]
              #
              # @return [::String]
              def pool_path project:, location:, pool:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                "projects/#{project}/locations/#{location}/pools/#{pool}"
              end

              ##
              # Create a fully-qualified SecretVersion resource string.
              #
              # The resource will be in the following format:
              #
              # `projects/{project}/secrets/{secret}/versions/{version}`
              #
              # @param project [String]
              # @param secret [String]
              # @param version [String]
              #
              # @return [::String]
              def secret_version_path project:, secret:, version:
                raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

                "projects/#{project}/secrets/#{secret}/versions/#{version}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
