# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/video/livestream/v1/service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Video
      module LiveStream
        module V1
          module LivestreamService
            ##
            # Client for the LivestreamService service.
            #
            # Using Live Stream API, you can generate live streams in the various
            # renditions and streaming formats. The streaming format include HTTP Live
            # Streaming (HLS) and Dynamic Adaptive Streaming over HTTP (DASH). You can send
            # a source stream in the various ways, including Real-Time Messaging
            # Protocol (RTMP) and Secure Reliable Transport (SRT).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "livestream.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :livestream_service_stub

              ##
              # Configure the LivestreamService Client class.
              #
              # See {::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all LivestreamService clients
              #   ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Video", "LiveStream", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_channel.timeout = 60.0

                  default_config.rpcs.list_channels.timeout = 60.0
                  default_config.rpcs.list_channels.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_channel.timeout = 60.0
                  default_config.rpcs.get_channel.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_channel.timeout = 60.0

                  default_config.rpcs.update_channel.timeout = 60.0

                  default_config.rpcs.start_channel.timeout = 60.0

                  default_config.rpcs.stop_channel.timeout = 60.0

                  default_config.rpcs.start_distribution.timeout = 60.0

                  default_config.rpcs.stop_distribution.timeout = 60.0

                  default_config.rpcs.create_input.timeout = 60.0

                  default_config.rpcs.list_inputs.timeout = 60.0
                  default_config.rpcs.list_inputs.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_input.timeout = 60.0
                  default_config.rpcs.get_input.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_input.timeout = 60.0

                  default_config.rpcs.update_input.timeout = 60.0

                  default_config.rpcs.preview_input.timeout = 60.0

                  default_config.rpcs.create_event.timeout = 60.0

                  default_config.rpcs.list_events.timeout = 60.0
                  default_config.rpcs.list_events.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_event.timeout = 60.0
                  default_config.rpcs.get_event.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_event.timeout = 60.0

                  default_config.rpcs.list_clips.timeout = 60.0
                  default_config.rpcs.list_clips.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_clip.timeout = 60.0
                  default_config.rpcs.get_clip.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_clip.timeout = 60.0

                  default_config.rpcs.delete_clip.timeout = 60.0

                  default_config.rpcs.create_dvr_session.timeout = 60.0

                  default_config.rpcs.list_dvr_sessions.timeout = 60.0
                  default_config.rpcs.list_dvr_sessions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_dvr_session.timeout = 60.0
                  default_config.rpcs.get_dvr_session.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_dvr_session.timeout = 60.0

                  default_config.rpcs.update_dvr_session.timeout = 60.0

                  default_config.rpcs.create_asset.timeout = 60.0

                  default_config.rpcs.delete_asset.timeout = 60.0

                  default_config.rpcs.get_asset.timeout = 60.0
                  default_config.rpcs.get_asset.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_assets.timeout = 60.0
                  default_config.rpcs.list_assets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_pool.timeout = 60.0
                  default_config.rpcs.get_pool.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_pool.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the LivestreamService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @livestream_service_stub.universe_domain
              end

              ##
              # Create a new LivestreamService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the LivestreamService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/cloud/video/livestream/v1/service_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @livestream_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @livestream_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @livestream_service_stub.endpoint
                  config.universe_domain = @livestream_service_stub.universe_domain
                  config.logger = @livestream_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::LivestreamService::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @livestream_service_stub.logger
              end

              # Service calls

              ##
              # Creates a channel with the provided unique ID in the specified
              # region.
              #
              # @overload create_channel(request, options = nil)
              #   Pass arguments to `create_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_channel(parent: nil, channel: nil, channel_id: nil, request_id: nil)
              #   Pass arguments to `create_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param channel [::Google::Cloud::Video::LiveStream::V1::Channel, ::Hash]
              #     Required. The channel resource to be created.
              #   @param channel_id [::String]
              #     Required. The ID of the channel resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateChannelRequest.new
              #
              #   # Call the create_channel method.
              #   result = client.create_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_channel, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all channels in the specified region.
              #
              # @overload list_channels(request, options = nil)
              #   Pass arguments to `list_channels` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_channels(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_channels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. If unspecified, server
              #     will pick an appropriate default. Server may return fewer items than
              #     requested. A caller should only rely on response's
              #     {::Google::Cloud::Video::LiveStream::V1::ListChannelsResponse#next_page_token next_page_token}
              #     to determine if there are more items left to be queried.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #   @param filter [::String]
              #     The filter to apply to list results.
              #   @param order_by [::String]
              #     Specifies the ordering of results following syntax at
              #     https://cloud.google.com/apis/design/design_patterns#sorting_order.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Channel>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Channel>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListChannelsRequest.new
              #
              #   # Call the list_channels method.
              #   result = client.list_channels request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::Channel.
              #     p item
              #   end
              #
              def list_channels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListChannelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_channels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_channels.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_channels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_channels, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_channels, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified channel.
              #
              # @overload get_channel(request, options = nil)
              #   Pass arguments to `get_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_channel(name: nil)
              #   Pass arguments to `get_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Channel]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Channel]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetChannelRequest.new
              #
              #   # Call the get_channel method.
              #   result = client.get_channel request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Channel.
              #   p result
              #
              def get_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_channel, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified channel.
              #
              # @overload delete_channel(request, options = nil)
              #   Pass arguments to `delete_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_channel(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #   @param force [::Boolean]
              #     If the `force` field is set to the default value of `false`, you must
              #     delete all of a channel's events before you can delete the channel itself.
              #     If the field is set to `true`, requests to delete a channel also delete
              #     associated channel events.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest.new
              #
              #   # Call the delete_channel method.
              #   result = client.delete_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_channel, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified channel.
              #
              # @overload update_channel(request, options = nil)
              #   Pass arguments to `update_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_channel(update_mask: nil, channel: nil, request_id: nil)
              #   Pass arguments to `update_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the Channel
              #     resource by the update. You can only update the following fields:
              #
              #     * [`inputAttachments`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputattachment)
              #     * [`inputConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputconfig)
              #     * [`output`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#output)
              #     * [`elementaryStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#elementarystream)
              #     * [`muxStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#muxstream)
              #     * [`manifests`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#manifest)
              #     * [`spriteSheets`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#spritesheet)
              #     * [`logConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#logconfig)
              #     * [`timecodeConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#timecodeconfig)
              #     * [`encryptions`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#encryption)
              #
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #
              #     If the mask is not present, then each field from the list above is updated
              #     if the field appears in the request payload. To unset a field, add the
              #     field to the update mask and remove it from the request payload.
              #   @param channel [::Google::Cloud::Video::LiveStream::V1::Channel, ::Hash]
              #     Required. The channel resource to be updated.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest.new
              #
              #   # Call the update_channel method.
              #   result = client.update_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::UpdateChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.channel&.name
                  header_params["channel.name"] = request.channel.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :update_channel, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts the specified channel. Part of the video pipeline will be created
              # only when the StartChannel request is received by the server.
              #
              # @overload start_channel(request, options = nil)
              #   Pass arguments to `start_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::StartChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::StartChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload start_channel(name: nil, request_id: nil)
              #   Pass arguments to `start_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::StartChannelRequest.new
              #
              #   # Call the start_channel method.
              #   result = client.start_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::StartChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.start_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.start_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.start_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :start_channel, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops the specified channel. Part of the video pipeline will be released
              # when the StopChannel request is received by the server.
              #
              # @overload stop_channel(request, options = nil)
              #   Pass arguments to `stop_channel` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::StopChannelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::StopChannelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload stop_channel(name: nil, request_id: nil)
              #   Pass arguments to `stop_channel` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::StopChannelRequest.new
              #
              #   # Call the stop_channel method.
              #   result = client.stop_channel request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_channel request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::StopChannelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.stop_channel.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.stop_channel.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.stop_channel.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :stop_channel, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts distribution which delivers outputs to the destination indicated by
              # the Distribution configuration.
              #
              # @overload start_distribution(request, options = nil)
              #   Pass arguments to `start_distribution` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload start_distribution(name: nil, distribution_keys: nil, request_id: nil)
              #   Pass arguments to `start_distribution` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param distribution_keys [::Array<::String>]
              #     Optional. A list of keys to identify the distribution configuration in the
              #     channel resource. If left empty, all the distributions in the channel
              #     specification will be started.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::StartDistributionRequest.new
              #
              #   # Call the start_distribution method.
              #   result = client.start_distribution request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_distribution request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::StartDistributionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.start_distribution.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.start_distribution.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.start_distribution.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :start_distribution, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops the specified distribution.
              #
              # @overload stop_distribution(request, options = nil)
              #   Pass arguments to `stop_distribution` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload stop_distribution(name: nil, distribution_keys: nil, request_id: nil)
              #   Pass arguments to `stop_distribution` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the channel resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param distribution_keys [::Array<::String>]
              #     Optional. A list of key to identify the distribution configuration in the
              #     channel resource. If left empty, all the distributions in the channel
              #     specification will be stopped.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::StopDistributionRequest.new
              #
              #   # Call the stop_distribution method.
              #   result = client.stop_distribution request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_distribution request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::StopDistributionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.stop_distribution.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.stop_distribution.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.stop_distribution.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :stop_distribution, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an input with the provided unique ID in the specified region.
              #
              # @overload create_input(request, options = nil)
              #   Pass arguments to `create_input` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateInputRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateInputRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_input(parent: nil, input: nil, input_id: nil, request_id: nil)
              #   Pass arguments to `create_input` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param input [::Google::Cloud::Video::LiveStream::V1::Input, ::Hash]
              #     Required. The input resource to be created.
              #   @param input_id [::String]
              #     Required. The ID of the input resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateInputRequest.new
              #
              #   # Call the create_input method.
              #   result = client.create_input request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_input request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateInputRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_input.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_input.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_input.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_input, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all inputs in the specified region.
              #
              # @overload list_inputs(request, options = nil)
              #   Pass arguments to `list_inputs` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListInputsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListInputsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_inputs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_inputs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. If unspecified, server
              #     will pick an appropriate default. Server may return fewer items than
              #     requested. A caller should only rely on response's
              #     {::Google::Cloud::Video::LiveStream::V1::ListInputsResponse#next_page_token next_page_token}
              #     to determine if there are more items left to be queried.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #   @param filter [::String]
              #     The filter to apply to list results.
              #   @param order_by [::String]
              #     Specifies the ordering of results following syntax at [Sorting
              #     Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Input>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Input>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListInputsRequest.new
              #
              #   # Call the list_inputs method.
              #   result = client.list_inputs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::Input.
              #     p item
              #   end
              #
              def list_inputs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListInputsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_inputs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_inputs.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_inputs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_inputs, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_inputs, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified input.
              #
              # @overload get_input(request, options = nil)
              #   Pass arguments to `get_input` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetInputRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetInputRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_input(name: nil)
              #   Pass arguments to `get_input` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the input resource, in the form of:
              #     `projects/{project}/locations/{location}/inputs/{inputId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Input]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Input]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetInputRequest.new
              #
              #   # Call the get_input method.
              #   result = client.get_input request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Input.
              #   p result
              #
              def get_input request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetInputRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_input.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_input.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_input.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_input, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified input.
              #
              # @overload delete_input(request, options = nil)
              #   Pass arguments to `delete_input` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_input(name: nil, request_id: nil)
              #   Pass arguments to `delete_input` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the input resource, in the form of:
              #     `projects/{project}/locations/{location}/inputs/{inputId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteInputRequest.new
              #
              #   # Call the delete_input method.
              #   result = client.delete_input request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_input request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteInputRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_input.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_input.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_input.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_input, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified input.
              #
              # @overload update_input(request, options = nil)
              #   Pass arguments to `update_input` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_input(update_mask: nil, input: nil, request_id: nil)
              #   Pass arguments to `update_input` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the Input
              #     resource by the update. You can only update the following fields:
              #
              #     * [`tier`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#Tier)
              #     * [`preprocessingConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#PreprocessingConfig)
              #     * [`securityRules`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#SecurityRule)
              #
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #
              #     If the mask is not present, then each field from the list above is updated
              #     if the field appears in the request payload. To unset a field, add the
              #     field to the update mask and remove it from the request payload.
              #   @param input [::Google::Cloud::Video::LiveStream::V1::Input, ::Hash]
              #     Required. The input resource to be updated.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::UpdateInputRequest.new
              #
              #   # Call the update_input method.
              #   result = client.update_input request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_input request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::UpdateInputRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_input.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.input&.name
                  header_params["input.name"] = request.input.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_input.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_input.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :update_input, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Preview the streaming content of the specified input.
              #
              # @overload preview_input(request, options = nil)
              #   Pass arguments to `preview_input` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload preview_input(name: nil)
              #   Pass arguments to `preview_input` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the input resource, in the form of:
              #     `projects/{project}/locations/{location}/inputs/{inputId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::PreviewInputResponse]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::PreviewInputResponse]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::PreviewInputRequest.new
              #
              #   # Call the preview_input method.
              #   result = client.preview_input request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::PreviewInputResponse.
              #   p result
              #
              def preview_input request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::PreviewInputRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.preview_input.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.preview_input.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.preview_input.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :preview_input, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an event with the provided unique ID in the specified channel.
              #
              # @overload create_event(request, options = nil)
              #   Pass arguments to `create_event` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_event(parent: nil, event: nil, event_id: nil, request_id: nil)
              #   Pass arguments to `create_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent channel for the resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param event [::Google::Cloud::Video::LiveStream::V1::Event, ::Hash]
              #     Required. The event resource to be created.
              #   @param event_id [::String]
              #     Required. The ID of the event resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Event]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Event]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateEventRequest.new
              #
              #   # Call the create_event method.
              #   result = client.create_event request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Event.
              #   p result
              #
              def create_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all events in the specified channel.
              #
              # @overload list_events(request, options = nil)
              #   Pass arguments to `list_events` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListEventsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListEventsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_events(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_events` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent channel for the resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. If unspecified, server
              #     will pick an appropriate default. Server may return fewer items than
              #     requested. A caller should only rely on response's
              #     {::Google::Cloud::Video::LiveStream::V1::ListEventsResponse#next_page_token next_page_token}
              #     to determine if there are more items left to be queried.
              #   @param page_token [::String]
              #     The next_page_token value returned from a previous List request, if any.
              #   @param filter [::String]
              #     The filter to apply to list results.
              #   @param order_by [::String]
              #     Specifies the ordering of results following syntax at
              #     https://cloud.google.com/apis/design/design_patterns#sorting_order.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Event>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Event>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListEventsRequest.new
              #
              #   # Call the list_events method.
              #   result = client.list_events request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::Event.
              #     p item
              #   end
              #
              def list_events request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListEventsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_events.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_events.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_events.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_events, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_events, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified event.
              #
              # @overload get_event(request, options = nil)
              #   Pass arguments to `get_event` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_event(name: nil)
              #   Pass arguments to `get_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the event resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Event]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Event]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetEventRequest.new
              #
              #   # Call the get_event method.
              #   result = client.get_event request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Event.
              #   p result
              #
              def get_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified event.
              #
              # @overload delete_event(request, options = nil)
              #   Pass arguments to `delete_event` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_event(name: nil, request_id: nil)
              #   Pass arguments to `delete_event` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the event resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteEventRequest.new
              #
              #   # Call the delete_event method.
              #   result = client.delete_event request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_event request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteEventRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_event.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_event.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_event.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_event, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all clips in the specified channel.
              #
              # @overload list_clips(request, options = nil)
              #   Pass arguments to `list_clips` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListClipsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListClipsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_clips(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_clips` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListClipsRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Clip>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Clip>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListClipsRequest.new
              #
              #   # Call the list_clips method.
              #   result = client.list_clips request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::Clip.
              #     p item
              #   end
              #
              def list_clips request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListClipsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_clips.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_clips.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_clips.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_clips, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_clips, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified clip.
              #
              # @overload get_clip(request, options = nil)
              #   Pass arguments to `get_clip` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetClipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetClipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_clip(name: nil)
              #   Pass arguments to `get_clip` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource, in the following form:
              #     `projects/{project}/locations/{location}/channels/{channel}/clips/{clip}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Clip]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Clip]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetClipRequest.new
              #
              #   # Call the get_clip method.
              #   result = client.get_clip request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Clip.
              #   p result
              #
              def get_clip request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetClipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_clip.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_clip.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_clip.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_clip, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a clip with the provided clip ID in the specified channel.
              #
              # @overload create_clip(request, options = nil)
              #   Pass arguments to `create_clip` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateClipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateClipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_clip(parent: nil, clip_id: nil, clip: nil, request_id: nil)
              #   Pass arguments to `create_clip` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the following form:
              #     `projects/{project}/locations/{location}/channels/{channel}`.
              #   @param clip_id [::String]
              #     Required. The ID of the clip resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param clip [::Google::Cloud::Video::LiveStream::V1::Clip, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateClipRequest.new
              #
              #   # Call the create_clip method.
              #   result = client.create_clip request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_clip request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateClipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_clip.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_clip.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_clip.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_clip, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified clip job resource. This method only deletes the clip
              # job and does not delete the VOD clip stored in Cloud Storage.
              #
              # @overload delete_clip(request, options = nil)
              #   Pass arguments to `delete_clip` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_clip(name: nil, request_id: nil)
              #   Pass arguments to `delete_clip` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the clip resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}/clips/{clipId}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteClipRequest.new
              #
              #   # Call the delete_clip method.
              #   result = client.delete_clip request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_clip request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteClipRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_clip.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_clip.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_clip.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_clip, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a DVR session with the provided unique ID in the specified channel.
              #
              # @overload create_dvr_session(request, options = nil)
              #   Pass arguments to `create_dvr_session` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_dvr_session(parent: nil, dvr_session_id: nil, dvr_session: nil, request_id: nil)
              #   Pass arguments to `create_dvr_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, in the following form:
              #     `projects/{project}/locations/{location}/channels/{channelId}`.
              #   @param dvr_session_id [::String]
              #     Required. The ID of the DVR session resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param dvr_session [::Google::Cloud::Video::LiveStream::V1::DvrSession, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest.new
              #
              #   # Call the create_dvr_session method.
              #   result = client.create_dvr_session request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_dvr_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateDvrSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_dvr_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_dvr_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_dvr_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_dvr_session, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all DVR sessions in the specified channel.
              #
              # @overload list_dvr_sessions(request, options = nil)
              #   Pass arguments to `list_dvr_sessions` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_dvr_sessions(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_dvr_sessions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListDvrSessionsRequest
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::DvrSession>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::DvrSession>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest.new
              #
              #   # Call the list_dvr_sessions method.
              #   result = client.list_dvr_sessions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::DvrSession.
              #     p item
              #   end
              #
              def list_dvr_sessions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListDvrSessionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_dvr_sessions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_dvr_sessions.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_dvr_sessions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_dvr_sessions, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_dvr_sessions, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified DVR session.
              #
              # @overload get_dvr_session(request, options = nil)
              #   Pass arguments to `get_dvr_session` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_dvr_session(name: nil)
              #   Pass arguments to `get_dvr_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource, in the following form:
              #     `projects/{project}/locations/{location}/channels/{channelId}/dvrSessions/{dvrSessionId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::DvrSession]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::DvrSession]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest.new
              #
              #   # Call the get_dvr_session method.
              #   result = client.get_dvr_session request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::DvrSession.
              #   p result
              #
              def get_dvr_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetDvrSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_dvr_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_dvr_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_dvr_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_dvr_session, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified DVR session.
              #
              # @overload delete_dvr_session(request, options = nil)
              #   Pass arguments to `delete_dvr_session` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_dvr_session(name: nil, request_id: nil)
              #   Pass arguments to `delete_dvr_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the event resource, in the form of:
              #     `projects/{project}/locations/{location}/channels/{channelId}/dvrSessions/{dvrSessionId}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest.new
              #
              #   # Call the delete_dvr_session method.
              #   result = client.delete_dvr_session request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_dvr_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteDvrSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_dvr_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_dvr_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_dvr_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_dvr_session, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified DVR session.
              #
              # @overload update_dvr_session(request, options = nil)
              #   Pass arguments to `update_dvr_session` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_dvr_session(update_mask: nil, dvr_session: nil, request_id: nil)
              #   Pass arguments to `update_dvr_session` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     DvrSession resource by the update. You can only update the following
              #     fields:
              #
              #     * `dvrWindows`
              #
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #   @param dvr_session [::Google::Cloud::Video::LiveStream::V1::DvrSession, ::Hash]
              #     Required. The DVR session resource to be updated.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest.new
              #
              #   # Call the update_dvr_session method.
              #   result = client.update_dvr_session request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_dvr_session request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::UpdateDvrSessionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_dvr_session.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.dvr_session&.name
                  header_params["dvr_session.name"] = request.dvr_session.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_dvr_session.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_dvr_session.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :update_dvr_session, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Asset with the provided unique ID in the specified
              # region.
              #
              # @overload create_asset(request, options = nil)
              #   Pass arguments to `create_asset` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload create_asset(parent: nil, asset: nil, asset_id: nil, request_id: nil)
              #   Pass arguments to `create_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param asset [::Google::Cloud::Video::LiveStream::V1::Asset, ::Hash]
              #     Required. The asset resource to be created.
              #   @param asset_id [::String]
              #     Required. The ID of the asset resource to be created.
              #
              #     This value must be 1-63 characters, begin and end with a lower-case letter
              #     or a number, and consist of only lower-case letters, numbers, and hyphens.
              #     In other words, it must match the following regex:
              #     `^[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?$`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::CreateAssetRequest.new
              #
              #   # Call the create_asset method.
              #   result = client.create_asset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::CreateAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.create_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.create_asset.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.create_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :create_asset, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the specified asset if it is not used.
              #
              # @overload delete_asset(request, options = nil)
              #   Pass arguments to `delete_asset` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload delete_asset(name: nil, request_id: nil)
              #   Pass arguments to `delete_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the asset resource, in the form of:
              #     `projects/{project}/locations/{location}/assets/{assetId}`.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest.new
              #
              #   # Call the delete_asset method.
              #   result = client.delete_asset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::DeleteAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.delete_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.delete_asset.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.delete_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :delete_asset, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified asset.
              #
              # @overload get_asset(request, options = nil)
              #   Pass arguments to `get_asset` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_asset(name: nil)
              #   Pass arguments to `get_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource, in the following form:
              #     `projects/{project}/locations/{location}/assets/{asset}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Asset]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Asset]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetAssetRequest.new
              #
              #   # Call the get_asset method.
              #   result = client.get_asset request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Asset.
              #   p result
              #
              def get_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_asset.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_asset, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of all assets in the specified region.
              #
              # @overload list_assets(request, options = nil)
              #   Pass arguments to `list_assets` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_assets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_assets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent location for the resource, in the form of:
              #     `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Asset>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Cloud::Video::LiveStream::V1::Asset>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::ListAssetsRequest.new
              #
              #   # Call the list_assets method.
              #   result = client.list_assets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Video::LiveStream::V1::Asset.
              #     p item
              #   end
              #
              def list_assets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::ListAssetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_assets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_assets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :list_assets, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @livestream_service_stub, :list_assets, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the specified pool.
              #
              # @overload get_pool(request, options = nil)
              #   Pass arguments to `get_pool` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::GetPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::GetPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_pool(name: nil)
              #   Pass arguments to `get_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the pool resource, in the form of:
              #     `projects/{project}/locations/{location}/pools/{poolId}`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Cloud::Video::LiveStream::V1::Pool]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Cloud::Video::LiveStream::V1::Pool]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::GetPoolRequest.new
              #
              #   # Call the get_pool method.
              #   result = client.get_pool request
              #
              #   # The returned object is of type Google::Cloud::Video::LiveStream::V1::Pool.
              #   p result
              #
              def get_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::GetPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_pool.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :get_pool, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the specified pool.
              #
              # @overload update_pool(request, options = nil)
              #   Pass arguments to `update_pool` via a request object, either of type
              #   {::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload update_pool(update_mask: nil, pool: nil, request_id: nil)
              #   Pass arguments to `update_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Field mask is used to specify the fields to be overwritten in the Pool
              #     resource by the update. You can only update the following fields:
              #
              #     * `networkConfig`
              #
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask.
              #   @param pool [::Google::Cloud::Video::LiveStream::V1::Pool, ::Hash]
              #     Required. The pool resource to be updated.
              #   @param request_id [::String]
              #     A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported `(00000000-0000-0000-0000-000000000000)`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::Operation]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/cloud/video/live_stream/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest.new
              #
              #   # Call the update_pool method.
              #   result = client.update_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Video::LiveStream::V1::UpdatePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.update_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Video::LiveStream::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.pool&.name
                  header_params["pool.name"] = request.pool.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.update_pool.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.update_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @livestream_service_stub.call_rpc :update_pool, request, options: options do |response, operation|
                  response = ::Gapic::Operation.new response, @operations_client, options: options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the LivestreamService API.
              #
              # This class represents the configuration for LivestreamService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_channel to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_channel.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_channel.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Cloud::Video::LiveStream::V1::LivestreamService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "livestream.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the LivestreamService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_channel
                  ##
                  # RPC-specific configuration for `list_channels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_channels
                  ##
                  # RPC-specific configuration for `get_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_channel
                  ##
                  # RPC-specific configuration for `delete_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_channel
                  ##
                  # RPC-specific configuration for `update_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_channel
                  ##
                  # RPC-specific configuration for `start_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_channel
                  ##
                  # RPC-specific configuration for `stop_channel`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_channel
                  ##
                  # RPC-specific configuration for `start_distribution`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_distribution
                  ##
                  # RPC-specific configuration for `stop_distribution`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_distribution
                  ##
                  # RPC-specific configuration for `create_input`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_input
                  ##
                  # RPC-specific configuration for `list_inputs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_inputs
                  ##
                  # RPC-specific configuration for `get_input`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_input
                  ##
                  # RPC-specific configuration for `delete_input`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_input
                  ##
                  # RPC-specific configuration for `update_input`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_input
                  ##
                  # RPC-specific configuration for `preview_input`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :preview_input
                  ##
                  # RPC-specific configuration for `create_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_event
                  ##
                  # RPC-specific configuration for `list_events`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_events
                  ##
                  # RPC-specific configuration for `get_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_event
                  ##
                  # RPC-specific configuration for `delete_event`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_event
                  ##
                  # RPC-specific configuration for `list_clips`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clips
                  ##
                  # RPC-specific configuration for `get_clip`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_clip
                  ##
                  # RPC-specific configuration for `create_clip`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_clip
                  ##
                  # RPC-specific configuration for `delete_clip`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_clip
                  ##
                  # RPC-specific configuration for `create_dvr_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dvr_session
                  ##
                  # RPC-specific configuration for `list_dvr_sessions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_dvr_sessions
                  ##
                  # RPC-specific configuration for `get_dvr_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dvr_session
                  ##
                  # RPC-specific configuration for `delete_dvr_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dvr_session
                  ##
                  # RPC-specific configuration for `update_dvr_session`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dvr_session
                  ##
                  # RPC-specific configuration for `create_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_asset
                  ##
                  # RPC-specific configuration for `delete_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_asset
                  ##
                  # RPC-specific configuration for `get_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_asset
                  ##
                  # RPC-specific configuration for `list_assets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_assets
                  ##
                  # RPC-specific configuration for `get_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_pool
                  ##
                  # RPC-specific configuration for `update_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_pool

                  # @private
                  def initialize parent_rpcs = nil
                    create_channel_config = parent_rpcs.create_channel if parent_rpcs.respond_to? :create_channel
                    @create_channel = ::Gapic::Config::Method.new create_channel_config
                    list_channels_config = parent_rpcs.list_channels if parent_rpcs.respond_to? :list_channels
                    @list_channels = ::Gapic::Config::Method.new list_channels_config
                    get_channel_config = parent_rpcs.get_channel if parent_rpcs.respond_to? :get_channel
                    @get_channel = ::Gapic::Config::Method.new get_channel_config
                    delete_channel_config = parent_rpcs.delete_channel if parent_rpcs.respond_to? :delete_channel
                    @delete_channel = ::Gapic::Config::Method.new delete_channel_config
                    update_channel_config = parent_rpcs.update_channel if parent_rpcs.respond_to? :update_channel
                    @update_channel = ::Gapic::Config::Method.new update_channel_config
                    start_channel_config = parent_rpcs.start_channel if parent_rpcs.respond_to? :start_channel
                    @start_channel = ::Gapic::Config::Method.new start_channel_config
                    stop_channel_config = parent_rpcs.stop_channel if parent_rpcs.respond_to? :stop_channel
                    @stop_channel = ::Gapic::Config::Method.new stop_channel_config
                    start_distribution_config = parent_rpcs.start_distribution if parent_rpcs.respond_to? :start_distribution
                    @start_distribution = ::Gapic::Config::Method.new start_distribution_config
                    stop_distribution_config = parent_rpcs.stop_distribution if parent_rpcs.respond_to? :stop_distribution
                    @stop_distribution = ::Gapic::Config::Method.new stop_distribution_config
                    create_input_config = parent_rpcs.create_input if parent_rpcs.respond_to? :create_input
                    @create_input = ::Gapic::Config::Method.new create_input_config
                    list_inputs_config = parent_rpcs.list_inputs if parent_rpcs.respond_to? :list_inputs
                    @list_inputs = ::Gapic::Config::Method.new list_inputs_config
                    get_input_config = parent_rpcs.get_input if parent_rpcs.respond_to? :get_input
                    @get_input = ::Gapic::Config::Method.new get_input_config
                    delete_input_config = parent_rpcs.delete_input if parent_rpcs.respond_to? :delete_input
                    @delete_input = ::Gapic::Config::Method.new delete_input_config
                    update_input_config = parent_rpcs.update_input if parent_rpcs.respond_to? :update_input
                    @update_input = ::Gapic::Config::Method.new update_input_config
                    preview_input_config = parent_rpcs.preview_input if parent_rpcs.respond_to? :preview_input
                    @preview_input = ::Gapic::Config::Method.new preview_input_config
                    create_event_config = parent_rpcs.create_event if parent_rpcs.respond_to? :create_event
                    @create_event = ::Gapic::Config::Method.new create_event_config
                    list_events_config = parent_rpcs.list_events if parent_rpcs.respond_to? :list_events
                    @list_events = ::Gapic::Config::Method.new list_events_config
                    get_event_config = parent_rpcs.get_event if parent_rpcs.respond_to? :get_event
                    @get_event = ::Gapic::Config::Method.new get_event_config
                    delete_event_config = parent_rpcs.delete_event if parent_rpcs.respond_to? :delete_event
                    @delete_event = ::Gapic::Config::Method.new delete_event_config
                    list_clips_config = parent_rpcs.list_clips if parent_rpcs.respond_to? :list_clips
                    @list_clips = ::Gapic::Config::Method.new list_clips_config
                    get_clip_config = parent_rpcs.get_clip if parent_rpcs.respond_to? :get_clip
                    @get_clip = ::Gapic::Config::Method.new get_clip_config
                    create_clip_config = parent_rpcs.create_clip if parent_rpcs.respond_to? :create_clip
                    @create_clip = ::Gapic::Config::Method.new create_clip_config
                    delete_clip_config = parent_rpcs.delete_clip if parent_rpcs.respond_to? :delete_clip
                    @delete_clip = ::Gapic::Config::Method.new delete_clip_config
                    create_dvr_session_config = parent_rpcs.create_dvr_session if parent_rpcs.respond_to? :create_dvr_session
                    @create_dvr_session = ::Gapic::Config::Method.new create_dvr_session_config
                    list_dvr_sessions_config = parent_rpcs.list_dvr_sessions if parent_rpcs.respond_to? :list_dvr_sessions
                    @list_dvr_sessions = ::Gapic::Config::Method.new list_dvr_sessions_config
                    get_dvr_session_config = parent_rpcs.get_dvr_session if parent_rpcs.respond_to? :get_dvr_session
                    @get_dvr_session = ::Gapic::Config::Method.new get_dvr_session_config
                    delete_dvr_session_config = parent_rpcs.delete_dvr_session if parent_rpcs.respond_to? :delete_dvr_session
                    @delete_dvr_session = ::Gapic::Config::Method.new delete_dvr_session_config
                    update_dvr_session_config = parent_rpcs.update_dvr_session if parent_rpcs.respond_to? :update_dvr_session
                    @update_dvr_session = ::Gapic::Config::Method.new update_dvr_session_config
                    create_asset_config = parent_rpcs.create_asset if parent_rpcs.respond_to? :create_asset
                    @create_asset = ::Gapic::Config::Method.new create_asset_config
                    delete_asset_config = parent_rpcs.delete_asset if parent_rpcs.respond_to? :delete_asset
                    @delete_asset = ::Gapic::Config::Method.new delete_asset_config
                    get_asset_config = parent_rpcs.get_asset if parent_rpcs.respond_to? :get_asset
                    @get_asset = ::Gapic::Config::Method.new get_asset_config
                    list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                    @list_assets = ::Gapic::Config::Method.new list_assets_config
                    get_pool_config = parent_rpcs.get_pool if parent_rpcs.respond_to? :get_pool
                    @get_pool = ::Gapic::Config::Method.new get_pool_config
                    update_pool_config = parent_rpcs.update_pool if parent_rpcs.respond_to? :update_pool
                    @update_pool = ::Gapic::Config::Method.new update_pool_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
