# -*- ruby -*-
# encoding: utf-8

require File.expand_path("lib/google/cloud/video/live_stream/v1/version", __dir__)

Gem::Specification.new do |gem|
  gem.name          = "google-cloud-video-live_stream-v1"
  gem.version       = Google::Cloud::Video::LiveStream::V1::VERSION

  gem.authors       = ["Google LLC"]
  gem.email         = "googleapis-packages@google.com"
  gem.description   = "The Live Stream API transcodes mezzanine live signals into direct-to-consumer streaming formats, including Dynamic Adaptive Streaming over HTTP (DASH/MPEG-DASH), and HTTP Live Streaming (HLS), for multiple device platforms. Note that google-cloud-video-live_stream-v1 is a version-specific client library. For most uses, we recommend installing the main client library google-cloud-video-live_stream instead. See the readme for more details."
  gem.summary       = "API Client library for the Live Stream V1 API"
  gem.homepage      = "https://github.com/googleapis/google-cloud-ruby"
  gem.license       = "Apache-2.0"

  gem.platform      = Gem::Platform::RUBY

  gem.files         = `git ls-files -- lib/*`.split("\n") +
                      `git ls-files -- proto_docs/*`.split("\n") +
                      ["README.md", "LICENSE.md", "AUTHENTICATION.md", ".yardopts"]
  gem.require_paths = ["lib"]

  gem.required_ruby_version = ">= 3.1"

  gem.add_dependency "gapic-common", "~> 1.2"
  gem.add_dependency "google-cloud-errors", "~> 1.0"
  gem.add_dependency "google-cloud-location", "~> 1.0"
end
