# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/translate/v3/translation_service_pb"
require "google/cloud/translate/v3/translation_service/rest"


class ::Google::Cloud::Translate::V3::TranslationService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_translate_text
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::TranslateTextResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    contents = ["hello world"]
    mime_type = "hello world"
    source_language_code = "hello world"
    target_language_code = "hello world"
    parent = "hello world"
    model = "hello world"
    glossary_config = {}
    transliteration_config = {}
    labels = {}

    translate_text_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_translate_text_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, translate_text_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.translate_text({ contents: contents, mime_type: mime_type, source_language_code: source_language_code, target_language_code: target_language_code, parent: parent, model: model, glossary_config: glossary_config, transliteration_config: transliteration_config, labels: labels }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.translate_text contents: contents, mime_type: mime_type, source_language_code: source_language_code, target_language_code: target_language_code, parent: parent, model: model, glossary_config: glossary_config, transliteration_config: transliteration_config, labels: labels do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.translate_text ::Google::Cloud::Translate::V3::TranslateTextRequest.new(contents: contents, mime_type: mime_type, source_language_code: source_language_code, target_language_code: target_language_code, parent: parent, model: model, glossary_config: glossary_config, transliteration_config: transliteration_config, labels: labels) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.translate_text({ contents: contents, mime_type: mime_type, source_language_code: source_language_code, target_language_code: target_language_code, parent: parent, model: model, glossary_config: glossary_config, transliteration_config: transliteration_config, labels: labels }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.translate_text(::Google::Cloud::Translate::V3::TranslateTextRequest.new(contents: contents, mime_type: mime_type, source_language_code: source_language_code, target_language_code: target_language_code, parent: parent, model: model, glossary_config: glossary_config, transliteration_config: transliteration_config, labels: labels), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, translate_text_client_stub.call_count
      end
    end
  end

  def test_romanize_text
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::RomanizeTextResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    contents = ["hello world"]
    source_language_code = "hello world"

    romanize_text_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_romanize_text_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, romanize_text_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.romanize_text({ parent: parent, contents: contents, source_language_code: source_language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.romanize_text parent: parent, contents: contents, source_language_code: source_language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.romanize_text ::Google::Cloud::Translate::V3::RomanizeTextRequest.new(parent: parent, contents: contents, source_language_code: source_language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.romanize_text({ parent: parent, contents: contents, source_language_code: source_language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.romanize_text(::Google::Cloud::Translate::V3::RomanizeTextRequest.new(parent: parent, contents: contents, source_language_code: source_language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, romanize_text_client_stub.call_count
      end
    end
  end

  def test_detect_language
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::DetectLanguageResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model = "hello world"
    content = "hello world"
    mime_type = "hello world"
    labels = {}

    detect_language_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_detect_language_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, detect_language_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.detect_language({ parent: parent, model: model, content: content, mime_type: mime_type, labels: labels }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.detect_language parent: parent, model: model, content: content, mime_type: mime_type, labels: labels do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.detect_language ::Google::Cloud::Translate::V3::DetectLanguageRequest.new(parent: parent, model: model, content: content, mime_type: mime_type, labels: labels) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.detect_language({ parent: parent, model: model, content: content, mime_type: mime_type, labels: labels }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.detect_language(::Google::Cloud::Translate::V3::DetectLanguageRequest.new(parent: parent, model: model, content: content, mime_type: mime_type, labels: labels), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, detect_language_client_stub.call_count
      end
    end
  end

  def test_get_supported_languages
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::SupportedLanguages.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    display_language_code = "hello world"
    model = "hello world"

    get_supported_languages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_supported_languages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_supported_languages_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_supported_languages({ parent: parent, display_language_code: display_language_code, model: model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_supported_languages parent: parent, display_language_code: display_language_code, model: model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_supported_languages ::Google::Cloud::Translate::V3::GetSupportedLanguagesRequest.new(parent: parent, display_language_code: display_language_code, model: model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_supported_languages({ parent: parent, display_language_code: display_language_code, model: model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_supported_languages(::Google::Cloud::Translate::V3::GetSupportedLanguagesRequest.new(parent: parent, display_language_code: display_language_code, model: model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_supported_languages_client_stub.call_count
      end
    end
  end

  def test_translate_document
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::TranslateDocumentResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_language_code = "hello world"
    target_language_code = "hello world"
    document_input_config = {}
    document_output_config = {}
    model = "hello world"
    glossary_config = {}
    labels = {}
    customized_attribution = "hello world"
    is_translate_native_pdf_only = true
    enable_shadow_removal_native_pdf = true
    enable_rotation_correction = true

    translate_document_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_translate_document_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, translate_document_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.translate_document({ parent: parent, source_language_code: source_language_code, target_language_code: target_language_code, document_input_config: document_input_config, document_output_config: document_output_config, model: model, glossary_config: glossary_config, labels: labels, customized_attribution: customized_attribution, is_translate_native_pdf_only: is_translate_native_pdf_only, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.translate_document parent: parent, source_language_code: source_language_code, target_language_code: target_language_code, document_input_config: document_input_config, document_output_config: document_output_config, model: model, glossary_config: glossary_config, labels: labels, customized_attribution: customized_attribution, is_translate_native_pdf_only: is_translate_native_pdf_only, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.translate_document ::Google::Cloud::Translate::V3::TranslateDocumentRequest.new(parent: parent, source_language_code: source_language_code, target_language_code: target_language_code, document_input_config: document_input_config, document_output_config: document_output_config, model: model, glossary_config: glossary_config, labels: labels, customized_attribution: customized_attribution, is_translate_native_pdf_only: is_translate_native_pdf_only, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.translate_document({ parent: parent, source_language_code: source_language_code, target_language_code: target_language_code, document_input_config: document_input_config, document_output_config: document_output_config, model: model, glossary_config: glossary_config, labels: labels, customized_attribution: customized_attribution, is_translate_native_pdf_only: is_translate_native_pdf_only, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.translate_document(::Google::Cloud::Translate::V3::TranslateDocumentRequest.new(parent: parent, source_language_code: source_language_code, target_language_code: target_language_code, document_input_config: document_input_config, document_output_config: document_output_config, model: model, glossary_config: glossary_config, labels: labels, customized_attribution: customized_attribution, is_translate_native_pdf_only: is_translate_native_pdf_only, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, translate_document_client_stub.call_count
      end
    end
  end

  def test_batch_translate_text
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_language_code = "hello world"
    target_language_codes = ["hello world"]
    models = {}
    input_configs = [{}]
    output_config = {}
    glossaries = {}
    labels = {}

    batch_translate_text_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_batch_translate_text_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_translate_text_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_translate_text({ parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, models: models, input_configs: input_configs, output_config: output_config, glossaries: glossaries, labels: labels }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_translate_text parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, models: models, input_configs: input_configs, output_config: output_config, glossaries: glossaries, labels: labels do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_translate_text ::Google::Cloud::Translate::V3::BatchTranslateTextRequest.new(parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, models: models, input_configs: input_configs, output_config: output_config, glossaries: glossaries, labels: labels) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_translate_text({ parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, models: models, input_configs: input_configs, output_config: output_config, glossaries: glossaries, labels: labels }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_translate_text(::Google::Cloud::Translate::V3::BatchTranslateTextRequest.new(parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, models: models, input_configs: input_configs, output_config: output_config, glossaries: glossaries, labels: labels), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_translate_text_client_stub.call_count
      end
    end
  end

  def test_batch_translate_document
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_language_code = "hello world"
    target_language_codes = ["hello world"]
    input_configs = [{}]
    output_config = {}
    models = {}
    glossaries = {}
    format_conversions = {}
    customized_attribution = "hello world"
    enable_shadow_removal_native_pdf = true
    enable_rotation_correction = true

    batch_translate_document_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_batch_translate_document_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_translate_document_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_translate_document({ parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, input_configs: input_configs, output_config: output_config, models: models, glossaries: glossaries, format_conversions: format_conversions, customized_attribution: customized_attribution, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_translate_document parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, input_configs: input_configs, output_config: output_config, models: models, glossaries: glossaries, format_conversions: format_conversions, customized_attribution: customized_attribution, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_translate_document ::Google::Cloud::Translate::V3::BatchTranslateDocumentRequest.new(parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, input_configs: input_configs, output_config: output_config, models: models, glossaries: glossaries, format_conversions: format_conversions, customized_attribution: customized_attribution, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_translate_document({ parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, input_configs: input_configs, output_config: output_config, models: models, glossaries: glossaries, format_conversions: format_conversions, customized_attribution: customized_attribution, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_translate_document(::Google::Cloud::Translate::V3::BatchTranslateDocumentRequest.new(parent: parent, source_language_code: source_language_code, target_language_codes: target_language_codes, input_configs: input_configs, output_config: output_config, models: models, glossaries: glossaries, format_conversions: format_conversions, customized_attribution: customized_attribution, enable_shadow_removal_native_pdf: enable_shadow_removal_native_pdf, enable_rotation_correction: enable_rotation_correction), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_translate_document_client_stub.call_count
      end
    end
  end

  def test_create_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    glossary = {}

    create_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_create_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_glossary({ parent: parent, glossary: glossary }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_glossary parent: parent, glossary: glossary do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_glossary ::Google::Cloud::Translate::V3::CreateGlossaryRequest.new(parent: parent, glossary: glossary) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_glossary({ parent: parent, glossary: glossary }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_glossary(::Google::Cloud::Translate::V3::CreateGlossaryRequest.new(parent: parent, glossary: glossary), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_glossary_client_stub.call_count
      end
    end
  end

  def test_update_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    glossary = {}
    update_mask = {}

    update_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_update_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_glossary({ glossary: glossary, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_glossary glossary: glossary, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_glossary ::Google::Cloud::Translate::V3::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_glossary({ glossary: glossary, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_glossary(::Google::Cloud::Translate::V3::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_glossary_client_stub.call_count
      end
    end
  end

  def test_list_glossaries
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListGlossariesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_glossaries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_glossaries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_glossaries_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_glossaries parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_glossaries ::Google::Cloud::Translate::V3::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_glossaries(::Google::Cloud::Translate::V3::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_glossaries_client_stub.call_count
      end
    end
  end

  def test_get_glossary
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::Glossary.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_glossary({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_glossary name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_glossary ::Google::Cloud::Translate::V3::GetGlossaryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_glossary({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_glossary(::Google::Cloud::Translate::V3::GetGlossaryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_glossary_client_stub.call_count
      end
    end
  end

  def test_delete_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_glossary({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_glossary name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_glossary ::Google::Cloud::Translate::V3::DeleteGlossaryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_glossary({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_glossary(::Google::Cloud::Translate::V3::DeleteGlossaryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_glossary_client_stub.call_count
      end
    end
  end

  def test_get_glossary_entry
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::GlossaryEntry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_glossary_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_glossary_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_glossary_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_glossary_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_glossary_entry ::Google::Cloud::Translate::V3::GetGlossaryEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_glossary_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_glossary_entry(::Google::Cloud::Translate::V3::GetGlossaryEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_glossary_entry_client_stub.call_count
      end
    end
  end

  def test_list_glossary_entries
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListGlossaryEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_glossary_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_glossary_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_glossary_entries_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_glossary_entries({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_glossary_entries parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_glossary_entries ::Google::Cloud::Translate::V3::ListGlossaryEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_glossary_entries({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_glossary_entries(::Google::Cloud::Translate::V3::ListGlossaryEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_glossary_entries_client_stub.call_count
      end
    end
  end

  def test_create_glossary_entry
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::GlossaryEntry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    glossary_entry = {}

    create_glossary_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_create_glossary_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_glossary_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_glossary_entry({ parent: parent, glossary_entry: glossary_entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_glossary_entry parent: parent, glossary_entry: glossary_entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_glossary_entry ::Google::Cloud::Translate::V3::CreateGlossaryEntryRequest.new(parent: parent, glossary_entry: glossary_entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_glossary_entry({ parent: parent, glossary_entry: glossary_entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_glossary_entry(::Google::Cloud::Translate::V3::CreateGlossaryEntryRequest.new(parent: parent, glossary_entry: glossary_entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_glossary_entry_client_stub.call_count
      end
    end
  end

  def test_update_glossary_entry
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::GlossaryEntry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    glossary_entry = {}

    update_glossary_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_update_glossary_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_glossary_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_glossary_entry({ glossary_entry: glossary_entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_glossary_entry glossary_entry: glossary_entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_glossary_entry ::Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest.new(glossary_entry: glossary_entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_glossary_entry({ glossary_entry: glossary_entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_glossary_entry(::Google::Cloud::Translate::V3::UpdateGlossaryEntryRequest.new(glossary_entry: glossary_entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_glossary_entry_client_stub.call_count
      end
    end
  end

  def test_delete_glossary_entry
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_glossary_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_glossary_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_glossary_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_glossary_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_glossary_entry ::Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_glossary_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_glossary_entry(::Google::Cloud::Translate::V3::DeleteGlossaryEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_glossary_entry_client_stub.call_count
      end
    end
  end

  def test_create_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset = {}

    create_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_create_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset({ parent: parent, dataset: dataset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset parent: parent, dataset: dataset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset ::Google::Cloud::Translate::V3::CreateDatasetRequest.new(parent: parent, dataset: dataset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset({ parent: parent, dataset: dataset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset(::Google::Cloud::Translate::V3::CreateDatasetRequest.new(parent: parent, dataset: dataset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_client_stub.call_count
      end
    end
  end

  def test_get_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset ::Google::Cloud::Translate::V3::GetDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset(::Google::Cloud::Translate::V3::GetDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_client_stub.call_count
      end
    end
  end

  def test_list_datasets
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_datasets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_datasets ::Google::Cloud::Translate::V3::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_datasets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_datasets(::Google::Cloud::Translate::V3::ListDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_datasets_client_stub.call_count
      end
    end
  end

  def test_delete_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset ::Google::Cloud::Translate::V3::DeleteDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset(::Google::Cloud::Translate::V3::DeleteDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_client_stub.call_count
      end
    end
  end

  def test_create_adaptive_mt_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::AdaptiveMtDataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    adaptive_mt_dataset = {}

    create_adaptive_mt_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_create_adaptive_mt_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_adaptive_mt_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_adaptive_mt_dataset({ parent: parent, adaptive_mt_dataset: adaptive_mt_dataset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_adaptive_mt_dataset parent: parent, adaptive_mt_dataset: adaptive_mt_dataset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_adaptive_mt_dataset ::Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest.new(parent: parent, adaptive_mt_dataset: adaptive_mt_dataset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_adaptive_mt_dataset({ parent: parent, adaptive_mt_dataset: adaptive_mt_dataset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_adaptive_mt_dataset(::Google::Cloud::Translate::V3::CreateAdaptiveMtDatasetRequest.new(parent: parent, adaptive_mt_dataset: adaptive_mt_dataset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_adaptive_mt_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_adaptive_mt_dataset
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_adaptive_mt_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_adaptive_mt_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_adaptive_mt_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_adaptive_mt_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_adaptive_mt_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_adaptive_mt_dataset ::Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_adaptive_mt_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_adaptive_mt_dataset(::Google::Cloud::Translate::V3::DeleteAdaptiveMtDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_adaptive_mt_dataset_client_stub.call_count
      end
    end
  end

  def test_get_adaptive_mt_dataset
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::AdaptiveMtDataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_adaptive_mt_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_adaptive_mt_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_adaptive_mt_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_adaptive_mt_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_adaptive_mt_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_adaptive_mt_dataset ::Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_adaptive_mt_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_adaptive_mt_dataset(::Google::Cloud::Translate::V3::GetAdaptiveMtDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_adaptive_mt_dataset_client_stub.call_count
      end
    end
  end

  def test_list_adaptive_mt_datasets
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_adaptive_mt_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_adaptive_mt_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_adaptive_mt_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_adaptive_mt_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_adaptive_mt_datasets parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_adaptive_mt_datasets ::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_adaptive_mt_datasets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_adaptive_mt_datasets(::Google::Cloud::Translate::V3::ListAdaptiveMtDatasetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_adaptive_mt_datasets_client_stub.call_count
      end
    end
  end

  def test_adaptive_mt_translate
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::AdaptiveMtTranslateResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset = "hello world"
    content = ["hello world"]
    reference_sentence_config = {}
    glossary_config = {}

    adaptive_mt_translate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_adaptive_mt_translate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, adaptive_mt_translate_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.adaptive_mt_translate({ parent: parent, dataset: dataset, content: content, reference_sentence_config: reference_sentence_config, glossary_config: glossary_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.adaptive_mt_translate parent: parent, dataset: dataset, content: content, reference_sentence_config: reference_sentence_config, glossary_config: glossary_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.adaptive_mt_translate ::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest.new(parent: parent, dataset: dataset, content: content, reference_sentence_config: reference_sentence_config, glossary_config: glossary_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.adaptive_mt_translate({ parent: parent, dataset: dataset, content: content, reference_sentence_config: reference_sentence_config, glossary_config: glossary_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.adaptive_mt_translate(::Google::Cloud::Translate::V3::AdaptiveMtTranslateRequest.new(parent: parent, dataset: dataset, content: content, reference_sentence_config: reference_sentence_config, glossary_config: glossary_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, adaptive_mt_translate_client_stub.call_count
      end
    end
  end

  def test_get_adaptive_mt_file
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::AdaptiveMtFile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_adaptive_mt_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_adaptive_mt_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_adaptive_mt_file_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_adaptive_mt_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_adaptive_mt_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_adaptive_mt_file ::Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_adaptive_mt_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_adaptive_mt_file(::Google::Cloud::Translate::V3::GetAdaptiveMtFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_adaptive_mt_file_client_stub.call_count
      end
    end
  end

  def test_delete_adaptive_mt_file
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_adaptive_mt_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_adaptive_mt_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_adaptive_mt_file_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_adaptive_mt_file({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_adaptive_mt_file name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_adaptive_mt_file ::Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_adaptive_mt_file({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_adaptive_mt_file(::Google::Cloud::Translate::V3::DeleteAdaptiveMtFileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_adaptive_mt_file_client_stub.call_count
      end
    end
  end

  def test_import_adaptive_mt_file
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ImportAdaptiveMtFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    file_input_source = {}

    import_adaptive_mt_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_import_adaptive_mt_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_adaptive_mt_file_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_adaptive_mt_file({ parent: parent, file_input_source: file_input_source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_adaptive_mt_file parent: parent, file_input_source: file_input_source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_adaptive_mt_file ::Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest.new(parent: parent, file_input_source: file_input_source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_adaptive_mt_file({ parent: parent, file_input_source: file_input_source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_adaptive_mt_file(::Google::Cloud::Translate::V3::ImportAdaptiveMtFileRequest.new(parent: parent, file_input_source: file_input_source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_adaptive_mt_file_client_stub.call_count
      end
    end
  end

  def test_list_adaptive_mt_files
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListAdaptiveMtFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_adaptive_mt_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_adaptive_mt_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_adaptive_mt_files_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_adaptive_mt_files({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_adaptive_mt_files parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_adaptive_mt_files ::Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_adaptive_mt_files({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_adaptive_mt_files(::Google::Cloud::Translate::V3::ListAdaptiveMtFilesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_adaptive_mt_files_client_stub.call_count
      end
    end
  end

  def test_list_adaptive_mt_sentences
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_adaptive_mt_sentences_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_adaptive_mt_sentences_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_adaptive_mt_sentences_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_adaptive_mt_sentences({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_adaptive_mt_sentences parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_adaptive_mt_sentences ::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_adaptive_mt_sentences({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_adaptive_mt_sentences(::Google::Cloud::Translate::V3::ListAdaptiveMtSentencesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_adaptive_mt_sentences_client_stub.call_count
      end
    end
  end

  def test_import_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dataset = "hello world"
    input_config = {}

    import_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_import_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_data_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_data({ dataset: dataset, input_config: input_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_data dataset: dataset, input_config: input_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_data ::Google::Cloud::Translate::V3::ImportDataRequest.new(dataset: dataset, input_config: input_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_data({ dataset: dataset, input_config: input_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_data(::Google::Cloud::Translate::V3::ImportDataRequest.new(dataset: dataset, input_config: input_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_data_client_stub.call_count
      end
    end
  end

  def test_export_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dataset = "hello world"
    output_config = {}

    export_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_export_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_data_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_data({ dataset: dataset, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_data dataset: dataset, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_data ::Google::Cloud::Translate::V3::ExportDataRequest.new(dataset: dataset, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_data({ dataset: dataset, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_data(::Google::Cloud::Translate::V3::ExportDataRequest.new(dataset: dataset, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_data_client_stub.call_count
      end
    end
  end

  def test_list_examples
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListExamplesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_examples_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_examples_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_examples_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_examples({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_examples parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_examples ::Google::Cloud::Translate::V3::ListExamplesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_examples({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_examples(::Google::Cloud::Translate::V3::ListExamplesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_examples_client_stub.call_count
      end
    end
  end

  def test_create_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model = {}

    create_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_create_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_model_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_model({ parent: parent, model: model }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_model parent: parent, model: model do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_model ::Google::Cloud::Translate::V3::CreateModelRequest.new(parent: parent, model: model) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_model({ parent: parent, model: model }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_model(::Google::Cloud::Translate::V3::CreateModelRequest.new(parent: parent, model: model), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_model_client_stub.call_count
      end
    end
  end

  def test_list_models
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::ListModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_list_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_models_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_models parent: parent, filter: filter, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_models ::Google::Cloud::Translate::V3::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_models(::Google::Cloud::Translate::V3::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_models_client_stub.call_count
      end
    end
  end

  def test_get_model
    # Create test objects.
    client_result = ::Google::Cloud::Translate::V3::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_get_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model ::Google::Cloud::Translate::V3::GetModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model(::Google::Cloud::Translate::V3::GetModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_client_stub.call_count
      end
    end
  end

  def test_delete_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Translate::V3::TranslationService::Rest::ServiceStub.stub :transcode_delete_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_client_stub do
        # Create client
        client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model ::Google::Cloud::Translate::V3::DeleteModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model(::Google::Cloud::Translate::V3::DeleteModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Translate::V3::TranslationService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Translate::V3::TranslationService::Rest::Client::Configuration, config
  end
end
