# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/translate/v3/translation_service"

class ::Google::Cloud::Translate::V3::TranslationService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_adaptive_mt_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.adaptive_mt_dataset_path project: "value0", location: "value1", dataset: "value2"
      assert_equal "projects/value0/locations/value1/adaptiveMtDatasets/value2", path
    end
  end

  def test_adaptive_mt_file_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.adaptive_mt_file_path project: "value0", location: "value1", dataset: "value2", file: "value3"
      assert_equal "projects/value0/locations/value1/adaptiveMtDatasets/value2/adaptiveMtFiles/value3", path
    end
  end

  def test_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dataset_path project: "value0", location: "value1", dataset: "value2"
      assert_equal "projects/value0/locations/value1/datasets/value2", path
    end
  end

  def test_glossary_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.glossary_path project: "value0", location: "value1", glossary: "value2"
      assert_equal "projects/value0/locations/value1/glossaries/value2", path
    end
  end

  def test_glossary_entry_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.glossary_entry_path project: "value0", location: "value1", glossary: "value2", glossary_entry: "value3"
      assert_equal "projects/value0/locations/value1/glossaries/value2/glossaryEntries/value3", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_model_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Translate::V3::TranslationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.model_path project: "value0", location: "value1", model: "value2"
      assert_equal "projects/value0/locations/value1/models/value2", path
    end
  end
end
