# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Translate
      module V3
        # Configures transliteration feature on top of translation.
        # @!attribute [rw] enable_transliteration
        #   @return [::Boolean]
        #     If true, source text in romanized form can be translated to the target
        #     language.
        class TransliterationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for synchronous translation.
        # @!attribute [rw] contents
        #   @return [::Array<::String>]
        #     Required. The content of the input in string format.
        #     We recommend the total content be less than 30,000 codepoints. The max
        #     length of this field is 1024. Use BatchTranslateText for larger text.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Optional. The format of the source text, for example, "text/html",
        #      "text/plain". If left blank, the MIME type defaults to "text/html".
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     Optional. The ISO-639 language code of the input text if
        #     known, for example, "en-US" or "sr-Latn". Supported language codes are
        #     listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages). If the source
        #     language isn't specified, the API attempts to identify the source language
        #     automatically and returns the source language within the response.
        # @!attribute [rw] target_language_code
        #   @return [::String]
        #     Required. The ISO-639 language code to use for translation of the input
        #     text, set to one of the language codes listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project or location to make a call. Must refer to a caller's
        #     project.
        #
        #     Format: `projects/{project-number-or-id}` or
        #     `projects/{project-number-or-id}/locations/{location-id}`.
        #
        #     For global calls, use `projects/{project-number-or-id}/locations/global` or
        #     `projects/{project-number-or-id}`.
        #
        #     Non-global location is required for requests using AutoML models or
        #     custom glossaries.
        #
        #     Models and glossaries must be within the same region (have same
        #     location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. The `model` type requested for this translation.
        #
        #     The format depends on model type:
        #
        #     - AutoML Translation models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
        #
        #     - General (built-in) models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
        #
        #     - Translation LLM models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/translation-llm`,
        #
        #     For global (non-regionalized) requests, use `location-id` `global`.
        #     For example,
        #     `projects/{project-number-or-id}/locations/global/models/general/nmt`.
        #
        #     If not provided, the default Google model (NMT) will be used
        # @!attribute [rw] glossary_config
        #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
        #     Optional. Glossary to be applied. The glossary must be
        #     within the same region (have the same location-id) as the model, otherwise
        #     an INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] transliteration_config
        #   @return [::Google::Cloud::Translate::V3::TransliterationConfig]
        #     Optional. Transliteration to be applied.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        #
        #     See https://cloud.google.com/translate/docs/advanced/labels for more
        #     information.
        class TranslateTextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] translations
        #   @return [::Array<::Google::Cloud::Translate::V3::Translation>]
        #     Text translation responses with no glossary applied.
        #     This field has the same length as
        #     {::Google::Cloud::Translate::V3::TranslateTextRequest#contents `contents`}.
        # @!attribute [rw] glossary_translations
        #   @return [::Array<::Google::Cloud::Translate::V3::Translation>]
        #     Text translation responses if a glossary is provided in the request.
        #     This can be the same as
        #     {::Google::Cloud::Translate::V3::TranslateTextResponse#translations `translations`}
        #     if no terms apply. This field has the same length as
        #     {::Google::Cloud::Translate::V3::TranslateTextRequest#contents `contents`}.
        class TranslateTextResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single translation response.
        # @!attribute [rw] translated_text
        #   @return [::String]
        #     Text translated into the target language.
        #     If an error occurs during translation, this field might be excluded from
        #     the response.
        # @!attribute [rw] model
        #   @return [::String]
        #     Only present when `model` is present in the request.
        #     `model` here is normalized to have project number.
        #
        #     For example:
        #     If the `model` requested in TranslationTextRequest is
        #     `projects/{project-id}/locations/{location-id}/models/general/nmt` then
        #     `model` here would be normalized to
        #     `projects/{project-number}/locations/{location-id}/models/general/nmt`.
        # @!attribute [rw] detected_language_code
        #   @return [::String]
        #     The ISO-639 language code of source text in the initial request, detected
        #     automatically, if no source language was passed within the initial
        #     request. If the source language was passed, auto-detection of the language
        #     does not occur and this field is empty.
        # @!attribute [rw] glossary_config
        #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
        #     The `glossary_config` used for this translation.
        class Translation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for synchronous romanization.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project or location to make a call. Must refer to a caller's
        #     project.
        #
        #     Format: `projects/{project-number-or-id}/locations/{location-id}` or
        #     `projects/{project-number-or-id}`.
        #
        #     For global calls, use `projects/{project-number-or-id}/locations/global` or
        #     `projects/{project-number-or-id}`.
        # @!attribute [rw] contents
        #   @return [::Array<::String>]
        #     Required. The content of the input in string format.
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     Optional. The ISO-639 language code of the input text if
        #     known, for example, "hi" or "zh". Supported language codes are
        #     listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages#roman). If the
        #     source language isn't specified, the API attempts to identify the source
        #     language automatically and returns the source language for each content in
        #     the response.
        class RomanizeTextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single romanization response.
        # @!attribute [rw] romanized_text
        #   @return [::String]
        #     Romanized text.
        #     If an error occurs during romanization, this field might be excluded from
        #     the response.
        # @!attribute [rw] detected_language_code
        #   @return [::String]
        #     The ISO-639 language code of source text in the initial request, detected
        #     automatically, if no source language was passed within the initial
        #     request. If the source language was passed, auto-detection of the language
        #     does not occur and this field is empty.
        class Romanization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for synchronous romanization.
        # @!attribute [rw] romanizations
        #   @return [::Array<::Google::Cloud::Translate::V3::Romanization>]
        #     Text romanization responses.
        #     This field has the same length as
        #     {::Google::Cloud::Translate::V3::RomanizeTextRequest#contents `contents`}.
        class RomanizeTextResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for language detection.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project or location to make a call. Must refer to a caller's
        #     project.
        #
        #     Format: `projects/{project-number-or-id}/locations/{location-id}` or
        #     `projects/{project-number-or-id}`.
        #
        #     For global calls, use `projects/{project-number-or-id}/locations/global` or
        #     `projects/{project-number-or-id}`.
        #
        #     Only models within the same region (has same location-id) can be used.
        #     Otherwise an INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. The language detection model to be used.
        #
        #     Format:
        #     `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
        #
        #     Only one language detection model is currently supported:
        #     `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
        #
        #     If not specified, the default model is used.
        # @!attribute [rw] content
        #   @return [::String]
        #     The content of the input stored as a string.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Optional. The format of the source text, for example, "text/html",
        #     "text/plain". If left blank, the MIME type defaults to "text/html".
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        #
        #     See https://cloud.google.com/translate/docs/advanced/labels for more
        #     information.
        class DetectLanguageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response message for language detection.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The ISO-639 language code of the source content in the request, detected
        #     automatically.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     The confidence of the detection result for this language.
        class DetectedLanguage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for language detection.
        # @!attribute [rw] languages
        #   @return [::Array<::Google::Cloud::Translate::V3::DetectedLanguage>]
        #     The most probable language detected by the Translation API. For each
        #     request, the Translation API will always return only one result.
        class DetectLanguageResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for discovering supported languages.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project or location to make a call. Must refer to a caller's
        #     project.
        #
        #     Format: `projects/{project-number-or-id}` or
        #     `projects/{project-number-or-id}/locations/{location-id}`.
        #
        #     For global calls, use `projects/{project-number-or-id}/locations/global` or
        #     `projects/{project-number-or-id}`.
        #
        #     Non-global location is required for AutoML models.
        #
        #     Only models within the same region (have same location-id) can be used,
        #     otherwise an INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] display_language_code
        #   @return [::String]
        #     Optional. The language to use to return localized, human readable names
        #     of supported languages. If missing, then display names are not returned
        #     in a response.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. Get supported languages of this model.
        #
        #     The format depends on model type:
        #
        #     - AutoML Translation models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
        #
        #     - General (built-in) models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
        #
        #
        #     Returns languages supported by the specified model.
        #     If missing, we get supported languages of Google general NMT model.
        class GetSupportedLanguagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for discovering supported languages.
        # @!attribute [rw] languages
        #   @return [::Array<::Google::Cloud::Translate::V3::SupportedLanguage>]
        #     A list of supported language responses. This list contains an entry
        #     for each language the Translation API supports.
        class SupportedLanguages
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single supported language response corresponds to information related
        # to one supported language.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Supported language code, generally consisting of its ISO 639-1
        #     identifier, for example, 'en', 'ja'. In certain cases, ISO-639 codes
        #     including language and region identifiers are returned (for example,
        #     'zh-TW' and 'zh-CN').
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human-readable name of the language localized in the display language
        #     specified in the request.
        # @!attribute [rw] support_source
        #   @return [::Boolean]
        #     Can be used as a source language.
        # @!attribute [rw] support_target
        #   @return [::Boolean]
        #     Can be used as a target language.
        class SupportedLanguage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Cloud Storage location for the input content.
        # @!attribute [rw] input_uri
        #   @return [::String]
        #     Required. Source data URI. For example, `gs://my_bucket/my_object`.
        class GcsSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input configuration for BatchTranslateText request.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Optional. Can be "text/plain" or "text/html".
        #     For `.tsv`, "text/html" is used if mime_type is missing.
        #     For `.html`, this field must be "text/html" or empty.
        #     For `.txt`, this field must be "text/plain" or empty.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::Translate::V3::GcsSource]
        #     Required. Google Cloud Storage location for the source input.
        #     This can be a single file (for example,
        #     `gs://translation-test/input.tsv`) or a wildcard (for example,
        #     `gs://translation-test/*`). If a file extension is `.tsv`, it can
        #     contain either one or two columns. The first column (optional) is the id
        #     of the text request. If the first column is missing, we use the row
        #     number (0-based) from the input file as the ID in the output file. The
        #     second column is the actual text to be
        #      translated. We recommend each row be <= 10K Unicode codepoints,
        #     otherwise an error might be returned.
        #     Note that the input tsv must be RFC 4180 compliant.
        #
        #     You could use https://github.com/Clever/csvlint to check potential
        #     formatting errors in your tsv file.
        #     csvlint --delimiter='\t' your_input_file.tsv
        #
        #     The other supported file extensions are `.txt` or `.html`, which is
        #     treated as a single large chunk of text.
        class InputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Cloud Storage location for the output content.
        # @!attribute [rw] output_uri_prefix
        #   @return [::String]
        #     Required. The bucket used in 'output_uri_prefix' must exist and there must
        #     be no files under 'output_uri_prefix'. 'output_uri_prefix' must end with
        #     "/" and start with "gs://". One 'output_uri_prefix' can only be used by one
        #     batch translation job at a time. Otherwise an INVALID_ARGUMENT (400) error
        #     is returned.
        class GcsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration for BatchTranslateText request.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Translate::V3::GcsDestination]
        #     Google Cloud Storage destination for output content.
        #     For every single input file (for example, gs://a/b/c.[extension]), we
        #     generate at most 2 * n output files. (n is the # of target_language_codes
        #     in the BatchTranslateTextRequest).
        #
        #     Output files (tsv) generated are compliant with RFC 4180 except that
        #     record delimiters are '\n' instead of '\r\n'. We don't provide any way to
        #     change record delimiters.
        #
        #     While the input files are being processed, we write/update an index file
        #     'index.csv'  under 'output_uri_prefix' (for example,
        #     gs://translation-test/index.csv) The index file is generated/updated as
        #     new files are being translated. The format is:
        #
        #     input_file,target_language_code,translations_file,errors_file,
        #     glossary_translations_file,glossary_errors_file
        #
        #     input_file is one file we matched using gcs_source.input_uri.
        #     target_language_code is provided in the request.
        #     translations_file contains the translations. (details provided below)
        #     errors_file contains the errors during processing of the file. (details
        #     below). Both translations_file and errors_file could be empty
        #     strings if we have no content to output.
        #     glossary_translations_file and glossary_errors_file are always empty
        #     strings if the input_file is tsv. They could also be empty if we have no
        #     content to output.
        #
        #     Once a row is present in index.csv, the input/output matching never
        #     changes. Callers should also expect all the content in input_file are
        #     processed and ready to be consumed (that is, no partial output file is
        #     written).
        #
        #     Since index.csv will be keeping updated during the process, please make
        #     sure there is no custom retention policy applied on the output bucket
        #     that may avoid file updating.
        #     (https://cloud.google.com/storage/docs/bucket-lock#retention-policy)
        #
        #     The format of translations_file (for target language code 'trg') is:
        #     `gs://translation_test/a_b_c_'trg'_translations.[extension]`
        #
        #     If the input file extension is tsv, the output has the following
        #     columns:
        #     Column 1: ID of the request provided in the input, if it's not
        #     provided in the input, then the input row number is used (0-based).
        #     Column 2: source sentence.
        #     Column 3: translation without applying a glossary. Empty string if there
        #     is an error.
        #     Column 4 (only present if a glossary is provided in the request):
        #     translation after applying the glossary. Empty string if there is an
        #     error applying the glossary. Could be same string as column 3 if there is
        #     no glossary applied.
        #
        #     If input file extension is a txt or html, the translation is directly
        #     written to the output file. If glossary is requested, a separate
        #     glossary_translations_file has format of
        #     `gs://translation_test/a_b_c_'trg'_glossary_translations.[extension]`
        #
        #     The format of errors file (for target language code 'trg') is:
        #     `gs://translation_test/a_b_c_'trg'_errors.[extension]`
        #
        #     If the input file extension is tsv, errors_file contains the following:
        #     Column 1: ID of the request provided in the input, if it's not
        #     provided in the input, then the input row number is used (0-based).
        #     Column 2: source sentence.
        #     Column 3: Error detail for the translation. Could be empty.
        #     Column 4 (only present if a glossary is provided in the request):
        #     Error when applying the glossary.
        #
        #     If the input file extension is txt or html, glossary_error_file will be
        #     generated that contains error details. glossary_error_file has format of
        #     `gs://translation_test/a_b_c_'trg'_glossary_errors.[extension]`
        class OutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A document translation request input config.
        # @!attribute [rw] content
        #   @return [::String]
        #     Document's content represented as a stream of bytes.
        #
        #     Note: The following fields are mutually exclusive: `content`, `gcs_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::Translate::V3::GcsSource]
        #     Google Cloud Storage location. This must be a single file.
        #     For example: gs://example_bucket/example_file.pdf
        #
        #     Note: The following fields are mutually exclusive: `gcs_source`, `content`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Specifies the input document's mime_type.
        #
        #     If not specified it will be determined using the file extension for
        #     gcs_source provided files. For a file provided through bytes content the
        #     mime_type must be provided.
        #     Currently supported mime types are:
        #     - application/pdf
        #     - application/vnd.openxmlformats-officedocument.wordprocessingml.document
        #     - application/vnd.openxmlformats-officedocument.presentationml.presentation
        #     - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
        class DocumentInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A document translation request output config.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Translate::V3::GcsDestination]
        #     Optional. Google Cloud Storage destination for the translation output,
        #     e.g., `gs://my_bucket/my_directory/`.
        #
        #     The destination directory provided does not have to be empty, but the
        #     bucket must exist. If a file with the same name as the output file
        #     already exists in the destination an error will be returned.
        #
        #     For a DocumentInputConfig.contents provided document, the output file
        #     will have the name "output_[trg]_translations.[ext]", where
        #     - [trg] corresponds to the translated file's language code,
        #     - [ext] corresponds to the translated file's extension according to its
        #     mime type.
        #
        #
        #     For a DocumentInputConfig.gcs_uri provided document, the output file will
        #     have a name according to its URI. For example: an input file with URI:
        #     `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
        #     "my_bucket" will have an output URI:
        #     `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
        #     - [trg] corresponds to the translated file's language code,
        #     - [ext] corresponds to the translated file's extension according to its
        #     mime type.
        #
        #
        #     If the document was directly provided through the request, then the
        #     output document will have the format:
        #     `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
        #     - [trg] corresponds to the translated file's language code,
        #     - [ext] corresponds to the translated file's extension according to its
        #     mime type.
        #
        #     If a glossary was provided, then the output URI for the glossary
        #     translation will be equal to the default output URI but have
        #     `glossary_translations` instead of `translations`. For the previous
        #     example, its glossary URI would be:
        #     `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
        #
        #     Thus the max number of output files will be 2 (Translated document,
        #     Glossary translated document).
        #
        #     Callers should expect no partial outputs. If there is any error during
        #     document translation, no output will be stored in the Cloud Storage
        #     bucket.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Optional. Specifies the translated document's mime_type.
        #     If not specified, the translated file's mime type will be the same as the
        #     input file's mime type.
        #     Currently only support the output mime type to be the same as input mime
        #     type.
        #     - application/pdf
        #     - application/vnd.openxmlformats-officedocument.wordprocessingml.document
        #     - application/vnd.openxmlformats-officedocument.presentationml.presentation
        #     - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
        class DocumentOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A document translation request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Location to make a regional call.
        #
        #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
        #
        #     For global calls, use `projects/{project-number-or-id}/locations/global` or
        #     `projects/{project-number-or-id}`.
        #
        #     Non-global location is required for requests using AutoML models or custom
        #     glossaries.
        #
        #     Models and glossaries must be within the same region (have the same
        #     location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     Optional. The ISO-639 language code of the input document if known, for
        #     example, "en-US" or "sr-Latn". Supported language codes are listed in
        #     [Language Support](https://cloud.google.com/translate/docs/languages). If
        #     the source language isn't specified, the API attempts to identify the
        #     source language automatically and returns the source language within the
        #     response. Source language must be specified if the request contains a
        #     glossary or a custom model.
        # @!attribute [rw] target_language_code
        #   @return [::String]
        #     Required. The ISO-639 language code to use for translation of the input
        #     document, set to one of the language codes listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] document_input_config
        #   @return [::Google::Cloud::Translate::V3::DocumentInputConfig]
        #     Required. Input configurations.
        # @!attribute [rw] document_output_config
        #   @return [::Google::Cloud::Translate::V3::DocumentOutputConfig]
        #     Optional. Output configurations.
        #     Defines if the output file should be stored within Cloud Storage as well
        #     as the desired output format. If not provided the translated file will
        #     only be returned through a byte-stream and its output mime type will be
        #     the same as the input file's mime type.
        # @!attribute [rw] model
        #   @return [::String]
        #     Optional. The `model` type requested for this translation.
        #
        #     The format depends on model type:
        #
        #     - AutoML Translation models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
        #
        #     - General (built-in) models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
        #
        #
        #     If not provided, the default Google model (NMT) will be used for
        #     translation.
        # @!attribute [rw] glossary_config
        #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
        #     Optional. Glossary to be applied. The glossary must be within the same
        #     region (have the same location-id) as the model, otherwise an
        #     INVALID_ARGUMENT (400) error is returned.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters (Unicode
        #     codepoints), can only contain lowercase letters, numeric characters,
        #     underscores and dashes. International characters are allowed. Label values
        #     are optional. Label keys must start with a letter.
        #
        #     See https://cloud.google.com/translate/docs/advanced/labels for more
        #     information.
        # @!attribute [rw] customized_attribution
        #   @return [::String]
        #     Optional. This flag is to support user customized attribution.
        #     If not provided, the default is `Machine Translated by Google`.
        #     Customized attribution should follow rules in
        #     https://cloud.google.com/translate/attribution#attribution_and_logos
        # @!attribute [rw] is_translate_native_pdf_only
        #   @return [::Boolean]
        #     Optional. is_translate_native_pdf_only field for external customers.
        #     If true, the page limit of online native pdf translation is 300 and only
        #     native pdf pages will be translated.
        # @!attribute [rw] enable_shadow_removal_native_pdf
        #   @return [::Boolean]
        #     Optional. If true, use the text removal server to remove the shadow text on
        #     background image for native pdf translation.
        #     Shadow removal feature can only be enabled when
        #     is_translate_native_pdf_only: false && pdf_native_only: false
        # @!attribute [rw] enable_rotation_correction
        #   @return [::Boolean]
        #     Optional. If true, enable auto rotation correction in DVS.
        class TranslateDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A translated document message.
        # @!attribute [rw] byte_stream_outputs
        #   @return [::Array<::String>]
        #     The array of translated documents. It is expected to be size 1 for now. We
        #     may produce multiple translated documents in the future for other type of
        #     file formats.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     The translated document's mime type.
        # @!attribute [rw] detected_language_code
        #   @return [::String]
        #     The detected language for the input document.
        #     If the user did not provide the source language for the input document,
        #     this field will have the language code automatically detected. If the
        #     source language was passed, auto-detection of the language does not occur
        #     and this field is empty.
        class DocumentTranslation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A translated document response message.
        # @!attribute [rw] document_translation
        #   @return [::Google::Cloud::Translate::V3::DocumentTranslation]
        #     Translated document.
        # @!attribute [rw] glossary_document_translation
        #   @return [::Google::Cloud::Translate::V3::DocumentTranslation]
        #     The document's translation output if a glossary is provided in the request.
        #     This can be the same as [TranslateDocumentResponse.document_translation]
        #     if no glossary terms apply.
        # @!attribute [rw] model
        #   @return [::String]
        #     Only present when 'model' is present in the request.
        #     'model' is normalized to have a project number.
        #
        #     For example:
        #     If the 'model' field in TranslateDocumentRequest is:
        #     `projects/{project-id}/locations/{location-id}/models/general/nmt` then
        #     `model` here would be normalized to
        #     `projects/{project-number}/locations/{location-id}/models/general/nmt`.
        # @!attribute [rw] glossary_config
        #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
        #     The `glossary_config` used for this translation.
        class TranslateDocumentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The batch translation request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Location to make a call. Must refer to a caller's project.
        #
        #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
        #
        #     The `global` location is not supported for batch translation.
        #
        #     Only AutoML Translation models or glossaries within the same region (have
        #     the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
        #     error is returned.
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     Required. Source language code. Supported language codes are listed in
        #     [Language
        #     Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] target_language_codes
        #   @return [::Array<::String>]
        #     Required. Specify up to 10 language codes here. Supported language codes
        #     are listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] models
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The models to use for translation. Map's key is target language
        #     code. Map's value is model name. Value can be a built-in general model,
        #     or an AutoML Translation model.
        #
        #     The value format depends on model type:
        #
        #     - AutoML Translation models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
        #
        #     - General (built-in) models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
        #
        #
        #     If the map is empty or a specific model is
        #     not requested for a language pair, then default google model (nmt) is used.
        # @!attribute [rw] input_configs
        #   @return [::Array<::Google::Cloud::Translate::V3::InputConfig>]
        #     Required. Input configurations.
        #     The total number of files matched should be <= 100.
        #     The total content size should be <= 100M Unicode codepoints.
        #     The files must use UTF-8 encoding.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Translate::V3::OutputConfig]
        #     Required. Output configuration.
        #     If 2 input configs match to the same file (that is, same input path),
        #     we don't generate output for duplicate inputs.
        # @!attribute [rw] glossaries
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig}]
        #     Optional. Glossaries to be applied for translation.
        #     It's keyed by target language code.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        #
        #     See https://cloud.google.com/translate/docs/advanced/labels for more
        #     information.
        class BatchTranslateTextRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ModelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
          class GlossariesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # State metadata for the batch translation operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::BatchTranslateMetadata::State]
        #     The state of the operation.
        # @!attribute [rw] translated_characters
        #   @return [::Integer]
        #     Number of successfully translated characters so far (Unicode codepoints).
        # @!attribute [rw] failed_characters
        #   @return [::Integer]
        #     Number of characters that have failed to process so far (Unicode
        #     codepoints).
        # @!attribute [rw] total_characters
        #   @return [::Integer]
        #     Total number of characters (Unicode codepoints).
        #     This is the total number of codepoints from input files times the number of
        #     target languages and appears here shortly after the call is submitted.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the operation was submitted.
        class BatchTranslateMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the job.
          module State
            # Invalid.
            STATE_UNSPECIFIED = 0

            # Request is being processed.
            RUNNING = 1

            # The batch is processed, and at least one item was successfully
            # processed.
            SUCCEEDED = 2

            # The batch is done and no item was successfully processed.
            FAILED = 3

            # Request is in the process of being canceled after caller invoked
            # longrunning.Operations.CancelOperation on the request id.
            CANCELLING = 4

            # The batch is done after the user has called the
            # longrunning.Operations.CancelOperation. Any records processed before the
            # cancel command are output as specified in the request.
            CANCELLED = 5
          end
        end

        # Stored in the
        # {::Google::Longrunning::Operation#response google.longrunning.Operation.response}
        # field returned by BatchTranslateText if at least one sentence is translated
        # successfully.
        # @!attribute [rw] total_characters
        #   @return [::Integer]
        #     Total number of characters (Unicode codepoints).
        # @!attribute [rw] translated_characters
        #   @return [::Integer]
        #     Number of successfully translated characters (Unicode codepoints).
        # @!attribute [rw] failed_characters
        #   @return [::Integer]
        #     Number of characters that have failed to process (Unicode codepoints).
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the operation was submitted.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation is finished and
        #     {::Google::Longrunning::Operation#done google.longrunning.Operation.done} is
        #     set to true.
        class BatchTranslateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input configuration for glossaries.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::Translate::V3::GcsSource]
        #     Required. Google Cloud Storage location of glossary data.
        #     File format is determined based on the filename extension. API returns
        #     [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s and file
        #     formats. Wildcards are not allowed. This must be a single file in one of
        #     the following formats:
        #
        #     For unidirectional glossaries:
        #
        #     - TSV/CSV (`.tsv`/`.csv`): Two column file, tab- or comma-separated.
        #       The first column is source text. The second column is target text.
        #       No headers in this file. The first row contains data and not column
        #       names.
        #
        #     - TMX (`.tmx`): TMX file with parallel data defining source/target term
        #     pairs.
        #
        #     For equivalent term sets glossaries:
        #
        #     - CSV (`.csv`): Multi-column CSV file defining equivalent glossary terms
        #       in multiple languages. See documentation for more information -
        #       [glossaries](https://cloud.google.com/translate/docs/advanced/glossary).
        class GlossaryInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a glossary built from user-provided data.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the glossary. Glossary names have the form
        #     `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
        # @!attribute [rw] language_pair
        #   @return [::Google::Cloud::Translate::V3::Glossary::LanguageCodePair]
        #     Used with unidirectional glossaries.
        #
        #     Note: The following fields are mutually exclusive: `language_pair`, `language_codes_set`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] language_codes_set
        #   @return [::Google::Cloud::Translate::V3::Glossary::LanguageCodesSet]
        #     Used with equivalent term set glossaries.
        #
        #     Note: The following fields are mutually exclusive: `language_codes_set`, `language_pair`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] input_config
        #   @return [::Google::Cloud::Translate::V3::GlossaryInputConfig]
        #     Required. Provides examples to build the glossary from.
        #     Total glossary must not exceed 10M Unicode codepoints.
        # @!attribute [r] entry_count
        #   @return [::Integer]
        #     Output only. The number of entries defined in the glossary.
        # @!attribute [r] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When CreateGlossary was called.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the glossary creation was finished.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The display name of the glossary.
        class Glossary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Used with unidirectional glossaries.
          # @!attribute [rw] source_language_code
          #   @return [::String]
          #     Required. The ISO-639 language code of the input text, for example,
          #     "en-US". Expected to be an exact match for GlossaryTerm.language_code.
          # @!attribute [rw] target_language_code
          #   @return [::String]
          #     Required. The ISO-639 language code for translation output, for example,
          #     "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
          class LanguageCodePair
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Used with equivalent term set glossaries.
          # @!attribute [rw] language_codes
          #   @return [::Array<::String>]
          #     The ISO-639 language code(s) for terms defined in the glossary.
          #     All entries are unique. The list contains at least two entries.
          #     Expected to be an exact match for GlossaryTerm.language_code.
          class LanguageCodesSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for CreateGlossary.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project name.
        # @!attribute [rw] glossary
        #   @return [::Google::Cloud::Translate::V3::Glossary]
        #     Required. The glossary to create.
        class CreateGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the update glossary flow
        # @!attribute [rw] glossary
        #   @return [::Google::Cloud::Translate::V3::Glossary]
        #     Required. The glossary entry to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to be updated. Currently only `display_name` and
        #     'input_config'
        class UpdateGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetGlossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the glossary to retrieve.
        class GetGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteGlossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the glossary to delete.
        class DeleteGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListGlossaries.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project from which to list all of the glossaries.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server may return fewer glossaries than
        #     requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        #     Typically, this is the value of [ListGlossariesResponse.next_page_token]
        #     returned from the previous call to `ListGlossaries` method.
        #     The first page is returned if `page_token`is empty or missing.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter specifying constraints of a list operation.
        #     Specify the constraint by the format of "key=value", where key must be
        #     "src" or "tgt", and the value must be a valid language code.
        #     For multiple restrictions, concatenate them by "AND" (uppercase only),
        #     such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used
        #     here, which means using 'en-US' and 'en' can lead to different results,
        #     which depends on the language code you used when you create the glossary.
        #     For the unidirectional glossaries, the "src" and "tgt" add restrictions
        #     on the source and target language code separately.
        #     For the equivalent term set glossaries, the "src" and/or "tgt" add
        #     restrictions on the term set.
        #     For example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
        #     glossaries which exactly match the source language code as "en-US" and the
        #     target language code "zh-CN", but all equivalent term set glossaries which
        #     contain "en-US" and "zh-CN" in their language set will be picked.
        #     If missing, no filtering is performed.
        class ListGlossariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListGlossaries.
        # @!attribute [rw] glossaries
        #   @return [::Array<::Google::Cloud::Translate::V3::Glossary>]
        #     The list of glossaries for a project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve a page of results. Pass this value in the
        #     [ListGlossariesRequest.page_token] field in the subsequent call to
        #     `ListGlossaries` method to retrieve the next page of results.
        class ListGlossariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the Get Glossary Entry Api
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the glossary entry to get
        class GetGlossaryEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for Delete Glossary Entry
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the glossary entry to delete
        class DeleteGlossaryEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListGlossaryEntries
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent glossary resource name for listing the glossary's
        #     entries.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server may return fewer glossary entries
        #     than requested. If unspecified, the server picks an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        #     Typically, this is the value of
        #     [ListGlossaryEntriesResponse.next_page_token] returned from the previous
        #     call. The first page is returned if `page_token`is empty or missing.
        class ListGlossaryEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListGlossaryEntries
        # @!attribute [rw] glossary_entries
        #   @return [::Array<::Google::Cloud::Translate::V3::GlossaryEntry>]
        #     Optional. The Glossary Entries
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. A token to retrieve a page of results. Pass this value in the
        #     [ListGLossaryEntriesRequest.page_token] field in the subsequent calls.
        class ListGlossaryEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateGlossaryEntry
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the glossary to create the entry under.
        # @!attribute [rw] glossary_entry
        #   @return [::Google::Cloud::Translate::V3::GlossaryEntry]
        #     Required. The glossary entry to create
        class CreateGlossaryEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateGlossaryEntry
        # @!attribute [rw] glossary_entry
        #   @return [::Google::Cloud::Translate::V3::GlossaryEntry]
        #     Required. The glossary entry to update.
        class UpdateGlossaryEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Stored in the
        # {::Google::Longrunning::Operation#metadata google.longrunning.Operation.metadata}
        # field returned by CreateGlossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the glossary that is being created.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::CreateGlossaryMetadata::State]
        #     The current state of the glossary creation operation.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was submitted to the server.
        class CreateGlossaryMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates the possible states that the creation request can be in.
          module State
            # Invalid.
            STATE_UNSPECIFIED = 0

            # Request is being processed.
            RUNNING = 1

            # The glossary was successfully created.
            SUCCEEDED = 2

            # Failed to create the glossary.
            FAILED = 3

            # Request is in the process of being canceled after caller invoked
            # longrunning.Operations.CancelOperation on the request id.
            CANCELLING = 4

            # The glossary creation request was successfully canceled.
            CANCELLED = 5
          end
        end

        # Stored in the
        # {::Google::Longrunning::Operation#metadata google.longrunning.Operation.metadata}
        # field returned by UpdateGlossary.
        # @!attribute [rw] glossary
        #   @return [::Google::Cloud::Translate::V3::Glossary]
        #     The updated glossary object.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::UpdateGlossaryMetadata::State]
        #     The current state of the glossary update operation. If the glossary input
        #     file was not updated this will be completed immediately
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was submitted to the server.
        class UpdateGlossaryMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates the possible states that the update request can be in.
          module State
            # Invalid.
            STATE_UNSPECIFIED = 0

            # Request is being processed.
            RUNNING = 1

            # The glossary was successfully updated.
            SUCCEEDED = 2

            # Failed to update the glossary.
            FAILED = 3

            # Request is in the process of being canceled after caller invoked
            # longrunning.Operations.CancelOperation on the request id.
            CANCELLING = 4

            # The glossary update request was successfully canceled.
            CANCELLED = 5
          end
        end

        # Stored in the
        # {::Google::Longrunning::Operation#metadata google.longrunning.Operation.metadata}
        # field returned by DeleteGlossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the glossary that is being deleted.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::DeleteGlossaryMetadata::State]
        #     The current state of the glossary deletion operation.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was submitted to the server.
        class DeleteGlossaryMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates the possible states that the creation request can be in.
          module State
            # Invalid.
            STATE_UNSPECIFIED = 0

            # Request is being processed.
            RUNNING = 1

            # The glossary was successfully deleted.
            SUCCEEDED = 2

            # Failed to delete the glossary.
            FAILED = 3

            # Request is in the process of being canceled after caller invoked
            # longrunning.Operations.CancelOperation on the request id.
            CANCELLING = 4

            # The glossary deletion request was successfully canceled.
            CANCELLED = 5
          end
        end

        # Stored in the
        # {::Google::Longrunning::Operation#response google.longrunning.Operation.response}
        # field returned by DeleteGlossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the deleted glossary.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation was submitted to the server.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the glossary deletion is finished and
        #     {::Google::Longrunning::Operation#done google.longrunning.Operation.done} is
        #     set to true.
        class DeleteGlossaryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The BatchTranslateDocument request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Location to make a regional call.
        #
        #     Format: `projects/{project-number-or-id}/locations/{location-id}`.
        #
        #     The `global` location is not supported for batch translation.
        #
        #     Only AutoML Translation models or glossaries within the same region (have
        #     the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
        #     error is returned.
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     Required. The ISO-639 language code of the input document if known, for
        #     example, "en-US" or "sr-Latn". Supported language codes are listed in
        #     [Language Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] target_language_codes
        #   @return [::Array<::String>]
        #     Required. The ISO-639 language code to use for translation of the input
        #     document. Specify up to 10 language codes here. Supported language codes
        #     are listed in [Language
        #     Support](https://cloud.google.com/translate/docs/languages).
        # @!attribute [rw] input_configs
        #   @return [::Array<::Google::Cloud::Translate::V3::BatchDocumentInputConfig>]
        #     Required. Input configurations.
        #     The total number of files matched should be <= 100.
        #     The total content size to translate should be <= 100M Unicode codepoints.
        #     The files must use UTF-8 encoding.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Translate::V3::BatchDocumentOutputConfig]
        #     Required. Output configuration.
        #     If 2 input configs match to the same file (that is, same input path),
        #     we don't generate output for duplicate inputs.
        # @!attribute [rw] models
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The models to use for translation. Map's key is target language
        #     code. Map's value is the model name. Value can be a built-in general model,
        #     or an AutoML Translation model.
        #
        #     The value format depends on model type:
        #
        #     - AutoML Translation models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
        #
        #     - General (built-in) models:
        #       `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
        #
        #
        #     If the map is empty or a specific model is
        #     not requested for a language pair, then default google model (nmt) is used.
        # @!attribute [rw] glossaries
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig}]
        #     Optional. Glossaries to be applied. It's keyed by target language code.
        # @!attribute [rw] format_conversions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The file format conversion map that is applied to all input
        #     files. The map key is the original mime_type. The map value is the target
        #     mime_type of translated documents.
        #
        #     Supported file format conversion includes:
        #     - `application/pdf` to
        #       `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
        #
        #     If nothing specified, output files will be in the same format as the
        #     original file.
        # @!attribute [rw] customized_attribution
        #   @return [::String]
        #     Optional. This flag is to support user customized attribution.
        #     If not provided, the default is `Machine Translated by Google`.
        #     Customized attribution should follow rules in
        #     https://cloud.google.com/translate/attribution#attribution_and_logos
        # @!attribute [rw] enable_shadow_removal_native_pdf
        #   @return [::Boolean]
        #     Optional. If true, use the text removal server to remove the shadow text on
        #     background image for native pdf translation.
        #     Shadow removal feature can only be enabled when
        #     is_translate_native_pdf_only: false && pdf_native_only: false
        # @!attribute [rw] enable_rotation_correction
        #   @return [::Boolean]
        #     Optional. If true, enable auto rotation correction in DVS.
        class BatchTranslateDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ModelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Translate::V3::TranslateTextGlossaryConfig]
          class GlossariesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class FormatConversionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Input configuration for BatchTranslateDocument request.
        # @!attribute [rw] gcs_source
        #   @return [::Google::Cloud::Translate::V3::GcsSource]
        #     Google Cloud Storage location for the source input.
        #     This can be a single file (for example,
        #     `gs://translation-test/input.docx`) or a wildcard (for example,
        #     `gs://translation-test/*`).
        #
        #     File mime type is determined based on extension. Supported mime type
        #     includes:
        #     - `pdf`, application/pdf
        #     - `docx`,
        #     application/vnd.openxmlformats-officedocument.wordprocessingml.document
        #     - `pptx`,
        #     application/vnd.openxmlformats-officedocument.presentationml.presentation
        #     - `xlsx`,
        #     application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
        #
        #     The max file size to support for `.docx`, `.pptx` and `.xlsx` is 100MB.
        #     The max file size to support for `.pdf` is 1GB and the max page limit is
        #     1000 pages.
        #     The max file size to support for all input documents is 1GB.
        class BatchDocumentInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration for BatchTranslateDocument request.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Translate::V3::GcsDestination]
        #     Google Cloud Storage destination for output content.
        #     For every single input document (for example, gs://a/b/c.[extension]), we
        #     generate at most 2 * n output files. (n is the # of target_language_codes
        #     in the BatchTranslateDocumentRequest).
        #
        #     While the input documents are being processed, we write/update an index
        #     file `index.csv` under `gcs_destination.output_uri_prefix` (for example,
        #     gs://translation_output/index.csv) The index file is generated/updated as
        #     new files are being translated. The format is:
        #
        #     input_document,target_language_code,translation_output,error_output,
        #     glossary_translation_output,glossary_error_output
        #
        #     `input_document` is one file we matched using gcs_source.input_uri.
        #     `target_language_code` is provided in the request.
        #     `translation_output` contains the translations. (details provided below)
        #     `error_output` contains the error message during processing of the file.
        #     Both translations_file and errors_file could be empty strings if we have
        #     no content to output.
        #     `glossary_translation_output` and `glossary_error_output` are the
        #     translated output/error when we apply glossaries. They could also be
        #     empty if we have no content to output.
        #
        #     Once a row is present in index.csv, the input/output matching never
        #     changes. Callers should also expect all the content in input_file are
        #     processed and ready to be consumed (that is, no partial output file is
        #     written).
        #
        #     Since index.csv will be keeping updated during the process, please make
        #     sure there is no custom retention policy applied on the output bucket
        #     that may avoid file updating.
        #     (https://cloud.google.com/storage/docs/bucket-lock#retention-policy)
        #
        #     The naming format of translation output files follows (for target
        #     language code [trg]): `translation_output`:
        #     `gs://translation_output/a_b_c_[trg]_translation.[extension]`
        #     `glossary_translation_output`:
        #     `gs://translation_test/a_b_c_[trg]_glossary_translation.[extension]`. The
        #     output document will maintain the same file format as the input document.
        #
        #     The naming format of error output files follows (for target language code
        #     [trg]): `error_output`: `gs://translation_test/a_b_c_[trg]_errors.txt`
        #     `glossary_error_output`:
        #     `gs://translation_test/a_b_c_[trg]_glossary_translation.txt`. The error
        #     output is a txt file containing error details.
        class BatchDocumentOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Stored in the
        # {::Google::Longrunning::Operation#response google.longrunning.Operation.response}
        # field returned by BatchTranslateDocument if at least one document is
        # translated successfully.
        # @!attribute [rw] total_pages
        #   @return [::Integer]
        #     Total number of pages to translate in all documents. Documents without
        #     clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] translated_pages
        #   @return [::Integer]
        #     Number of successfully translated pages in all documents. Documents without
        #     clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] failed_pages
        #   @return [::Integer]
        #     Number of pages that failed to process in all documents. Documents without
        #     clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] total_billable_pages
        #   @return [::Integer]
        #     Number of billable pages in documents with clear page definition (such as
        #     PDF, DOCX, PPTX)
        # @!attribute [rw] total_characters
        #   @return [::Integer]
        #     Total number of characters (Unicode codepoints) in all documents.
        # @!attribute [rw] translated_characters
        #   @return [::Integer]
        #     Number of successfully translated characters (Unicode codepoints) in all
        #     documents.
        # @!attribute [rw] failed_characters
        #   @return [::Integer]
        #     Number of characters that have failed to process (Unicode codepoints) in
        #     all documents.
        # @!attribute [rw] total_billable_characters
        #   @return [::Integer]
        #     Number of billable characters (Unicode codepoints) in documents without
        #     clear page definition, such as XLSX.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the operation was submitted.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the operation is finished and
        #     {::Google::Longrunning::Operation#done google.longrunning.Operation.done} is
        #     set to true.
        class BatchTranslateDocumentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # State metadata for the batch translation operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::BatchTranslateDocumentMetadata::State]
        #     The state of the operation.
        # @!attribute [rw] total_pages
        #   @return [::Integer]
        #     Total number of pages to translate in all documents so far. Documents
        #     without clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] translated_pages
        #   @return [::Integer]
        #     Number of successfully translated pages in all documents so far. Documents
        #     without clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] failed_pages
        #   @return [::Integer]
        #     Number of pages that failed to process in all documents so far. Documents
        #     without clear page definition (such as XLSX) are not counted.
        # @!attribute [rw] total_billable_pages
        #   @return [::Integer]
        #     Number of billable pages in documents with clear page definition (such as
        #     PDF, DOCX, PPTX) so far.
        # @!attribute [rw] total_characters
        #   @return [::Integer]
        #     Total number of characters (Unicode codepoints) in all documents so far.
        # @!attribute [rw] translated_characters
        #   @return [::Integer]
        #     Number of successfully translated characters (Unicode codepoints) in all
        #     documents so far.
        # @!attribute [rw] failed_characters
        #   @return [::Integer]
        #     Number of characters that have failed to process (Unicode codepoints) in
        #     all documents so far.
        # @!attribute [rw] total_billable_characters
        #   @return [::Integer]
        #     Number of billable characters (Unicode codepoints) in documents without
        #     clear page definition (such as XLSX) so far.
        # @!attribute [rw] submit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the operation was submitted.
        class BatchTranslateDocumentMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the job.
          module State
            # Invalid.
            STATE_UNSPECIFIED = 0

            # Request is being processed.
            RUNNING = 1

            # The batch is processed, and at least one item was successfully processed.
            SUCCEEDED = 2

            # The batch is done and no item was successfully processed.
            FAILED = 3

            # Request is in the process of being canceled after caller invoked
            # longrunning.Operations.CancelOperation on the request id.
            CANCELLING = 4

            # The batch is done after the user has called the
            # longrunning.Operations.CancelOperation. Any records processed before the
            # cancel command are output as specified in the request.
            CANCELLED = 5
          end
        end

        # Configures which glossary is used for a specific target language and defines
        # options for applying that glossary.
        # @!attribute [rw] glossary
        #   @return [::String]
        #     Required. The `glossary` to be applied for this translation.
        #
        #     The format depends on the glossary:
        #
        #     - User-provided custom glossary:
        #       `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
        # @!attribute [rw] ignore_case
        #   @return [::Boolean]
        #     Optional. Indicates match is case insensitive. The default value is `false`
        #     if missing.
        # @!attribute [rw] contextual_translation_enabled
        #   @return [::Boolean]
        #     Optional. If set to true, the glossary will be used for contextual
        #     translation.
        class TranslateTextGlossaryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
