# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Translate
      module V3
        # The Google Cloud Storage location for the input content.
        # @!attribute [rw] input_uri
        #   @return [::String]
        #     Required. Source data URI. For example, `gs://my_bucket/my_object`.
        class GcsInputSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An inlined file.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The file's mime type.
        # @!attribute [rw] content
        #   @return [::String]
        #     Required. The file's byte contents.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The file's display name.
        class FileInputSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Google Cloud Storage location for the output content.
        # @!attribute [rw] output_uri_prefix
        #   @return [::String]
        #     Required. Google Cloud Storage URI to output directory. For example,
        #     `gs://bucket/directory`. The requesting user must have write permission to
        #     the bucket. The directory will be created if it doesn't exist.
        class GcsOutputDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single entry in a glossary.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the entry.
        #     Format:
        #       `projects/*/locations/*/glossaries/*/glossaryEntries/*`
        # @!attribute [rw] terms_pair
        #   @return [::Google::Cloud::Translate::V3::GlossaryEntry::GlossaryTermsPair]
        #     Used for an unidirectional glossary.
        #
        #     Note: The following fields are mutually exclusive: `terms_pair`, `terms_set`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] terms_set
        #   @return [::Google::Cloud::Translate::V3::GlossaryEntry::GlossaryTermsSet]
        #     Used for an equivalent term sets glossary.
        #
        #     Note: The following fields are mutually exclusive: `terms_set`, `terms_pair`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] description
        #   @return [::String]
        #     Describes the glossary entry.
        class GlossaryEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a single entry for an unidirectional glossary.
          # @!attribute [rw] source_term
          #   @return [::Google::Cloud::Translate::V3::GlossaryTerm]
          #     The source term is the term that will get match in the text,
          # @!attribute [rw] target_term
          #   @return [::Google::Cloud::Translate::V3::GlossaryTerm]
          #     The term that will replace the match source term.
          class GlossaryTermsPair
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a single entry for an equivalent term set glossary. This is used
          # for equivalent term sets where each term can be replaced by the other terms
          # in the set.
          # @!attribute [rw] terms
          #   @return [::Array<::Google::Cloud::Translate::V3::GlossaryTerm>]
          #     Each term in the set represents a term that can be replaced by the other
          #     terms.
          class GlossaryTermsSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a single glossary term
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The language for this glossary term.
        # @!attribute [rw] text
        #   @return [::String]
        #     The text for the glossary term.
        class GlossaryTerm
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Possible states of long running operations.
        module OperationState
          # Invalid.
          OPERATION_STATE_UNSPECIFIED = 0

          # Request is being processed.
          OPERATION_STATE_RUNNING = 1

          # The operation was successful.
          OPERATION_STATE_SUCCEEDED = 2

          # Failed to process operation.
          OPERATION_STATE_FAILED = 3

          # Request is in the process of being canceled after caller invoked
          # longrunning.Operations.CancelOperation on the request id.
          OPERATION_STATE_CANCELLING = 4

          # The operation request was successfully canceled.
          OPERATION_STATE_CANCELLED = 5
        end
      end
    end
  end
end
