# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Translate
      module V3
        # Request message for ImportData.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. Name of the dataset. In form of
        #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
        # @!attribute [rw] input_config
        #   @return [::Google::Cloud::Translate::V3::DatasetInputConfig]
        #     Required. The config for the input content.
        class ImportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Input configuration for datasets.
        # @!attribute [rw] input_files
        #   @return [::Array<::Google::Cloud::Translate::V3::DatasetInputConfig::InputFile>]
        #     Files containing the sentence pairs to be imported to the dataset.
        class DatasetInputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An input file.
          # @!attribute [rw] usage
          #   @return [::String]
          #     Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
          #     or UNASSIGNED (by default) for auto split.
          # @!attribute [rw] gcs_source
          #   @return [::Google::Cloud::Translate::V3::GcsInputSource]
          #     Google Cloud Storage file source.
          class InputFile
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Metadata of import data operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class ImportDataMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ExportData.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. Name of the dataset. In form of
        #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::Translate::V3::DatasetOutputConfig]
        #     Required. The config for the output content.
        class ExportDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Output configuration for datasets.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::Translate::V3::GcsOutputDestination]
        #     Google Cloud Storage destination to write the output.
        class DatasetOutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of export data operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class ExportDataMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDataset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the dataset to delete.
        class DeleteDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of delete dataset operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class DeleteDatasetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDataset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the dataset to retrieve.
        class GetDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDatasets.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent project. In form of
        #     `projects/{project-number-or-id}/locations/{location-id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server can return fewer results than
        #     requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results for the server to return.
        #     Typically obtained from next_page_token field in the response of a
        #     ListDatasets call.
        class ListDatasetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDatasets.
        # @!attribute [rw] datasets
        #   @return [::Array<::Google::Cloud::Translate::V3::Dataset>]
        #     The datasets read.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass this token to the page_token field in the ListDatasetsRequest to
        #     obtain the corresponding page.
        class ListDatasetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDataset.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project name.
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::Translate::V3::Dataset]
        #     Required. The Dataset to create.
        class CreateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of create dataset operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class CreateDatasetMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListExamples.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent dataset. In form of
        #     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-id}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the examples that will be returned.
        #     Example filter:
        #     * `usage=TRAIN`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server can return fewer results than
        #     requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results for the server to return.
        #     Typically obtained from next_page_token field in the response of a
        #     ListExamples call.
        class ListExamplesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListExamples.
        # @!attribute [rw] examples
        #   @return [::Array<::Google::Cloud::Translate::V3::Example>]
        #     The sentence pairs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass this token to the page_token field in the ListExamplesRequest to
        #     obtain the corresponding page.
        class ListExamplesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A sentence pair.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the example, in form of
        #     `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id}/examples/{example_id}`
        # @!attribute [rw] source_text
        #   @return [::String]
        #     Sentence in source language.
        # @!attribute [rw] target_text
        #   @return [::String]
        #     Sentence in target language.
        # @!attribute [r] usage
        #   @return [::String]
        #     Output only. Usage of the sentence pair. Options are TRAIN|VALIDATION|TEST.
        class Example
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for BatchTransferResources.
        # @!attribute [rw] responses
        #   @return [::Array<::Google::Cloud::Translate::V3::BatchTransferResourcesResponse::TransferResourceResponse>]
        #     Responses of the transfer for individual resources.
        class BatchTransferResourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Transfer response for a single resource.
          # @!attribute [rw] source
          #   @return [::String]
          #     Full name of the resource to transfer as specified in the request.
          # @!attribute [rw] target
          #   @return [::String]
          #     Full name of the new resource successfully transferred from the source
          #     hosted by Translation API. Target will be empty if the transfer failed.
          # @!attribute [rw] error
          #   @return [::Google::Rpc::Status]
          #     The error result in case of failure.
          class TransferResourceResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A dataset that hosts the examples (sentence pairs) used for translation
        # models.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the dataset, in form of
        #     `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The name of the dataset to show in the interface. The name can be
        #     up to 32 characters long and can consist only of ASCII Latin letters A-Z
        #     and a-z, underscores (_), and ASCII digits 0-9.
        # @!attribute [rw] source_language_code
        #   @return [::String]
        #     The BCP-47 language code of the source language.
        # @!attribute [rw] target_language_code
        #   @return [::String]
        #     The BCP-47 language code of the target language.
        # @!attribute [r] example_count
        #   @return [::Integer]
        #     Output only. The number of examples in the dataset.
        # @!attribute [r] train_example_count
        #   @return [::Integer]
        #     Output only. Number of training examples (sentence pairs).
        # @!attribute [r] validate_example_count
        #   @return [::Integer]
        #     Output only. Number of validation examples (sentence pairs).
        # @!attribute [r] test_example_count
        #   @return [::Integer]
        #     Output only. Number of test examples (sentence pairs).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this dataset was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this dataset was last updated.
        class Dataset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateModel.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project name, in form of
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] model
        #   @return [::Google::Cloud::Translate::V3::Model]
        #     Required. The Model to create.
        class CreateModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of create model operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class CreateModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListModels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of the parent project. In form of
        #     `projects/{project-number-or-id}/locations/{location-id}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression for filtering the models that will be returned.
        #     Supported filter:
        #     `dataset_id=${dataset_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. The server can return fewer results than
        #     requested.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results for the server to return.
        #     Typically obtained from next_page_token field in the response of a
        #     ListModels call.
        class ListModelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListModels.
        # @!attribute [rw] models
        #   @return [::Array<::Google::Cloud::Translate::V3::Model>]
        #     The models read.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve next page of results.
        #     Pass this token to the page_token field in the ListModelsRequest to
        #     obtain the corresponding page.
        class ListModelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetModel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the model to retrieve.
        class GetModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteModel.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the model to delete.
        class DeleteModelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of delete model operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Translate::V3::OperationState]
        #     The current state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] error
        #   @return [::Google::Rpc::Status]
        #     Only populated when operation doesn't succeed.
        class DeleteModelMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A trained translation model.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the model, in form of
        #     `projects/{project-number-or-id}/locations/{location_id}/models/{model_id}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The name of the model to show in the interface. The name can be
        #     up to 32 characters long and can consist only of ASCII Latin letters A-Z
        #     and a-z, underscores (_), and ASCII digits 0-9.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     The dataset from which the model is trained, in form of
        #     `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id}`
        # @!attribute [r] source_language_code
        #   @return [::String]
        #     Output only. The BCP-47 language code of the source language.
        # @!attribute [r] target_language_code
        #   @return [::String]
        #     Output only. The BCP-47 language code of the target language.
        # @!attribute [r] train_example_count
        #   @return [::Integer]
        #     Output only. Number of examples (sentence pairs) used to train the model.
        # @!attribute [r] validate_example_count
        #   @return [::Integer]
        #     Output only. Number of examples (sentence pairs) used to validate the
        #     model.
        # @!attribute [r] test_example_count
        #   @return [::Integer]
        #     Output only. Number of examples (sentence pairs) used to test the model.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the model resource was created, which is also
        #     when the training started.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this model was last updated.
        class Model
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
